/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;
import libcore.io.Base64;
import libcore.io.DropBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PinFailureLogger {
    private static final long LOG_INTERVAL_NANOS = 817405952L;
    private static long lastLoggedNanos = 0L;

    public static synchronized void log(String cn, boolean chainContainsUserCert, boolean pinIsEnforcing, List<X509Certificate> chain) {
        if (!PinFailureLogger.timeToLog()) {
            return;
        }
        PinFailureLogger.writeToLog(cn, chainContainsUserCert, pinIsEnforcing, chain);
        lastLoggedNanos = System.nanoTime();
    }

    protected static synchronized void writeToLog(String cn, boolean chainContainsUserCert, boolean pinIsEnforcing, List<X509Certificate> chain) {
        StringBuilder sb = new StringBuilder();
        sb.append(cn);
        sb.append("|");
        sb.append(chainContainsUserCert);
        sb.append("|");
        sb.append(pinIsEnforcing);
        sb.append("|");
        for (X509Certificate cert : chain) {
            try {
                sb.append(Base64.encode(cert.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                sb.append("Error: could not encode certificate");
            }
            sb.append("|");
        }
        DropBox.addText("exp_det_cert_pin_failure", sb.toString());
    }

    protected static boolean timeToLog() {
        long currentTimeNanos = System.nanoTime();
        return currentTimeNanos - lastLoggedNanos > 817405952L;
    }
}

