/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.media;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.android.org.chromium.base.CalledByNative;
import com.android.org.chromium.base.JNINamespace;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

@JNINamespace(value="media")
class WebAudioMediaCodecBridge {
    private static final boolean DEBUG = true;
    static final String LOG_TAG = "WebAudioMediaCodec";
    static final long TIMEOUT_MICROSECONDS = 500L;

    WebAudioMediaCodecBridge() {
    }

    @CalledByNative
    private static String CreateTempFile(Context ctx) throws IOException {
        File outputDirectory = ctx.getCacheDir();
        File outputFile = File.createTempFile("webaudio", ".dat", outputDirectory);
        return outputFile.getAbsolutePath();
    }

    @CalledByNative
    private static boolean decodeAudioFile(Context ctx, int nativeMediaCodecBridge, int inputFD, long dataSize) {
        int inputChannelCount;
        if (dataSize < 0L || dataSize > Integer.MAX_VALUE) {
            return false;
        }
        MediaExtractor extractor = new MediaExtractor();
        ParcelFileDescriptor encodedFD = ParcelFileDescriptor.adoptFd(inputFD);
        try {
            extractor.setDataSource(encodedFD.getFileDescriptor(), 0L, dataSize);
        }
        catch (Exception e) {
            e.printStackTrace();
            encodedFD.detachFd();
            return false;
        }
        if (extractor.getTrackCount() <= 0) {
            encodedFD.detachFd();
            return false;
        }
        MediaFormat format = extractor.getTrackFormat(0);
        int outputChannelCount = inputChannelCount = format.getInteger("channel-count");
        int sampleRate = format.getInteger("sample-rate");
        String mime = format.getString("mime");
        long durationMicroseconds = 0L;
        if (format.containsKey("durationUs")) {
            try {
                durationMicroseconds = format.getLong("durationUs");
            }
            catch (Exception e) {
                Log.d(LOG_TAG, "Cannot get duration");
            }
        }
        Log.d(LOG_TAG, "Tracks: " + extractor.getTrackCount() + " Rate: " + sampleRate + " Channels: " + inputChannelCount + " Mime: " + mime + " Duration: " + durationMicroseconds + " microsec");
        WebAudioMediaCodecBridge.nativeInitializeDestination(nativeMediaCodecBridge, inputChannelCount, sampleRate, durationMicroseconds);
        MediaCodec codec = MediaCodec.createDecoderByType(mime);
        codec.configure(format, null, null, 0);
        codec.start();
        ByteBuffer[] codecInputBuffers = codec.getInputBuffers();
        ByteBuffer[] codecOutputBuffers = codec.getOutputBuffers();
        extractor.selectTrack(0);
        boolean sawInputEOS = false;
        boolean sawOutputEOS = false;
        while (!sawOutputEOS) {
            MediaCodec.BufferInfo info;
            int outputBufIndex;
            int inputBufIndex;
            if (!sawInputEOS && (inputBufIndex = codec.dequeueInputBuffer(500L)) >= 0) {
                ByteBuffer dstBuf = codecInputBuffers[inputBufIndex];
                int sampleSize = extractor.readSampleData(dstBuf, 0);
                long presentationTimeMicroSec = 0L;
                if (sampleSize < 0) {
                    sawInputEOS = true;
                    sampleSize = 0;
                } else {
                    presentationTimeMicroSec = extractor.getSampleTime();
                }
                codec.queueInputBuffer(inputBufIndex, 0, sampleSize, presentationTimeMicroSec, sawInputEOS ? 4 : 0);
                if (!sawInputEOS) {
                    extractor.advance();
                }
            }
            if ((outputBufIndex = codec.dequeueOutputBuffer(info = new MediaCodec.BufferInfo(), 500L)) >= 0) {
                ByteBuffer buf = codecOutputBuffers[outputBufIndex];
                if (info.size > 0) {
                    WebAudioMediaCodecBridge.nativeOnChunkDecoded(nativeMediaCodecBridge, buf, info.size, inputChannelCount, outputChannelCount);
                }
                buf.clear();
                codec.releaseOutputBuffer(outputBufIndex, false);
                if ((info.flags & 4) == 0) continue;
                sawOutputEOS = true;
                continue;
            }
            if (outputBufIndex == -3) {
                codecOutputBuffers = codec.getOutputBuffers();
                continue;
            }
            if (outputBufIndex != -2) continue;
            MediaFormat newFormat = codec.getOutputFormat();
            outputChannelCount = newFormat.getInteger("channel-count");
            Log.d(LOG_TAG, "output format changed to " + newFormat);
        }
        encodedFD.detachFd();
        codec.stop();
        codec.release();
        codec = null;
        return true;
    }

    private static native void nativeOnChunkDecoded(int var0, ByteBuffer var1, int var2, int var3, int var4);

    private static native void nativeInitializeDestination(int var0, int var1, int var2, long var3);
}

