/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.common;

import android.os.Build;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;
import com.android.org.chromium.base.ThreadUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TraceEvent {
    private static volatile boolean sEnabled = false;
    private static long sTraceTagView;
    private static Method sSystemPropertiesGetLongMethod;
    private static final String PROPERTY_TRACE_TAG_ENABLEFLAGS = "debug.atrace.tags.enableflags";

    public static void setEnabledToMatchNative() {
        boolean enabled = TraceEvent.nativeTraceEnabled();
        if (sSystemPropertiesGetLongMethod != null) {
            try {
                long enabledFlags = (Long)sSystemPropertiesGetLongMethod.invoke(null, PROPERTY_TRACE_TAG_ENABLEFLAGS, 0);
                if ((enabledFlags & sTraceTagView) != 0L) {
                    TraceEvent.nativeStartATrace();
                    enabled = true;
                } else {
                    TraceEvent.nativeStopATrace();
                }
            }
            catch (IllegalArgumentException e) {
                Log.e("TraceEvent", "setEnabledToMatchNative", e);
            }
            catch (IllegalAccessException e) {
                Log.e("TraceEvent", "setEnabledToMatchNative", e);
            }
            catch (InvocationTargetException e) {
                Log.e("TraceEvent", "setEnabledToMatchNative", e);
            }
        }
        TraceEvent.setEnabled(enabled);
    }

    public static synchronized void setEnabled(boolean enabled) {
        if (sEnabled == enabled) {
            return;
        }
        sEnabled = enabled;
        ThreadUtils.getUiThreadLooper().setMessageLogging(enabled ? LooperMonitor.getInstance() : null);
    }

    public static boolean enabled() {
        return sEnabled;
    }

    public static void instant(String name) {
        if (sEnabled) {
            TraceEvent.nativeInstant(name, null);
        }
    }

    public static void instant(String name, String arg) {
        if (sEnabled) {
            TraceEvent.nativeInstant(name, arg);
        }
    }

    public static void startAsync(long id2) {
        if (sEnabled) {
            TraceEvent.nativeStartAsync(TraceEvent.getCallerName(), id2, null);
        }
    }

    public static void startAsync(String name, long id2) {
        if (sEnabled) {
            TraceEvent.nativeStartAsync(name, id2, null);
        }
    }

    public static void startAsync(String name, long id2, String arg) {
        if (sEnabled) {
            TraceEvent.nativeStartAsync(name, id2, arg);
        }
    }

    public static void finishAsync(long id2) {
        if (sEnabled) {
            TraceEvent.nativeFinishAsync(TraceEvent.getCallerName(), id2, null);
        }
    }

    public static void finishAsync(String name, long id2) {
        if (sEnabled) {
            TraceEvent.nativeFinishAsync(name, id2, null);
        }
    }

    public static void finishAsync(String name, long id2, String arg) {
        if (sEnabled) {
            TraceEvent.nativeFinishAsync(name, id2, arg);
        }
    }

    public static void begin() {
        if (sEnabled) {
            TraceEvent.nativeBegin(TraceEvent.getCallerName(), null);
        }
    }

    public static void begin(String name) {
        if (sEnabled) {
            TraceEvent.nativeBegin(name, null);
        }
    }

    public static void begin(String name, String arg) {
        if (sEnabled) {
            TraceEvent.nativeBegin(name, arg);
        }
    }

    public static void end() {
        if (sEnabled) {
            TraceEvent.nativeEnd(TraceEvent.getCallerName(), null);
        }
    }

    public static void end(String name) {
        if (sEnabled) {
            TraceEvent.nativeEnd(name, null);
        }
    }

    public static void end(String name, String arg) {
        if (sEnabled) {
            TraceEvent.nativeEnd(name, arg);
        }
    }

    private static String getCallerName() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        return stack[4].getClassName() + "." + stack[4].getMethodName();
    }

    private static native boolean nativeTraceEnabled();

    private static native void nativeStartATrace();

    private static native void nativeStopATrace();

    private static native void nativeInstant(String var0, String var1);

    private static native void nativeBegin(String var0, String var1);

    private static native void nativeEnd(String var0, String var1);

    private static native void nativeStartAsync(String var0, long var1, String var3);

    private static native void nativeFinishAsync(String var0, long var1, String var3);

    static {
        if (Build.VERSION.SDK_INT >= 16) {
            try {
                Class<?> traceClass = Class.forName("android.os.Trace");
                sTraceTagView = traceClass.getField("TRACE_TAG_WEBVIEW").getLong(null);
                Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
                sSystemPropertiesGetLongMethod = systemPropertiesClass.getDeclaredMethod("getLong", String.class, Long.TYPE);
                Method addChangeCallbackMethod = systemPropertiesClass.getDeclaredMethod("addChangeCallback", Runnable.class);
                addChangeCallbackMethod.invoke(null, new Runnable(){

                    public void run() {
                        TraceEvent.setEnabledToMatchNative();
                    }
                });
            }
            catch (ClassNotFoundException e) {
                Log.e("TraceEvent", "init", e);
            }
            catch (NoSuchMethodException e) {
                Log.e("TraceEvent", "init", e);
            }
            catch (IllegalArgumentException e) {
                Log.e("TraceEvent", "init", e);
            }
            catch (IllegalAccessException e) {
                Log.e("TraceEvent", "init", e);
            }
            catch (InvocationTargetException e) {
                Log.e("TraceEvent", "init", e);
            }
            catch (NoSuchFieldException e) {
                Log.e("TraceEvent", "init", e);
            }
        }
    }

    private static final class LooperMonitor
    implements Printer,
    MessageQueue.IdleHandler {
        private static final String TAG = "TraceEvent.LooperMonitor";
        private static final String IDLE_EVENT_NAME = "Looper.queueIdle";
        private static final String DISPATCH_EVENT_NAME = "Looper.dispatchMessage";
        private static final long FRAME_DURATION_MILLIS = 16L;
        private static final long MIN_INTERESTING_DURATION_MILLIS = 16L;
        private static final long MIN_INTERESTING_BURST_DURATION_MILLIS = 48L;
        private long mLastIdleStartedAt = 0L;
        private long mLastWorkStartedAt = 0L;
        private int mNumTasksSeen = 0;
        private int mNumIdlesSeen = 0;
        private int mNumTasksSinceLastIdle = 0;
        private boolean mIdleMonitorAttached = false;

        private LooperMonitor() {
        }

        public void println(String line) {
            if (line.startsWith(">")) {
                this.begin(line);
            } else {
                assert (line.startsWith("<"));
                this.end(line);
            }
        }

        private final void syncIdleMonitoring() {
            if (sEnabled && !this.mIdleMonitorAttached) {
                this.mLastIdleStartedAt = SystemClock.elapsedRealtime();
                Looper.myQueue().addIdleHandler(LooperMonitor.getInstance());
                this.mIdleMonitorAttached = true;
                Log.v(TAG, "attached idle handler");
            } else if (this.mIdleMonitorAttached && !sEnabled) {
                Looper.myQueue().removeIdleHandler(LooperMonitor.getInstance());
                this.mIdleMonitorAttached = false;
                Log.v(TAG, "detached idle handler");
            }
        }

        private final void begin(String line) {
            if (this.mNumTasksSinceLastIdle == 0) {
                TraceEvent.end(IDLE_EVENT_NAME);
            }
            TraceEvent.begin(DISPATCH_EVENT_NAME, line);
            this.mLastWorkStartedAt = SystemClock.elapsedRealtime();
            this.syncIdleMonitoring();
        }

        private final void end(String line) {
            long elapsed = SystemClock.elapsedRealtime() - this.mLastWorkStartedAt;
            if (elapsed > 16L) {
                LooperMonitor.traceAndLog(5, "observed a task that took " + elapsed + "ms: " + line);
            }
            TraceEvent.end(DISPATCH_EVENT_NAME);
            this.syncIdleMonitoring();
            ++this.mNumTasksSeen;
            ++this.mNumTasksSinceLastIdle;
        }

        private static void traceAndLog(int level, String message) {
            TraceEvent.instant("TraceEvent.LooperMonitor:IdleStats", message);
            Log.println(level, TAG, message);
        }

        public final boolean queueIdle() {
            long now = SystemClock.elapsedRealtime();
            if (this.mLastIdleStartedAt == 0L) {
                this.mLastIdleStartedAt = now;
            }
            long elapsed = now - this.mLastIdleStartedAt;
            ++this.mNumIdlesSeen;
            TraceEvent.begin(IDLE_EVENT_NAME, this.mNumTasksSinceLastIdle + " tasks since last idle.");
            if (elapsed > 48L) {
                String statsString = this.mNumTasksSeen + " tasks and " + this.mNumIdlesSeen + " idles processed so far, " + this.mNumTasksSinceLastIdle + " tasks bursted and " + elapsed + "ms elapsed since last idle";
                LooperMonitor.traceAndLog(3, statsString);
            }
            this.mLastIdleStartedAt = now;
            this.mNumTasksSinceLastIdle = 0;
            return true;
        }

        public static final LooperMonitor getInstance() {
            return Holder.sInstance;
        }

        private static final class Holder {
            private static final LooperMonitor sInstance = new LooperMonitor();

            private Holder() {
            }
        }
    }
}

