/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser.input;

import android.content.Context;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.FrameLayout;
import android.widget.NumberPicker;
import com.android.org.chromium.content.R;
import java.util.Calendar;

public abstract class TwoFieldDatePicker
extends FrameLayout {
    private NumberPicker mPositionInYearSpinner;
    private NumberPicker mYearSpinner;
    private OnMonthOrWeekChangedListener mMonthOrWeekChangedListener;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private Calendar mCurrentDate;

    public TwoFieldDatePicker(Context context, long minValue, long maxValue) {
        super(context, null, 16843612);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(R.layout.two_field_date_picker, (ViewGroup)this, true);
        NumberPicker.OnValueChangeListener onChangeListener = new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                int year = TwoFieldDatePicker.this.getYear();
                int positionInYear = TwoFieldDatePicker.this.getPositionInYear();
                if (picker == TwoFieldDatePicker.this.mPositionInYearSpinner) {
                    positionInYear = newVal;
                    if (oldVal == picker.getMaxValue() && newVal == picker.getMinValue()) {
                        positionInYear = TwoFieldDatePicker.this.getMinPositionInYear(++year);
                    } else if (oldVal == picker.getMinValue() && newVal == picker.getMaxValue()) {
                        positionInYear = TwoFieldDatePicker.this.getMaxPositionInYear(--year);
                    }
                } else if (picker == TwoFieldDatePicker.this.mYearSpinner) {
                    year = newVal;
                } else {
                    throw new IllegalArgumentException();
                }
                TwoFieldDatePicker.this.setCurrentDate(year, positionInYear);
                TwoFieldDatePicker.this.updateSpinners();
                TwoFieldDatePicker.this.notifyDateChanged();
            }
        };
        this.mCurrentDate = Calendar.getInstance();
        if (minValue >= maxValue) {
            this.mMinDate = Calendar.getInstance();
            this.mMinDate.set(0, 0, 1);
            this.mMaxDate = Calendar.getInstance();
            this.mMaxDate.set(9999, 0, 1);
        } else {
            this.mMinDate = this.createDateFromValue(minValue);
            this.mMaxDate = this.createDateFromValue(maxValue);
        }
        this.mPositionInYearSpinner = (NumberPicker)this.findViewById(R.id.position_in_year);
        this.mPositionInYearSpinner.setOnLongPressUpdateInterval(200L);
        this.mPositionInYearSpinner.setOnValueChangedListener(onChangeListener);
        this.mYearSpinner = (NumberPicker)this.findViewById(R.id.year);
        this.mYearSpinner.setOnLongPressUpdateInterval(100L);
        this.mYearSpinner.setOnValueChangedListener(onChangeListener);
    }

    public void init(int year, int positionInYear, OnMonthOrWeekChangedListener onMonthOrWeekChangedListener) {
        this.setCurrentDate(year, positionInYear);
        this.updateSpinners();
        this.mMonthOrWeekChangedListener = onMonthOrWeekChangedListener;
    }

    public boolean isNewDate(int year, int positionInYear) {
        return this.getYear() != year || this.getPositionInYear() != positionInYear;
    }

    protected abstract Calendar createDateFromValue(long var1);

    public void updateDate(int year, int positionInYear) {
        if (!this.isNewDate(year, positionInYear)) {
            return;
        }
        this.setCurrentDate(year, positionInYear);
        this.updateSpinners();
        this.notifyDateChanged();
    }

    protected abstract void setCurrentDate(int var1, int var2);

    protected void setCurrentDate(Calendar date) {
        this.mCurrentDate = date;
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        super.onPopulateAccessibilityEvent(event);
        int flags = 20;
        String selectedDateUtterance = DateUtils.formatDateTime(this.getContext(), this.mCurrentDate.getTimeInMillis(), 20);
        event.getText().add(selectedDateUtterance);
    }

    public int getYear() {
        return this.mCurrentDate.get(1);
    }

    public abstract int getPositionInYear();

    protected abstract int getMaxYear();

    protected abstract int getMinYear();

    protected abstract int getMaxPositionInYear(int var1);

    protected abstract int getMinPositionInYear(int var1);

    protected Calendar getMaxDate() {
        return this.mMaxDate;
    }

    protected Calendar getMinDate() {
        return this.mMinDate;
    }

    protected Calendar getCurrentDate() {
        return this.mCurrentDate;
    }

    protected NumberPicker getPositionInYearSpinner() {
        return this.mPositionInYearSpinner;
    }

    protected NumberPicker getYearSpinner() {
        return this.mYearSpinner;
    }

    protected void updateSpinners() {
        this.mPositionInYearSpinner.setDisplayedValues(null);
        this.mPositionInYearSpinner.setMinValue(this.getMinPositionInYear(this.getYear()));
        this.mPositionInYearSpinner.setMaxValue(this.getMaxPositionInYear(this.getYear()));
        this.mPositionInYearSpinner.setWrapSelectorWheel(!this.mCurrentDate.equals(this.mMinDate) && !this.mCurrentDate.equals(this.mMaxDate));
        this.mYearSpinner.setMinValue(this.getMinYear());
        this.mYearSpinner.setMaxValue(this.getMaxYear());
        this.mYearSpinner.setWrapSelectorWheel(false);
        this.mYearSpinner.setValue(this.getYear());
        this.mPositionInYearSpinner.setValue(this.getPositionInYear());
    }

    protected void notifyDateChanged() {
        this.sendAccessibilityEvent(4);
        if (this.mMonthOrWeekChangedListener != null) {
            this.mMonthOrWeekChangedListener.onMonthOrWeekChanged(this, this.getYear(), this.getPositionInYear());
        }
    }

    public static interface OnMonthOrWeekChangedListener {
        public void onMonthOrWeekChanged(TwoFieldDatePicker var1, int var2, int var3);
    }
}

