/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser.input;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckedTextView;
import android.widget.ListView;
import com.android.org.chromium.content.R;
import com.android.org.chromium.content.browser.ContentViewCore;

public class SelectPopupDialog {
    private static SelectPopupDialog sShownDialog;
    private static final int[] SELECT_DIALOG_ATTRS;
    private AlertDialog mListBoxPopup = null;
    private ContentViewCore mContentViewCore;

    private int getSelectDialogLayout(boolean isMultiChoice) {
        TypedArray styledAttributes = this.mContentViewCore.getContext().obtainStyledAttributes(R.style.SelectPopupDialog, SELECT_DIALOG_ATTRS);
        int resource_id = styledAttributes.getResourceId(isMultiChoice ? 0 : 1, 0);
        styledAttributes.recycle();
        return resource_id;
    }

    private SelectPopupDialog(ContentViewCore contentViewCore, String[] labels, int[] enabled, boolean multiple, int[] selected) {
        this.mContentViewCore = contentViewCore;
        final ListView listView = new ListView(this.mContentViewCore.getContext());
        listView.setCacheColorHint(0);
        AlertDialog.Builder b = new AlertDialog.Builder(this.mContentViewCore.getContext()).setView(listView).setCancelable(true).setInverseBackgroundForced(true);
        if (multiple) {
            b.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    SelectPopupDialog.this.mContentViewCore.selectPopupMenuItems(SelectPopupDialog.this.getSelectedIndices(listView));
                }
            });
            b.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    SelectPopupDialog.this.mContentViewCore.selectPopupMenuItems(null);
                }
            });
        }
        this.mListBoxPopup = b.create();
        SelectPopupArrayAdapter adapter = new SelectPopupArrayAdapter(labels, enabled, multiple);
        listView.setAdapter(adapter);
        listView.setFocusableInTouchMode(true);
        if (multiple) {
            listView.setChoiceMode(2);
            for (int i = 0; i < selected.length; ++i) {
                listView.setItemChecked(selected[i], true);
            }
        } else {
            listView.setChoiceMode(1);
            listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                @Override
                public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                    SelectPopupDialog.this.mContentViewCore.selectPopupMenuItems(SelectPopupDialog.this.getSelectedIndices(listView));
                    SelectPopupDialog.this.mListBoxPopup.dismiss();
                }
            });
            if (selected.length > 0) {
                listView.setSelection(selected[0]);
                listView.setItemChecked(selected[0], true);
            }
        }
        this.mListBoxPopup.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                SelectPopupDialog.this.mContentViewCore.selectPopupMenuItems(null);
            }
        });
        this.mListBoxPopup.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                SelectPopupDialog.this.mListBoxPopup = null;
                sShownDialog = null;
            }
        });
    }

    private int[] getSelectedIndices(ListView listView) {
        SparseBooleanArray sparseArray = listView.getCheckedItemPositions();
        int selectedCount = 0;
        for (int i = 0; i < sparseArray.size(); ++i) {
            if (!sparseArray.valueAt(i)) continue;
            ++selectedCount;
        }
        int[] indices = new int[selectedCount];
        int j = 0;
        for (int i = 0; i < sparseArray.size(); ++i) {
            if (!sparseArray.valueAt(i)) continue;
            indices[j++] = sparseArray.keyAt(i);
        }
        return indices;
    }

    public static void show(ContentViewCore contentViewCore, String[] items, int[] enabled, boolean multiple, int[] selectedIndices) {
        SelectPopupDialog.hide(null);
        sShownDialog = new SelectPopupDialog(contentViewCore, items, enabled, multiple, selectedIndices);
        SelectPopupDialog.sShownDialog.mListBoxPopup.show();
    }

    public static void hide(ContentViewCore contentView) {
        if (sShownDialog != null && (contentView == null || SelectPopupDialog.sShownDialog.mContentViewCore == contentView)) {
            if (contentView != null) {
                contentView.selectPopupMenuItems(null);
            }
            SelectPopupDialog.sShownDialog.mListBoxPopup.dismiss();
        }
    }

    public static SelectPopupDialog getCurrent() {
        return sShownDialog;
    }

    static {
        SELECT_DIALOG_ATTRS = new int[]{R.attr.select_dialog_multichoice, R.attr.select_dialog_singlechoice};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectPopupArrayAdapter
    extends ArrayAdapter<String> {
        static final int POPUP_ITEM_TYPE_GROUP = 0;
        static final int POPUP_ITEM_TYPE_DISABLED = 1;
        static final int POPUP_ITEM_TYPE_ENABLED = 2;
        private int[] mItemEnabled;
        private boolean mAreAllItemsEnabled;

        public SelectPopupArrayAdapter(String[] labels, int[] enabled, boolean multiple) {
            super(SelectPopupDialog.this.mContentViewCore.getContext(), SelectPopupDialog.this.getSelectDialogLayout(multiple), labels);
            this.mItemEnabled = enabled;
            this.mAreAllItemsEnabled = true;
            for (int item : this.mItemEnabled) {
                if (item == 2) continue;
                this.mAreAllItemsEnabled = false;
                break;
            }
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            convertView = super.getView(position, null, parent);
            if (this.mItemEnabled[position] != 2) {
                if (this.mItemEnabled[position] == 0) {
                    ((CheckedTextView)convertView).setCheckMarkDrawable(null);
                } else {
                    convertView.setEnabled(false);
                }
            }
            return convertView;
        }

        @Override
        public boolean areAllItemsEnabled() {
            return this.mAreAllItemsEnabled;
        }

        @Override
        public boolean isEnabled(int position) {
            if (position < 0 || position >= this.getCount()) {
                return false;
            }
            return this.mItemEnabled[position] == 2;
        }
    }
}

