/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser.input;

import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import com.android.org.chromium.com.google.common.annotations.VisibleForTesting;
import com.android.org.chromium.content.browser.input.CursorController;
import com.android.org.chromium.content.browser.input.HandleView;

public abstract class InsertionHandleController
implements CursorController {
    private HandleView mHandle;
    private View mParent;
    private boolean mIsShowing;
    private boolean mAllowAutomaticShowing;
    private Context mContext;

    public InsertionHandleController(View parent) {
        this.mParent = parent;
        this.mContext = parent.getContext();
    }

    public void allowAutomaticShowing() {
        this.mAllowAutomaticShowing = true;
    }

    public void hideAndDisallowAutomaticShowing() {
        this.hide();
        this.mAllowAutomaticShowing = false;
    }

    public void showHandle() {
        this.createHandleIfNeeded();
        this.showHandleIfNeeded();
    }

    void showPastePopup() {
        if (this.mIsShowing) {
            this.mHandle.showPastePopupWindow();
        }
    }

    public void showHandleWithPastePopup() {
        this.showHandle();
        this.showPastePopup();
    }

    public void onCursorPositionChanged() {
        if (this.mAllowAutomaticShowing) {
            this.showHandle();
        }
    }

    public void setHandlePosition(float x, float y) {
        this.mHandle.positionAt((int)x, (int)y);
    }

    public void beginHandleFadeIn() {
        this.mHandle.beginFadeIn();
    }

    public void setHandleVisibility(int visibility) {
        this.mHandle.setVisibility(visibility);
    }

    int getHandleX() {
        return this.mHandle.getAdjustedPositionX();
    }

    int getHandleY() {
        return this.mHandle.getAdjustedPositionY();
    }

    @VisibleForTesting
    public HandleView getHandleViewForTest() {
        return this.mHandle;
    }

    public void onTouchModeChanged(boolean isInTouchMode) {
        if (!isInTouchMode) {
            this.hide();
        }
    }

    public void hide() {
        if (this.mIsShowing) {
            if (this.mHandle != null) {
                this.mHandle.hide();
            }
            this.mIsShowing = false;
        }
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    public void beforeStartUpdatingPosition(HandleView handle) {
    }

    public void updatePosition(HandleView handle, int x, int y) {
        this.setCursorPosition(x, y);
    }

    protected abstract void setCursorPosition(int var1, int var2);

    protected abstract void paste();

    protected abstract int getLineHeight();

    public void onDetached() {
    }

    boolean canPaste() {
        return ((ClipboardManager)this.mContext.getSystemService("clipboard")).hasPrimaryClip();
    }

    private void createHandleIfNeeded() {
        if (this.mHandle == null) {
            this.mHandle = new HandleView(this, 1, this.mParent);
        }
    }

    private void showHandleIfNeeded() {
        if (!this.mIsShowing) {
            this.mIsShowing = true;
            this.mHandle.show();
            this.setHandleVisibility(0);
        }
    }

    class PastePopupMenu
    implements View.OnClickListener {
        private final PopupWindow mContainer;
        private int mPositionX;
        private int mPositionY;
        private View[] mPasteViews;
        private int[] mPasteViewLayouts;

        public PastePopupMenu() {
            this.mContainer = new PopupWindow(InsertionHandleController.this.mContext, null, 16843464);
            this.mContainer.setSplitTouchEnabled(true);
            this.mContainer.setClippingEnabled(false);
            this.mContainer.setWidth(-2);
            this.mContainer.setHeight(-2);
            int[] POPUP_LAYOUT_ATTRS = new int[]{16843540, 16843541, 16843614, 16843615};
            this.mPasteViews = new View[POPUP_LAYOUT_ATTRS.length];
            this.mPasteViewLayouts = new int[POPUP_LAYOUT_ATTRS.length];
            TypedArray attrs = InsertionHandleController.this.mContext.obtainStyledAttributes(POPUP_LAYOUT_ATTRS);
            for (int i = 0; i < attrs.length(); ++i) {
                this.mPasteViewLayouts[i] = attrs.getResourceId(attrs.getIndex(i), 0);
            }
            attrs.recycle();
        }

        private int viewIndex(boolean onTop) {
            return (onTop ? 0 : 2) + (InsertionHandleController.this.canPaste() ? 0 : 1);
        }

        private void updateContent(boolean onTop) {
            int viewIndex = this.viewIndex(onTop);
            View view = this.mPasteViews[viewIndex];
            if (view == null) {
                int layout2 = this.mPasteViewLayouts[viewIndex];
                LayoutInflater inflater = (LayoutInflater)InsertionHandleController.this.mContext.getSystemService("layout_inflater");
                if (inflater != null) {
                    view = inflater.inflate(layout2, null);
                }
                if (view == null) {
                    throw new IllegalArgumentException("Unable to inflate TextEdit paste window");
                }
                int size = View.MeasureSpec.makeMeasureSpec(0, 0);
                view.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
                view.measure(size, size);
                view.setOnClickListener(this);
                this.mPasteViews[viewIndex] = view;
            }
            this.mContainer.setContentView(view);
        }

        void show() {
            this.updateContent(true);
            this.positionAtCursor();
        }

        void hide() {
            this.mContainer.dismiss();
        }

        boolean isShowing() {
            return this.mContainer.isShowing();
        }

        public void onClick(View v) {
            if (InsertionHandleController.this.canPaste()) {
                InsertionHandleController.this.paste();
            }
            this.hide();
        }

        void positionAtCursor() {
            View contentView = this.mContainer.getContentView();
            int width = contentView.getMeasuredWidth();
            int height = contentView.getMeasuredHeight();
            int lineHeight = InsertionHandleController.this.getLineHeight();
            this.mPositionX = (int)((float)InsertionHandleController.this.mHandle.getAdjustedPositionX() - (float)width / 2.0f);
            this.mPositionY = InsertionHandleController.this.mHandle.getAdjustedPositionY() - height - lineHeight;
            int[] coords = new int[2];
            InsertionHandleController.this.mParent.getLocationInWindow(coords);
            coords[0] = coords[0] + this.mPositionX;
            coords[1] = coords[1] + this.mPositionY;
            int screenWidth = ((InsertionHandleController)InsertionHandleController.this).mContext.getResources().getDisplayMetrics().widthPixels;
            if (coords[1] < 0) {
                this.updateContent(false);
                contentView = this.mContainer.getContentView();
                width = contentView.getMeasuredWidth();
                height = contentView.getMeasuredHeight();
                coords[1] = coords[1] + height;
                coords[1] = coords[1] + lineHeight;
                Drawable handle = InsertionHandleController.this.mHandle.getDrawable();
                int handleHalfWidth = handle.getIntrinsicWidth() / 2;
                coords[0] = InsertionHandleController.this.mHandle.getAdjustedPositionX() + width < screenWidth ? coords[0] + (handleHalfWidth + width / 2) : coords[0] - (handleHalfWidth + width / 2);
            } else {
                coords[0] = Math.max(0, coords[0]);
                coords[0] = Math.min(screenWidth - width, coords[0]);
            }
            this.mContainer.showAtLocation(InsertionHandleController.this.mParent, 0, coords[0], coords[1]);
        }
    }
}

