/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser.input;

import android.os.Handler;
import android.os.ResultReceiver;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import com.android.org.chromium.base.CalledByNative;
import com.android.org.chromium.base.JNINamespace;
import com.android.org.chromium.com.google.common.annotations.VisibleForTesting;
import com.android.org.chromium.content.browser.input.AdapterInputConnection;
import com.android.org.chromium.content.browser.input.InputDialogContainer;
import com.android.org.chromium.content.browser.input.InputMethodManagerWrapper;

@JNINamespace(value="content")
public class ImeAdapter {
    private static final int COMPOSITION_KEY_CODE = 229;
    private static final int INPUT_DISMISS_DELAY = 150;
    static int sEventTypeRawKeyDown;
    static int sEventTypeKeyUp;
    static int sEventTypeChar;
    static int sTextInputTypeNone;
    static int sTextInputTypeText;
    static int sTextInputTypeTextArea;
    static int sTextInputTypePassword;
    static int sTextInputTypeSearch;
    static int sTextInputTypeUrl;
    static int sTextInputTypeEmail;
    static int sTextInputTypeTel;
    static int sTextInputTypeNumber;
    static int sTextInputTypeWeek;
    static int sTextInputTypeContentEditable;
    static int sModifierShift;
    static int sModifierAlt;
    static int sModifierCtrl;
    static int sModifierCapsLockOn;
    static int sModifierNumLockOn;
    private int mNativeImeAdapterAndroid;
    private InputMethodManagerWrapper mInputMethodManagerWrapper;
    private AdapterInputConnection mInputConnection;
    private final ImeAdapterDelegate mViewEmbedder;
    private final Handler mHandler;
    private DelayedDismissInput mDismissInput = null;
    private int mTextInputType;
    private int mInitialSelectionStart;
    private int mInitialSelectionEnd;
    @VisibleForTesting
    boolean mIsShowWithoutHideOutstanding = false;

    public ImeAdapter(InputMethodManagerWrapper wrapper, ImeAdapterDelegate embedder) {
        this.mInputMethodManagerWrapper = wrapper;
        this.mViewEmbedder = embedder;
        this.mHandler = new Handler();
    }

    @VisibleForTesting
    public void setInputMethodManagerWrapper(InputMethodManagerWrapper immw) {
        this.mInputMethodManagerWrapper = immw;
    }

    InputMethodManagerWrapper getInputMethodManagerWrapper() {
        return this.mInputMethodManagerWrapper;
    }

    void setInputConnection(AdapterInputConnection inputConnection) {
        this.mInputConnection = inputConnection;
    }

    int getTextInputType() {
        return this.mTextInputType;
    }

    int getInitialSelectionStart() {
        return this.mInitialSelectionStart;
    }

    int getInitialSelectionEnd() {
        return this.mInitialSelectionEnd;
    }

    public static int getTextInputTypeNone() {
        return sTextInputTypeNone;
    }

    private static int getModifiers(int metaState) {
        int modifiers = 0;
        if ((metaState & 1) != 0) {
            modifiers |= sModifierShift;
        }
        if ((metaState & 2) != 0) {
            modifiers |= sModifierAlt;
        }
        if ((metaState & 0x1000) != 0) {
            modifiers |= sModifierCtrl;
        }
        if ((metaState & 0x100000) != 0) {
            modifiers |= sModifierCapsLockOn;
        }
        if ((metaState & 0x200000) != 0) {
            modifiers |= sModifierNumLockOn;
        }
        return modifiers;
    }

    public boolean isActive() {
        return this.mInputConnection != null && this.mInputConnection.isActive();
    }

    private boolean isFor(int nativeImeAdapter, int textInputType) {
        return this.mNativeImeAdapterAndroid == nativeImeAdapter && this.mTextInputType == textInputType;
    }

    public void attachAndShowIfNeeded(int nativeImeAdapter, int textInputType, int selectionStart, int selectionEnd, boolean showIfNeeded) {
        this.mHandler.removeCallbacks(this.mDismissInput);
        if (this.mTextInputType == sTextInputTypeNone && !showIfNeeded) {
            return;
        }
        if (!this.isFor(nativeImeAdapter, textInputType)) {
            if (textInputType == sTextInputTypeNone) {
                this.mDismissInput = new DelayedDismissInput(nativeImeAdapter);
                this.mHandler.postDelayed(this.mDismissInput, 150L);
                return;
            }
            int previousType = this.mTextInputType;
            this.attach(nativeImeAdapter, textInputType, selectionStart, selectionEnd);
            this.mInputMethodManagerWrapper.restartInput(this.mViewEmbedder.getAttachedView());
            if (showIfNeeded) {
                this.showKeyboard();
            }
        } else if (this.hasInputType() && showIfNeeded) {
            this.showKeyboard();
        }
    }

    public void attach(int nativeImeAdapter, int textInputType, int selectionStart, int selectionEnd) {
        if (this.mNativeImeAdapterAndroid != 0) {
            this.nativeResetImeAdapter(this.mNativeImeAdapterAndroid);
        }
        this.mNativeImeAdapterAndroid = nativeImeAdapter;
        this.mTextInputType = textInputType;
        this.mInitialSelectionStart = selectionStart;
        this.mInitialSelectionEnd = selectionEnd;
        if (nativeImeAdapter != 0) {
            this.nativeAttachImeAdapter(this.mNativeImeAdapterAndroid);
        }
    }

    public void attach(int nativeImeAdapter) {
        if (this.mNativeImeAdapterAndroid != 0) {
            this.nativeResetImeAdapter(this.mNativeImeAdapterAndroid);
        }
        this.mNativeImeAdapterAndroid = nativeImeAdapter;
        if (nativeImeAdapter != 0) {
            this.nativeAttachImeAdapter(this.mNativeImeAdapterAndroid);
        }
    }

    public boolean isNativeImeAdapterAttached() {
        return this.mNativeImeAdapterAndroid != 0;
    }

    private void showKeyboard() {
        this.mIsShowWithoutHideOutstanding = true;
        this.mInputMethodManagerWrapper.showSoftInput(this.mViewEmbedder.getAttachedView(), 0, this.mViewEmbedder.getNewShowKeyboardReceiver());
    }

    private void dismissInput(boolean unzoomIfNeeded) {
        this.hideKeyboard(unzoomIfNeeded);
        this.mViewEmbedder.onDismissInput();
    }

    private void hideKeyboard(boolean unzoomIfNeeded) {
        this.mIsShowWithoutHideOutstanding = false;
        View view = this.mViewEmbedder.getAttachedView();
        if (this.mInputMethodManagerWrapper.isActive(view)) {
            this.mInputMethodManagerWrapper.hideSoftInputFromWindow(view.getWindowToken(), 0, unzoomIfNeeded ? this.mViewEmbedder.getNewShowKeyboardReceiver() : null);
        }
    }

    private boolean hasInputType() {
        return this.mTextInputType != sTextInputTypeNone;
    }

    static boolean isTextInputType(int type) {
        return type != sTextInputTypeNone && !InputDialogContainer.isDialogInputType(type);
    }

    public boolean hasTextInputType() {
        return ImeAdapter.isTextInputType(this.mTextInputType);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return this.translateAndSendNativeEvents(event);
    }

    private int shouldSendKeyEventWithKeyCode(String text) {
        if (text.length() != 1) {
            return 229;
        }
        if (text.equals("\n")) {
            return 66;
        }
        if (text.equals("\t")) {
            return 61;
        }
        return 229;
    }

    void sendKeyEventWithKeyCode(int keyCode, int flags) {
        long eventTime = System.currentTimeMillis();
        this.translateAndSendNativeEvents(new KeyEvent(eventTime, eventTime, 0, keyCode, 0, 0, -1, 0, flags));
        this.translateAndSendNativeEvents(new KeyEvent(System.currentTimeMillis(), eventTime, 1, keyCode, 0, 0, -1, 0, flags));
    }

    @VisibleForTesting
    boolean checkCompositionQueueAndCallNative(String text, int newCursorPosition, boolean isCommit) {
        if (this.mNativeImeAdapterAndroid == 0) {
            return false;
        }
        boolean isFinish = text.isEmpty();
        this.mViewEmbedder.onImeEvent(isFinish);
        int keyCode = this.shouldSendKeyEventWithKeyCode(text);
        long timeStampMs = System.currentTimeMillis();
        if (keyCode != 229) {
            this.sendKeyEventWithKeyCode(keyCode, 6);
        } else {
            this.nativeSendSyntheticKeyEvent(this.mNativeImeAdapterAndroid, sEventTypeRawKeyDown, timeStampMs, keyCode, 0);
            if (isCommit) {
                this.nativeCommitText(this.mNativeImeAdapterAndroid, text);
            } else {
                this.nativeSetComposingText(this.mNativeImeAdapterAndroid, text, newCursorPosition);
            }
            this.nativeSendSyntheticKeyEvent(this.mNativeImeAdapterAndroid, sEventTypeKeyUp, timeStampMs, keyCode, 0);
        }
        return true;
    }

    void finishComposingText() {
        if (this.mNativeImeAdapterAndroid == 0) {
            return;
        }
        this.nativeFinishComposingText(this.mNativeImeAdapterAndroid);
    }

    boolean translateAndSendNativeEvents(KeyEvent event) {
        if (this.mNativeImeAdapterAndroid == 0) {
            return false;
        }
        int action = event.getAction();
        if (action != 0 && action != 1) {
            return false;
        }
        this.mViewEmbedder.onImeEvent(false);
        return this.nativeSendKeyEvent(this.mNativeImeAdapterAndroid, event, event.getAction(), ImeAdapter.getModifiers(event.getMetaState()), event.getEventTime(), event.getKeyCode(), event.isSystem(), event.getUnicodeChar());
    }

    boolean sendSyntheticKeyEvent(int eventType, long timestampMs, int keyCode, int unicodeChar) {
        if (this.mNativeImeAdapterAndroid == 0) {
            return false;
        }
        this.nativeSendSyntheticKeyEvent(this.mNativeImeAdapterAndroid, eventType, timestampMs, keyCode, unicodeChar);
        return true;
    }

    boolean deleteSurroundingText(int leftLength, int rightLength) {
        if (this.mNativeImeAdapterAndroid == 0) {
            return false;
        }
        this.nativeDeleteSurroundingText(this.mNativeImeAdapterAndroid, leftLength, rightLength);
        return true;
    }

    @VisibleForTesting
    protected boolean setEditableSelectionOffsets(int start, int end) {
        if (this.mNativeImeAdapterAndroid == 0) {
            return false;
        }
        this.nativeSetEditableSelectionOffsets(this.mNativeImeAdapterAndroid, start, end);
        return true;
    }

    void batchStateChanged(boolean isBegin) {
        if (this.mNativeImeAdapterAndroid == 0) {
            return;
        }
        this.nativeImeBatchStateChanged(this.mNativeImeAdapterAndroid, isBegin);
    }

    void commitText() {
        this.cancelComposition();
        if (this.mNativeImeAdapterAndroid != 0) {
            this.nativeCommitText(this.mNativeImeAdapterAndroid, "");
        }
    }

    boolean setComposingRegion(int start, int end) {
        if (this.mNativeImeAdapterAndroid == 0) {
            return false;
        }
        this.nativeSetComposingRegion(this.mNativeImeAdapterAndroid, start, end);
        return true;
    }

    public boolean unselect() {
        if (this.mNativeImeAdapterAndroid == 0) {
            return false;
        }
        this.nativeUnselect(this.mNativeImeAdapterAndroid);
        return true;
    }

    public boolean selectAll() {
        if (this.mNativeImeAdapterAndroid == 0) {
            return false;
        }
        this.nativeSelectAll(this.mNativeImeAdapterAndroid);
        return true;
    }

    public boolean cut() {
        if (this.mNativeImeAdapterAndroid == 0) {
            return false;
        }
        this.nativeCut(this.mNativeImeAdapterAndroid);
        return true;
    }

    public boolean copy() {
        if (this.mNativeImeAdapterAndroid == 0) {
            return false;
        }
        this.nativeCopy(this.mNativeImeAdapterAndroid);
        return true;
    }

    public boolean paste() {
        if (this.mNativeImeAdapterAndroid == 0) {
            return false;
        }
        this.nativePaste(this.mNativeImeAdapterAndroid);
        return true;
    }

    @CalledByNative
    private static void initializeWebInputEvents(int eventTypeRawKeyDown, int eventTypeKeyUp, int eventTypeChar, int modifierShift, int modifierAlt, int modifierCtrl, int modifierCapsLockOn, int modifierNumLockOn) {
        sEventTypeRawKeyDown = eventTypeRawKeyDown;
        sEventTypeKeyUp = eventTypeKeyUp;
        sEventTypeChar = eventTypeChar;
        sModifierShift = modifierShift;
        sModifierAlt = modifierAlt;
        sModifierCtrl = modifierCtrl;
        sModifierCapsLockOn = modifierCapsLockOn;
        sModifierNumLockOn = modifierNumLockOn;
    }

    @CalledByNative
    private static void initializeTextInputTypes(int textInputTypeNone, int textInputTypeText, int textInputTypeTextArea, int textInputTypePassword, int textInputTypeSearch, int textInputTypeUrl, int textInputTypeEmail, int textInputTypeTel, int textInputTypeNumber, int textInputTypeDate, int textInputTypeDateTime, int textInputTypeDateTimeLocal, int textInputTypeMonth, int textInputTypeTime, int textInputTypeWeek, int textInputTypeContentEditable) {
        sTextInputTypeNone = textInputTypeNone;
        sTextInputTypeText = textInputTypeText;
        sTextInputTypeTextArea = textInputTypeTextArea;
        sTextInputTypePassword = textInputTypePassword;
        sTextInputTypeSearch = textInputTypeSearch;
        sTextInputTypeUrl = textInputTypeUrl;
        sTextInputTypeEmail = textInputTypeEmail;
        sTextInputTypeTel = textInputTypeTel;
        sTextInputTypeNumber = textInputTypeNumber;
        sTextInputTypeWeek = textInputTypeWeek;
        sTextInputTypeContentEditable = textInputTypeContentEditable;
    }

    @CalledByNative
    private void cancelComposition() {
        if (this.mInputConnection != null) {
            this.mInputConnection.restartInput();
        }
    }

    @CalledByNative
    void detach() {
        this.mNativeImeAdapterAndroid = 0;
        this.mTextInputType = 0;
    }

    private native boolean nativeSendSyntheticKeyEvent(int var1, int var2, long var3, int var5, int var6);

    private native boolean nativeSendKeyEvent(int var1, KeyEvent var2, int var3, int var4, long var5, int var7, boolean var8, int var9);

    private native void nativeSetComposingText(int var1, String var2, int var3);

    private native void nativeCommitText(int var1, String var2);

    private native void nativeFinishComposingText(int var1);

    private native void nativeAttachImeAdapter(int var1);

    private native void nativeSetEditableSelectionOffsets(int var1, int var2, int var3);

    private native void nativeSetComposingRegion(int var1, int var2, int var3);

    private native void nativeDeleteSurroundingText(int var1, int var2, int var3);

    private native void nativeImeBatchStateChanged(int var1, boolean var2);

    private native void nativeUnselect(int var1);

    private native void nativeSelectAll(int var1);

    private native void nativeCut(int var1);

    private native void nativeCopy(int var1);

    private native void nativePaste(int var1);

    private native void nativeResetImeAdapter(int var1);

    public static class AdapterInputConnectionFactory {
        public AdapterInputConnection get(View view, ImeAdapter imeAdapter, EditorInfo outAttrs) {
            return new AdapterInputConnection(view, imeAdapter, outAttrs);
        }
    }

    private class DelayedDismissInput
    implements Runnable {
        private final int mNativeImeAdapter;

        DelayedDismissInput(int nativeImeAdapter) {
            this.mNativeImeAdapter = nativeImeAdapter;
        }

        public void run() {
            ImeAdapter.this.attach(this.mNativeImeAdapter, sTextInputTypeNone, -1, -1);
            ImeAdapter.this.dismissInput(true);
        }
    }

    public static interface ImeAdapterDelegate {
        public void onImeEvent(boolean var1);

        public void onSetFieldValue();

        public void onDismissInput();

        public View getAttachedView();

        public ResultReceiver getNewShowKeyboardReceiver();
    }
}

