/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.com.google.common.primitives;

import com.android.org.chromium.com.google.common.annotations.VisibleForTesting;
import com.android.org.chromium.com.google.common.base.Preconditions;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnsignedBytes {
    public static final byte MAX_POWER_OF_TWO = -128;

    private UnsignedBytes() {
    }

    public static int toInt(byte value) {
        return value & 0xFF;
    }

    public static byte checkedCast(long value) {
        Preconditions.checkArgument(value >> 8 == 0L, "out of range: %s", value);
        return (byte)value;
    }

    public static byte saturatedCast(long value) {
        if (value > 255L) {
            return -1;
        }
        if (value < 0L) {
            return 0;
        }
        return (byte)value;
    }

    public static int compare(byte a, byte b) {
        return UnsignedBytes.toInt(a) - UnsignedBytes.toInt(b);
    }

    public static byte min(byte ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int min = UnsignedBytes.toInt(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            int next = UnsignedBytes.toInt(array2[i]);
            if (next >= min) continue;
            min = next;
        }
        return (byte)min;
    }

    public static byte max(byte ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int max = UnsignedBytes.toInt(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            int next = UnsignedBytes.toInt(array2[i]);
            if (next <= max) continue;
            max = next;
        }
        return (byte)max;
    }

    public static String join(String separator, byte ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 5);
        builder.append(UnsignedBytes.toInt(array2[0]));
        for (int i = 1; i < array2.length; ++i) {
            builder.append(separator).append(UnsignedBytes.toInt(array2[i]));
        }
        return builder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparatorHolder.BEST_COMPARATOR;
    }

    @VisibleForTesting
    static Comparator<byte[]> lexicographicalComparatorJavaImpl() {
        return LexicographicalComparatorHolder.PureJavaComparator.INSTANCE;
    }

    @VisibleForTesting
    static class LexicographicalComparatorHolder {
        static final String UNSAFE_COMPARATOR_NAME = LexicographicalComparatorHolder.class.getName() + "$UnsafeComparator";
        static final Comparator<byte[]> BEST_COMPARATOR = UnsignedBytes.lexicographicalComparatorJavaImpl();

        LexicographicalComparatorHolder() {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum PureJavaComparator implements Comparator<byte[]>
        {
            INSTANCE;


            @Override
            public int compare(byte[] left, byte[] right) {
                int minLength = Math.min(left.length, right.length);
                for (int i = 0; i < minLength; ++i) {
                    int result = UnsignedBytes.compare(left[i], right[i]);
                    if (result == 0) continue;
                    return result;
                }
                return left.length - right.length;
            }
        }
    }
}

