/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.base;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Environment;
import com.android.org.chromium.base.CalledByNative;
import com.android.org.chromium.base.ContextTypes;
import java.io.File;

public abstract class PathUtils {
    private static String sDataDirectorySuffix;
    private static String sWebappDirectorySuffix;
    private static String sWebappCacheDirectory;

    private PathUtils() {
    }

    public static void setPrivateDataDirectorySuffix(String suffix) {
        sDataDirectorySuffix = suffix;
    }

    public static void setWebappDirectoryInfo(String webappSuffix, String cacheDir) {
        sWebappDirectorySuffix = webappSuffix;
        sWebappCacheDirectory = cacheDir;
    }

    @CalledByNative
    public static String getDataDirectory(Context appContext) {
        if (sDataDirectorySuffix == null) {
            throw new IllegalStateException("setDataDirectorySuffix must be called before getDataDirectory");
        }
        return appContext.getDir(sDataDirectorySuffix, 0).getPath();
    }

    @CalledByNative
    public static String getDatabaseDirectory(Context appContext) {
        return appContext.getDatabasePath("foo").getParent();
    }

    @CalledByNative
    public static String getCacheDirectory(Context appContext) {
        if (ContextTypes.getInstance().getType(appContext) == 1) {
            return appContext.getCacheDir().getPath();
        }
        if (sWebappDirectorySuffix == null || sWebappCacheDirectory == null) {
            throw new IllegalStateException("setWebappDirectoryInfo must be called before getCacheDirectory");
        }
        return new File(appContext.getDir(sWebappDirectorySuffix, 0), sWebappCacheDirectory).getPath();
    }

    @CalledByNative
    private static String getDownloadsDirectory(Context appContext) {
        return Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS).getPath();
    }

    @CalledByNative
    private static String getNativeLibraryDirectory(Context appContext) {
        ApplicationInfo ai = appContext.getApplicationInfo();
        if ((ai.flags & 0x80) != 0 || (ai.flags & 1) == 0) {
            return ai.nativeLibraryDir;
        }
        return "/system/lib/";
    }

    @CalledByNative
    public static String getExternalStorageDirectory() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }
}

