/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.base;

import com.android.org.chromium.javax.annotation.concurrent.NotThreadSafe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class ObserverList<E>
implements Iterable<E> {
    public final List<E> mObservers = new ArrayList();
    private int mIterationDepth = 0;

    public void addObserver(E obs) {
        if (obs == null || this.mObservers.contains(obs)) {
            assert (false);
            return;
        }
        this.mObservers.add(obs);
    }

    public void removeObserver(E obs) {
        int index = this.mObservers.indexOf(obs);
        if (index == -1) {
            return;
        }
        if (this.mIterationDepth == 0) {
            this.mObservers.remove(obs);
        } else {
            this.mObservers.set(index, null);
        }
    }

    public boolean hasObserver(E obs) {
        return this.mObservers.contains(obs);
    }

    public void clear() {
        if (this.mIterationDepth == 0) {
            this.mObservers.clear();
            return;
        }
        int size = this.mObservers.size();
        for (int i = 0; i < size; ++i) {
            this.mObservers.set(i, null);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new ObserverListIterator();
    }

    private void compact() {
        assert (this.mIterationDepth == 0);
        Iterator<E> it = this.mObservers.iterator();
        while (it.hasNext()) {
            E el = it.next();
            if (el != null) continue;
            it.remove();
        }
    }

    private void incrementIterationDepth() {
        ++this.mIterationDepth;
    }

    private void decrementIterationDepthAndCompactIfNeeded() {
        --this.mIterationDepth;
        assert (this.mIterationDepth >= 0);
        if (this.mIterationDepth == 0) {
            this.compact();
        }
    }

    private int getSize() {
        return this.mObservers.size();
    }

    private E getObserverAt(int index) {
        return this.mObservers.get(index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObserverListIterator
    implements Iterator<E> {
        private final int mListEndMarker;
        private int mIndex = 0;
        private boolean mIsExhausted = false;

        private ObserverListIterator() {
            ObserverList.this.incrementIterationDepth();
            this.mListEndMarker = ObserverList.this.getSize();
        }

        @Override
        public boolean hasNext() {
            int lookupIndex;
            for (lookupIndex = this.mIndex; lookupIndex < this.mListEndMarker && ObserverList.this.getObserverAt(lookupIndex) == null; ++lookupIndex) {
            }
            if (lookupIndex < this.mListEndMarker) {
                return true;
            }
            this.compactListIfNeeded();
            return false;
        }

        @Override
        public E next() {
            while (this.mIndex < this.mListEndMarker && ObserverList.this.getObserverAt(this.mIndex) == null) {
                ++this.mIndex;
            }
            if (this.mIndex < this.mListEndMarker) {
                return ObserverList.this.getObserverAt(this.mIndex++);
            }
            this.compactListIfNeeded();
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void compactListIfNeeded() {
            if (!this.mIsExhausted) {
                this.mIsExhausted = true;
                ObserverList.this.decrementIterationDepthAndCompactIfNeeded();
            }
        }
    }
}

