/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.android_webview;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.provider.Settings;
import android.webkit.WebSettings;
import com.android.org.chromium.base.CalledByNative;
import com.android.org.chromium.base.JNINamespace;
import com.android.org.chromium.base.ThreadUtils;

@JNINamespace(value="android_webview")
public class AwSettings {
    private static final String TAG = "AwSettings";
    private final boolean mHasInternetPermission;
    private ZoomSupportChangeListener mZoomChangeListener;
    private double mDIPScale = 1.0;
    private final Object mAwSettingsLock = new Object();
    private LayoutAlgorithm mLayoutAlgorithm = LayoutAlgorithm.NARROW_COLUMNS;
    private int mTextSizePercent = 100;
    private String mStandardFontFamily = "sans-serif";
    private String mFixedFontFamily = "monospace";
    private String mSansSerifFontFamily = "sans-serif";
    private String mSerifFontFamily = "serif";
    private String mCursiveFontFamily = "cursive";
    private String mFantasyFontFamily = "fantasy";
    private String mDefaultTextEncoding = "Latin-1";
    private String mUserAgent;
    private int mMinimumFontSize = 8;
    private int mMinimumLogicalFontSize = 8;
    private int mDefaultFontSize = 16;
    private int mDefaultFixedFontSize = 13;
    private boolean mLoadsImagesAutomatically = true;
    private boolean mImagesEnabled = true;
    private boolean mJavaScriptEnabled = false;
    private boolean mAllowUniversalAccessFromFileURLs = false;
    private boolean mAllowFileAccessFromFileURLs = false;
    private boolean mJavaScriptCanOpenWindowsAutomatically = false;
    private boolean mSupportMultipleWindows = false;
    private WebSettings.PluginState mPluginState = WebSettings.PluginState.OFF;
    private boolean mAppCacheEnabled = false;
    private boolean mDomStorageEnabled = false;
    private boolean mDatabaseEnabled = false;
    private boolean mUseWideViewport = false;
    private boolean mLoadWithOverviewMode = false;
    private boolean mMediaPlaybackRequiresUserGesture = true;
    private String mDefaultVideoPosterURL;
    private float mInitialPageScalePercent = 0.0f;
    private final boolean mSupportLegacyQuirks;
    private final boolean mPasswordEchoEnabled;
    private boolean mBlockNetworkLoads;
    private boolean mAllowContentUrlAccess = true;
    private boolean mAllowFileUrlAccess = true;
    private int mCacheMode = -1;
    private boolean mShouldFocusFirstNode = true;
    private boolean mGeolocationEnabled = true;
    private boolean mAutoCompleteEnabled = true;
    private boolean mSupportZoom = true;
    private boolean mBuiltInZoomControls = false;
    private boolean mDisplayZoomControls = true;
    private static final Object sGlobalContentSettingsLock = new Object();
    private static boolean sAppCachePathIsSet = false;
    private int mNativeAwSettings = 0;
    private boolean mIsUpdateWebkitPrefsMessagePending = false;
    private final EventHandler mEventHandler;
    private static final int MINIMUM_FONT_SIZE = 1;
    private static final int MAXIMUM_FONT_SIZE = 72;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AwSettings(Context context, boolean isAccessFromFileURLsGrantedByDefault, boolean supportsLegacyQuirks) {
        boolean hasInternetPermission = context.checkPermission("android.permission.INTERNET", Process.myPid(), Process.myUid()) == 0;
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            this.mHasInternetPermission = hasInternetPermission;
            this.mBlockNetworkLoads = !hasInternetPermission;
            this.mEventHandler = new EventHandler();
            if (isAccessFromFileURLsGrantedByDefault) {
                this.mAllowUniversalAccessFromFileURLs = true;
                this.mAllowFileAccessFromFileURLs = true;
            }
            this.mUserAgent = LazyDefaultUserAgent.sInstance;
            this.mPasswordEchoEnabled = Settings.System.getInt(context.getContentResolver(), "show_password", 1) == 1;
            this.mSupportLegacyQuirks = supportsLegacyQuirks;
        }
    }

    @CalledByNative
    private void nativeAwSettingsGone(int nativeAwSettings) {
        assert (this.mNativeAwSettings != 0 && this.mNativeAwSettings == nativeAwSettings);
        this.mNativeAwSettings = 0;
    }

    @CalledByNative
    private double getDIPScaleLocked() {
        return this.mDIPScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDIPScale(double dipScale) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            this.mDIPScale = dipScale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setZoomListener(ZoomSupportChangeListener zoomChangeListener) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            this.mZoomChangeListener = zoomChangeListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWebContents(int nativeWebContents) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mNativeAwSettings != 0) {
                this.nativeDestroy(this.mNativeAwSettings);
                assert (this.mNativeAwSettings == 0);
            }
            if (nativeWebContents != 0) {
                this.mEventHandler.bindUiThread();
                this.mNativeAwSettings = this.nativeInit(nativeWebContents);
                this.nativeUpdateEverythingLocked(this.mNativeAwSettings);
                this.onGestureZoomSupportChanged(this.supportsGestureZoomLocked());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockNetworkLoads(boolean flag) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (!flag && !this.mHasInternetPermission) {
                throw new SecurityException("Permission denied - application missing INTERNET permission");
            }
            this.mBlockNetworkLoads = flag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBlockNetworkLoads() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mBlockNetworkLoads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowFileAccess(boolean allow) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mAllowFileUrlAccess != allow) {
                this.mAllowFileUrlAccess = allow;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAllowFileAccess() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mAllowFileUrlAccess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowContentAccess(boolean allow) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mAllowContentUrlAccess != allow) {
                this.mAllowContentUrlAccess = allow;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAllowContentAccess() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mAllowContentUrlAccess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheMode(int mode) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mCacheMode != mode) {
                this.mCacheMode = mode;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCacheMode() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mCacheMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShouldFocusFirstNode(boolean flag) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            this.mShouldFocusFirstNode = flag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialPageScale(float scaleInPercent) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mInitialPageScalePercent != scaleInPercent) {
                this.mInitialPageScalePercent = scaleInPercent;
                this.mEventHandler.maybeRunOnUiThreadBlocking(new Runnable(){

                    public void run() {
                        if (AwSettings.this.mNativeAwSettings != 0) {
                            AwSettings.this.nativeUpdateInitialPageScaleLocked(AwSettings.this.mNativeAwSettings);
                        }
                    }
                });
            }
        }
    }

    @CalledByNative
    private float getInitialPageScalePercentLocked() {
        return this.mInitialPageScalePercent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldFocusFirstNode() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mShouldFocusFirstNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeolocationEnabled(boolean flag) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mGeolocationEnabled != flag) {
                this.mGeolocationEnabled = flag;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getGeolocationEnabled() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mGeolocationEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSaveFormData(boolean enable) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mAutoCompleteEnabled != enable) {
                this.mAutoCompleteEnabled = enable;
                this.mEventHandler.maybeRunOnUiThreadBlocking(new Runnable(){

                    public void run() {
                        if (AwSettings.this.mNativeAwSettings != 0) {
                            AwSettings.this.nativeUpdateFormDataPreferencesLocked(AwSettings.this.mNativeAwSettings);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSaveFormData() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.getSaveFormDataLocked();
        }
    }

    @CalledByNative
    private boolean getSaveFormDataLocked() {
        return this.mAutoCompleteEnabled;
    }

    public static String getDefaultUserAgent() {
        return LazyDefaultUserAgent.sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserAgentString(String ua) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            String oldUserAgent = this.mUserAgent;
            this.mUserAgent = ua == null || ua.length() == 0 ? LazyDefaultUserAgent.sInstance : ua;
            if (!oldUserAgent.equals(this.mUserAgent)) {
                this.mEventHandler.maybeRunOnUiThreadBlocking(new Runnable(){

                    public void run() {
                        if (AwSettings.this.mNativeAwSettings != 0) {
                            AwSettings.this.nativeUpdateUserAgentLocked(AwSettings.this.mNativeAwSettings);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserAgentString() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mUserAgent;
        }
    }

    @CalledByNative
    private String getUserAgentLocked() {
        return this.mUserAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadWithOverviewMode(boolean overview) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mLoadWithOverviewMode != overview) {
                this.mLoadWithOverviewMode = overview;
                this.mEventHandler.updateWebkitPreferencesLocked();
                this.mEventHandler.maybeRunOnUiThreadBlocking(new Runnable(){

                    public void run() {
                        if (AwSettings.this.mNativeAwSettings != 0) {
                            AwSettings.this.nativeResetScrollAndScaleState(AwSettings.this.mNativeAwSettings);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getLoadWithOverviewMode() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mLoadWithOverviewMode;
        }
    }

    @CalledByNative
    private boolean getLoadWithOverviewModeLocked() {
        return this.mLoadWithOverviewMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextZoom(int textZoom) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mTextSizePercent != textZoom) {
                this.mTextSizePercent = textZoom;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTextZoom() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mTextSizePercent;
        }
    }

    @CalledByNative
    private int getTextSizePercentLocked() {
        return this.mTextSizePercent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStandardFontFamily(String font) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (font != null && !this.mStandardFontFamily.equals(font)) {
                this.mStandardFontFamily = font;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStandardFontFamily() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mStandardFontFamily;
        }
    }

    @CalledByNative
    private String getStandardFontFamilyLocked() {
        return this.mStandardFontFamily;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFixedFontFamily(String font) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (font != null && !this.mFixedFontFamily.equals(font)) {
                this.mFixedFontFamily = font;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFixedFontFamily() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mFixedFontFamily;
        }
    }

    @CalledByNative
    private String getFixedFontFamilyLocked() {
        return this.mFixedFontFamily;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSansSerifFontFamily(String font) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (font != null && !this.mSansSerifFontFamily.equals(font)) {
                this.mSansSerifFontFamily = font;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSansSerifFontFamily() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mSansSerifFontFamily;
        }
    }

    @CalledByNative
    private String getSansSerifFontFamilyLocked() {
        return this.mSansSerifFontFamily;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSerifFontFamily(String font) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (font != null && !this.mSerifFontFamily.equals(font)) {
                this.mSerifFontFamily = font;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerifFontFamily() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mSerifFontFamily;
        }
    }

    @CalledByNative
    private String getSerifFontFamilyLocked() {
        return this.mSerifFontFamily;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursiveFontFamily(String font) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (font != null && !this.mCursiveFontFamily.equals(font)) {
                this.mCursiveFontFamily = font;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursiveFontFamily() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mCursiveFontFamily;
        }
    }

    @CalledByNative
    private String getCursiveFontFamilyLocked() {
        return this.mCursiveFontFamily;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFantasyFontFamily(String font) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (font != null && !this.mFantasyFontFamily.equals(font)) {
                this.mFantasyFontFamily = font;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFantasyFontFamily() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mFantasyFontFamily;
        }
    }

    @CalledByNative
    private String getFantasyFontFamilyLocked() {
        return this.mFantasyFontFamily;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimumFontSize(int size) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            size = this.clipFontSize(size);
            if (this.mMinimumFontSize != size) {
                this.mMinimumFontSize = size;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinimumFontSize() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mMinimumFontSize;
        }
    }

    @CalledByNative
    private int getMinimumFontSizeLocked() {
        return this.mMinimumFontSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimumLogicalFontSize(int size) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            size = this.clipFontSize(size);
            if (this.mMinimumLogicalFontSize != size) {
                this.mMinimumLogicalFontSize = size;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinimumLogicalFontSize() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mMinimumLogicalFontSize;
        }
    }

    @CalledByNative
    private int getMinimumLogicalFontSizeLocked() {
        return this.mMinimumLogicalFontSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultFontSize(int size) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            size = this.clipFontSize(size);
            if (this.mDefaultFontSize != size) {
                this.mDefaultFontSize = size;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDefaultFontSize() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mDefaultFontSize;
        }
    }

    @CalledByNative
    private int getDefaultFontSizeLocked() {
        return this.mDefaultFontSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultFixedFontSize(int size) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            size = this.clipFontSize(size);
            if (this.mDefaultFixedFontSize != size) {
                this.mDefaultFixedFontSize = size;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDefaultFixedFontSize() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mDefaultFixedFontSize;
        }
    }

    @CalledByNative
    private int getDefaultFixedFontSizeLocked() {
        return this.mDefaultFixedFontSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJavaScriptEnabled(boolean flag) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mJavaScriptEnabled != flag) {
                this.mJavaScriptEnabled = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowUniversalAccessFromFileURLs(boolean flag) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mAllowUniversalAccessFromFileURLs != flag) {
                this.mAllowUniversalAccessFromFileURLs = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowFileAccessFromFileURLs(boolean flag) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mAllowFileAccessFromFileURLs != flag) {
                this.mAllowFileAccessFromFileURLs = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadsImagesAutomatically(boolean flag) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mLoadsImagesAutomatically != flag) {
                this.mLoadsImagesAutomatically = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getLoadsImagesAutomatically() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mLoadsImagesAutomatically;
        }
    }

    @CalledByNative
    private boolean getLoadsImagesAutomaticallyLocked() {
        return this.mLoadsImagesAutomatically;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImagesEnabled(boolean flag) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mImagesEnabled != flag) {
                this.mImagesEnabled = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getImagesEnabled() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mImagesEnabled;
        }
    }

    @CalledByNative
    private boolean getImagesEnabledLocked() {
        return this.mImagesEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getJavaScriptEnabled() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mJavaScriptEnabled;
        }
    }

    @CalledByNative
    private boolean getJavaScriptEnabledLocked() {
        return this.mJavaScriptEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAllowUniversalAccessFromFileURLs() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mAllowUniversalAccessFromFileURLs;
        }
    }

    @CalledByNative
    private boolean getAllowUniversalAccessFromFileURLsLocked() {
        return this.mAllowUniversalAccessFromFileURLs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAllowFileAccessFromFileURLs() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mAllowFileAccessFromFileURLs;
        }
    }

    @CalledByNative
    private boolean getAllowFileAccessFromFileURLsLocked() {
        return this.mAllowFileAccessFromFileURLs;
    }

    public void setPluginsEnabled(boolean flag) {
        this.setPluginState(flag ? WebSettings.PluginState.ON : WebSettings.PluginState.OFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPluginState(WebSettings.PluginState state) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mPluginState != state) {
                this.mPluginState = state;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPluginsEnabled() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mPluginState == WebSettings.PluginState.ON;
        }
    }

    @CalledByNative
    private boolean getPluginsDisabledLocked() {
        return this.mPluginState == WebSettings.PluginState.OFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSettings.PluginState getPluginState() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mPluginState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJavaScriptCanOpenWindowsAutomatically(boolean flag) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mJavaScriptCanOpenWindowsAutomatically != flag) {
                this.mJavaScriptCanOpenWindowsAutomatically = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getJavaScriptCanOpenWindowsAutomatically() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mJavaScriptCanOpenWindowsAutomatically;
        }
    }

    @CalledByNative
    private boolean getJavaScriptCanOpenWindowsAutomaticallyLocked() {
        return this.mJavaScriptCanOpenWindowsAutomatically;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutAlgorithm(LayoutAlgorithm l) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mLayoutAlgorithm != l) {
                this.mLayoutAlgorithm = l;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutAlgorithm getLayoutAlgorithm() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mLayoutAlgorithm;
        }
    }

    @CalledByNative
    private boolean getTextAutosizingEnabledLocked() {
        return this.mLayoutAlgorithm == LayoutAlgorithm.TEXT_AUTOSIZING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSupportMultipleWindows(boolean support) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mSupportMultipleWindows != support) {
                this.mSupportMultipleWindows = support;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportMultipleWindows() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mSupportMultipleWindows;
        }
    }

    @CalledByNative
    private boolean getSupportMultipleWindowsLocked() {
        return this.mSupportMultipleWindows;
    }

    @CalledByNative
    private boolean getSupportLegacyQuirksLocked() {
        return this.mSupportLegacyQuirks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseWideViewPort(boolean use) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mUseWideViewport != use) {
                this.mUseWideViewport = use;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getUseWideViewPort() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mUseWideViewport;
        }
    }

    @CalledByNative
    private boolean getUseWideViewportLocked() {
        return this.mUseWideViewport;
    }

    @CalledByNative
    private boolean getPasswordEchoEnabled() {
        return this.mPasswordEchoEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppCacheEnabled(boolean flag) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mAppCacheEnabled != flag) {
                this.mAppCacheEnabled = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppCachePath(String path) {
        boolean needToSync = false;
        Object object = sGlobalContentSettingsLock;
        synchronized (object) {
            if (!sAppCachePathIsSet && path != null && !path.isEmpty()) {
                sAppCachePathIsSet = true;
                needToSync = true;
            }
        }
        if (needToSync) {
            object = this.mAwSettingsLock;
            synchronized (object) {
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private boolean getAppCacheEnabledLocked() {
        if (!this.mAppCacheEnabled) {
            return false;
        }
        Object object = sGlobalContentSettingsLock;
        synchronized (object) {
            return sAppCachePathIsSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDomStorageEnabled(boolean flag) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mDomStorageEnabled != flag) {
                this.mDomStorageEnabled = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDomStorageEnabled() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mDomStorageEnabled;
        }
    }

    @CalledByNative
    private boolean getDomStorageEnabledLocked() {
        return this.mDomStorageEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDatabaseEnabled(boolean flag) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mDatabaseEnabled != flag) {
                this.mDatabaseEnabled = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDatabaseEnabled() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mDatabaseEnabled;
        }
    }

    @CalledByNative
    private boolean getDatabaseEnabledLocked() {
        return this.mDatabaseEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultTextEncodingName(String encoding) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (encoding != null && !this.mDefaultTextEncoding.equals(encoding)) {
                this.mDefaultTextEncoding = encoding;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultTextEncodingName() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mDefaultTextEncoding;
        }
    }

    @CalledByNative
    private String getDefaultTextEncodingLocked() {
        return this.mDefaultTextEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMediaPlaybackRequiresUserGesture(boolean require) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mMediaPlaybackRequiresUserGesture != require) {
                this.mMediaPlaybackRequiresUserGesture = require;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMediaPlaybackRequiresUserGesture() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mMediaPlaybackRequiresUserGesture;
        }
    }

    @CalledByNative
    private boolean getMediaPlaybackRequiresUserGestureLocked() {
        return this.mMediaPlaybackRequiresUserGesture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultVideoPosterURL(String url) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mDefaultVideoPosterURL != null && !this.mDefaultVideoPosterURL.equals(url) || this.mDefaultVideoPosterURL == null && url != null) {
                this.mDefaultVideoPosterURL = url;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultVideoPosterURL() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mDefaultVideoPosterURL;
        }
    }

    @CalledByNative
    private String getDefaultVideoPosterURLLocked() {
        return this.mDefaultVideoPosterURL;
    }

    private void onGestureZoomSupportChanged(final boolean supportsGestureZoom) {
        this.mEventHandler.maybePostOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = AwSettings.this.mAwSettingsLock;
                synchronized (object) {
                    if (AwSettings.this.mZoomChangeListener != null) {
                        AwSettings.this.mZoomChangeListener.onGestureZoomSupportChanged(supportsGestureZoom);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSupportZoom(boolean support) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mSupportZoom != support) {
                this.mSupportZoom = support;
                this.onGestureZoomSupportChanged(this.supportsGestureZoomLocked());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportZoom() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mSupportZoom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuiltInZoomControls(boolean enabled) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            if (this.mBuiltInZoomControls != enabled) {
                this.mBuiltInZoomControls = enabled;
                this.onGestureZoomSupportChanged(this.supportsGestureZoomLocked());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBuiltInZoomControls() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mBuiltInZoomControls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayZoomControls(boolean enabled) {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            this.mDisplayZoomControls = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDisplayZoomControls() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.mDisplayZoomControls;
        }
    }

    private boolean supportsGestureZoomLocked() {
        assert (Thread.holdsLock(this.mAwSettingsLock));
        return this.mSupportZoom && this.mBuiltInZoomControls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean supportsGestureZoom() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.supportsGestureZoomLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shouldDisplayZoomControls() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            return this.supportsGestureZoomLocked() && this.mDisplayZoomControls;
        }
    }

    private int clipFontSize(int size) {
        if (size < 1) {
            return 1;
        }
        if (size > 72) {
            return 72;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void updateEverything() {
        Object object = this.mAwSettingsLock;
        synchronized (object) {
            this.nativeUpdateEverythingLocked(this.mNativeAwSettings);
        }
    }

    private void updateWebkitPreferencesOnUiThreadLocked() {
        if (this.mNativeAwSettings != 0) {
            assert (this.mEventHandler.mHandler != null);
            ThreadUtils.assertOnUiThread();
            this.nativeUpdateWebkitPreferencesLocked(this.mNativeAwSettings);
        }
    }

    private native int nativeInit(int var1);

    private native void nativeDestroy(int var1);

    private native void nativeResetScrollAndScaleState(int var1);

    private native void nativeUpdateEverythingLocked(int var1);

    private native void nativeUpdateInitialPageScaleLocked(int var1);

    private native void nativeUpdateUserAgentLocked(int var1);

    private native void nativeUpdateWebkitPreferencesLocked(int var1);

    private static native String nativeGetDefaultUserAgent();

    private native void nativeUpdateFormDataPreferencesLocked(int var1);

    static /* synthetic */ String access$000() {
        return AwSettings.nativeGetDefaultUserAgent();
    }

    static interface ZoomSupportChangeListener {
        public void onGestureZoomSupportChanged(boolean var1);
    }

    private class EventHandler {
        private static final int UPDATE_WEBKIT_PREFERENCES = 0;
        private Handler mHandler;

        EventHandler() {
        }

        void bindUiThread() {
            if (this.mHandler != null) {
                return;
            }
            this.mHandler = new Handler(ThreadUtils.getUiThreadLooper()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            Object object = AwSettings.this.mAwSettingsLock;
                            synchronized (object) {
                                AwSettings.this.updateWebkitPreferencesOnUiThreadLocked();
                                AwSettings.this.mIsUpdateWebkitPrefsMessagePending = false;
                                AwSettings.this.mAwSettingsLock.notifyAll();
                                break;
                            }
                        }
                    }
                }
            };
        }

        void maybeRunOnUiThreadBlocking(Runnable r) {
            if (this.mHandler != null) {
                ThreadUtils.runOnUiThreadBlocking(r);
            }
        }

        void maybePostOnUiThread(Runnable r) {
            if (this.mHandler != null) {
                this.mHandler.post(r);
            }
        }

        private void updateWebkitPreferencesLocked() {
            assert (Thread.holdsLock(AwSettings.this.mAwSettingsLock));
            if (AwSettings.this.mNativeAwSettings == 0) {
                return;
            }
            if (this.mHandler == null) {
                return;
            }
            if (ThreadUtils.runningOnUiThread()) {
                AwSettings.this.updateWebkitPreferencesOnUiThreadLocked();
            } else {
                if (AwSettings.this.mIsUpdateWebkitPrefsMessagePending) {
                    return;
                }
                AwSettings.this.mIsUpdateWebkitPrefsMessagePending = true;
                this.mHandler.sendMessage(Message.obtain(null, 0));
                try {
                    while (AwSettings.this.mIsUpdateWebkitPrefsMessagePending) {
                        AwSettings.this.mAwSettingsLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    static class LazyDefaultUserAgent {
        private static final String sInstance = AwSettings.access$000();

        LazyDefaultUserAgent() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LayoutAlgorithm {
        NORMAL,
        SINGLE_COLUMN,
        NARROW_COLUMNS,
        TEXT_AUTOSIZING;

    }
}

