/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.android_webview;

import android.content.SharedPreferences;
import android.webkit.ValueCallback;
import com.android.org.chromium.base.ThreadUtils;
import com.android.org.chromium.net.GURLUtils;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AwGeolocationPermissions {
    private static final String PREF_PREFIX = "AwGeolocationPermissions%";
    private final SharedPreferences mSharedPreferences;

    public AwGeolocationPermissions(SharedPreferences sharedPreferences) {
        this.mSharedPreferences = sharedPreferences;
    }

    public void allow(String origin) {
        String key = this.getOriginKey(origin);
        if (key != null) {
            this.mSharedPreferences.edit().putBoolean(key, true).apply();
        }
    }

    public void deny(String origin) {
        String key = this.getOriginKey(origin);
        if (key != null) {
            this.mSharedPreferences.edit().putBoolean(key, false).apply();
        }
    }

    public void clear(String origin) {
        String key = this.getOriginKey(origin);
        if (key != null) {
            this.mSharedPreferences.edit().remove(key).apply();
        }
    }

    public void clearAll() {
        SharedPreferences.Editor editor = null;
        for (String name : this.mSharedPreferences.getAll().keySet()) {
            if (!name.startsWith(PREF_PREFIX)) continue;
            if (editor == null) {
                editor = this.mSharedPreferences.edit();
            }
            editor.remove(name);
        }
        if (editor != null) {
            editor.apply();
        }
    }

    public boolean isOriginAllowed(String origin) {
        return this.mSharedPreferences.getBoolean(this.getOriginKey(origin), false);
    }

    public boolean hasOrigin(String origin) {
        return this.mSharedPreferences.contains(this.getOriginKey(origin));
    }

    public void getAllowed(String origin, final ValueCallback<Boolean> callback) {
        final boolean finalAllowed = this.isOriginAllowed(origin);
        ThreadUtils.postOnUiThread(new Runnable(){

            public void run() {
                callback.onReceiveValue(finalAllowed);
            }
        });
    }

    public void getOrigins(final ValueCallback<Set<String>> callback) {
        final HashSet<String> origins = new HashSet<String>();
        for (String name : this.mSharedPreferences.getAll().keySet()) {
            if (!name.startsWith(PREF_PREFIX)) continue;
            origins.add(name.substring(PREF_PREFIX.length()));
        }
        ThreadUtils.postOnUiThread(new Runnable(){

            public void run() {
                callback.onReceiveValue(origins);
            }
        });
    }

    private String getOriginKey(String url) {
        String origin = GURLUtils.getOrigin(url);
        if (origin.isEmpty()) {
            return null;
        }
        return PREF_PREFIX + origin;
    }
}

