/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.app.ActivityManagerNative;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.text.TextUtils;
import com.android.ims.ImsCallForwardInfo;
import com.android.ims.ImsEcbm;
import com.android.ims.ImsEcbmStateListener;
import com.android.ims.ImsException;
import com.android.ims.ImsReasonInfo;
import com.android.ims.ImsSsInfo;
import com.android.ims.ImsUtInterface;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.Subscription;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.imsphone.ImsPhoneBase;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.imsphone.ImsPhoneCallTracker;
import com.android.internal.telephony.imsphone.ImsPhoneConnection;
import com.android.internal.telephony.imsphone.ImsPhoneMmiCode;
import com.android.internal.telephony.uicc.IccRecords;
import java.util.ArrayList;
import java.util.List;

public class ImsPhone
extends ImsPhoneBase {
    private static final String LOG_TAG = "ImsPhone";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    protected static final int EVENT_SET_CALL_BARRING_DONE = 34;
    protected static final int EVENT_GET_CALL_BARRING_DONE = 35;
    protected static final int EVENT_SET_CALL_WAITING_DONE = 36;
    protected static final int EVENT_GET_CALL_WAITING_DONE = 37;
    public static final String CS_FALLBACK = "cs_fallback";
    static final int RESTART_ECM_TIMER = 0;
    static final int CANCEL_ECM_TIMER = 1;
    private static final int DEFAULT_ECM_EXIT_TIMER_VALUE = 300000;
    PhoneBase mDefaultPhone;
    ImsPhoneCallTracker mCT;
    ArrayList<ImsPhoneMmiCode> mPendingMMIs = new ArrayList();
    Registrant mPostDialHandler;
    ServiceState mSS = new ServiceState();
    private String mLastDialString;
    PowerManager.WakeLock mWakeLock;
    protected boolean mIsPhoneInEcmState;
    private Registrant mEcmExitRespRegistrant;
    private final RegistrantList mSilentRedialRegistrants = new RegistrantList();
    private Runnable mExitEcmRunnable = new Runnable(){

        @Override
        public void run() {
            ImsPhone.this.exitEmergencyCallbackMode();
        }
    };
    ImsEcbmStateListener mImsEcbmStateListener = new ImsEcbmStateListener(){

        public void onECBMEntered() {
            Rlog.d(ImsPhone.LOG_TAG, "onECBMEntered");
            ImsPhone.this.handleEnterEmergencyCallbackMode();
        }

        public void onECBMExited() {
            Rlog.d(ImsPhone.LOG_TAG, "onECBMExited");
            ImsPhone.this.handleExitEmergencyCallbackMode();
        }
    };

    ImsPhone(Context context, PhoneNotifier notifier, Phone defaultPhone) {
        super(LOG_TAG, context, notifier);
        this.mDefaultPhone = (PhoneBase)defaultPhone;
        this.mCT = new ImsPhoneCallTracker(this);
        this.mSS.setStateOff();
        this.mPhoneId = this.mDefaultPhone.getPhoneId();
        this.mIsPhoneInEcmState = SystemProperties.getBoolean("ril.cdma.inecmmode", false);
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, LOG_TAG);
        this.mWakeLock.setReferenceCounted(false);
    }

    public void updateParentPhone(PhoneBase parentPhone) {
        this.mDefaultPhone = parentPhone;
        this.mPhoneId = this.mDefaultPhone.getPhoneId();
    }

    @Override
    public void dispose() {
        Rlog.d(LOG_TAG, "dispose");
        this.mPendingMMIs.clear();
        this.mCT.dispose();
    }

    @Override
    public void removeReferences() {
        Rlog.d(LOG_TAG, "removeReferences");
        super.removeReferences();
        this.mCT = null;
        this.mSS = null;
    }

    @Override
    public ServiceState getServiceState() {
        return this.mSS;
    }

    void setServiceState(int state) {
        this.mSS.setState(state);
    }

    @Override
    public CallTracker getCallTracker() {
        return this.mCT;
    }

    public List<? extends ImsPhoneMmiCode> getPendingMmiCodes() {
        return this.mPendingMMIs;
    }

    public void acceptCall(int videoState) throws CallStateException {
        this.mCT.acceptCall(videoState);
    }

    @Override
    public void rejectCall() throws CallStateException {
        this.mCT.rejectCall();
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        this.mCT.switchWaitingOrHoldingAndActive();
    }

    @Override
    public boolean canConference() {
        return this.mCT.canConference();
    }

    @Override
    public boolean canDial() {
        return this.mCT.canDial();
    }

    @Override
    public void conference() {
        this.mCT.conference();
    }

    @Override
    public void clearDisconnected() {
        this.mCT.clearDisconnected();
    }

    @Override
    public boolean canTransfer() {
        return this.mCT.canTransfer();
    }

    @Override
    public void explicitCallTransfer() {
        this.mCT.explicitCallTransfer();
    }

    @Override
    public ImsPhoneCall getForegroundCall() {
        return this.mCT.mForegroundCall;
    }

    @Override
    public ImsPhoneCall getBackgroundCall() {
        return this.mCT.mBackgroundCall;
    }

    @Override
    public ImsPhoneCall getRingingCall() {
        return this.mCT.mRingingCall;
    }

    private boolean handleCallDeflectionIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        if (this.getRingingCall().getState() != Call.State.IDLE) {
            Rlog.d(LOG_TAG, "MmiCode 0: rejectCall");
            try {
                this.mCT.rejectCall();
            }
            catch (CallStateException e) {
                Rlog.d(LOG_TAG, "reject failed", e);
                this.notifySuppServiceFailed(Phone.SuppService.REJECT);
            }
        } else if (this.getBackgroundCall().getState() != Call.State.IDLE) {
            Rlog.d(LOG_TAG, "MmiCode 0: hangupWaitingOrBackground");
            try {
                this.mCT.hangup(this.getBackgroundCall());
            }
            catch (CallStateException e) {
                Rlog.d(LOG_TAG, "hangup failed", e);
            }
        }
        return true;
    }

    private boolean handleCallWaitingIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len > 2) {
            return false;
        }
        ImsPhoneCall call = this.getForegroundCall();
        try {
            if (len > 1) {
                Rlog.d(LOG_TAG, "not support 1X SEND");
                this.notifySuppServiceFailed(Phone.SuppService.HANGUP);
            } else if (call.getState() != Call.State.IDLE) {
                Rlog.d(LOG_TAG, "MmiCode 1: hangup foreground");
                this.mCT.hangup(call);
            } else {
                Rlog.d(LOG_TAG, "MmiCode 1: switchWaitingOrHoldingAndActive");
                this.mCT.switchWaitingOrHoldingAndActive();
            }
        }
        catch (CallStateException e) {
            Rlog.d(LOG_TAG, "hangup failed", e);
            this.notifySuppServiceFailed(Phone.SuppService.HANGUP);
        }
        return true;
    }

    private boolean handleCallHoldIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len > 2) {
            return false;
        }
        ImsPhoneCall call = this.getForegroundCall();
        if (len > 1) {
            Rlog.d(LOG_TAG, "separate not supported");
            this.notifySuppServiceFailed(Phone.SuppService.SEPARATE);
        } else {
            try {
                if (this.getRingingCall().getState() != Call.State.IDLE) {
                    Rlog.d(LOG_TAG, "MmiCode 2: accept ringing call");
                    this.mCT.acceptCall(2);
                } else {
                    Rlog.d(LOG_TAG, "MmiCode 2: switchWaitingOrHoldingAndActive");
                    this.mCT.switchWaitingOrHoldingAndActive();
                }
            }
            catch (CallStateException e) {
                Rlog.d(LOG_TAG, "switch failed", e);
                this.notifySuppServiceFailed(Phone.SuppService.SWITCH);
            }
        }
        return true;
    }

    private boolean handleMultipartyIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        Rlog.d(LOG_TAG, "MmiCode 3: merge calls");
        this.conference();
        return true;
    }

    private boolean handleEctIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len != 1) {
            return false;
        }
        Rlog.d(LOG_TAG, "MmiCode 4: not support explicit call transfer");
        this.notifySuppServiceFailed(Phone.SuppService.TRANSFER);
        return true;
    }

    private boolean handleCcbsIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        Rlog.i(LOG_TAG, "MmiCode 5: CCBS not supported!");
        this.notifySuppServiceFailed(Phone.SuppService.UNKNOWN);
        return true;
    }

    @Override
    public boolean handleInCallMmiCommands(String dialString) {
        if (!this.isInCall()) {
            return false;
        }
        if (TextUtils.isEmpty(dialString)) {
            return false;
        }
        boolean result = false;
        char ch = dialString.charAt(0);
        switch (ch) {
            case '0': {
                result = this.handleCallDeflectionIncallSupplementaryService(dialString);
                break;
            }
            case '1': {
                result = this.handleCallWaitingIncallSupplementaryService(dialString);
                break;
            }
            case '2': {
                result = this.handleCallHoldIncallSupplementaryService(dialString);
                break;
            }
            case '3': {
                result = this.handleMultipartyIncallSupplementaryService(dialString);
                break;
            }
            case '4': {
                result = this.handleEctIncallSupplementaryService(dialString);
                break;
            }
            case '5': {
                result = this.handleCcbsIncallSupplementaryService(dialString);
                break;
            }
        }
        return result;
    }

    @Override
    boolean isInCall() {
        Call.State foregroundCallState = this.getForegroundCall().getState();
        Call.State backgroundCallState = this.getBackgroundCall().getState();
        Call.State ringingCallState = this.getRingingCall().getState();
        return foregroundCallState.isAlive() || backgroundCallState.isAlive() || ringingCallState.isAlive();
    }

    void notifyNewRingingConnection(Connection c) {
        this.mDefaultPhone.notifyNewRingingConnectionP(c);
    }

    public Connection dial(String dialString, int videoState) throws CallStateException {
        return this.dialInternal(dialString, videoState);
    }

    protected Connection dialInternal(String dialString, int videoState) throws CallStateException {
        String newDialString = PhoneNumberUtils.stripSeparators(dialString);
        if (this.handleInCallMmiCommands(newDialString)) {
            return null;
        }
        if (this.mDefaultPhone.getPhoneType() == 2) {
            return this.mCT.dial(dialString, videoState);
        }
        String networkPortion = PhoneNumberUtils.extractNetworkPortionAlt(newDialString);
        ImsPhoneMmiCode mmi = ImsPhoneMmiCode.newFromDialString(networkPortion, this);
        Rlog.d(LOG_TAG, "dialing w/ mmi '" + mmi + "'...");
        if (mmi == null) {
            return this.mCT.dial(dialString, videoState);
        }
        if (mmi.isTemporaryModeCLIR()) {
            return this.mCT.dial(mmi.getDialingNumber(), mmi.getCLIRMode(), videoState);
        }
        if (!mmi.isSupportedOverImsPhone()) {
            throw new CallStateException(CS_FALLBACK);
        }
        this.mPendingMMIs.add(mmi);
        this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        mmi.processCode();
        return null;
    }

    @Override
    public void sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Rlog.e(LOG_TAG, "sendDtmf called with invalid character '" + c + "'");
        } else if (this.mCT.mState == PhoneConstants.State.OFFHOOK) {
            this.mCT.sendDtmf(c);
        }
    }

    @Override
    public void startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Rlog.e(LOG_TAG, "startDtmf called with invalid character '" + c + "'");
        } else {
            this.sendDtmf(c);
        }
    }

    @Override
    public void stopDtmf() {
    }

    @Override
    public void setOnPostDialCharacter(Handler h, int what, Object obj) {
        this.mPostDialHandler = new Registrant(h, what, obj);
    }

    void notifyIncomingRing() {
        Rlog.d(LOG_TAG, "notifyIncomingRing");
        AsyncResult ar = new AsyncResult(null, null, null);
        this.sendMessage(this.obtainMessage(14, ar));
    }

    @Override
    public void setMute(boolean muted) {
        this.mCT.setMute(muted);
    }

    @Override
    public boolean getMute() {
        return this.mCT.getMute();
    }

    @Override
    public PhoneConstants.State getState() {
        return this.mCT.mState;
    }

    private boolean isValidCommandInterfaceCFReason(int commandInterfaceCFReason) {
        switch (commandInterfaceCFReason) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private boolean isValidCommandInterfaceCFAction(int commandInterfaceCFAction) {
        switch (commandInterfaceCFAction) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private boolean isCfEnable(int action) {
        return action == 1 || action == 3;
    }

    private int getConditionFromCFReason(int reason) {
        switch (reason) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return -1;
    }

    private int getCFReasonFromCondition(int condition) {
        switch (condition) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 3;
    }

    private int getActionFromCFAction(int action) {
        switch (action) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public void getCallForwardingOption(int commandInterfaceCFReason, Message onComplete) {
        Rlog.d(LOG_TAG, "getCallForwardingOption reason=" + commandInterfaceCFReason);
        if (this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
            Rlog.d(LOG_TAG, "requesting call forwarding query.");
            Message resp = this.obtainMessage(13, onComplete);
            try {
                ImsUtInterface ut = this.mCT.getUtInterface();
                ut.queryCallForward(this.getConditionFromCFReason(commandInterfaceCFReason), null, resp);
            }
            catch (ImsException e) {
                this.sendErrorResponse(onComplete, e);
            }
        } else if (onComplete != null) {
            this.sendErrorResponse(onComplete);
        }
    }

    @Override
    public void setCallForwardingOption(int commandInterfaceCFAction, int commandInterfaceCFReason, String dialingNumber, int timerSeconds, Message onComplete) {
        Rlog.d(LOG_TAG, "setCallForwardingOption action=" + commandInterfaceCFAction + ", reason=" + commandInterfaceCFReason);
        if (this.isValidCommandInterfaceCFAction(commandInterfaceCFAction) && this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
            Cf cf = new Cf(dialingNumber, commandInterfaceCFReason == 0, onComplete);
            Message resp = this.obtainMessage(12, this.isCfEnable(commandInterfaceCFAction) ? 1 : 0, 0, cf);
            try {
                ImsUtInterface ut = this.mCT.getUtInterface();
                ut.updateCallForward(this.getActionFromCFAction(commandInterfaceCFAction), this.getConditionFromCFReason(commandInterfaceCFReason), dialingNumber, timerSeconds, onComplete);
            }
            catch (ImsException e) {
                this.sendErrorResponse(onComplete, e);
            }
        } else if (onComplete != null) {
            this.sendErrorResponse(onComplete);
        }
    }

    @Override
    public void getCallWaiting(Message onComplete) {
        Rlog.d(LOG_TAG, "getCallWaiting");
        Message resp = this.obtainMessage(37, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.queryCallWaiting(resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    @Override
    public void setCallWaiting(boolean enable, Message onComplete) {
        Rlog.d(LOG_TAG, "setCallWaiting enable=" + enable);
        Message resp = this.obtainMessage(36, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.updateCallWaiting(enable, resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    private int getCBTypeFromFacility(String facility) {
        if ("AO".equals(facility)) {
            return 2;
        }
        if ("OI".equals(facility)) {
            return 3;
        }
        if ("OX".equals(facility)) {
            return 4;
        }
        if ("AI".equals(facility)) {
            return 1;
        }
        if ("IR".equals(facility)) {
            return 5;
        }
        if ("AB".equals(facility)) {
            return 7;
        }
        if ("AG".equals(facility)) {
            return 8;
        }
        if ("AC".equals(facility)) {
            return 9;
        }
        return 0;
    }

    void getCallBarring(String facility, Message onComplete) {
        Rlog.d(LOG_TAG, "getCallBarring facility=" + facility);
        Message resp = this.obtainMessage(35, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.queryCallBarring(this.getCBTypeFromFacility(facility), resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    void setCallBarring(String facility, boolean lockState, String password, Message onComplete) {
        Rlog.d(LOG_TAG, "setCallBarring facility=" + facility + ", lockState=" + lockState);
        Message resp = this.obtainMessage(34, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.updateCallBarring(this.getCBTypeFromFacility(facility), lockState, resp, null);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    @Override
    public void sendUssdResponse(String ussdMessge) {
        Rlog.d(LOG_TAG, "sendUssdResponse");
        ImsPhoneMmiCode mmi = ImsPhoneMmiCode.newFromUssdUserInput(ussdMessge, this);
        this.mPendingMMIs.add(mmi);
        this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        mmi.sendUssd(ussdMessge);
    }

    void sendUSSD(String ussdString, Message response) {
        this.mCT.sendUSSD(ussdString, response);
    }

    void cancelUSSD() {
        this.mCT.cancelUSSD();
    }

    void sendErrorResponse(Message onComplete) {
        Rlog.d(LOG_TAG, "sendErrorResponse");
        if (onComplete != null) {
            AsyncResult.forMessage(onComplete, null, new CommandException(CommandException.Error.GENERIC_FAILURE));
            onComplete.sendToTarget();
        }
    }

    void sendErrorResponse(Message onComplete, Throwable e) {
        Rlog.d(LOG_TAG, "sendErrorResponse");
        if (onComplete != null) {
            AsyncResult.forMessage(onComplete, null, this.getCommandException(e));
            onComplete.sendToTarget();
        }
    }

    void sendErrorResponse(Message onComplete, ImsReasonInfo reasonInfo) {
        Rlog.d(LOG_TAG, "sendErrorResponse reasonCode=" + reasonInfo.getCode());
        if (onComplete != null) {
            AsyncResult.forMessage(onComplete, null, this.getCommandException(reasonInfo.getCode()));
            onComplete.sendToTarget();
        }
    }

    CommandException getCommandException(int code) {
        Rlog.d(LOG_TAG, "getCommandException code=" + code);
        CommandException.Error error = CommandException.Error.GENERIC_FAILURE;
        switch (code) {
            case 801: {
                error = CommandException.Error.REQUEST_NOT_SUPPORTED;
                break;
            }
            case 821: {
                error = CommandException.Error.PASSWORD_INCORRECT;
                break;
            }
        }
        return new CommandException(error);
    }

    CommandException getCommandException(Throwable e) {
        CommandException ex = null;
        if (e instanceof ImsException) {
            ex = this.getCommandException(((ImsException)e).getCode());
        } else {
            Rlog.d(LOG_TAG, "getCommandException generic failure");
            ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
        }
        return ex;
    }

    private void onNetworkInitiatedUssd(ImsPhoneMmiCode mmi) {
        Rlog.d(LOG_TAG, "onNetworkInitiatedUssd");
        this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
    }

    void onIncomingUSSD(int ussdMode, String ussdMessage) {
        Rlog.d(LOG_TAG, "onIncomingUSSD ussdMode=" + ussdMode);
        boolean isUssdRequest = ussdMode == 1;
        boolean isUssdError = ussdMode != 0 && ussdMode != 1;
        ImsPhoneMmiCode found = null;
        int s = this.mPendingMMIs.size();
        for (int i = 0; i < s; ++i) {
            if (!this.mPendingMMIs.get(i).isPendingUSSD()) continue;
            found = this.mPendingMMIs.get(i);
            break;
        }
        if (found != null) {
            if (isUssdError) {
                found.onUssdFinishedError();
            } else {
                found.onUssdFinished(ussdMessage, isUssdRequest);
            }
        } else if (!isUssdError && ussdMessage != null) {
            ImsPhoneMmiCode mmi = ImsPhoneMmiCode.newNetworkInitiatedUssd(ussdMessage, isUssdRequest, this);
            this.onNetworkInitiatedUssd(mmi);
        }
    }

    void onMMIDone(ImsPhoneMmiCode mmi) {
        if (this.mPendingMMIs.remove(mmi) || mmi.isUssdRequest()) {
            this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        }
    }

    public ImsPhoneConnection getHandoverConnection() {
        ImsPhoneConnection conn = this.getForegroundCall().getHandoverConnection();
        if (conn == null) {
            conn = this.getBackgroundCall().getHandoverConnection();
        }
        if (conn == null) {
            conn = this.getRingingCall().getHandoverConnection();
        }
        return conn;
    }

    public void notifySrvccState(Call.SrvccState state) {
        this.mCT.notifySrvccState(state);
    }

    void initiateSilentRedial() {
        String result = this.mLastDialString;
        AsyncResult ar = new AsyncResult(null, result, null);
        if (ar != null) {
            this.mSilentRedialRegistrants.notifyRegistrants(ar);
        }
    }

    public void registerForSilentRedial(Handler h, int what, Object obj) {
        this.mSilentRedialRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForSilentRedial(Handler h) {
        this.mSilentRedialRegistrants.remove(h);
    }

    public long getSubId() {
        return this.mDefaultPhone.getSubId();
    }

    public int getPhoneId() {
        return this.mDefaultPhone.getPhoneId();
    }

    public Subscription getSubscriptionInfo() {
        return this.mDefaultPhone.getSubscriptionInfo();
    }

    private IccRecords getIccRecords() {
        return this.mDefaultPhone.mIccRecords.get();
    }

    private CallForwardInfo getCallForwardInfo(ImsCallForwardInfo info) {
        CallForwardInfo cfInfo = new CallForwardInfo();
        cfInfo.status = info.mStatus;
        cfInfo.reason = this.getCFReasonFromCondition(info.mCondition);
        cfInfo.serviceClass = 1;
        cfInfo.toa = info.mToA;
        cfInfo.number = info.mNumber;
        cfInfo.timeSeconds = info.mTimeSeconds;
        return cfInfo;
    }

    private CallForwardInfo[] handleCfQueryResult(ImsCallForwardInfo[] infos) {
        CallForwardInfo[] cfInfos = null;
        if (infos != null && infos.length != 0) {
            cfInfos = new CallForwardInfo[infos.length];
        }
        IccRecords r = this.getIccRecords();
        if (infos == null || infos.length == 0) {
            if (r != null) {
                r.setVoiceCallForwardingFlag(1, false, null);
            }
        } else {
            int s = infos.length;
            for (int i = 0; i < s; ++i) {
                if (infos[i].mCondition == 0 && r != null) {
                    r.setVoiceCallForwardingFlag(1, infos[i].mStatus == 1, infos[i].mNumber);
                }
                cfInfos[i] = this.getCallForwardInfo(infos[i]);
            }
        }
        return cfInfos;
    }

    private int[] handleCbQueryResult(ImsSsInfo[] infos) {
        int[] cbInfos = new int[]{0};
        if (infos[0].mStatus == 1) {
            cbInfos[0] = 1;
        }
        return cbInfos;
    }

    private int[] handleCwQueryResult(ImsSsInfo[] infos) {
        int[] cwInfos = new int[2];
        cwInfos[0] = 0;
        if (infos[0].mStatus == 1) {
            cwInfos[0] = 1;
            cwInfos[1] = 1;
        }
        return cwInfos;
    }

    private void sendResponse(Message onComplete, Object result, Throwable e) {
        if (onComplete != null) {
            CommandException ex = null;
            if (e != null) {
                ex = this.getCommandException(e);
            }
            AsyncResult.forMessage(onComplete, result, ex);
            onComplete.sendToTarget();
        }
    }

    @Override
    public void handleMessage(Message msg) {
        AsyncResult ar = (AsyncResult)msg.obj;
        Rlog.d(LOG_TAG, "handleMessage what=" + msg.what);
        switch (msg.what) {
            case 12: {
                IccRecords r = this.getIccRecords();
                Cf cf = (Cf)ar.userObj;
                if (cf.mIsCfu && ar.exception == null && r != null) {
                    r.setVoiceCallForwardingFlag(1, msg.arg1 == 1, cf.mSetCfNumber);
                }
                this.sendResponse(cf.mOnComplete, null, ar.exception);
                break;
            }
            case 13: {
                CallForwardInfo[] cfInfos = null;
                if (ar.exception == null) {
                    cfInfos = this.handleCfQueryResult((ImsCallForwardInfo[])ar.result);
                }
                this.sendResponse((Message)ar.userObj, cfInfos, ar.exception);
                break;
            }
            case 35: 
            case 37: {
                int[] ssInfos = null;
                if (ar.exception == null) {
                    if (msg.what == 35) {
                        ssInfos = this.handleCbQueryResult((ImsSsInfo[])ar.result);
                    } else if (msg.what == 37) {
                        ssInfos = this.handleCwQueryResult((ImsSsInfo[])ar.result);
                    }
                }
                this.sendResponse((Message)ar.userObj, ssInfos, ar.exception);
                break;
            }
            case 34: 
            case 36: {
                this.sendResponse((Message)ar.userObj, null, ar.exception);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    @Override
    public boolean isInEmergencyCall() {
        return this.mCT.isInEmergencyCall();
    }

    @Override
    public boolean isInEcm() {
        return this.mIsPhoneInEcmState;
    }

    void sendEmergencyCallbackModeChange() {
        Intent intent = new Intent("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        intent.putExtra("phoneinECMState", this.mIsPhoneInEcmState);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.getPhoneId());
        ActivityManagerNative.broadcastStickyIntent(intent, null, -1);
        Rlog.d(LOG_TAG, "sendEmergencyCallbackModeChange");
    }

    @Override
    public void exitEmergencyCallbackMode() {
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
        Rlog.d(LOG_TAG, "exitEmergencyCallbackMode()");
        try {
            ImsEcbm ecbm = this.mCT.getEcbmInterface();
            ecbm.exitEmergencyCallbackMode();
        }
        catch (ImsException e) {
            e.printStackTrace();
        }
    }

    private void handleEnterEmergencyCallbackMode() {
        Rlog.d(LOG_TAG, "handleEnterEmergencyCallbackMode,mIsPhoneInEcmState= " + this.mIsPhoneInEcmState);
        if (!this.mIsPhoneInEcmState) {
            this.mIsPhoneInEcmState = true;
            this.sendEmergencyCallbackModeChange();
            this.setSystemProperty("ril.cdma.inecmmode", "true");
            long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
            this.postDelayed(this.mExitEcmRunnable, delayInMillis);
            this.mWakeLock.acquire();
        }
    }

    private void handleExitEmergencyCallbackMode() {
        Rlog.d(LOG_TAG, "handleExitEmergencyCallbackMode: mIsPhoneInEcmState = " + this.mIsPhoneInEcmState);
        this.removeCallbacks(this.mExitEcmRunnable);
        if (this.mEcmExitRespRegistrant != null) {
            this.mEcmExitRespRegistrant.notifyResult(Boolean.TRUE);
        }
        if (this.mIsPhoneInEcmState) {
            this.mIsPhoneInEcmState = false;
            this.setSystemProperty("ril.cdma.inecmmode", "false");
        }
        this.sendEmergencyCallbackModeChange();
    }

    void handleTimerInEmergencyCallbackMode(int action) {
        switch (action) {
            case 1: {
                this.removeCallbacks(this.mExitEcmRunnable);
                if (this.mDefaultPhone.getPhoneType() == 1) {
                    ((GSMPhone)this.mDefaultPhone).notifyEcbmTimerReset(Boolean.TRUE);
                    break;
                }
                ((CDMAPhone)this.mDefaultPhone).notifyEcbmTimerReset(Boolean.TRUE);
                break;
            }
            case 0: {
                long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
                this.postDelayed(this.mExitEcmRunnable, delayInMillis);
                if (this.mDefaultPhone.getPhoneType() == 1) {
                    ((GSMPhone)this.mDefaultPhone).notifyEcbmTimerReset(Boolean.FALSE);
                    break;
                }
                ((CDMAPhone)this.mDefaultPhone).notifyEcbmTimerReset(Boolean.FALSE);
                break;
            }
            default: {
                Rlog.e(LOG_TAG, "handleTimerInEmergencyCallbackMode, unsupported action " + action);
            }
        }
    }

    @Override
    public void setOnEcbModeExitResponse(Handler h, int what, Object obj) {
        this.mEcmExitRespRegistrant = new Registrant(h, what, obj);
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler h) {
        this.mEcmExitRespRegistrant.clear();
    }

    public boolean isVolteEnabled() {
        return this.mCT.isVolteEnabled();
    }

    public boolean isVtEnabled() {
        return this.mCT.isVtEnabled();
    }

    private static class Cf {
        final String mSetCfNumber;
        final Message mOnComplete;
        final boolean mIsCfu;

        Cf(String cfNumber, boolean isCfu, Message onComplete) {
            this.mSetCfNumber = cfNumber;
            this.mIsCfu = isCfu;
            this.mOnComplete = onComplete;
        }
    }
}

