/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.format.Time;
import com.android.internal.telephony.EncodeException;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.SmsConstants;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.gsm.GsmSmsAddress;
import com.android.internal.telephony.uicc.IccUtils;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;

public class SmsMessage
extends SmsMessageBase {
    static final String LOG_TAG = "SmsMessage";
    private static final boolean VDBG = false;
    private SmsConstants.MessageClass messageClass;
    private int mMti;
    private int mProtocolIdentifier;
    private int mDataCodingScheme;
    private boolean mReplyPathPresent = false;
    private GsmSmsAddress mRecipientAddress;
    private int mStatus;
    private boolean mIsStatusReportMessage = false;

    public static SmsMessage createFromPdu(byte[] pdu) {
        try {
            SmsMessage msg = new SmsMessage();
            msg.parsePdu(pdu);
            return msg;
        }
        catch (RuntimeException ex) {
            Rlog.e(LOG_TAG, "SMS PDU parsing failed: ", ex);
            return null;
        }
        catch (OutOfMemoryError e) {
            Rlog.e(LOG_TAG, "SMS PDU parsing failed with out of memory: ", e);
            return null;
        }
    }

    public boolean isTypeZero() {
        return this.mProtocolIdentifier == 64;
    }

    public static SmsMessage newFromCMT(String[] lines) {
        try {
            SmsMessage msg = new SmsMessage();
            msg.parsePdu(IccUtils.hexStringToBytes(lines[1]));
            return msg;
        }
        catch (RuntimeException ex) {
            Rlog.e(LOG_TAG, "SMS PDU parsing failed: ", ex);
            return null;
        }
    }

    public static SmsMessage newFromCDS(String line) {
        try {
            SmsMessage msg = new SmsMessage();
            msg.parsePdu(IccUtils.hexStringToBytes(line));
            return msg;
        }
        catch (RuntimeException ex) {
            Rlog.e(LOG_TAG, "CDS SMS PDU parsing failed: ", ex);
            return null;
        }
    }

    public static SmsMessage createFromEfRecord(int index, byte[] data) {
        try {
            SmsMessage msg = new SmsMessage();
            msg.mIndexOnIcc = index;
            if ((data[0] & 1) == 0) {
                Rlog.w(LOG_TAG, "SMS parsing failed: Trying to parse a free record");
                return null;
            }
            msg.mStatusOnIcc = data[0] & 7;
            int size = data.length - 1;
            byte[] pdu = new byte[size];
            System.arraycopy(data, 1, pdu, 0, size);
            msg.parsePdu(pdu);
            return msg;
        }
        catch (RuntimeException ex) {
            Rlog.e(LOG_TAG, "SMS PDU parsing failed: ", ex);
            return null;
        }
    }

    public static int getTPLayerLengthForPDU(String pdu) {
        int len = pdu.length() / 2;
        int smscLen = Integer.parseInt(pdu.substring(0, 2), 16);
        return len - smscLen - 1;
    }

    public static SubmitPdu getSubmitPdu(String scAddress, String destinationAddress, String message, boolean statusReportRequested, byte[] header) {
        return SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, statusReportRequested, header, 0, 0, 0);
    }

    public static SubmitPdu getSubmitPdu(String scAddress, String destinationAddress, String message, boolean statusReportRequested, byte[] header, int encoding, int languageTable, int languageShiftTable) {
        byte[] userData;
        ByteArrayOutputStream bo;
        SubmitPdu ret;
        block17: {
            if (message == null || destinationAddress == null) {
                return null;
            }
            if (encoding == 0) {
                GsmAlphabet.TextEncodingDetails ted = SmsMessage.calculateLength(message, false);
                encoding = ted.codeUnitSize;
                languageTable = ted.languageTable;
                languageShiftTable = ted.languageShiftTable;
                if (encoding == 1 && (languageTable != 0 || languageShiftTable != 0)) {
                    SmsHeader smsHeader;
                    if (header != null) {
                        smsHeader = SmsHeader.fromByteArray(header);
                        if (smsHeader.languageTable != languageTable || smsHeader.languageShiftTable != languageShiftTable) {
                            Rlog.w(LOG_TAG, "Updating language table in SMS header: " + smsHeader.languageTable + " -> " + languageTable + ", " + smsHeader.languageShiftTable + " -> " + languageShiftTable);
                            smsHeader.languageTable = languageTable;
                            smsHeader.languageShiftTable = languageShiftTable;
                            header = SmsHeader.toByteArray(smsHeader);
                        }
                    } else {
                        smsHeader = new SmsHeader();
                        smsHeader.languageTable = languageTable;
                        smsHeader.languageShiftTable = languageShiftTable;
                        header = SmsHeader.toByteArray(smsHeader);
                    }
                }
            }
            ret = new SubmitPdu();
            byte mtiByte = (byte)(1 | (header != null ? 64 : 0));
            bo = SmsMessage.getSubmitPduHead(scAddress, destinationAddress, mtiByte, statusReportRequested, ret);
            try {
                if (encoding == 1) {
                    userData = GsmAlphabet.stringToGsm7BitPackedWithHeader(message, header, languageTable, languageShiftTable);
                    break block17;
                }
                try {
                    userData = SmsMessage.encodeUCS2(message, header);
                }
                catch (UnsupportedEncodingException uex) {
                    Rlog.e(LOG_TAG, "Implausible UnsupportedEncodingException ", uex);
                    return null;
                }
            }
            catch (EncodeException ex) {
                try {
                    userData = SmsMessage.encodeUCS2(message, header);
                    encoding = 3;
                }
                catch (UnsupportedEncodingException uex) {
                    Rlog.e(LOG_TAG, "Implausible UnsupportedEncodingException ", uex);
                    return null;
                }
            }
        }
        if (encoding == 1) {
            if ((0xFF & userData[0]) > 160) {
                Rlog.e(LOG_TAG, "Message too long (" + (0xFF & userData[0]) + " septets)");
                return null;
            }
            bo.write(0);
        } else {
            if ((0xFF & userData[0]) > 140) {
                Rlog.e(LOG_TAG, "Message too long (" + (0xFF & userData[0]) + " bytes)");
                return null;
            }
            bo.write(8);
        }
        bo.write(userData, 0, userData.length);
        ret.encodedMessage = bo.toByteArray();
        return ret;
    }

    private static byte[] encodeUCS2(String message, byte[] header) throws UnsupportedEncodingException {
        byte[] userData;
        byte[] textPart = message.getBytes("utf-16be");
        if (header != null) {
            userData = new byte[header.length + textPart.length + 1];
            userData[0] = (byte)header.length;
            System.arraycopy(header, 0, userData, 1, header.length);
            System.arraycopy(textPart, 0, userData, header.length + 1, textPart.length);
        } else {
            userData = textPart;
        }
        byte[] ret = new byte[userData.length + 1];
        ret[0] = (byte)(userData.length & 0xFF);
        System.arraycopy(userData, 0, ret, 1, userData.length);
        return ret;
    }

    public static SubmitPdu getSubmitPdu(String scAddress, String destinationAddress, String message, boolean statusReportRequested) {
        return SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, statusReportRequested, null);
    }

    public static SubmitPdu getSubmitPdu(String scAddress, String destinationAddress, int destinationPort, byte[] data, boolean statusReportRequested) {
        SmsHeader.PortAddrs portAddrs = new SmsHeader.PortAddrs();
        portAddrs.destPort = destinationPort;
        portAddrs.origPort = 0;
        portAddrs.areEightBits = false;
        SmsHeader smsHeader = new SmsHeader();
        smsHeader.portAddrs = portAddrs;
        byte[] smsHeaderData = SmsHeader.toByteArray(smsHeader);
        if (data.length + smsHeaderData.length + 1 > 140) {
            Rlog.e(LOG_TAG, "SMS data message may only contain " + (140 - smsHeaderData.length - 1) + " bytes");
            return null;
        }
        SubmitPdu ret = new SubmitPdu();
        ByteArrayOutputStream bo = SmsMessage.getSubmitPduHead(scAddress, destinationAddress, (byte)65, statusReportRequested, ret);
        bo.write(4);
        bo.write(data.length + smsHeaderData.length + 1);
        bo.write(smsHeaderData.length);
        bo.write(smsHeaderData, 0, smsHeaderData.length);
        bo.write(data, 0, data.length);
        ret.encodedMessage = bo.toByteArray();
        return ret;
    }

    private static ByteArrayOutputStream getSubmitPduHead(String scAddress, String destinationAddress, byte mtiByte, boolean statusReportRequested, SubmitPdu ret) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream(180);
        ret.encodedScAddress = (byte[])(scAddress == null ? null : PhoneNumberUtils.networkPortionToCalledPartyBCDWithLength(scAddress));
        if (statusReportRequested) {
            mtiByte = (byte)(mtiByte | 0x20);
        }
        bo.write(mtiByte);
        bo.write(0);
        byte[] daBytes = PhoneNumberUtils.networkPortionToCalledPartyBCD(destinationAddress);
        bo.write((daBytes.length - 1) * 2 - ((daBytes[daBytes.length - 1] & 0xF0) == 240 ? 1 : 0));
        bo.write(daBytes, 0, daBytes.length);
        bo.write(0);
        return bo;
    }

    public static GsmAlphabet.TextEncodingDetails calculateLength(CharSequence msgBody, boolean use7bitOnly) {
        GsmAlphabet.TextEncodingDetails ted = GsmAlphabet.countGsmSeptets(msgBody, use7bitOnly);
        if (ted == null) {
            ted = new GsmAlphabet.TextEncodingDetails();
            int octets = msgBody.length() * 2;
            ted.codeUnitCount = msgBody.length();
            if (octets > 140) {
                ted.msgCount = (octets + 133) / 134;
                ted.codeUnitsRemaining = (ted.msgCount * 134 - octets) / 2;
            } else {
                ted.msgCount = 1;
                ted.codeUnitsRemaining = (140 - octets) / 2;
            }
            ted.codeUnitSize = 3;
        }
        return ted;
    }

    public int getProtocolIdentifier() {
        return this.mProtocolIdentifier;
    }

    int getDataCodingScheme() {
        return this.mDataCodingScheme;
    }

    public boolean isReplace() {
        return (this.mProtocolIdentifier & 0xC0) == 64 && (this.mProtocolIdentifier & 0x3F) > 0 && (this.mProtocolIdentifier & 0x3F) < 8;
    }

    public boolean isCphsMwiMessage() {
        return ((GsmSmsAddress)this.mOriginatingAddress).isCphsVoiceMessageClear() || ((GsmSmsAddress)this.mOriginatingAddress).isCphsVoiceMessageSet();
    }

    public boolean isMWIClearMessage() {
        if (this.mIsMwi && !this.mMwiSense) {
            return true;
        }
        return this.mOriginatingAddress != null && ((GsmSmsAddress)this.mOriginatingAddress).isCphsVoiceMessageClear();
    }

    public boolean isMWISetMessage() {
        if (this.mIsMwi && this.mMwiSense) {
            return true;
        }
        return this.mOriginatingAddress != null && ((GsmSmsAddress)this.mOriginatingAddress).isCphsVoiceMessageSet();
    }

    public boolean isMwiDontStore() {
        if (this.mIsMwi && this.mMwiDontStore) {
            return true;
        }
        return this.isCphsMwiMessage() && " ".equals(this.getMessageBody());
    }

    public int getStatus() {
        return this.mStatus;
    }

    public boolean isStatusReportMessage() {
        return this.mIsStatusReportMessage;
    }

    public boolean isReplyPathPresent() {
        return this.mReplyPathPresent;
    }

    private void parsePdu(byte[] pdu) {
        this.mPdu = pdu;
        PduParser p = new PduParser(pdu);
        this.mScAddress = p.getSCAddress();
        if (this.mScAddress != null) {
            // empty if block
        }
        int firstByte = p.getByte();
        this.mMti = firstByte & 3;
        switch (this.mMti) {
            case 0: 
            case 3: {
                this.parseSmsDeliver(p, firstByte);
                break;
            }
            case 1: {
                this.parseSmsSubmit(p, firstByte);
                break;
            }
            case 2: {
                this.parseSmsStatusReport(p, firstByte);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported message type");
            }
        }
    }

    private void parseSmsStatusReport(PduParser p, int firstByte) {
        this.mIsStatusReportMessage = true;
        this.mMessageRef = p.getByte();
        this.mRecipientAddress = p.getAddress();
        this.mScTimeMillis = p.getSCTimestampMillis();
        p.getSCTimestampMillis();
        this.mStatus = p.getByte();
        if (p.moreDataPresent()) {
            int extraParams;
            int moreExtraParams = extraParams = p.getByte();
            while ((moreExtraParams & 0x80) != 0) {
                moreExtraParams = p.getByte();
            }
            if ((extraParams & 0x78) == 0) {
                if ((extraParams & 1) != 0) {
                    this.mProtocolIdentifier = p.getByte();
                }
                if ((extraParams & 2) != 0) {
                    this.mDataCodingScheme = p.getByte();
                }
                if ((extraParams & 4) != 0) {
                    boolean hasUserDataHeader = (firstByte & 0x40) == 64;
                    this.parseUserData(p, hasUserDataHeader);
                }
            }
        }
    }

    private void parseSmsDeliver(PduParser p, int firstByte) {
        this.mReplyPathPresent = (firstByte & 0x80) == 128;
        this.mOriginatingAddress = p.getAddress();
        if (this.mOriginatingAddress != null) {
            // empty if block
        }
        this.mProtocolIdentifier = p.getByte();
        this.mDataCodingScheme = p.getByte();
        this.mScTimeMillis = p.getSCTimestampMillis();
        boolean hasUserDataHeader = (firstByte & 0x40) == 64;
        this.parseUserData(p, hasUserDataHeader);
    }

    private void parseSmsSubmit(PduParser p, int firstByte) {
        this.mReplyPathPresent = (firstByte & 0x80) == 128;
        this.mMessageRef = p.getByte();
        this.mRecipientAddress = p.getAddress();
        if (this.mRecipientAddress != null) {
            // empty if block
        }
        this.mProtocolIdentifier = p.getByte();
        this.mDataCodingScheme = p.getByte();
        int validityPeriodLength = 0;
        int validityPeriodFormat = firstByte >> 3 & 3;
        validityPeriodLength = 0 == validityPeriodFormat ? 0 : (2 == validityPeriodFormat ? 1 : 7);
        while (validityPeriodLength-- > 0) {
            p.getByte();
        }
        boolean hasUserDataHeader = (firstByte & 0x40) == 64;
        this.parseUserData(p, hasUserDataHeader);
    }

    private void parseUserData(PduParser p, boolean hasUserDataHeader) {
        boolean hasMessageClass = false;
        boolean userDataCompressed = false;
        int encodingType = 0;
        if ((this.mDataCodingScheme & 0x80) == 0) {
            userDataCompressed = 0 != (this.mDataCodingScheme & 0x20);
            boolean bl = hasMessageClass = 0 != (this.mDataCodingScheme & 0x10);
            if (userDataCompressed) {
                Rlog.w(LOG_TAG, "4 - Unsupported SMS data coding scheme (compression) " + (this.mDataCodingScheme & 0xFF));
            } else {
                switch (this.mDataCodingScheme >> 2 & 3) {
                    case 0: {
                        encodingType = 1;
                        break;
                    }
                    case 2: {
                        encodingType = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        Rlog.w(LOG_TAG, "1 - Unsupported SMS data coding scheme " + (this.mDataCodingScheme & 0xFF));
                        encodingType = 2;
                    }
                }
            }
        } else if ((this.mDataCodingScheme & 0xF0) == 240) {
            hasMessageClass = true;
            userDataCompressed = false;
            encodingType = 0 == (this.mDataCodingScheme & 4) ? 1 : 2;
        } else if ((this.mDataCodingScheme & 0xF0) == 192 || (this.mDataCodingScheme & 0xF0) == 208 || (this.mDataCodingScheme & 0xF0) == 224) {
            boolean active;
            encodingType = (this.mDataCodingScheme & 0xF0) == 224 ? 3 : 1;
            userDataCompressed = false;
            boolean bl = active = (this.mDataCodingScheme & 8) == 8;
            if ((this.mDataCodingScheme & 3) == 0) {
                this.mIsMwi = true;
                this.mMwiSense = active;
                this.mMwiDontStore = (this.mDataCodingScheme & 0xF0) == 192;
            } else {
                this.mIsMwi = false;
                Rlog.w(LOG_TAG, "MWI for fax, email, or other " + (this.mDataCodingScheme & 0xFF));
            }
        } else if ((this.mDataCodingScheme & 0xC0) == 128) {
            if (this.mDataCodingScheme == 132) {
                encodingType = 4;
            } else {
                Rlog.w(LOG_TAG, "5 - Unsupported SMS data coding scheme " + (this.mDataCodingScheme & 0xFF));
            }
        } else {
            Rlog.w(LOG_TAG, "3 - Unsupported SMS data coding scheme " + (this.mDataCodingScheme & 0xFF));
        }
        int count = p.constructUserData(hasUserDataHeader, encodingType == 1);
        this.mUserData = p.getUserData();
        this.mUserDataHeader = p.getUserDataHeader();
        switch (encodingType) {
            case 0: 
            case 2: {
                this.mMessageBody = null;
                break;
            }
            case 1: {
                this.mMessageBody = p.getUserDataGSM7Bit(count, hasUserDataHeader ? this.mUserDataHeader.languageTable : 0, hasUserDataHeader ? this.mUserDataHeader.languageShiftTable : 0);
                break;
            }
            case 3: {
                this.mMessageBody = p.getUserDataUCS2(count);
                break;
            }
            case 4: {
                this.mMessageBody = p.getUserDataKSC5601(count);
            }
        }
        if (this.mMessageBody != null) {
            this.parseMessageBody();
        }
        if (!hasMessageClass) {
            this.messageClass = SmsConstants.MessageClass.UNKNOWN;
        } else {
            switch (this.mDataCodingScheme & 3) {
                case 0: {
                    this.messageClass = SmsConstants.MessageClass.CLASS_0;
                    break;
                }
                case 1: {
                    this.messageClass = SmsConstants.MessageClass.CLASS_1;
                    break;
                }
                case 2: {
                    this.messageClass = SmsConstants.MessageClass.CLASS_2;
                    break;
                }
                case 3: {
                    this.messageClass = SmsConstants.MessageClass.CLASS_3;
                }
            }
        }
    }

    public SmsConstants.MessageClass getMessageClass() {
        return this.messageClass;
    }

    boolean isUsimDataDownload() {
        return this.messageClass == SmsConstants.MessageClass.CLASS_2 && (this.mProtocolIdentifier == 127 || this.mProtocolIdentifier == 124);
    }

    private static class PduParser {
        byte[] mPdu;
        int mCur;
        SmsHeader mUserDataHeader;
        byte[] mUserData;
        int mUserDataSeptetPadding;

        PduParser(byte[] pdu) {
            this.mPdu = pdu;
            this.mCur = 0;
            this.mUserDataSeptetPadding = 0;
        }

        String getSCAddress() {
            String ret;
            int len = this.getByte();
            if (len == 0) {
                ret = null;
            } else {
                try {
                    ret = PhoneNumberUtils.calledPartyBCDToString(this.mPdu, this.mCur, len);
                }
                catch (RuntimeException tr) {
                    Rlog.d(SmsMessage.LOG_TAG, "invalid SC address: ", tr);
                    ret = null;
                }
            }
            this.mCur += len;
            return ret;
        }

        int getByte() {
            return this.mPdu[this.mCur++] & 0xFF;
        }

        GsmSmsAddress getAddress() {
            GsmSmsAddress ret;
            int addressLength = this.mPdu[this.mCur] & 0xFF;
            int lengthBytes = 2 + (addressLength + 1) / 2;
            try {
                ret = new GsmSmsAddress(this.mPdu, this.mCur, lengthBytes);
            }
            catch (ParseException e) {
                Rlog.e(SmsMessage.LOG_TAG, e.getMessage());
                ret = null;
            }
            this.mCur += lengthBytes;
            return ret;
        }

        long getSCTimestampMillis() {
            int year = IccUtils.gsmBcdByteToInt(this.mPdu[this.mCur++]);
            int month = IccUtils.gsmBcdByteToInt(this.mPdu[this.mCur++]);
            int day = IccUtils.gsmBcdByteToInt(this.mPdu[this.mCur++]);
            int hour = IccUtils.gsmBcdByteToInt(this.mPdu[this.mCur++]);
            int minute = IccUtils.gsmBcdByteToInt(this.mPdu[this.mCur++]);
            int second = IccUtils.gsmBcdByteToInt(this.mPdu[this.mCur++]);
            byte tzByte = this.mPdu[this.mCur++];
            int timezoneOffset = IccUtils.gsmBcdByteToInt((byte)(tzByte & 0xFFFFFFF7));
            timezoneOffset = (tzByte & 8) == 0 ? timezoneOffset : -timezoneOffset;
            Time time = new Time("UTC");
            time.year = year >= 90 ? year + 1900 : year + 2000;
            time.month = month - 1;
            time.monthDay = day;
            time.hour = hour;
            time.minute = minute;
            time.second = second;
            return time.toMillis(true) - (long)(timezoneOffset * 15 * 60 * 1000);
        }

        int constructUserData(boolean hasUserDataHeader, boolean dataInSeptets) {
            int bufferLen;
            int offset = this.mCur;
            int userDataLength = this.mPdu[offset++] & 0xFF;
            int headerSeptets = 0;
            int userDataHeaderLength = 0;
            if (hasUserDataHeader) {
                userDataHeaderLength = this.mPdu[offset++] & 0xFF;
                byte[] udh = new byte[userDataHeaderLength];
                System.arraycopy(this.mPdu, offset, udh, 0, userDataHeaderLength);
                this.mUserDataHeader = SmsHeader.fromByteArray(udh);
                offset += userDataHeaderLength;
                int headerBits = (userDataHeaderLength + 1) * 8;
                headerSeptets = headerBits / 7;
                this.mUserDataSeptetPadding = (headerSeptets += headerBits % 7 > 0 ? 1 : 0) * 7 - headerBits;
            }
            if (dataInSeptets) {
                bufferLen = this.mPdu.length - offset;
            } else {
                bufferLen = userDataLength - (hasUserDataHeader ? userDataHeaderLength + 1 : 0);
                if (bufferLen < 0) {
                    bufferLen = 0;
                }
            }
            this.mUserData = new byte[bufferLen];
            System.arraycopy(this.mPdu, offset, this.mUserData, 0, this.mUserData.length);
            this.mCur = offset;
            if (dataInSeptets) {
                int count = userDataLength - headerSeptets;
                return count < 0 ? 0 : count;
            }
            return this.mUserData.length;
        }

        byte[] getUserData() {
            return this.mUserData;
        }

        SmsHeader getUserDataHeader() {
            return this.mUserDataHeader;
        }

        String getUserDataGSM7Bit(int septetCount, int languageTable, int languageShiftTable) {
            String ret = GsmAlphabet.gsm7BitPackedToString(this.mPdu, this.mCur, septetCount, this.mUserDataSeptetPadding, languageTable, languageShiftTable);
            this.mCur += septetCount * 7 / 8;
            return ret;
        }

        String getUserDataUCS2(int byteCount) {
            String ret;
            try {
                ret = new String(this.mPdu, this.mCur, byteCount, "utf-16");
            }
            catch (UnsupportedEncodingException ex) {
                ret = "";
                Rlog.e(SmsMessage.LOG_TAG, "implausible UnsupportedEncodingException", ex);
            }
            this.mCur += byteCount;
            return ret;
        }

        String getUserDataKSC5601(int byteCount) {
            String ret;
            try {
                ret = new String(this.mPdu, this.mCur, byteCount, "KSC5601");
            }
            catch (UnsupportedEncodingException ex) {
                ret = "";
                Rlog.e(SmsMessage.LOG_TAG, "implausible UnsupportedEncodingException", ex);
            }
            this.mCur += byteCount;
            return ret;
        }

        boolean moreDataPresent() {
            return this.mPdu.length > this.mCur;
        }
    }

    public static class SubmitPdu
    extends SmsMessageBase.SubmitPduBase {
    }
}

