/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.util.HashSet;
import java.util.Iterator;

public class DcSwitchState
extends StateMachine {
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final String LOG_TAG = "DcSwitchState";
    private static final int BASE = 274432;
    private static final int EVENT_CONNECT = 274432;
    private static final int EVENT_DISCONNECT = 274433;
    private static final int EVENT_CLEANUP_ALL = 274434;
    private static final int EVENT_CONNECTED = 274435;
    private static final int EVENT_DETACH_DONE = 274436;
    private static final int EVENT_TO_IDLE_DIRECTLY = 274437;
    private static final int EVENT_TO_ACTING_DIRECTLY = 274438;
    private int mId;
    private Phone mPhone;
    private AsyncChannel mAc;
    private RegistrantList mIdleRegistrants = new RegistrantList();
    private HashSet<String> mApnTypes = new HashSet();
    private IdleState mIdleState = new IdleState();
    private ActingState mActingState = new ActingState();
    private ActedState mActedState = new ActedState();
    private DeactingState mDeactingState = new DeactingState();
    private DefaultState mDefaultState = new DefaultState();

    protected DcSwitchState(Phone phone, String name, int id2) {
        super(name);
        this.log("DcSwitchState constructor E");
        this.mPhone = phone;
        this.mId = id2;
        this.addState(this.mDefaultState);
        this.addState(this.mIdleState, this.mDefaultState);
        this.addState(this.mActingState, this.mDefaultState);
        this.addState(this.mActedState, this.mDefaultState);
        this.addState(this.mDeactingState, this.mDefaultState);
        this.setInitialState(this.mIdleState);
        this.log("DcSwitchState constructor X");
    }

    private int setupConnection(String type) {
        this.mApnTypes.add(type);
        this.log("DcSwitchState:setupConnection type = " + type);
        return 1;
    }

    private int teardownConnection(String type) {
        this.mApnTypes.remove(type);
        if (this.mApnTypes.isEmpty()) {
            this.log("No APN is using, then clean up all");
            this.requestDataIdle();
            this.transitionTo(this.mDeactingState);
            return 1;
        }
        return 1;
    }

    private void requestDataIdle() {
        this.log("requestDataIdle is triggered");
        Iterator<String> itrType = this.mApnTypes.iterator();
        while (itrType.hasNext()) {
        }
        this.mApnTypes.clear();
        PhoneBase pb = (PhoneBase)((PhoneProxy)this.mPhone).getActivePhone();
        pb.mCi.setDataAllowed(false, this.obtainMessage(274436));
    }

    public void notifyDataConnection(int phoneId, String state, String reason, String apnName, String apnType, boolean unavailable) {
        if (phoneId == this.mId && TextUtils.equals(state, PhoneConstants.DataState.CONNECTED.toString())) {
            this.sendMessage(this.obtainMessage(274435));
        }
    }

    public void cleanupAllConnection() {
        this.sendMessage(this.obtainMessage(274434));
    }

    public void registerForIdle(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mIdleRegistrants.add(r);
    }

    public void unregisterForIdle(Handler h) {
        this.mIdleRegistrants.remove(h);
    }

    public void transitToIdleState() {
        this.sendMessage(this.obtainMessage(274437));
    }

    public void transitToActingState() {
        this.sendMessage(this.obtainMessage(274438));
    }

    @Override
    protected void log(String s) {
        Log.d(LOG_TAG, "[" + this.getName() + "] " + s);
    }

    private class DefaultState
    extends State {
        private DefaultState() {
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 69633: {
                    if (DcSwitchState.this.mAc != null) {
                        DcSwitchState.this.mAc.replyToMessage(msg, 69634, 3);
                        break;
                    }
                    DcSwitchState.this.mAc = new AsyncChannel();
                    DcSwitchState.this.mAc.connected(null, DcSwitchState.this.getHandler(), msg.replyTo);
                    DcSwitchState.this.mAc.replyToMessage(msg, 69634, 0, DcSwitchState.this.mId, "hi");
                    break;
                }
                case 69635: {
                    DcSwitchState.this.mAc.disconnect();
                    break;
                }
                case 69636: {
                    DcSwitchState.this.mAc = null;
                    break;
                }
                case 278532: {
                    boolean val = DcSwitchState.this.getCurrentState() == DcSwitchState.this.mIdleState;
                    DcSwitchState.this.mAc.replyToMessage(msg, 278533, val ? 1 : 0);
                    break;
                }
                case 278534: {
                    boolean val = DcSwitchState.this.getCurrentState() == DcSwitchState.this.mIdleState || DcSwitchState.this.getCurrentState() == DcSwitchState.this.mDeactingState;
                    DcSwitchState.this.mAc.replyToMessage(msg, 278535, val ? 1 : 0);
                    break;
                }
                case 274438: {
                    DcSwitchState.this.log("Just transit to Acting state");
                    DcSwitchState.this.transitionTo(DcSwitchState.this.mActingState);
                    break;
                }
                case 274437: {
                    DcSwitchState.this.log("Just transit to Idle state");
                    Iterator itrType = DcSwitchState.this.mApnTypes.iterator();
                    while (itrType.hasNext()) {
                    }
                    DcSwitchState.this.mApnTypes.clear();
                    DcSwitchState.this.transitionTo(DcSwitchState.this.mIdleState);
                }
                default: {
                    DcSwitchState.this.log("DefaultState: shouldn't happen but ignore msg.what=0x" + Integer.toHexString(msg.what));
                }
            }
            return true;
        }
    }

    private class DeactingState
    extends State {
        private DeactingState() {
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 274432: 
                case 278528: {
                    String type = (String)msg.obj;
                    DcSwitchState.this.log("DeactingState: REQ_CONNECT/EVENT_CONNECT(" + msg.what + ") type=" + type + ", request is defered.");
                    DcSwitchState.this.deferMessage(DcSwitchState.this.obtainMessage(274432, type));
                    if (msg.what == 278528) {
                        DcSwitchState.this.mAc.replyToMessage(msg, 278529, 1);
                    }
                    retVal = true;
                    break;
                }
                case 278530: {
                    String type = (String)msg.obj;
                    DcSwitchState.this.log("DeactingState: DcSwitchAsyncChannel.REQ_DISCONNECT type=" + type);
                    DcSwitchState.this.mAc.replyToMessage(msg, 278531, 4);
                    retVal = true;
                    break;
                }
                case 274436: {
                    DcSwitchState.this.log("DeactingState: EVENT_DETACH_DONE");
                    DcSwitchState.this.transitionTo(DcSwitchState.this.mIdleState);
                    retVal = true;
                    break;
                }
                case 274435: {
                    DcSwitchState.this.log("DeactingState: Receive invalid event EVENT_CONNECTED!");
                    retVal = true;
                    break;
                }
                case 274434: {
                    DcSwitchState.this.log("DeactingState: EVENT_CLEANUP_ALL, already deacting.");
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class ActedState
    extends State {
        private ActedState() {
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 274432: 
                case 278528: {
                    String type = (String)msg.obj;
                    DcSwitchState.this.log("ActedState: REQ_CONNECT/EVENT_CONNECT(" + msg.what + ") type=" + type);
                    int result = DcSwitchState.this.setupConnection(type);
                    if (msg.what == 278528) {
                        DcSwitchState.this.mAc.replyToMessage(msg, 278529, result);
                    }
                    retVal = true;
                    break;
                }
                case 278530: {
                    String type = (String)msg.obj;
                    DcSwitchState.this.log("ActedState: DcSwitchAsyncChannel.REQ_DISCONNECT type=" + type);
                    int result = DcSwitchState.this.teardownConnection(type);
                    DcSwitchState.this.mAc.replyToMessage(msg, 278531, result);
                    retVal = true;
                    break;
                }
                case 274435: {
                    DcSwitchState.this.log("ActedState: EVENT_CONNECTED");
                    retVal = true;
                    break;
                }
                case 274434: {
                    DcSwitchState.this.log("ActedState: EVENT_CLEANUP_ALL");
                    DcSwitchState.this.requestDataIdle();
                    DcSwitchState.this.transitionTo(DcSwitchState.this.mDeactingState);
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class ActingState
    extends State {
        private ActingState() {
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 274432: 
                case 278528: {
                    String type = (String)msg.obj;
                    DcSwitchState.this.log("ActingState: REQ_CONNECT/EVENT_CONNECT(" + msg.what + ") type=" + type);
                    int result = DcSwitchState.this.setupConnection(type);
                    if (msg.what == 278528) {
                        DcSwitchState.this.mAc.replyToMessage(msg, 278529, result);
                    }
                    retVal = true;
                    break;
                }
                case 278530: {
                    String type = (String)msg.obj;
                    DcSwitchState.this.log("ActingState: DcSwitchAsyncChannel.REQ_DISCONNECT type=" + type);
                    int result = DcSwitchState.this.teardownConnection(type);
                    DcSwitchState.this.mAc.replyToMessage(msg, 278531, result);
                    retVal = true;
                    break;
                }
                case 274435: {
                    DcSwitchState.this.log("ActingState: EVENT_CONNECTED");
                    DcSwitchState.this.transitionTo(DcSwitchState.this.mActedState);
                    retVal = true;
                    break;
                }
                case 274434: {
                    DcSwitchState.this.log("ActingState: EVENT_CLEANUP_ALL");
                    DcSwitchState.this.requestDataIdle();
                    DcSwitchState.this.transitionTo(DcSwitchState.this.mDeactingState);
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class IdleState
    extends State {
        private IdleState() {
        }

        @Override
        public void enter() {
            DcSwitchState.this.mIdleRegistrants.notifyRegistrants();
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 274432: 
                case 278528: {
                    String type = (String)msg.obj;
                    DcSwitchState.this.log("IdleState: REQ_CONNECT/EVENT_CONNECT(" + msg.what + ") type=" + type);
                    PhoneBase pb = (PhoneBase)((PhoneProxy)DcSwitchState.this.mPhone).getActivePhone();
                    pb.mCi.setDataAllowed(true, null);
                    int result = DcSwitchState.this.setupConnection(type);
                    if (msg.what == 278528) {
                        DcSwitchState.this.mAc.replyToMessage(msg, 278529, result);
                    }
                    DcSwitchState.this.transitionTo(DcSwitchState.this.mActingState);
                    retVal = true;
                    break;
                }
                case 278530: {
                    String type = (String)msg.obj;
                    DcSwitchState.this.log("IdleState: DcSwitchAsyncChannel.REQ_DISCONNECT type=" + type);
                    DcSwitchState.this.mAc.replyToMessage(msg, 278531, 4);
                    retVal = true;
                    break;
                }
                case 274434: {
                    DcSwitchState.this.log("IdleState: EVENT_CLEANUP_ALL");
                    DcSwitchState.this.requestDataIdle();
                    retVal = true;
                    break;
                }
                case 274435: {
                    DcSwitchState.this.log("IdleState: Receive invalid event EVENT_CONNECTED!");
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
            return retVal;
        }
    }
}

