/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.dataconnection.DcSwitchState;
import com.android.internal.util.AsyncChannel;

public class DcSwitchAsyncChannel
extends AsyncChannel {
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final String LOG_TAG = "DcSwitchAsyncChannel";
    private int tagId = 0;
    private DcSwitchState mDcSwitchState;
    private static final int BASE = 278528;
    static final int REQ_CONNECT = 278528;
    static final int RSP_CONNECT = 278529;
    static final int REQ_DISCONNECT = 278530;
    static final int RSP_DISCONNECT = 278531;
    static final int REQ_IS_IDLE_STATE = 278532;
    static final int RSP_IS_IDLE_STATE = 278533;
    static final int REQ_IS_IDLE_OR_DEACTING_STATE = 278534;
    static final int RSP_IS_IDLE_OR_DEACTING_STATE = 278535;
    private static final int CMD_TO_STRING_COUNT = 8;
    private static String[] sCmdToString = new String[8];

    protected static String cmdToString(int cmd) {
        if ((cmd -= 278528) >= 0 && cmd < sCmdToString.length) {
            return sCmdToString[cmd];
        }
        return AsyncChannel.cmdToString(cmd + 278528);
    }

    public DcSwitchAsyncChannel(DcSwitchState dcSwitchState, int id2) {
        this.mDcSwitchState = dcSwitchState;
        this.tagId = id2;
    }

    public void reqConnect(String type) {
        this.sendMessage(278528, type);
        this.log("reqConnect");
    }

    public int rspConnect(Message response) {
        int retVal = response.arg1;
        this.log("rspConnect=" + retVal);
        return retVal;
    }

    public int connectSync(String type) {
        Message response = this.sendMessageSynchronously(278528, type);
        if (response != null && response.what == 278529) {
            return this.rspConnect(response);
        }
        this.log("rspConnect error response=" + response);
        return 3;
    }

    public void reqDisconnect(String type) {
        this.sendMessage(278530, type);
        this.log("reqDisconnect");
    }

    public int rspDisconnect(Message response) {
        int retVal = response.arg1;
        this.log("rspDisconnect=" + retVal);
        return retVal;
    }

    public int disconnectSync(String type) {
        Message response = this.sendMessageSynchronously(278530, type);
        if (response != null && response.what == 278531) {
            return this.rspDisconnect(response);
        }
        this.log("rspDisconnect error response=" + response);
        return 3;
    }

    public void reqIsIdle() {
        this.sendMessage(278532);
        this.log("reqIsIdle");
    }

    public boolean rspIsIdle(Message response) {
        boolean retVal = response.arg1 == 1;
        this.log("rspIsIdle=" + retVal);
        return retVal;
    }

    public boolean isIdleSync() {
        Message response = this.sendMessageSynchronously(278532);
        if (response != null && response.what == 278533) {
            return this.rspIsIdle(response);
        }
        this.log("rspIsIndle error response=" + response);
        return false;
    }

    public void reqIsIdleOrDeacting() {
        this.sendMessage(278534);
        this.log("reqIsIdleOrDeacting");
    }

    public boolean rspIsIdleOrDeacting(Message response) {
        boolean retVal = response.arg1 == 1;
        this.log("rspIsIdleOrDeacting=" + retVal);
        return retVal;
    }

    public boolean isIdleOrDeactingSync() {
        Message response = this.sendMessageSynchronously(278534);
        if (response != null && response.what == 278535) {
            return this.rspIsIdleOrDeacting(response);
        }
        this.log("rspIsIndleOrDeacting error response=" + response);
        return false;
    }

    public String toString() {
        return this.mDcSwitchState.getName();
    }

    private void log(String s) {
        Log.d(LOG_TAG, "[DcSwitchAsyncChannel-" + this.tagId + "]: " + s);
    }

    static {
        DcSwitchAsyncChannel.sCmdToString[0] = "REQ_CONNECT";
        DcSwitchAsyncChannel.sCmdToString[1] = "RSP_CONNECT";
        DcSwitchAsyncChannel.sCmdToString[2] = "REQ_DISCONNECT";
        DcSwitchAsyncChannel.sCmdToString[3] = "RSP_DISCONNECT";
        DcSwitchAsyncChannel.sCmdToString[4] = "REQ_IS_IDLE_STATE";
        DcSwitchAsyncChannel.sCmdToString[5] = "RSP_IS_IDLE_STATE";
        DcSwitchAsyncChannel.sCmdToString[6] = "REQ_IS_IDLE_OR_DEACTING_STATE";
        DcSwitchAsyncChannel.sCmdToString[7] = "RSP_IS_IDLE_OR_DEACTING_STATE";
    }
}

