/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.cdma.CDMAPhone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CdmaMmiCode
extends Handler
implements MmiCode {
    static final String LOG_TAG = "CdmaMmiCode";
    static final String ACTION_REGISTER = "**";
    static final String SC_PUK = "05";
    static final int EVENT_SET_COMPLETE = 1;
    CDMAPhone mPhone;
    Context mContext;
    String mAction;
    String mSc;
    String mSia;
    String mSib;
    String mSic;
    String mPoundString;
    String mDialingNumber;
    String mPwd;
    MmiCode.State mState = MmiCode.State.PENDING;
    CharSequence mMessage;
    static Pattern sPatternSuppService = Pattern.compile("((\\*|#|\\*#|\\*\\*|##)(\\d{2,3})(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*))?)?)?)?#)(.*)");
    static final int MATCH_GROUP_POUND_STRING = 1;
    static final int MATCH_GROUP_ACTION = 2;
    static final int MATCH_GROUP_SERVICE_CODE = 3;
    static final int MATCH_GROUP_SIA = 5;
    static final int MATCH_GROUP_SIB = 7;
    static final int MATCH_GROUP_SIC = 9;
    static final int MATCH_GROUP_PWD_CONFIRM = 11;
    static final int MATCH_GROUP_DIALING_NUMBER = 12;

    public static CdmaMmiCode newFromDialString(String dialString, CDMAPhone phone) {
        CdmaMmiCode ret = null;
        Matcher m = sPatternSuppService.matcher(dialString);
        if (m.matches()) {
            ret = new CdmaMmiCode(phone);
            ret.mPoundString = CdmaMmiCode.makeEmptyNull(m.group(1));
            ret.mAction = CdmaMmiCode.makeEmptyNull(m.group(2));
            ret.mSc = CdmaMmiCode.makeEmptyNull(m.group(3));
            ret.mSia = CdmaMmiCode.makeEmptyNull(m.group(5));
            ret.mSib = CdmaMmiCode.makeEmptyNull(m.group(7));
            ret.mSic = CdmaMmiCode.makeEmptyNull(m.group(9));
            ret.mPwd = CdmaMmiCode.makeEmptyNull(m.group(11));
            ret.mDialingNumber = CdmaMmiCode.makeEmptyNull(m.group(12));
        }
        return ret;
    }

    private static String makeEmptyNull(String s) {
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    CdmaMmiCode(CDMAPhone phone) {
        super(phone.getHandler().getLooper());
        this.mPhone = phone;
        this.mContext = phone.getContext();
    }

    public MmiCode.State getState() {
        return this.mState;
    }

    public CharSequence getMessage() {
        return this.mMessage;
    }

    public void cancel() {
        if (this.mState == MmiCode.State.COMPLETE || this.mState == MmiCode.State.FAILED) {
            return;
        }
        this.mState = MmiCode.State.CANCELLED;
        this.mPhone.onMMIDone(this);
    }

    public boolean isCancelable() {
        return false;
    }

    boolean isPukCommand() {
        return this.mSc != null && this.mSc.equals(SC_PUK);
    }

    boolean isRegister() {
        return this.mAction != null && this.mAction.equals(ACTION_REGISTER);
    }

    public boolean isUssdRequest() {
        Rlog.w(LOG_TAG, "isUssdRequest is not implemented in CdmaMmiCode");
        return false;
    }

    void processCode() {
        block8: {
            try {
                if (this.isPukCommand()) {
                    String oldPinOrPuk = this.mSia;
                    String newPin = this.mSib;
                    int pinLen = newPin.length();
                    if (this.isRegister()) {
                        if (!newPin.equals(this.mSic)) {
                            this.handlePasswordError(17039452);
                        } else if (pinLen < 4 || pinLen > 8) {
                            this.handlePasswordError(17039453);
                        } else {
                            this.mPhone.mCi.supplyIccPuk(oldPinOrPuk, newPin, this.obtainMessage(1, this));
                        }
                        break block8;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                throw new RuntimeException("Invalid or Unsupported MMI Code");
            }
            catch (RuntimeException exc) {
                this.mState = MmiCode.State.FAILED;
                this.mMessage = this.mContext.getText(17039441);
                this.mPhone.onMMIDone(this);
            }
        }
    }

    private void handlePasswordError(int res) {
        this.mState = MmiCode.State.FAILED;
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        sb.append(this.mContext.getText(res));
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    public void handleMessage(Message msg) {
        if (msg.what == 1) {
            AsyncResult ar = (AsyncResult)msg.obj;
            this.onSetComplete(ar);
        } else {
            Rlog.e(LOG_TAG, "Unexpected reply");
        }
    }

    private CharSequence getScString() {
        if (this.mSc != null && this.isPukCommand()) {
            return this.mContext.getText(17039465);
        }
        return "";
    }

    private void onSetComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof CommandException) {
                CommandException.Error err = ((CommandException)ar.exception).getCommandError();
                if (err == CommandException.Error.PASSWORD_INCORRECT) {
                    if (this.isPukCommand()) {
                        sb.append(this.mContext.getText(17039451));
                    } else {
                        sb.append(this.mContext.getText(17039448));
                    }
                } else {
                    sb.append(this.mContext.getText(17039441));
                }
            } else {
                sb.append(this.mContext.getText(17039441));
            }
        } else if (this.isRegister()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17039446));
        } else {
            this.mState = MmiCode.State.FAILED;
            sb.append(this.mContext.getText(17039441));
        }
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }
}

