/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.Rlog;
import com.android.internal.telephony.IIccPhoneBook;
import com.android.internal.telephony.IccPhoneBookInterfaceManagerProxy;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.uicc.AdnRecord;
import java.util.List;

public class UiccPhoneBookController
extends IIccPhoneBook.Stub {
    private static final String TAG = "UiccPhoneBookController";
    private Phone[] mPhone;

    public UiccPhoneBookController(Phone[] phone) {
        if (ServiceManager.getService("simphonebook") == null) {
            ServiceManager.addService("simphonebook", this);
        }
        this.mPhone = phone;
    }

    @Override
    public boolean updateAdnRecordsInEfBySearch(int efid, String oldTag, String oldPhoneNumber, String newTag, String newPhoneNumber, String pin2) throws RemoteException {
        return this.updateAdnRecordsInEfBySearchForSubscriber(this.getDefaultSubscription(), efid, oldTag, oldPhoneNumber, newTag, newPhoneNumber, pin2);
    }

    public boolean updateAdnRecordsInEfBySearchForSubscriber(long subId, int efid, String oldTag, String oldPhoneNumber, String newTag, String newPhoneNumber, String pin2) throws RemoteException {
        IccPhoneBookInterfaceManagerProxy iccPbkIntMgrProxy = this.getIccPhoneBookInterfaceManagerProxy(subId);
        if (iccPbkIntMgrProxy != null) {
            return iccPbkIntMgrProxy.updateAdnRecordsInEfBySearch(efid, oldTag, oldPhoneNumber, newTag, newPhoneNumber, pin2);
        }
        Rlog.e(TAG, "updateAdnRecordsInEfBySearch iccPbkIntMgrProxy is null for Subscription:" + subId);
        return false;
    }

    @Override
    public boolean updateAdnRecordsInEfByIndex(int efid, String newTag, String newPhoneNumber, int index, String pin2) throws RemoteException {
        return this.updateAdnRecordsInEfByIndexForSubscriber(this.getDefaultSubscription(), efid, newTag, newPhoneNumber, index, pin2);
    }

    public boolean updateAdnRecordsInEfByIndexForSubscriber(long subId, int efid, String newTag, String newPhoneNumber, int index, String pin2) throws RemoteException {
        IccPhoneBookInterfaceManagerProxy iccPbkIntMgrProxy = this.getIccPhoneBookInterfaceManagerProxy(subId);
        if (iccPbkIntMgrProxy != null) {
            return iccPbkIntMgrProxy.updateAdnRecordsInEfByIndex(efid, newTag, newPhoneNumber, index, pin2);
        }
        Rlog.e(TAG, "updateAdnRecordsInEfByIndex iccPbkIntMgrProxy is null for Subscription:" + subId);
        return false;
    }

    @Override
    public int[] getAdnRecordsSize(int efid) throws RemoteException {
        return this.getAdnRecordsSizeForSubscriber(this.getDefaultSubscription(), efid);
    }

    public int[] getAdnRecordsSizeForSubscriber(long subId, int efid) throws RemoteException {
        IccPhoneBookInterfaceManagerProxy iccPbkIntMgrProxy = this.getIccPhoneBookInterfaceManagerProxy(subId);
        if (iccPbkIntMgrProxy != null) {
            return iccPbkIntMgrProxy.getAdnRecordsSize(efid);
        }
        Rlog.e(TAG, "getAdnRecordsSize iccPbkIntMgrProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public List<AdnRecord> getAdnRecordsInEf(int efid) throws RemoteException {
        return this.getAdnRecordsInEfForSubscriber(this.getDefaultSubscription(), efid);
    }

    public List<AdnRecord> getAdnRecordsInEfForSubscriber(long subId, int efid) throws RemoteException {
        IccPhoneBookInterfaceManagerProxy iccPbkIntMgrProxy = this.getIccPhoneBookInterfaceManagerProxy(subId);
        if (iccPbkIntMgrProxy != null) {
            return iccPbkIntMgrProxy.getAdnRecordsInEf(efid);
        }
        Rlog.e(TAG, "getAdnRecordsInEf iccPbkIntMgrProxy isnull for Subscription:" + subId);
        return null;
    }

    private IccPhoneBookInterfaceManagerProxy getIccPhoneBookInterfaceManagerProxy(long subId) {
        long phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        try {
            return ((PhoneProxy)this.mPhone[(int)phoneId]).getIccPhoneBookInterfaceManagerProxy();
        }
        catch (NullPointerException e) {
            Rlog.e(TAG, "Exception is :" + e.toString() + " For subscription :" + subId);
            e.printStackTrace();
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Rlog.e(TAG, "Exception is :" + e.toString() + " For subscription :" + subId);
            e.printStackTrace();
            return null;
        }
    }

    private long getDefaultSubscription() {
        return PhoneFactory.getDefaultSubscription();
    }
}

