/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.provider.Telephony;
import android.telephony.Rlog;
import com.android.internal.telephony.InboundSmsHandler;
import com.android.internal.telephony.InboundSmsTracker;
import com.android.internal.telephony.cdma.CdmaInboundSmsHandler;
import com.android.internal.telephony.gsm.GsmInboundSmsHandler;
import java.util.HashMap;
import java.util.HashSet;

public class SmsBroadcastUndelivered
implements Runnable {
    private static final String TAG = "SmsBroadcastUndelivered";
    private static final boolean DBG = true;
    static final long PARTIAL_SEGMENT_EXPIRE_AGE = 2592000000L;
    private static final String[] PDU_PENDING_MESSAGE_PROJECTION = new String[]{"pdu", "sequence", "destination_port", "date", "reference_number", "count", "address", "_id"};
    private static final Uri sRawUri = Uri.withAppendedPath(Telephony.Sms.CONTENT_URI, "raw");
    private final ContentResolver mResolver;
    private final GsmInboundSmsHandler mGsmInboundSmsHandler;
    private final CdmaInboundSmsHandler mCdmaInboundSmsHandler;

    public SmsBroadcastUndelivered(Context context, GsmInboundSmsHandler gsmInboundSmsHandler, CdmaInboundSmsHandler cdmaInboundSmsHandler) {
        this.mResolver = context.getContentResolver();
        this.mGsmInboundSmsHandler = gsmInboundSmsHandler;
        this.mCdmaInboundSmsHandler = cdmaInboundSmsHandler;
    }

    public void run() {
        Rlog.d(TAG, "scanning raw table for undelivered messages");
        this.scanRawTable();
        if (this.mGsmInboundSmsHandler != null) {
            this.mGsmInboundSmsHandler.sendMessage(6);
        }
        if (this.mCdmaInboundSmsHandler != null) {
            this.mCdmaInboundSmsHandler.sendMessage(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scanRawTable() {
        Cursor cursor;
        long startTime;
        block19: {
            block17: {
                startTime = System.nanoTime();
                HashMap<SmsReferenceKey, Integer> multiPartReceivedCount = new HashMap<SmsReferenceKey, Integer>(4);
                HashSet<SmsReferenceKey> oldMultiPartMessages = new HashSet<SmsReferenceKey>(4);
                cursor = null;
                try {
                    block18: {
                        try {
                            cursor = this.mResolver.query(sRawUri, PDU_PENDING_MESSAGE_PROJECTION, null, null, null);
                            if (cursor == null) {
                                Rlog.e(TAG, "error getting pending message cursor");
                                Object var12_5 = null;
                                if (cursor == null) break block17;
                                break block18;
                            }
                            boolean isCurrentFormat3gpp2 = InboundSmsHandler.isCurrentFormat3gpp2();
                            while (cursor.moveToNext()) {
                                InboundSmsTracker tracker;
                                try {
                                    tracker = new InboundSmsTracker(cursor, isCurrentFormat3gpp2);
                                }
                                catch (IllegalArgumentException e) {
                                    Rlog.e(TAG, "error loading SmsTracker: " + e);
                                    continue;
                                }
                                if (tracker.getMessageCount() == 1) {
                                    this.broadcastSms(tracker);
                                    continue;
                                }
                                SmsReferenceKey reference = new SmsReferenceKey(tracker);
                                Integer receivedCount = (Integer)multiPartReceivedCount.get(reference);
                                if (receivedCount == null) {
                                    multiPartReceivedCount.put(reference, 1);
                                    if (tracker.getTimestamp() >= System.currentTimeMillis() - 2592000000L) continue;
                                    oldMultiPartMessages.add(reference);
                                    continue;
                                }
                                int newCount = receivedCount + 1;
                                if (newCount == tracker.getMessageCount()) {
                                    Rlog.d(TAG, "found complete multi-part message");
                                    this.broadcastSms(tracker);
                                    oldMultiPartMessages.remove(reference);
                                    continue;
                                }
                                multiPartReceivedCount.put(reference, newCount);
                            }
                            for (SmsReferenceKey message : oldMultiPartMessages) {
                                int rows = this.mResolver.delete(sRawUri, "address=? AND reference_number=? AND count=?", message.getDeleteWhereArgs());
                                if (rows == 0) {
                                    Rlog.e(TAG, "No rows were deleted from raw table!");
                                    continue;
                                }
                                Rlog.d(TAG, "Deleted " + rows + " rows from raw table for incomplete " + message.mMessageCount + " part message");
                            }
                            break block19;
                        }
                        catch (SQLException e) {
                            Rlog.e(TAG, "error reading pending SMS messages", e);
                            Object var12_7 = null;
                            if (cursor != null) {
                                cursor.close();
                            }
                            Rlog.d(TAG, "finished scanning raw table in " + (System.nanoTime() - startTime) / 1000000L + " ms");
                            return;
                        }
                    }
                    cursor.close();
                }
                catch (Throwable throwable) {
                    Object var12_8 = null;
                    if (cursor != null) {
                        cursor.close();
                    }
                    Rlog.d(TAG, "finished scanning raw table in " + (System.nanoTime() - startTime) / 1000000L + " ms");
                    throw throwable;
                }
            }
            Rlog.d(TAG, "finished scanning raw table in " + (System.nanoTime() - startTime) / 1000000L + " ms");
            return;
        }
        Object var12_6 = null;
        if (cursor != null) {
            cursor.close();
        }
        Rlog.d(TAG, "finished scanning raw table in " + (System.nanoTime() - startTime) / 1000000L + " ms");
    }

    private void broadcastSms(InboundSmsTracker tracker) {
        InboundSmsHandler handler = tracker.is3gpp2() ? this.mCdmaInboundSmsHandler : this.mGsmInboundSmsHandler;
        if (handler != null) {
            handler.sendMessage(2, tracker);
        } else {
            Rlog.e(TAG, "null handler for " + tracker.getFormat() + " format, can't deliver.");
        }
    }

    private static class SmsReferenceKey {
        final String mAddress;
        final int mReferenceNumber;
        final int mMessageCount;

        SmsReferenceKey(InboundSmsTracker tracker) {
            this.mAddress = tracker.getAddress();
            this.mReferenceNumber = tracker.getReferenceNumber();
            this.mMessageCount = tracker.getMessageCount();
        }

        String[] getDeleteWhereArgs() {
            return new String[]{this.mAddress, Integer.toString(this.mReferenceNumber), Integer.toString(this.mMessageCount)};
        }

        public int hashCode() {
            return (this.mReferenceNumber * 31 + this.mMessageCount) * 31 + this.mAddress.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof SmsReferenceKey) {
                SmsReferenceKey other = (SmsReferenceKey)o;
                return other.mAddress.equals(this.mAddress) && other.mReferenceNumber == this.mReferenceNumber && other.mMessageCount == this.mMessageCount;
            }
            return false;
        }
    }
}

