/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.PhoneSubInfoController;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.UiccPhoneBookController;
import com.android.internal.telephony.UiccSmsController;
import com.android.internal.telephony.dataconnection.DctController;
import com.android.internal.telephony.uicc.UiccController;

public class ProxyController {
    static final String LOG_TAG = "ProxyController";
    private static ProxyController sProxyController;
    private Phone[] mProxyPhones;
    private UiccController mUiccController;
    private CommandsInterface[] mCi;
    private Context mContext;
    private static DctController mDctController;
    private UiccPhoneBookController mUiccPhoneBookController;
    private PhoneSubInfoController mPhoneSubInfoController;
    private UiccSmsController mUiccSmsController;

    public static ProxyController getInstance(Context context, Phone[] phoneProxy, UiccController uiccController, CommandsInterface[] ci) {
        if (sProxyController == null) {
            sProxyController = new ProxyController(context, phoneProxy, uiccController, ci);
        }
        return sProxyController;
    }

    public static ProxyController getInstance() {
        return sProxyController;
    }

    private ProxyController(Context context, Phone[] phoneProxy, UiccController uiccController, CommandsInterface[] ci) {
        this.logd("Constructor - Enter");
        this.mContext = context;
        this.mProxyPhones = phoneProxy;
        this.mUiccController = uiccController;
        this.mCi = ci;
        mDctController = DctController.makeDctController((PhoneProxy[])phoneProxy);
        this.mUiccPhoneBookController = new UiccPhoneBookController(this.mProxyPhones);
        this.mPhoneSubInfoController = new PhoneSubInfoController(this.mProxyPhones);
        this.mUiccSmsController = new UiccSmsController(this.mProxyPhones);
        this.logd("Constructor - Exit");
    }

    public void updateDataConnectionTracker(int sub) {
        ((PhoneProxy)this.mProxyPhones[sub]).updateDataConnectionTracker();
    }

    public void enableDataConnectivity(int sub) {
        ((PhoneProxy)this.mProxyPhones[sub]).setInternalDataEnabled(true);
    }

    public void disableDataConnectivity(int sub, Message dataCleanedUpMsg) {
        ((PhoneProxy)this.mProxyPhones[sub]).setInternalDataEnabled(false, dataCleanedUpMsg);
    }

    public void updateCurrentCarrierInProvider(int sub) {
        ((PhoneProxy)this.mProxyPhones[sub]).updateCurrentCarrierInProvider();
    }

    public void registerForAllDataDisconnected(long subId, Handler h, int what, Object obj) {
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        if (phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount()) {
            ((PhoneProxy)this.mProxyPhones[phoneId]).registerForAllDataDisconnected(h, what, obj);
        }
    }

    public void unregisterForAllDataDisconnected(long subId, Handler h) {
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        if (phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount()) {
            ((PhoneProxy)this.mProxyPhones[phoneId]).unregisterForAllDataDisconnected(h);
        }
    }

    public boolean isDataDisconnected(long subId) {
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        if (phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount()) {
            Phone activePhone = ((PhoneProxy)this.mProxyPhones[phoneId]).getActivePhone();
            return ((PhoneBase)activePhone).mDcTracker.isDisconnected();
        }
        return false;
    }

    private void logd(String string2) {
        Rlog.d(LOG_TAG, string2);
    }
}

