/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.telephony.Rlog;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.UUSInfo;

public abstract class Connection {
    protected String mCnapName;
    protected int mCnapNamePresentation = PhoneConstants.PRESENTATION_ALLOWED;
    private static String LOG_TAG = "Connection";
    Object mUserData;

    public abstract String getAddress();

    public String getCnapName() {
        return this.mCnapName;
    }

    public String getOrigDialString() {
        return null;
    }

    public int getCnapNamePresentation() {
        return this.mCnapNamePresentation;
    }

    public abstract Call getCall();

    public abstract long getCreateTime();

    public abstract long getConnectTime();

    public abstract long getDisconnectTime();

    public abstract long getDurationMillis();

    public abstract long getHoldDurationMillis();

    public abstract DisconnectCause getDisconnectCause();

    public abstract boolean isIncoming();

    public Call.State getState() {
        Call c = this.getCall();
        if (c == null) {
            return Call.State.IDLE;
        }
        return c.getState();
    }

    public boolean isAlive() {
        return this.getState().isAlive();
    }

    public boolean isRinging() {
        return this.getState().isRinging();
    }

    public Object getUserData() {
        return this.mUserData;
    }

    public void setUserData(Object userdata) {
        this.mUserData = userdata;
    }

    public abstract void hangup() throws CallStateException;

    public abstract void separate() throws CallStateException;

    public void clearUserData() {
        this.mUserData = null;
    }

    public abstract PostDialState getPostDialState();

    public abstract String getRemainingPostDialString();

    public abstract void proceedAfterWaitChar();

    public abstract void proceedAfterWildChar(String var1);

    public abstract void cancelPostDial();

    public abstract int getNumberPresentation();

    public abstract UUSInfo getUUSInfo();

    public String toString() {
        StringBuilder str = new StringBuilder(128);
        if (Rlog.isLoggable(LOG_TAG, 3)) {
            str.append("addr: " + this.getAddress()).append(" pres.: " + this.getNumberPresentation()).append(" dial: " + this.getOrigDialString()).append(" postdial: " + this.getRemainingPostDialString()).append(" cnap name: " + this.getCnapName()).append("(" + this.getCnapNamePresentation() + ")");
        }
        str.append(" incoming: " + this.isIncoming()).append(" state: " + (Object)((Object)this.getState())).append(" post dial state: " + (Object)((Object)this.getPostDialState()));
        return str.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PostDialState {
        NOT_STARTED,
        STARTED,
        WAIT,
        WILD,
        COMPLETE,
        CANCELLED,
        PAUSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisconnectCause {
        NOT_DISCONNECTED,
        INCOMING_MISSED,
        NORMAL,
        LOCAL,
        BUSY,
        CONGESTION,
        MMI,
        INVALID_NUMBER,
        NUMBER_UNREACHABLE,
        SERVER_UNREACHABLE,
        INVALID_CREDENTIALS,
        OUT_OF_NETWORK,
        SERVER_ERROR,
        TIMED_OUT,
        LOST_SIGNAL,
        LIMIT_EXCEEDED,
        INCOMING_REJECTED,
        POWER_OFF,
        OUT_OF_SERVICE,
        ICC_ERROR,
        CALL_BARRED,
        FDN_BLOCKED,
        CS_RESTRICTED,
        CS_RESTRICTED_NORMAL,
        CS_RESTRICTED_EMERGENCY,
        UNOBTAINABLE_NUMBER,
        CDMA_LOCKED_UNTIL_POWER_CYCLE,
        CDMA_DROP,
        CDMA_INTERCEPT,
        CDMA_REORDER,
        CDMA_SO_REJECT,
        CDMA_RETRY_ORDER,
        CDMA_ACCESS_FAILURE,
        CDMA_PREEMPTED,
        CDMA_NOT_EMERGENCY,
        CDMA_ACCESS_BLOCKED,
        ERROR_UNSPECIFIED;

    }
}

