/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.util.Slog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import libcore.io.IoUtils;
import libcore.io.Streams;

public class InstallerConnection {
    private static final String TAG = "InstallerConnection";
    private static final boolean LOCAL_DEBUG = false;
    private InputStream mIn;
    private OutputStream mOut;
    private LocalSocket mSocket;
    private final byte[] buf = new byte[1024];

    public synchronized String transact(String cmd) {
        int replyLength;
        if (!this.connect()) {
            Slog.e(TAG, "connection failed");
            return "-1";
        }
        if (!this.writeCommand(cmd)) {
            Slog.e(TAG, "write command failed? reconnect!");
            if (!this.connect() || !this.writeCommand(cmd)) {
                return "-1";
            }
        }
        if ((replyLength = this.readReply()) > 0) {
            String s = new String(this.buf, 0, replyLength);
            return s;
        }
        return "-1";
    }

    public int execute(String cmd) {
        String res = this.transact(cmd);
        try {
            return Integer.parseInt(res);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public int dexopt(String apkPath, int uid, boolean isPublic, String instructionSet) {
        return this.dexopt(apkPath, uid, isPublic, "*", instructionSet, false);
    }

    public int dexopt(String apkPath, int uid, boolean isPublic, String pkgName, String instructionSet, boolean vmSafeMode) {
        StringBuilder builder = new StringBuilder("dexopt");
        builder.append(' ');
        builder.append(apkPath);
        builder.append(' ');
        builder.append(uid);
        builder.append(isPublic ? " 1" : " 0");
        builder.append(' ');
        builder.append(pkgName);
        builder.append(' ');
        builder.append(instructionSet);
        builder.append(' ');
        builder.append(vmSafeMode ? " 1" : " 0");
        return this.execute(builder.toString());
    }

    public int patchoat(String apkPath, int uid, boolean isPublic, String instructionSet) {
        return this.patchoat(apkPath, uid, isPublic, "*", instructionSet);
    }

    public int patchoat(String apkPath, int uid, boolean isPublic, String pkgName, String instructionSet) {
        StringBuilder builder = new StringBuilder("patchoat");
        builder.append(' ');
        builder.append(apkPath);
        builder.append(' ');
        builder.append(uid);
        builder.append(isPublic ? " 1" : " 0");
        builder.append(' ');
        builder.append(pkgName);
        builder.append(' ');
        builder.append(instructionSet);
        return this.execute(builder.toString());
    }

    private boolean connect() {
        if (this.mSocket != null) {
            return true;
        }
        Slog.i(TAG, "connecting...");
        try {
            this.mSocket = new LocalSocket();
            LocalSocketAddress address = new LocalSocketAddress("installd", LocalSocketAddress.Namespace.RESERVED);
            this.mSocket.connect(address);
            this.mIn = this.mSocket.getInputStream();
            this.mOut = this.mSocket.getOutputStream();
        }
        catch (IOException ex) {
            this.disconnect();
            return false;
        }
        return true;
    }

    public void disconnect() {
        Slog.i(TAG, "disconnecting...");
        IoUtils.closeQuietly(this.mSocket);
        IoUtils.closeQuietly(this.mIn);
        IoUtils.closeQuietly(this.mOut);
        this.mSocket = null;
        this.mIn = null;
        this.mOut = null;
    }

    private boolean readFully(byte[] buffer, int len) {
        try {
            Streams.readFully(this.mIn, buffer, 0, len);
        }
        catch (IOException ioe) {
            Slog.e(TAG, "read exception");
            this.disconnect();
            return false;
        }
        return true;
    }

    private int readReply() {
        if (!this.readFully(this.buf, 2)) {
            return -1;
        }
        int len = this.buf[0] & 0xFF | (this.buf[1] & 0xFF) << 8;
        if (len < 1 || len > this.buf.length) {
            Slog.e(TAG, "invalid reply length (" + len + ")");
            this.disconnect();
            return -1;
        }
        if (!this.readFully(this.buf, len)) {
            return -1;
        }
        return len;
    }

    private boolean writeCommand(String cmdString) {
        byte[] cmd = cmdString.getBytes();
        int len = cmd.length;
        if (len < 1 || len > this.buf.length) {
            return false;
        }
        this.buf[0] = (byte)(len & 0xFF);
        this.buf[1] = (byte)(len >> 8 & 0xFF);
        try {
            this.mOut.write(this.buf, 0, 2);
            this.mOut.write(cmd, 0, len);
        }
        catch (IOException ex) {
            Slog.e(TAG, "write error");
            this.disconnect();
            return false;
        }
        return true;
    }
}

