/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.notification;

import android.app.Notification;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.provider.Settings;
import android.text.SpannableString;
import android.util.Slog;
import com.android.internal.notification.NotificationScorer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemoContactNotificationScorer
implements NotificationScorer {
    private static final String TAG = "DemoContactNotificationScorer";
    private static final boolean DBG = false;
    protected static final boolean ENABLE_CONTACT_SCORER = true;
    private static final String SETTING_ENABLE_SCORER = "contact_scorer_enabled";
    protected boolean mEnabled;
    private static final int NOTIFICATION_PRIORITY_MULTIPLIER = 10;
    private Context mContext;
    private static final List<String> RELEVANT_KEYS_LIST = Arrays.asList("android.infoText", "android.text", "android.textLines", "android.subText", "android.title");
    private static final String[] PROJECTION = new String[]{"_id", "display_name"};
    private static final Uri CONTACTS_URI = ContactsContract.Contacts.CONTENT_URI;

    private static List<String> extractSpannedStrings(CharSequence charSequence) {
        if (charSequence == null) {
            return Collections.emptyList();
        }
        if (!(charSequence instanceof SpannableString)) {
            return Arrays.asList(((Object)charSequence).toString());
        }
        SpannableString spannableString = (SpannableString)charSequence;
        Object[] ssArr = spannableString.getSpans(0, spannableString.length(), Object.class);
        ArrayList<String> sss = new ArrayList<String>();
        for (Object spanObj : ssArr) {
            try {
                sss.add(((Object)spannableString.subSequence(spannableString.getSpanStart(spanObj), spannableString.getSpanEnd(spanObj))).toString());
            }
            catch (StringIndexOutOfBoundsException e) {
                Slog.e(TAG, "Bad indices when extracting spanned subsequence", e);
            }
        }
        return sss;
    }

    private static String getQuestionMarksInParens(int n) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < n; ++i) {
            if (sb.length() > 1) {
                sb.append(',');
            }
            sb.append('?');
        }
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasStarredContact(Bundle extras) {
        if (extras == null) {
            return false;
        }
        ArrayList<String> qStrings = new ArrayList<String>();
        for (String rk : RELEVANT_KEYS_LIST) {
            if (extras.get(rk) == null) continue;
            if (extras.get(rk) instanceof CharSequence) {
                qStrings.addAll(DemoContactNotificationScorer.extractSpannedStrings((CharSequence)extras.get(rk)));
                continue;
            }
            if (extras.get(rk) instanceof CharSequence[]) {
                for (CharSequence line : (CharSequence[])extras.get(rk)) {
                    qStrings.addAll(DemoContactNotificationScorer.extractSpannedStrings(line));
                }
                continue;
            }
            Slog.w(TAG, "Strange, the extra " + rk + " is of unexpected type.");
        }
        if (qStrings.isEmpty()) {
            return false;
        }
        String[] qStringsArr = qStrings.toArray(new String[qStrings.size()]);
        String selection = "display_name IN " + DemoContactNotificationScorer.getQuestionMarksInParens(qStringsArr.length) + " AND " + "starred" + " ='1'";
        Cursor c = null;
        try {
            c = this.mContext.getContentResolver().query(CONTACTS_URI, PROJECTION, selection, qStringsArr, null);
            if (c != null) {
                int len$ = c.getCount() > 0 ? 1 : 0;
                return len$ != 0;
            }
        }
        catch (Throwable t) {
            Slog.w(TAG, "Problem getting content resolver or performing contacts query.", t);
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return false;
    }

    private static final int clamp(int x, int low, int high) {
        return x < low ? low : (x > high ? high : x);
    }

    private static int priorityBumpMap(int incomingScore) {
        int pm = 10;
        int theScore = incomingScore;
        if ((theScore = DemoContactNotificationScorer.clamp(theScore, -2 * pm, 2 * pm)) != incomingScore) {
            return incomingScore;
        }
        theScore = theScore <= -pm ? (int)((double)theScore + 1.5 * (double)(theScore + 2 * pm)) : (int)((double)theScore + 0.5 * (double)(2 * pm - theScore));
        return theScore;
    }

    @Override
    public void initialize(Context context) {
        this.mContext = context;
        this.mEnabled = 1 == Settings.Global.getInt(this.mContext.getContentResolver(), SETTING_ENABLE_SCORER, 0);
    }

    @Override
    public int getScore(Notification notification, int score) {
        if (notification == null || !this.mEnabled) {
            return score;
        }
        boolean hasStarredPriority = this.hasStarredContact(notification.extras);
        if (hasStarredPriority) {
            score = DemoContactNotificationScorer.priorityBumpMap(score);
        }
        return score;
    }
}

