/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.media.MediaRouter;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.Checkable;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.SeekBar;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MediaRouteChooserDialogFragment
extends DialogFragment {
    private static final String TAG = "MediaRouteChooserDialogFragment";
    public static final String FRAGMENT_TAG = "android:MediaRouteChooserDialogFragment";
    private static final int[] ITEM_LAYOUTS = new int[]{17367137, 17367136, 17367133, 17367134, 17367135};
    MediaRouter mRouter;
    private int mRouteTypes;
    private LayoutInflater mInflater;
    private LauncherListener mLauncherListener;
    private View.OnClickListener mExtendedSettingsListener;
    private RouteAdapter mAdapter;
    private ListView mListView;
    private SeekBar mVolumeSlider;
    private ImageView mVolumeIcon;
    final RouteComparator mComparator = new RouteComparator();
    final MediaRouterCallback mCallback = new MediaRouterCallback();
    private boolean mIgnoreSliderVolumeChanges;
    private boolean mIgnoreCallbackVolumeChanges;

    public MediaRouteChooserDialogFragment() {
        this.setStyle(1, 16974126);
    }

    public void setLauncherListener(LauncherListener listener) {
        this.mLauncherListener = listener;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mRouter = (MediaRouter)activity.getSystemService("media_router");
        this.mRouter.addCallback(this.mRouteTypes, this.mCallback, 1);
    }

    public void onDetach() {
        super.onDetach();
        if (this.mLauncherListener != null) {
            this.mLauncherListener.onDetached(this);
        }
        if (this.mAdapter != null) {
            this.mAdapter = null;
        }
        this.mInflater = null;
        this.mRouter.removeCallback(this.mCallback);
        this.mRouter = null;
    }

    public void setExtendedSettingsClickListener(View.OnClickListener listener) {
        this.mExtendedSettingsListener = listener;
    }

    public void setRouteTypes(int types) {
        this.mRouteTypes = types;
    }

    void updateVolume() {
        if (this.mRouter == null) {
            return;
        }
        MediaRouter.RouteInfo selectedRoute = this.mRouter.getSelectedRoute(this.mRouteTypes);
        this.mVolumeIcon.setImageResource(selectedRoute == null || selectedRoute.getPlaybackType() == 0 ? 17302188 : 17302318);
        this.mIgnoreSliderVolumeChanges = true;
        if (selectedRoute == null || selectedRoute.getVolumeHandling() == 0) {
            this.mVolumeSlider.setMax(1);
            this.mVolumeSlider.setProgress(1);
            this.mVolumeSlider.setEnabled(false);
        } else {
            this.mVolumeSlider.setEnabled(true);
            this.mVolumeSlider.setMax(selectedRoute.getVolumeMax());
            this.mVolumeSlider.setProgress(selectedRoute.getVolume());
        }
        this.mIgnoreSliderVolumeChanges = false;
    }

    void changeVolume(int newValue) {
        if (this.mIgnoreSliderVolumeChanges) {
            return;
        }
        MediaRouter.RouteInfo selectedRoute = this.mRouter.getSelectedRoute(this.mRouteTypes);
        if (selectedRoute != null && selectedRoute.getVolumeHandling() == 1) {
            int maxVolume = selectedRoute.getVolumeMax();
            newValue = Math.max(0, Math.min(newValue, maxVolume));
            selectedRoute.requestSetVolume(newValue);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mInflater = inflater;
        View layout2 = inflater.inflate(17367132, container, false);
        this.mVolumeIcon = (ImageView)layout2.findViewById(16909001);
        this.mVolumeSlider = (SeekBar)layout2.findViewById(16909002);
        this.updateVolume();
        this.mVolumeSlider.setOnSeekBarChangeListener(new VolumeSliderChangeListener());
        if (this.mExtendedSettingsListener != null) {
            View extendedSettingsButton = layout2.findViewById(16909003);
            extendedSettingsButton.setVisibility(0);
            extendedSettingsButton.setOnClickListener(this.mExtendedSettingsListener);
        }
        ListView list = (ListView)layout2.findViewById(16908298);
        list.setItemsCanFocus(true);
        this.mAdapter = new RouteAdapter();
        list.setAdapter(this.mAdapter);
        list.setOnItemClickListener(this.mAdapter);
        this.mListView = list;
        this.mAdapter.scrollToSelectedItem();
        return layout2;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        return new RouteChooserDialog(this.getActivity(), this.getTheme());
    }

    class VolumeSliderChangeListener
    implements SeekBar.OnSeekBarChangeListener {
        VolumeSliderChangeListener() {
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            MediaRouteChooserDialogFragment.this.changeVolume(progress);
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
            MediaRouteChooserDialogFragment.this.mIgnoreCallbackVolumeChanges = true;
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            MediaRouteChooserDialogFragment.this.mIgnoreCallbackVolumeChanges = false;
            MediaRouteChooserDialogFragment.this.updateVolume();
        }
    }

    public static interface LauncherListener {
        public void onDetached(MediaRouteChooserDialogFragment var1);
    }

    class RouteChooserDialog
    extends Dialog {
        public RouteChooserDialog(Context context, int theme) {
            super(context, theme);
        }

        public void onBackPressed() {
            if (MediaRouteChooserDialogFragment.this.mAdapter != null && MediaRouteChooserDialogFragment.this.mAdapter.isGrouping()) {
                MediaRouteChooserDialogFragment.this.mAdapter.finishGrouping();
            } else {
                super.onBackPressed();
            }
        }

        public boolean onKeyDown(int keyCode, KeyEvent event) {
            MediaRouter.RouteInfo selectedRoute;
            if (keyCode == 25 && MediaRouteChooserDialogFragment.this.mVolumeSlider.isEnabled()) {
                MediaRouter.RouteInfo selectedRoute2 = MediaRouteChooserDialogFragment.this.mRouter.getSelectedRoute(MediaRouteChooserDialogFragment.this.mRouteTypes);
                if (selectedRoute2 != null) {
                    selectedRoute2.requestUpdateVolume(-1);
                    return true;
                }
            } else if (keyCode == 24 && MediaRouteChooserDialogFragment.this.mVolumeSlider.isEnabled() && (selectedRoute = MediaRouteChooserDialogFragment.this.mRouter.getSelectedRoute(MediaRouteChooserDialogFragment.this.mRouteTypes)) != null) {
                MediaRouteChooserDialogFragment.this.mRouter.getSelectedRoute(MediaRouteChooserDialogFragment.this.mRouteTypes).requestUpdateVolume(1);
                return true;
            }
            return super.onKeyDown(keyCode, event);
        }

        public boolean onKeyUp(int keyCode, KeyEvent event) {
            if (keyCode == 25 && MediaRouteChooserDialogFragment.this.mVolumeSlider.isEnabled()) {
                return true;
            }
            if (keyCode == 24 && MediaRouteChooserDialogFragment.this.mVolumeSlider.isEnabled()) {
                return true;
            }
            return super.onKeyUp(keyCode, event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RouteComparator
    implements Comparator<MediaRouter.RouteInfo> {
        RouteComparator() {
        }

        @Override
        public int compare(MediaRouter.RouteInfo lhs, MediaRouter.RouteInfo rhs) {
            return ((Object)lhs.getName(MediaRouteChooserDialogFragment.this.getActivity())).toString().compareTo(((Object)rhs.getName(MediaRouteChooserDialogFragment.this.getActivity())).toString());
        }
    }

    class MediaRouterCallback
    extends MediaRouter.Callback {
        MediaRouterCallback() {
        }

        public void onRouteSelected(MediaRouter router, int type, MediaRouter.RouteInfo info) {
            MediaRouteChooserDialogFragment.this.mAdapter.update();
            MediaRouteChooserDialogFragment.this.updateVolume();
        }

        public void onRouteUnselected(MediaRouter router, int type, MediaRouter.RouteInfo info) {
            MediaRouteChooserDialogFragment.this.mAdapter.update();
        }

        public void onRouteAdded(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteChooserDialogFragment.this.mAdapter.update();
        }

        public void onRouteRemoved(MediaRouter router, MediaRouter.RouteInfo info) {
            if (info == MediaRouteChooserDialogFragment.this.mAdapter.mEditingGroup) {
                MediaRouteChooserDialogFragment.this.mAdapter.finishGrouping();
            }
            MediaRouteChooserDialogFragment.this.mAdapter.update();
        }

        public void onRouteChanged(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteChooserDialogFragment.this.mAdapter.notifyDataSetChanged();
        }

        public void onRouteGrouped(MediaRouter router, MediaRouter.RouteInfo info, MediaRouter.RouteGroup group, int index) {
            MediaRouteChooserDialogFragment.this.mAdapter.update();
        }

        public void onRouteUngrouped(MediaRouter router, MediaRouter.RouteInfo info, MediaRouter.RouteGroup group) {
            MediaRouteChooserDialogFragment.this.mAdapter.update();
        }

        public void onRouteVolumeChanged(MediaRouter router, MediaRouter.RouteInfo info) {
            if (!MediaRouteChooserDialogFragment.this.mIgnoreCallbackVolumeChanges) {
                MediaRouteChooserDialogFragment.this.updateVolume();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RouteAdapter
    extends BaseAdapter
    implements AdapterView.OnItemClickListener {
        private static final int VIEW_TOP_HEADER = 0;
        private static final int VIEW_SECTION_HEADER = 1;
        private static final int VIEW_ROUTE = 2;
        private static final int VIEW_GROUPING_ROUTE = 3;
        private static final int VIEW_GROUPING_DONE = 4;
        private int mSelectedItemPosition = -1;
        private final ArrayList<Object> mItems = new ArrayList();
        private MediaRouter.RouteCategory mCategoryEditingGroups;
        private MediaRouter.RouteGroup mEditingGroup;
        private final ArrayList<MediaRouter.RouteInfo> mCatRouteList = new ArrayList();
        private final ArrayList<MediaRouter.RouteInfo> mSortRouteList = new ArrayList();
        private boolean mIgnoreUpdates;

        RouteAdapter() {
            this.update();
        }

        void update() {
            if (this.mIgnoreUpdates) {
                return;
            }
            this.mItems.clear();
            MediaRouter.RouteInfo selectedRoute = MediaRouteChooserDialogFragment.this.mRouter.getSelectedRoute(MediaRouteChooserDialogFragment.this.mRouteTypes);
            this.mSelectedItemPosition = -1;
            int catCount = MediaRouteChooserDialogFragment.this.mRouter.getCategoryCount();
            for (int i = 0; i < catCount; ++i) {
                MediaRouter.RouteCategory cat = MediaRouteChooserDialogFragment.this.mRouter.getCategoryAt(i);
                List<MediaRouter.RouteInfo> routes = cat.getRoutes(this.mCatRouteList);
                if (!cat.isSystem()) {
                    this.mItems.add(cat);
                }
                if (cat == this.mCategoryEditingGroups) {
                    this.addGroupEditingCategoryRoutes(routes);
                } else {
                    this.addSelectableRoutes(selectedRoute, routes);
                }
                routes.clear();
            }
            this.notifyDataSetChanged();
            if (MediaRouteChooserDialogFragment.this.mListView != null && this.mSelectedItemPosition >= 0) {
                MediaRouteChooserDialogFragment.this.mListView.setItemChecked(this.mSelectedItemPosition, true);
            }
        }

        void scrollToEditingGroup() {
            if (this.mCategoryEditingGroups == null || MediaRouteChooserDialogFragment.this.mListView == null) {
                return;
            }
            int pos = 0;
            int bound = 0;
            int itemCount = this.mItems.size();
            for (int i = 0; i < itemCount; ++i) {
                Object item = this.mItems.get(i);
                if (item != null && item == this.mCategoryEditingGroups) {
                    bound = i;
                }
                if (item != null) continue;
                pos = i;
                break;
            }
            MediaRouteChooserDialogFragment.this.mListView.smoothScrollToPosition(pos, bound);
        }

        void scrollToSelectedItem() {
            if (MediaRouteChooserDialogFragment.this.mListView == null || this.mSelectedItemPosition < 0) {
                return;
            }
            MediaRouteChooserDialogFragment.this.mListView.smoothScrollToPosition(this.mSelectedItemPosition);
        }

        void addSelectableRoutes(MediaRouter.RouteInfo selectedRoute, List<MediaRouter.RouteInfo> from) {
            int routeCount = from.size();
            for (int j = 0; j < routeCount; ++j) {
                MediaRouter.RouteInfo info = from.get(j);
                if (info == selectedRoute) {
                    this.mSelectedItemPosition = this.mItems.size();
                }
                this.mItems.add(info);
            }
        }

        void addGroupEditingCategoryRoutes(List<MediaRouter.RouteInfo> from) {
            int topCount = from.size();
            for (int i = 0; i < topCount; ++i) {
                MediaRouter.RouteInfo route = from.get(i);
                MediaRouter.RouteGroup group = route.getGroup();
                if (group == route) {
                    int groupCount = group.getRouteCount();
                    for (int j = 0; j < groupCount; ++j) {
                        MediaRouter.RouteInfo innerRoute = group.getRouteAt(j);
                        this.mSortRouteList.add(innerRoute);
                    }
                    continue;
                }
                this.mSortRouteList.add(route);
            }
            Collections.sort(this.mSortRouteList, MediaRouteChooserDialogFragment.this.mComparator);
            this.mItems.addAll(this.mSortRouteList);
            this.mSortRouteList.clear();
            this.mItems.add(null);
        }

        @Override
        public int getCount() {
            return this.mItems.size();
        }

        @Override
        public int getViewTypeCount() {
            return 5;
        }

        @Override
        public int getItemViewType(int position) {
            Object item = this.getItem(position);
            if (item instanceof MediaRouter.RouteCategory) {
                return position == 0 ? 0 : 1;
            }
            if (item == null) {
                return 4;
            }
            MediaRouter.RouteInfo info = (MediaRouter.RouteInfo)item;
            if (info.getCategory() == this.mCategoryEditingGroups) {
                return 3;
            }
            return 2;
        }

        @Override
        public boolean areAllItemsEnabled() {
            return false;
        }

        @Override
        public boolean isEnabled(int position) {
            switch (this.getItemViewType(position)) {
                case 2: {
                    return ((MediaRouter.RouteInfo)this.mItems.get(position)).isEnabled();
                }
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object getItem(int position) {
            return this.mItems.get(position);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            int viewType = this.getItemViewType(position);
            if (convertView == null) {
                convertView = MediaRouteChooserDialogFragment.this.mInflater.inflate(ITEM_LAYOUTS[viewType], parent, false);
                holder = new ViewHolder();
                holder.position = position;
                holder.text1 = (TextView)convertView.findViewById(16908308);
                holder.text2 = (TextView)convertView.findViewById(16908309);
                holder.icon = (ImageView)convertView.findViewById(16908294);
                holder.check = (CheckBox)convertView.findViewById(16909005);
                holder.expandGroupButton = (ImageButton)convertView.findViewById(16909004);
                if (holder.expandGroupButton != null) {
                    holder.expandGroupListener = new ExpandGroupListener();
                    holder.expandGroupButton.setOnClickListener(holder.expandGroupListener);
                }
                final View fview = convertView;
                final ListView list = (ListView)parent;
                final ViewHolder fholder = holder;
                convertView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        list.performItemClick(fview, fholder.position, 0L);
                    }
                });
                convertView.setTag(holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
                holder.position = position;
            }
            switch (viewType) {
                case 2: 
                case 3: {
                    this.bindItemView(position, holder);
                    break;
                }
                case 0: 
                case 1: {
                    this.bindHeaderView(position, holder);
                }
            }
            convertView.setActivated(position == this.mSelectedItemPosition);
            convertView.setEnabled(this.isEnabled(position));
            return convertView;
        }

        void bindItemView(int position, ViewHolder holder) {
            MediaRouter.RouteInfo info = (MediaRouter.RouteInfo)this.mItems.get(position);
            holder.text1.setText(info.getName(MediaRouteChooserDialogFragment.this.getActivity()));
            CharSequence status = info.getStatus();
            if (TextUtils.isEmpty(status)) {
                holder.text2.setVisibility(8);
            } else {
                holder.text2.setVisibility(0);
                holder.text2.setText(status);
            }
            Drawable icon = info.getIconDrawable();
            if (icon != null) {
                icon = icon.getConstantState().newDrawable(MediaRouteChooserDialogFragment.this.getResources());
            }
            holder.icon.setImageDrawable(icon);
            holder.icon.setVisibility(icon != null ? 0 : 8);
            MediaRouter.RouteCategory cat = info.getCategory();
            boolean canGroup = false;
            if (cat == this.mCategoryEditingGroups) {
                MediaRouter.RouteGroup group = info.getGroup();
                holder.check.setEnabled(group.getRouteCount() > 1);
                holder.check.setChecked(group == this.mEditingGroup);
            } else if (cat.isGroupable()) {
                MediaRouter.RouteGroup group = (MediaRouter.RouteGroup)info;
                boolean bl = canGroup = group.getRouteCount() > 1 || this.getItemViewType(position - 1) == 2 || position < this.getCount() - 1 && this.getItemViewType(position + 1) == 2;
            }
            if (holder.expandGroupButton != null) {
                holder.expandGroupButton.setVisibility(canGroup ? 0 : 8);
                holder.expandGroupListener.position = position;
            }
        }

        void bindHeaderView(int position, ViewHolder holder) {
            MediaRouter.RouteCategory cat = (MediaRouter.RouteCategory)this.mItems.get(position);
            holder.text1.setText(cat.getName(MediaRouteChooserDialogFragment.this.getActivity()));
        }

        @Override
        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            int type = this.getItemViewType(position);
            if (type == 1 || type == 0) {
                return;
            }
            if (type == 4) {
                this.finishGrouping();
                return;
            }
            Object item = this.getItem(position);
            if (!(item instanceof MediaRouter.RouteInfo)) {
                return;
            }
            MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)item;
            if (type == 2) {
                MediaRouteChooserDialogFragment.this.mRouter.selectRouteInt(MediaRouteChooserDialogFragment.this.mRouteTypes, route);
                MediaRouteChooserDialogFragment.this.dismiss();
            } else if (type == 3) {
                Checkable c = (Checkable)((Object)view);
                boolean wasChecked = c.isChecked();
                this.mIgnoreUpdates = true;
                MediaRouter.RouteGroup oldGroup = route.getGroup();
                if (!wasChecked && oldGroup != this.mEditingGroup) {
                    if (MediaRouteChooserDialogFragment.this.mRouter.getSelectedRoute(MediaRouteChooserDialogFragment.this.mRouteTypes) == oldGroup) {
                        MediaRouteChooserDialogFragment.this.mRouter.selectRouteInt(MediaRouteChooserDialogFragment.this.mRouteTypes, this.mEditingGroup);
                    }
                    oldGroup.removeRoute(route);
                    this.mEditingGroup.addRoute(route);
                    c.setChecked(true);
                } else if (wasChecked && this.mEditingGroup.getRouteCount() > 1) {
                    this.mEditingGroup.removeRoute(route);
                    MediaRouteChooserDialogFragment.this.mRouter.addRouteInt(route);
                }
                this.mIgnoreUpdates = false;
                this.update();
            }
        }

        boolean isGrouping() {
            return this.mCategoryEditingGroups != null;
        }

        void finishGrouping() {
            this.mCategoryEditingGroups = null;
            this.mEditingGroup = null;
            MediaRouteChooserDialogFragment.this.getDialog().setCanceledOnTouchOutside(true);
            this.update();
            this.scrollToSelectedItem();
        }

        class ExpandGroupListener
        implements View.OnClickListener {
            int position;

            ExpandGroupListener() {
            }

            public void onClick(View v) {
                MediaRouter.RouteGroup group = (MediaRouter.RouteGroup)RouteAdapter.this.getItem(this.position);
                RouteAdapter.this.mEditingGroup = group;
                RouteAdapter.this.mCategoryEditingGroups = group.getCategory();
                MediaRouteChooserDialogFragment.this.getDialog().setCanceledOnTouchOutside(false);
                MediaRouteChooserDialogFragment.this.mRouter.selectRouteInt(MediaRouteChooserDialogFragment.this.mRouteTypes, RouteAdapter.this.mEditingGroup);
                RouteAdapter.this.update();
                RouteAdapter.this.scrollToEditingGroup();
            }
        }
    }

    private static class ViewHolder {
        public TextView text1;
        public TextView text2;
        public ImageView icon;
        public ImageButton expandGroupButton;
        public RouteAdapter.ExpandGroupListener expandGroupListener;
        public int position;
        public CheckBox check;

        private ViewHolder() {
        }
    }
}

