/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.UndoManager;
import android.content.res.ColorStateList;
import android.content.res.CompatibilityInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Canvas;
import android.graphics.Insets;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.ExtractEditText;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.BoringLayout;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.GetChars;
import android.text.GraphicsOperations;
import android.text.InputFilter;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.AllCapsTransformationMethod;
import android.text.method.ArrowKeyMovementMethod;
import android.text.method.BaseKeyListener;
import android.text.method.DateKeyListener;
import android.text.method.DateTimeKeyListener;
import android.text.method.DialerKeyListener;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.text.method.LinkMovementMethod;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.SingleLineTransformationMethod;
import android.text.method.TextKeyListener;
import android.text.method.TimeKeyListener;
import android.text.method.TransformationMethod;
import android.text.method.TransformationMethod2;
import android.text.method.WordIterator;
import android.text.style.CharacterStyle;
import android.text.style.ClickableSpan;
import android.text.style.ParagraphStyle;
import android.text.style.SpellCheckSpan;
import android.text.style.SuggestionSpan;
import android.text.style.URLSpan;
import android.text.style.UpdateAppearance;
import android.text.util.Linkify;
import android.util.AttributeSet;
import android.util.FloatMath;
import android.util.Log;
import android.util.TypedValue;
import android.view.AccessibilityIterators;
import android.view.ActionMode;
import android.view.DragEvent;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewRootImpl;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.view.textservice.SpellCheckerSubtype;
import android.view.textservice.TextServicesManager;
import android.widget.AccessibilityIterators;
import android.widget.Editor;
import android.widget.RemoteViews;
import android.widget.Scroller;
import android.widget.SpellChecker;
import com.android.internal.R;
import com.android.internal.util.FastMath;
import com.android.internal.widget.EditableInputConnection;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RemoteViews.RemoteView
public class TextView
extends View
implements ViewTreeObserver.OnPreDrawListener {
    static final String LOG_TAG = "TextView";
    static final boolean DEBUG_EXTRACT = false;
    private static final int SANS = 1;
    private static final int SERIF = 2;
    private static final int MONOSPACE = 3;
    private static final int SIGNED = 2;
    private static final int DECIMAL = 4;
    private static final int MARQUEE_FADE_NORMAL = 0;
    private static final int MARQUEE_FADE_SWITCH_SHOW_ELLIPSIS = 1;
    private static final int MARQUEE_FADE_SWITCH_SHOW_FADE = 2;
    private static final int LINES = 1;
    private static final int EMS = 1;
    private static final int PIXELS = 2;
    private static final RectF TEMP_RECTF = new RectF();
    private static final int VERY_WIDE = 0x100000;
    private static final int ANIMATED_SCROLL_GAP = 250;
    private static final InputFilter[] NO_FILTERS = new InputFilter[0];
    private static final Spanned EMPTY_SPANNED = new SpannedString("");
    private static final int CHANGE_WATCHER_PRIORITY = 100;
    private static final int[] MULTILINE_STATE_SET = new int[]{16843597};
    static long LAST_CUT_OR_COPY_TIME;
    private ColorStateList mTextColor;
    private ColorStateList mHintTextColor;
    private ColorStateList mLinkTextColor;
    private int mCurTextColor;
    private int mCurHintTextColor;
    private boolean mFreezesText;
    private boolean mTemporaryDetach;
    private boolean mDispatchTemporaryDetach;
    private Editable.Factory mEditableFactory = Editable.Factory.getInstance();
    private Spannable.Factory mSpannableFactory = Spannable.Factory.getInstance();
    private float mShadowRadius;
    private float mShadowDx;
    private float mShadowDy;
    private boolean mPreDrawRegistered;
    private boolean mPreventDefaultMovement;
    private TextUtils.TruncateAt mEllipsize;
    Drawables mDrawables;
    private CharWrapper mCharWrapper;
    private Marquee mMarquee;
    private boolean mRestartMarquee;
    private int mMarqueeRepeatLimit = 3;
    private int mLastLayoutDirection = -1;
    private int mMarqueeFadeMode = 0;
    private Layout mSavedMarqueeModeLayout;
    @ViewDebug.ExportedProperty(category="text")
    private CharSequence mText = "";
    private CharSequence mTransformed;
    private BufferType mBufferType = BufferType.NORMAL;
    private CharSequence mHint;
    private Layout mHintLayout;
    private MovementMethod mMovement;
    private TransformationMethod mTransformation;
    private boolean mAllowTransformationLengthChange;
    private ChangeWatcher mChangeWatcher;
    private ArrayList<TextWatcher> mListeners;
    private final TextPaint mTextPaint;
    private boolean mUserSetTextScaleX;
    private Layout mLayout;
    private int mGravity = 0x800033;
    private boolean mHorizontallyScrolling;
    private int mAutoLinkMask;
    private boolean mLinksClickable = true;
    private float mSpacingMult = 1.0f;
    private float mSpacingAdd = 0.0f;
    private int mMaximum = Integer.MAX_VALUE;
    private int mMaxMode = 1;
    private int mMinimum = 0;
    private int mMinMode = 1;
    private int mOldMaximum = this.mMaximum;
    private int mOldMaxMode = this.mMaxMode;
    private int mMaxWidth = Integer.MAX_VALUE;
    private int mMaxWidthMode = 2;
    private int mMinWidth = 0;
    private int mMinWidthMode = 2;
    private boolean mSingleLine;
    private int mDesiredHeightAtMeasure = -1;
    private boolean mIncludePad = true;
    private int mDeferScroll = -1;
    private Rect mTempRect;
    private long mLastScroll;
    private Scroller mScroller;
    private BoringLayout.Metrics mBoring;
    private BoringLayout.Metrics mHintBoring;
    private BoringLayout mSavedLayout;
    private BoringLayout mSavedHintLayout;
    private TextDirectionHeuristic mTextDir;
    private InputFilter[] mFilters = NO_FILTERS;
    private volatile Locale mCurrentSpellCheckerLocaleCache;
    int mHighlightColor = 1714664933;
    private Path mHighlightPath;
    private final Paint mHighlightPaint;
    private boolean mHighlightPathBogus = true;
    int mCursorDrawableRes;
    int mTextSelectHandleLeftRes;
    int mTextSelectHandleRightRes;
    int mTextSelectHandleRes;
    int mTextEditSuggestionItemLayout;
    private Editor mEditor;
    private static final BoringLayout.Metrics UNKNOWN_BORING;
    static final int ID_SELECT_ALL = 16908319;
    static final int ID_CUT = 0x1020020;
    static final int ID_COPY = 0x1020021;
    static final int ID_PASTE = 0x1020022;

    public TextView(Context context) {
        this(context, null);
    }

    public TextView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public TextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        boolean focusable;
        boolean numberPasswordInputType;
        Resources res = this.getResources();
        CompatibilityInfo compat = res.getCompatibilityInfo();
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.density = res.getDisplayMetrics().density;
        this.mTextPaint.setCompatibilityScaling(compat.applicationScale);
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setCompatibilityScaling(compat.applicationScale);
        this.mMovement = this.getDefaultMovementMethod();
        this.mTransformation = null;
        int textColorHighlight = 0;
        ColorStateList textColor = null;
        ColorStateList textColorHint = null;
        ColorStateList textColorLink = null;
        int textSize = 15;
        String fontFamily = null;
        int typefaceIndex = -1;
        int styleIndex = -1;
        boolean allCaps = false;
        int shadowcolor = 0;
        float dx = 0.0f;
        float dy = 0.0f;
        float r = 0.0f;
        Resources.Theme theme = context.getTheme();
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.TextViewAppearance, defStyle, 0);
        TypedArray appearance = null;
        int ap = a.getResourceId(0, -1);
        a.recycle();
        if (ap != -1) {
            appearance = theme.obtainStyledAttributes(ap, R.styleable.TextAppearance);
        }
        if (appearance != null) {
            int n = appearance.getIndexCount();
            block119: for (int i = 0; i < n; ++i) {
                int attr2 = appearance.getIndex(i);
                switch (attr2) {
                    case 4: {
                        textColorHighlight = appearance.getColor(attr2, textColorHighlight);
                        continue block119;
                    }
                    case 3: {
                        textColor = appearance.getColorStateList(attr2);
                        continue block119;
                    }
                    case 5: {
                        textColorHint = appearance.getColorStateList(attr2);
                        continue block119;
                    }
                    case 6: {
                        textColorLink = appearance.getColorStateList(attr2);
                        continue block119;
                    }
                    case 0: {
                        textSize = appearance.getDimensionPixelSize(attr2, textSize);
                        continue block119;
                    }
                    case 1: {
                        typefaceIndex = appearance.getInt(attr2, -1);
                        continue block119;
                    }
                    case 12: {
                        fontFamily = appearance.getString(attr2);
                        continue block119;
                    }
                    case 2: {
                        styleIndex = appearance.getInt(attr2, -1);
                        continue block119;
                    }
                    case 11: {
                        allCaps = appearance.getBoolean(attr2, false);
                        continue block119;
                    }
                    case 7: {
                        shadowcolor = a.getInt(attr2, 0);
                        continue block119;
                    }
                    case 8: {
                        dx = a.getFloat(attr2, 0.0f);
                        continue block119;
                    }
                    case 9: {
                        dy = a.getFloat(attr2, 0.0f);
                        continue block119;
                    }
                    case 10: {
                        r = a.getFloat(attr2, 0.0f);
                    }
                }
            }
            appearance.recycle();
        }
        boolean editable = this.getDefaultEditable();
        CharSequence inputMethod = null;
        int numeric = 0;
        CharSequence digits = null;
        boolean phone = false;
        boolean autotext = false;
        int autocap = -1;
        int buffertype = 0;
        boolean selectallonfocus = false;
        Drawable drawableLeft = null;
        Drawable drawableTop = null;
        Drawable drawableRight = null;
        Drawable drawableBottom = null;
        Drawable drawableStart = null;
        Drawable drawableEnd = null;
        int drawablePadding = 0;
        int ellipsize = -1;
        boolean singleLine = false;
        int maxlength = -1;
        CharSequence text = "";
        CharSequence hint = null;
        boolean password = false;
        int inputType = 0;
        a = theme.obtainStyledAttributes(attrs, R.styleable.TextView, defStyle, 0);
        int n = a.getIndexCount();
        block120: for (int i = 0; i < n; ++i) {
            int attr3 = a.getIndex(i);
            switch (attr3) {
                case 46: {
                    editable = a.getBoolean(attr3, editable);
                    continue block120;
                }
                case 43: {
                    inputMethod = a.getText(attr3);
                    continue block120;
                }
                case 40: {
                    numeric = a.getInt(attr3, numeric);
                    continue block120;
                }
                case 41: {
                    digits = a.getText(attr3);
                    continue block120;
                }
                case 42: {
                    phone = a.getBoolean(attr3, phone);
                    continue block120;
                }
                case 45: {
                    autotext = a.getBoolean(attr3, autotext);
                    continue block120;
                }
                case 44: {
                    autocap = a.getInt(attr3, autocap);
                    continue block120;
                }
                case 17: {
                    buffertype = a.getInt(attr3, buffertype);
                    continue block120;
                }
                case 33: {
                    selectallonfocus = a.getBoolean(attr3, selectallonfocus);
                    continue block120;
                }
                case 11: {
                    this.mAutoLinkMask = a.getInt(attr3, 0);
                    continue block120;
                }
                case 12: {
                    this.mLinksClickable = a.getBoolean(attr3, true);
                    continue block120;
                }
                case 50: {
                    drawableLeft = a.getDrawable(attr3);
                    continue block120;
                }
                case 48: {
                    drawableTop = a.getDrawable(attr3);
                    continue block120;
                }
                case 51: {
                    drawableRight = a.getDrawable(attr3);
                    continue block120;
                }
                case 49: {
                    drawableBottom = a.getDrawable(attr3);
                    continue block120;
                }
                case 73: {
                    drawableStart = a.getDrawable(attr3);
                    continue block120;
                }
                case 74: {
                    drawableEnd = a.getDrawable(attr3);
                    continue block120;
                }
                case 52: {
                    drawablePadding = a.getDimensionPixelSize(attr3, drawablePadding);
                    continue block120;
                }
                case 22: {
                    this.setMaxLines(a.getInt(attr3, -1));
                    continue block120;
                }
                case 14: {
                    this.setMaxHeight(a.getDimensionPixelSize(attr3, -1));
                    continue block120;
                }
                case 23: {
                    this.setLines(a.getInt(attr3, -1));
                    continue block120;
                }
                case 24: {
                    this.setHeight(a.getDimensionPixelSize(attr3, -1));
                    continue block120;
                }
                case 25: {
                    this.setMinLines(a.getInt(attr3, -1));
                    continue block120;
                }
                case 16: {
                    this.setMinHeight(a.getDimensionPixelSize(attr3, -1));
                    continue block120;
                }
                case 26: {
                    this.setMaxEms(a.getInt(attr3, -1));
                    continue block120;
                }
                case 13: {
                    this.setMaxWidth(a.getDimensionPixelSize(attr3, -1));
                    continue block120;
                }
                case 27: {
                    this.setEms(a.getInt(attr3, -1));
                    continue block120;
                }
                case 28: {
                    this.setWidth(a.getDimensionPixelSize(attr3, -1));
                    continue block120;
                }
                case 29: {
                    this.setMinEms(a.getInt(attr3, -1));
                    continue block120;
                }
                case 15: {
                    this.setMinWidth(a.getDimensionPixelSize(attr3, -1));
                    continue block120;
                }
                case 10: {
                    this.setGravity(a.getInt(attr3, -1));
                    continue block120;
                }
                case 19: {
                    hint = a.getText(attr3);
                    continue block120;
                }
                case 18: {
                    text = a.getText(attr3);
                    continue block120;
                }
                case 30: {
                    if (!a.getBoolean(attr3, false)) continue block120;
                    this.setHorizontallyScrolling(true);
                    continue block120;
                }
                case 32: {
                    singleLine = a.getBoolean(attr3, singleLine);
                    continue block120;
                }
                case 9: {
                    ellipsize = a.getInt(attr3, ellipsize);
                    continue block120;
                }
                case 55: {
                    this.setMarqueeRepeatLimit(a.getInt(attr3, this.mMarqueeRepeatLimit));
                    continue block120;
                }
                case 34: {
                    if (a.getBoolean(attr3, true)) continue block120;
                    this.setIncludeFontPadding(false);
                    continue block120;
                }
                case 21: {
                    if (a.getBoolean(attr3, true)) continue block120;
                    this.setCursorVisible(false);
                    continue block120;
                }
                case 35: {
                    maxlength = a.getInt(attr3, -1);
                    continue block120;
                }
                case 20: {
                    this.setTextScaleX(a.getFloat(attr3, 1.0f));
                    continue block120;
                }
                case 47: {
                    this.mFreezesText = a.getBoolean(attr3, false);
                    continue block120;
                }
                case 36: {
                    shadowcolor = a.getInt(attr3, 0);
                    continue block120;
                }
                case 37: {
                    dx = a.getFloat(attr3, 0.0f);
                    continue block120;
                }
                case 38: {
                    dy = a.getFloat(attr3, 0.0f);
                    continue block120;
                }
                case 39: {
                    r = a.getFloat(attr3, 0.0f);
                    continue block120;
                }
                case 0: {
                    this.setEnabled(a.getBoolean(attr3, this.isEnabled()));
                    continue block120;
                }
                case 6: {
                    textColorHighlight = a.getColor(attr3, textColorHighlight);
                    continue block120;
                }
                case 5: {
                    textColor = a.getColorStateList(attr3);
                    continue block120;
                }
                case 7: {
                    textColorHint = a.getColorStateList(attr3);
                    continue block120;
                }
                case 8: {
                    textColorLink = a.getColorStateList(attr3);
                    continue block120;
                }
                case 2: {
                    textSize = a.getDimensionPixelSize(attr3, textSize);
                    continue block120;
                }
                case 3: {
                    typefaceIndex = a.getInt(attr3, typefaceIndex);
                    continue block120;
                }
                case 4: {
                    styleIndex = a.getInt(attr3, styleIndex);
                    continue block120;
                }
                case 75: {
                    fontFamily = a.getString(attr3);
                    continue block120;
                }
                case 31: {
                    password = a.getBoolean(attr3, password);
                    continue block120;
                }
                case 53: {
                    this.mSpacingAdd = a.getDimensionPixelSize(attr3, (int)this.mSpacingAdd);
                    continue block120;
                }
                case 54: {
                    this.mSpacingMult = a.getFloat(attr3, this.mSpacingMult);
                    continue block120;
                }
                case 56: {
                    inputType = a.getInt(attr3, 0);
                    continue block120;
                }
                case 59: {
                    this.createEditorIfNeeded();
                    this.mEditor.createInputContentTypeIfNeeded();
                    this.mEditor.mInputContentType.imeOptions = a.getInt(attr3, this.mEditor.mInputContentType.imeOptions);
                    continue block120;
                }
                case 60: {
                    this.createEditorIfNeeded();
                    this.mEditor.createInputContentTypeIfNeeded();
                    this.mEditor.mInputContentType.imeActionLabel = a.getText(attr3);
                    continue block120;
                }
                case 61: {
                    this.createEditorIfNeeded();
                    this.mEditor.createInputContentTypeIfNeeded();
                    this.mEditor.mInputContentType.imeActionId = a.getInt(attr3, this.mEditor.mInputContentType.imeActionId);
                    continue block120;
                }
                case 57: {
                    this.setPrivateImeOptions(a.getString(attr3));
                    continue block120;
                }
                case 58: {
                    try {
                        this.setInputExtras(a.getResourceId(attr3, 0));
                    }
                    catch (XmlPullParserException e) {
                        Log.w(LOG_TAG, "Failure reading input extras", e);
                    }
                    catch (IOException e) {
                        Log.w(LOG_TAG, "Failure reading input extras", e);
                    }
                    continue block120;
                }
                case 70: {
                    this.mCursorDrawableRes = a.getResourceId(attr3, 0);
                    continue block120;
                }
                case 62: {
                    this.mTextSelectHandleLeftRes = a.getResourceId(attr3, 0);
                    continue block120;
                }
                case 63: {
                    this.mTextSelectHandleRightRes = a.getResourceId(attr3, 0);
                    continue block120;
                }
                case 64: {
                    this.mTextSelectHandleRes = a.getResourceId(attr3, 0);
                    continue block120;
                }
                case 71: {
                    this.mTextEditSuggestionItemLayout = a.getResourceId(attr3, 0);
                    continue block120;
                }
                case 67: {
                    this.setTextIsSelectable(a.getBoolean(attr3, false));
                    continue block120;
                }
                case 72: {
                    allCaps = a.getBoolean(attr3, false);
                }
            }
        }
        a.recycle();
        BufferType bufferType = BufferType.EDITABLE;
        int variation = inputType & 0xFFF;
        boolean passwordInputType = variation == 129;
        boolean webPasswordInputType = variation == 225;
        boolean bl = numberPasswordInputType = variation == 18;
        if (inputMethod != null) {
            Class<?> c;
            try {
                c = Class.forName(((Object)inputMethod).toString());
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            try {
                this.createEditorIfNeeded();
                this.mEditor.mKeyListener = (KeyListener)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            try {
                this.mEditor.mInputType = inputType != 0 ? inputType : this.mEditor.mKeyListener.getInputType();
            }
            catch (IncompatibleClassChangeError e) {
                this.mEditor.mInputType = 1;
            }
        } else if (digits != null) {
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = DigitsKeyListener.getInstance(((Object)digits).toString());
            this.mEditor.mInputType = inputType != 0 ? inputType : 1;
        } else if (inputType != 0) {
            this.setInputType(inputType, true);
            singleLine = !TextView.isMultilineInputType(inputType);
        } else if (phone) {
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = DialerKeyListener.getInstance();
            inputType = 3;
            this.mEditor.mInputType = 3;
        } else if (numeric != 0) {
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = DigitsKeyListener.getInstance((numeric & 2) != 0, (numeric & 4) != 0);
            inputType = 2;
            if ((numeric & 2) != 0) {
                inputType |= 0x1000;
            }
            if ((numeric & 4) != 0) {
                inputType |= 0x2000;
            }
            this.mEditor.mInputType = inputType;
        } else if (autotext || autocap != -1) {
            TextKeyListener.Capitalize cap;
            inputType = 1;
            switch (autocap) {
                case 1: {
                    cap = TextKeyListener.Capitalize.SENTENCES;
                    inputType |= 0x4000;
                    break;
                }
                case 2: {
                    cap = TextKeyListener.Capitalize.WORDS;
                    inputType |= 0x2000;
                    break;
                }
                case 3: {
                    cap = TextKeyListener.Capitalize.CHARACTERS;
                    inputType |= 0x1000;
                    break;
                }
                default: {
                    cap = TextKeyListener.Capitalize.NONE;
                }
            }
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = TextKeyListener.getInstance(autotext, cap);
            this.mEditor.mInputType = inputType;
        } else if (this.isTextSelectable()) {
            if (this.mEditor != null) {
                this.mEditor.mKeyListener = null;
                this.mEditor.mInputType = 0;
            }
            bufferType = BufferType.SPANNABLE;
            this.setMovementMethod(ArrowKeyMovementMethod.getInstance());
        } else if (editable) {
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = TextKeyListener.getInstance();
            this.mEditor.mInputType = 1;
        } else {
            if (this.mEditor != null) {
                this.mEditor.mKeyListener = null;
            }
            switch (buffertype) {
                case 0: {
                    bufferType = BufferType.NORMAL;
                    break;
                }
                case 1: {
                    bufferType = BufferType.SPANNABLE;
                    break;
                }
                case 2: {
                    bufferType = BufferType.EDITABLE;
                }
            }
        }
        if (this.mEditor != null) {
            this.mEditor.adjustInputType(password, passwordInputType, webPasswordInputType, numberPasswordInputType);
        }
        if (selectallonfocus) {
            this.createEditorIfNeeded();
            this.mEditor.mSelectAllOnFocus = true;
            if (bufferType == BufferType.NORMAL) {
                bufferType = BufferType.SPANNABLE;
            }
        }
        this.setCompoundDrawablesWithIntrinsicBounds(drawableLeft, drawableTop, drawableRight, drawableBottom);
        this.setRelativeDrawablesIfNeeded(drawableStart, drawableEnd);
        this.setCompoundDrawablePadding(drawablePadding);
        this.setInputTypeSingleLine(singleLine);
        this.applySingleLine(singleLine, singleLine, singleLine);
        if (singleLine && this.getKeyListener() == null && ellipsize < 0) {
            ellipsize = 3;
        }
        switch (ellipsize) {
            case 1: {
                this.setEllipsize(TextUtils.TruncateAt.START);
                break;
            }
            case 2: {
                this.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                break;
            }
            case 3: {
                this.setEllipsize(TextUtils.TruncateAt.END);
                break;
            }
            case 4: {
                if (ViewConfiguration.get(context).isFadingMarqueeEnabled()) {
                    this.setHorizontalFadingEdgeEnabled(true);
                    this.mMarqueeFadeMode = 0;
                } else {
                    this.setHorizontalFadingEdgeEnabled(false);
                    this.mMarqueeFadeMode = 1;
                }
                this.setEllipsize(TextUtils.TruncateAt.MARQUEE);
            }
        }
        this.setTextColor(textColor != null ? textColor : ColorStateList.valueOf(-16777216));
        this.setHintTextColor(textColorHint);
        this.setLinkTextColor(textColorLink);
        if (textColorHighlight != 0) {
            this.setHighlightColor(textColorHighlight);
        }
        this.setRawTextSize(textSize);
        if (allCaps) {
            this.setTransformationMethod(new AllCapsTransformationMethod(this.getContext()));
        }
        if (password || passwordInputType || webPasswordInputType || numberPasswordInputType) {
            this.setTransformationMethod(PasswordTransformationMethod.getInstance());
            typefaceIndex = 3;
        } else if (this.mEditor != null && (this.mEditor.mInputType & 0xFFF) == 129) {
            typefaceIndex = 3;
        }
        this.setTypefaceFromAttrs(fontFamily, typefaceIndex, styleIndex);
        if (shadowcolor != 0) {
            this.setShadowLayer(r, dx, dy, shadowcolor);
        }
        if (maxlength >= 0) {
            this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxlength)});
        } else {
            this.setFilters(NO_FILTERS);
        }
        this.setText(text, bufferType);
        if (hint != null) {
            this.setHint(hint);
        }
        a = context.obtainStyledAttributes(attrs, R.styleable.View, defStyle, 0);
        boolean clickable = focusable = this.mMovement != null || this.getKeyListener() != null;
        boolean longClickable = focusable;
        n = a.getIndexCount();
        block121: for (int i = 0; i < n; ++i) {
            int attr4 = a.getIndex(i);
            switch (attr4) {
                case 18: {
                    focusable = a.getBoolean(attr4, focusable);
                    continue block121;
                }
                case 29: {
                    clickable = a.getBoolean(attr4, clickable);
                    continue block121;
                }
                case 30: {
                    longClickable = a.getBoolean(attr4, longClickable);
                }
            }
        }
        a.recycle();
        this.setFocusable(focusable);
        this.setClickable(clickable);
        this.setLongClickable(longClickable);
        if (this.mEditor != null) {
            this.mEditor.prepareCursorControllers();
        }
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
    }

    private void setTypefaceFromAttrs(String familyName, int typefaceIndex, int styleIndex) {
        Typeface tf = null;
        if (familyName != null && (tf = Typeface.create(familyName, styleIndex)) != null) {
            this.setTypeface(tf);
            return;
        }
        switch (typefaceIndex) {
            case 1: {
                tf = Typeface.SANS_SERIF;
                break;
            }
            case 2: {
                tf = Typeface.SERIF;
                break;
            }
            case 3: {
                tf = Typeface.MONOSPACE;
            }
        }
        this.setTypeface(tf, styleIndex);
    }

    private void setRelativeDrawablesIfNeeded(Drawable start, Drawable end) {
        boolean hasRelativeDrawables;
        boolean bl = hasRelativeDrawables = start != null || end != null;
        if (hasRelativeDrawables) {
            Drawables dr = this.mDrawables;
            if (dr == null) {
                this.mDrawables = dr = new Drawables(this.getContext());
            }
            this.mDrawables.mOverride = true;
            Rect compoundRect = dr.mCompoundRect;
            int[] state = this.getDrawableState();
            if (start != null) {
                start.setBounds(0, 0, start.getIntrinsicWidth(), start.getIntrinsicHeight());
                start.setState(state);
                start.copyBounds(compoundRect);
                start.setCallback(this);
                dr.mDrawableStart = start;
                dr.mDrawableSizeStart = compoundRect.width();
                dr.mDrawableHeightStart = compoundRect.height();
            } else {
                dr.mDrawableHeightStart = 0;
                dr.mDrawableSizeStart = 0;
            }
            if (end != null) {
                end.setBounds(0, 0, end.getIntrinsicWidth(), end.getIntrinsicHeight());
                end.setState(state);
                end.copyBounds(compoundRect);
                end.setCallback(this);
                dr.mDrawableEnd = end;
                dr.mDrawableSizeEnd = compoundRect.width();
                dr.mDrawableHeightEnd = compoundRect.height();
            } else {
                dr.mDrawableHeightEnd = 0;
                dr.mDrawableSizeEnd = 0;
            }
            this.resetResolvedDrawables();
            this.resolveDrawables();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        InputMethodManager imm;
        if (enabled == this.isEnabled()) {
            return;
        }
        if (!enabled && (imm = InputMethodManager.peekInstance()) != null && imm.isActive(this)) {
            imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
        super.setEnabled(enabled);
        if (enabled && (imm = InputMethodManager.peekInstance()) != null) {
            imm.restartInput(this);
        }
        if (this.mEditor != null) {
            this.mEditor.invalidateTextDisplayList();
            this.mEditor.prepareCursorControllers();
            this.mEditor.makeBlink();
        }
    }

    public void setTypeface(Typeface tf, int style2) {
        if (style2 > 0) {
            tf = tf == null ? Typeface.defaultFromStyle(style2) : Typeface.create(tf, style2);
            this.setTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = style2 & ~typefaceStyle;
            this.mTextPaint.setFakeBoldText((need & 1) != 0);
            this.mTextPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mTextPaint.setFakeBoldText(false);
            this.mTextPaint.setTextSkewX(0.0f);
            this.setTypeface(tf);
        }
    }

    protected boolean getDefaultEditable() {
        return false;
    }

    protected MovementMethod getDefaultMovementMethod() {
        return null;
    }

    @ViewDebug.CapturedViewProperty
    public CharSequence getText() {
        return this.mText;
    }

    public int length() {
        return this.mText.length();
    }

    public Editable getEditableText() {
        return this.mText instanceof Editable ? (Editable)this.mText : null;
    }

    public int getLineHeight() {
        return FastMath.round((float)this.mTextPaint.getFontMetricsInt(null) * this.mSpacingMult + this.mSpacingAdd);
    }

    public final Layout getLayout() {
        return this.mLayout;
    }

    final Layout getHintLayout() {
        return this.mHintLayout;
    }

    public final UndoManager getUndoManager() {
        return this.mEditor == null ? null : this.mEditor.mUndoManager;
    }

    public final void setUndoManager(UndoManager undoManager, String tag) {
        if (undoManager != null) {
            this.createEditorIfNeeded();
            this.mEditor.mUndoManager = undoManager;
            this.mEditor.mUndoOwner = undoManager.getOwner(tag, this);
            this.mEditor.mUndoInputFilter = new Editor.UndoInputFilter(this.mEditor);
            if (!(this.mText instanceof Editable)) {
                this.setText(this.mText, BufferType.EDITABLE);
            }
            this.setFilters((Editable)this.mText, this.mFilters);
        } else if (this.mEditor != null) {
            this.mEditor.mUndoManager = null;
            this.mEditor.mUndoOwner = null;
            this.mEditor.mUndoInputFilter = null;
        }
    }

    public final KeyListener getKeyListener() {
        return this.mEditor == null ? null : this.mEditor.mKeyListener;
    }

    public void setKeyListener(KeyListener input) {
        this.setKeyListenerOnly(input);
        this.fixFocusableAndClickableSettings();
        if (input != null) {
            this.createEditorIfNeeded();
            try {
                this.mEditor.mInputType = this.mEditor.mKeyListener.getInputType();
            }
            catch (IncompatibleClassChangeError e) {
                this.mEditor.mInputType = 1;
            }
            this.setInputTypeSingleLine(this.mSingleLine);
        } else if (this.mEditor != null) {
            this.mEditor.mInputType = 0;
        }
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (imm != null) {
            imm.restartInput(this);
        }
    }

    private void setKeyListenerOnly(KeyListener input) {
        if (this.mEditor == null && input == null) {
            return;
        }
        this.createEditorIfNeeded();
        if (this.mEditor.mKeyListener != input) {
            this.mEditor.mKeyListener = input;
            if (input != null && !(this.mText instanceof Editable)) {
                this.setText(this.mText);
            }
            this.setFilters((Editable)this.mText, this.mFilters);
        }
    }

    public final MovementMethod getMovementMethod() {
        return this.mMovement;
    }

    public final void setMovementMethod(MovementMethod movement) {
        if (this.mMovement != movement) {
            this.mMovement = movement;
            if (movement != null && !(this.mText instanceof Spannable)) {
                this.setText(this.mText);
            }
            this.fixFocusableAndClickableSettings();
            if (this.mEditor != null) {
                this.mEditor.prepareCursorControllers();
            }
        }
    }

    private void fixFocusableAndClickableSettings() {
        if (this.mMovement != null || this.mEditor != null && this.mEditor.mKeyListener != null) {
            this.setFocusable(true);
            this.setClickable(true);
            this.setLongClickable(true);
        } else {
            this.setFocusable(false);
            this.setClickable(false);
            this.setLongClickable(false);
        }
    }

    public final TransformationMethod getTransformationMethod() {
        return this.mTransformation;
    }

    public final void setTransformationMethod(TransformationMethod method) {
        if (method == this.mTransformation) {
            return;
        }
        if (this.mTransformation != null && this.mText instanceof Spannable) {
            ((Spannable)this.mText).removeSpan(this.mTransformation);
        }
        this.mTransformation = method;
        if (method instanceof TransformationMethod2) {
            TransformationMethod2 method2 = (TransformationMethod2)method;
            this.mAllowTransformationLengthChange = !this.isTextSelectable() && !(this.mText instanceof Editable);
            method2.setLengthChangesAllowed(this.mAllowTransformationLengthChange);
        } else {
            this.mAllowTransformationLengthChange = false;
        }
        this.setText(this.mText);
        if (this.hasPasswordTransformationMethod()) {
            this.notifyViewAccessibilityStateChangedIfNeeded(0);
        }
    }

    public int getCompoundPaddingTop() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mDrawableTop == null) {
            return this.mPaddingTop;
        }
        return this.mPaddingTop + dr.mDrawablePadding + dr.mDrawableSizeTop;
    }

    public int getCompoundPaddingBottom() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mDrawableBottom == null) {
            return this.mPaddingBottom;
        }
        return this.mPaddingBottom + dr.mDrawablePadding + dr.mDrawableSizeBottom;
    }

    public int getCompoundPaddingLeft() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mDrawableLeft == null) {
            return this.mPaddingLeft;
        }
        return this.mPaddingLeft + dr.mDrawablePadding + dr.mDrawableSizeLeft;
    }

    public int getCompoundPaddingRight() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mDrawableRight == null) {
            return this.mPaddingRight;
        }
        return this.mPaddingRight + dr.mDrawablePadding + dr.mDrawableSizeRight;
    }

    public int getCompoundPaddingStart() {
        this.resolveDrawables();
        switch (this.getLayoutDirection()) {
            default: {
                return this.getCompoundPaddingLeft();
            }
            case 1: 
        }
        return this.getCompoundPaddingRight();
    }

    public int getCompoundPaddingEnd() {
        this.resolveDrawables();
        switch (this.getLayoutDirection()) {
            default: {
                return this.getCompoundPaddingRight();
            }
            case 1: 
        }
        return this.getCompoundPaddingLeft();
    }

    public int getExtendedPaddingTop() {
        if (this.mMaxMode != 1) {
            return this.getCompoundPaddingTop();
        }
        if (this.mLayout.getLineCount() <= this.mMaximum) {
            return this.getCompoundPaddingTop();
        }
        int top = this.getCompoundPaddingTop();
        int bottom = this.getCompoundPaddingBottom();
        int viewht = this.getHeight() - top - bottom;
        int layoutht = this.mLayout.getLineTop(this.mMaximum);
        if (layoutht >= viewht) {
            return top;
        }
        int gravity = this.mGravity & 0x70;
        if (gravity == 48) {
            return top;
        }
        if (gravity == 80) {
            return top + viewht - layoutht;
        }
        return top + (viewht - layoutht) / 2;
    }

    public int getExtendedPaddingBottom() {
        if (this.mMaxMode != 1) {
            return this.getCompoundPaddingBottom();
        }
        if (this.mLayout.getLineCount() <= this.mMaximum) {
            return this.getCompoundPaddingBottom();
        }
        int top = this.getCompoundPaddingTop();
        int bottom = this.getCompoundPaddingBottom();
        int viewht = this.getHeight() - top - bottom;
        int layoutht = this.mLayout.getLineTop(this.mMaximum);
        if (layoutht >= viewht) {
            return bottom;
        }
        int gravity = this.mGravity & 0x70;
        if (gravity == 48) {
            return bottom + viewht - layoutht;
        }
        if (gravity == 80) {
            return bottom;
        }
        return bottom + (viewht - layoutht) / 2;
    }

    public int getTotalPaddingLeft() {
        return this.getCompoundPaddingLeft();
    }

    public int getTotalPaddingRight() {
        return this.getCompoundPaddingRight();
    }

    public int getTotalPaddingStart() {
        return this.getCompoundPaddingStart();
    }

    public int getTotalPaddingEnd() {
        return this.getCompoundPaddingEnd();
    }

    public int getTotalPaddingTop() {
        return this.getExtendedPaddingTop() + this.getVerticalOffset(true);
    }

    public int getTotalPaddingBottom() {
        return this.getExtendedPaddingBottom() + this.getBottomVerticalOffset(true);
    }

    public void setCompoundDrawables(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        boolean drawables;
        Drawables dr = this.mDrawables;
        boolean bl = drawables = left != null || top != null || right != null || bottom != null;
        if (!drawables) {
            if (dr != null) {
                if (dr.mDrawablePadding == 0) {
                    this.mDrawables = null;
                } else {
                    if (dr.mDrawableLeft != null) {
                        dr.mDrawableLeft.setCallback(null);
                    }
                    dr.mDrawableLeft = null;
                    if (dr.mDrawableTop != null) {
                        dr.mDrawableTop.setCallback(null);
                    }
                    dr.mDrawableTop = null;
                    if (dr.mDrawableRight != null) {
                        dr.mDrawableRight.setCallback(null);
                    }
                    dr.mDrawableRight = null;
                    if (dr.mDrawableBottom != null) {
                        dr.mDrawableBottom.setCallback(null);
                    }
                    dr.mDrawableBottom = null;
                    dr.mDrawableHeightLeft = 0;
                    dr.mDrawableSizeLeft = 0;
                    dr.mDrawableHeightRight = 0;
                    dr.mDrawableSizeRight = 0;
                    dr.mDrawableWidthTop = 0;
                    dr.mDrawableSizeTop = 0;
                    dr.mDrawableWidthBottom = 0;
                    dr.mDrawableSizeBottom = 0;
                }
            }
        } else {
            if (dr == null) {
                this.mDrawables = dr = new Drawables(this.getContext());
            }
            this.mDrawables.mOverride = false;
            if (dr.mDrawableLeft != left && dr.mDrawableLeft != null) {
                dr.mDrawableLeft.setCallback(null);
            }
            dr.mDrawableLeft = left;
            if (dr.mDrawableTop != top && dr.mDrawableTop != null) {
                dr.mDrawableTop.setCallback(null);
            }
            dr.mDrawableTop = top;
            if (dr.mDrawableRight != right && dr.mDrawableRight != null) {
                dr.mDrawableRight.setCallback(null);
            }
            dr.mDrawableRight = right;
            if (dr.mDrawableBottom != bottom && dr.mDrawableBottom != null) {
                dr.mDrawableBottom.setCallback(null);
            }
            dr.mDrawableBottom = bottom;
            Rect compoundRect = dr.mCompoundRect;
            int[] state = this.getDrawableState();
            if (left != null) {
                left.setState(state);
                left.copyBounds(compoundRect);
                left.setCallback(this);
                dr.mDrawableSizeLeft = compoundRect.width();
                dr.mDrawableHeightLeft = compoundRect.height();
            } else {
                dr.mDrawableHeightLeft = 0;
                dr.mDrawableSizeLeft = 0;
            }
            if (right != null) {
                right.setState(state);
                right.copyBounds(compoundRect);
                right.setCallback(this);
                dr.mDrawableSizeRight = compoundRect.width();
                dr.mDrawableHeightRight = compoundRect.height();
            } else {
                dr.mDrawableHeightRight = 0;
                dr.mDrawableSizeRight = 0;
            }
            if (top != null) {
                top.setState(state);
                top.copyBounds(compoundRect);
                top.setCallback(this);
                dr.mDrawableSizeTop = compoundRect.height();
                dr.mDrawableWidthTop = compoundRect.width();
            } else {
                dr.mDrawableWidthTop = 0;
                dr.mDrawableSizeTop = 0;
            }
            if (bottom != null) {
                bottom.setState(state);
                bottom.copyBounds(compoundRect);
                bottom.setCallback(this);
                dr.mDrawableSizeBottom = compoundRect.height();
                dr.mDrawableWidthBottom = compoundRect.width();
            } else {
                dr.mDrawableWidthBottom = 0;
                dr.mDrawableSizeBottom = 0;
            }
        }
        if (dr != null) {
            dr.mDrawableLeftInitial = left;
            dr.mDrawableRightInitial = right;
        }
        this.resetResolvedDrawables();
        this.resolveDrawables();
        this.invalidate();
        this.requestLayout();
    }

    @RemotableViewMethod
    public void setCompoundDrawablesWithIntrinsicBounds(int left, int top, int right, int bottom) {
        Resources resources = this.getContext().getResources();
        this.setCompoundDrawablesWithIntrinsicBounds(left != 0 ? resources.getDrawable(left) : null, top != 0 ? resources.getDrawable(top) : null, right != 0 ? resources.getDrawable(right) : null, bottom != 0 ? resources.getDrawable(bottom) : null);
    }

    public void setCompoundDrawablesWithIntrinsicBounds(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        if (left != null) {
            left.setBounds(0, 0, left.getIntrinsicWidth(), left.getIntrinsicHeight());
        }
        if (right != null) {
            right.setBounds(0, 0, right.getIntrinsicWidth(), right.getIntrinsicHeight());
        }
        if (top != null) {
            top.setBounds(0, 0, top.getIntrinsicWidth(), top.getIntrinsicHeight());
        }
        if (bottom != null) {
            bottom.setBounds(0, 0, bottom.getIntrinsicWidth(), bottom.getIntrinsicHeight());
        }
        this.setCompoundDrawables(left, top, right, bottom);
    }

    public void setCompoundDrawablesRelative(Drawable start, Drawable top, Drawable end, Drawable bottom) {
        boolean drawables;
        Drawables dr = this.mDrawables;
        boolean bl = drawables = start != null || top != null || end != null || bottom != null;
        if (!drawables) {
            if (dr != null) {
                if (dr.mDrawablePadding == 0) {
                    this.mDrawables = null;
                } else {
                    if (dr.mDrawableStart != null) {
                        dr.mDrawableStart.setCallback(null);
                    }
                    dr.mDrawableStart = null;
                    if (dr.mDrawableTop != null) {
                        dr.mDrawableTop.setCallback(null);
                    }
                    dr.mDrawableTop = null;
                    if (dr.mDrawableEnd != null) {
                        dr.mDrawableEnd.setCallback(null);
                    }
                    dr.mDrawableEnd = null;
                    if (dr.mDrawableBottom != null) {
                        dr.mDrawableBottom.setCallback(null);
                    }
                    dr.mDrawableBottom = null;
                    dr.mDrawableHeightStart = 0;
                    dr.mDrawableSizeStart = 0;
                    dr.mDrawableHeightEnd = 0;
                    dr.mDrawableSizeEnd = 0;
                    dr.mDrawableWidthTop = 0;
                    dr.mDrawableSizeTop = 0;
                    dr.mDrawableWidthBottom = 0;
                    dr.mDrawableSizeBottom = 0;
                }
            }
        } else {
            if (dr == null) {
                this.mDrawables = dr = new Drawables(this.getContext());
            }
            this.mDrawables.mOverride = true;
            if (dr.mDrawableStart != start && dr.mDrawableStart != null) {
                dr.mDrawableStart.setCallback(null);
            }
            dr.mDrawableStart = start;
            if (dr.mDrawableTop != top && dr.mDrawableTop != null) {
                dr.mDrawableTop.setCallback(null);
            }
            dr.mDrawableTop = top;
            if (dr.mDrawableEnd != end && dr.mDrawableEnd != null) {
                dr.mDrawableEnd.setCallback(null);
            }
            dr.mDrawableEnd = end;
            if (dr.mDrawableBottom != bottom && dr.mDrawableBottom != null) {
                dr.mDrawableBottom.setCallback(null);
            }
            dr.mDrawableBottom = bottom;
            Rect compoundRect = dr.mCompoundRect;
            int[] state = this.getDrawableState();
            if (start != null) {
                start.setState(state);
                start.copyBounds(compoundRect);
                start.setCallback(this);
                dr.mDrawableSizeStart = compoundRect.width();
                dr.mDrawableHeightStart = compoundRect.height();
            } else {
                dr.mDrawableHeightStart = 0;
                dr.mDrawableSizeStart = 0;
            }
            if (end != null) {
                end.setState(state);
                end.copyBounds(compoundRect);
                end.setCallback(this);
                dr.mDrawableSizeEnd = compoundRect.width();
                dr.mDrawableHeightEnd = compoundRect.height();
            } else {
                dr.mDrawableHeightEnd = 0;
                dr.mDrawableSizeEnd = 0;
            }
            if (top != null) {
                top.setState(state);
                top.copyBounds(compoundRect);
                top.setCallback(this);
                dr.mDrawableSizeTop = compoundRect.height();
                dr.mDrawableWidthTop = compoundRect.width();
            } else {
                dr.mDrawableWidthTop = 0;
                dr.mDrawableSizeTop = 0;
            }
            if (bottom != null) {
                bottom.setState(state);
                bottom.copyBounds(compoundRect);
                bottom.setCallback(this);
                dr.mDrawableSizeBottom = compoundRect.height();
                dr.mDrawableWidthBottom = compoundRect.width();
            } else {
                dr.mDrawableWidthBottom = 0;
                dr.mDrawableSizeBottom = 0;
            }
        }
        this.resetResolvedDrawables();
        this.resolveDrawables();
        this.invalidate();
        this.requestLayout();
    }

    @RemotableViewMethod
    public void setCompoundDrawablesRelativeWithIntrinsicBounds(int start, int top, int end, int bottom) {
        Resources resources = this.getContext().getResources();
        this.setCompoundDrawablesRelativeWithIntrinsicBounds(start != 0 ? resources.getDrawable(start) : null, top != 0 ? resources.getDrawable(top) : null, end != 0 ? resources.getDrawable(end) : null, bottom != 0 ? resources.getDrawable(bottom) : null);
    }

    public void setCompoundDrawablesRelativeWithIntrinsicBounds(Drawable start, Drawable top, Drawable end, Drawable bottom) {
        if (start != null) {
            start.setBounds(0, 0, start.getIntrinsicWidth(), start.getIntrinsicHeight());
        }
        if (end != null) {
            end.setBounds(0, 0, end.getIntrinsicWidth(), end.getIntrinsicHeight());
        }
        if (top != null) {
            top.setBounds(0, 0, top.getIntrinsicWidth(), top.getIntrinsicHeight());
        }
        if (bottom != null) {
            bottom.setBounds(0, 0, bottom.getIntrinsicWidth(), bottom.getIntrinsicHeight());
        }
        this.setCompoundDrawablesRelative(start, top, end, bottom);
    }

    public Drawable[] getCompoundDrawables() {
        Drawables dr = this.mDrawables;
        if (dr != null) {
            return new Drawable[]{dr.mDrawableLeft, dr.mDrawableTop, dr.mDrawableRight, dr.mDrawableBottom};
        }
        return new Drawable[]{null, null, null, null};
    }

    public Drawable[] getCompoundDrawablesRelative() {
        Drawables dr = this.mDrawables;
        if (dr != null) {
            return new Drawable[]{dr.mDrawableStart, dr.mDrawableTop, dr.mDrawableEnd, dr.mDrawableBottom};
        }
        return new Drawable[]{null, null, null, null};
    }

    @RemotableViewMethod
    public void setCompoundDrawablePadding(int pad) {
        Drawables dr = this.mDrawables;
        if (pad == 0) {
            if (dr != null) {
                dr.mDrawablePadding = pad;
            }
        } else {
            if (dr == null) {
                this.mDrawables = dr = new Drawables(this.getContext());
            }
            dr.mDrawablePadding = pad;
        }
        this.invalidate();
        this.requestLayout();
    }

    public int getCompoundDrawablePadding() {
        Drawables dr = this.mDrawables;
        return dr != null ? dr.mDrawablePadding : 0;
    }

    @Override
    public void setPadding(int left, int top, int right, int bottom) {
        if (left != this.mPaddingLeft || right != this.mPaddingRight || top != this.mPaddingTop || bottom != this.mPaddingBottom) {
            this.nullLayouts();
        }
        super.setPadding(left, top, right, bottom);
        this.invalidate();
    }

    @Override
    public void setPaddingRelative(int start, int top, int end, int bottom) {
        if (start != this.getPaddingStart() || end != this.getPaddingEnd() || top != this.mPaddingTop || bottom != this.mPaddingBottom) {
            this.nullLayouts();
        }
        super.setPaddingRelative(start, top, end, bottom);
        this.invalidate();
    }

    public final int getAutoLinkMask() {
        return this.mAutoLinkMask;
    }

    public void setTextAppearance(Context context, int resid) {
        int ts;
        ColorStateList colors;
        TypedArray appearance = context.obtainStyledAttributes(resid, R.styleable.TextAppearance);
        int color2 = appearance.getColor(4, 0);
        if (color2 != 0) {
            this.setHighlightColor(color2);
        }
        if ((colors = appearance.getColorStateList(3)) != null) {
            this.setTextColor(colors);
        }
        if ((ts = appearance.getDimensionPixelSize(0, 0)) != 0) {
            this.setRawTextSize(ts);
        }
        if ((colors = appearance.getColorStateList(5)) != null) {
            this.setHintTextColor(colors);
        }
        if ((colors = appearance.getColorStateList(6)) != null) {
            this.setLinkTextColor(colors);
        }
        String familyName = appearance.getString(12);
        int typefaceIndex = appearance.getInt(1, -1);
        int styleIndex = appearance.getInt(2, -1);
        this.setTypefaceFromAttrs(familyName, typefaceIndex, styleIndex);
        int shadowcolor = appearance.getInt(7, 0);
        if (shadowcolor != 0) {
            float dx = appearance.getFloat(8, 0.0f);
            float dy = appearance.getFloat(9, 0.0f);
            float r = appearance.getFloat(10, 0.0f);
            this.setShadowLayer(r, dx, dy, shadowcolor);
        }
        if (appearance.getBoolean(11, false)) {
            this.setTransformationMethod(new AllCapsTransformationMethod(this.getContext()));
        }
        appearance.recycle();
    }

    public Locale getTextLocale() {
        return this.mTextPaint.getTextLocale();
    }

    public void setTextLocale(Locale locale) {
        this.mTextPaint.setTextLocale(locale);
    }

    @ViewDebug.ExportedProperty(category="text")
    public float getTextSize() {
        return this.mTextPaint.getTextSize();
    }

    @RemotableViewMethod
    public void setTextSize(float size) {
        this.setTextSize(2, size);
    }

    public void setTextSize(int unit, float size) {
        Context c = this.getContext();
        Resources r = c == null ? Resources.getSystem() : c.getResources();
        this.setRawTextSize(TypedValue.applyDimension(unit, size, r.getDisplayMetrics()));
    }

    private void setRawTextSize(float size) {
        if (size != this.mTextPaint.getTextSize()) {
            this.mTextPaint.setTextSize(size);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public float getTextScaleX() {
        return this.mTextPaint.getTextScaleX();
    }

    @RemotableViewMethod
    public void setTextScaleX(float size) {
        if (size != this.mTextPaint.getTextScaleX()) {
            this.mUserSetTextScaleX = true;
            this.mTextPaint.setTextScaleX(size);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public void setTypeface(Typeface tf) {
        if (this.mTextPaint.getTypeface() != tf) {
            this.mTextPaint.setTypeface(tf);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public Typeface getTypeface() {
        return this.mTextPaint.getTypeface();
    }

    @RemotableViewMethod
    public void setTextColor(int color2) {
        this.mTextColor = ColorStateList.valueOf(color2);
        this.updateTextColors();
    }

    public void setTextColor(ColorStateList colors) {
        if (colors == null) {
            throw new NullPointerException();
        }
        this.mTextColor = colors;
        this.updateTextColors();
    }

    public final ColorStateList getTextColors() {
        return this.mTextColor;
    }

    public final int getCurrentTextColor() {
        return this.mCurTextColor;
    }

    @RemotableViewMethod
    public void setHighlightColor(int color2) {
        if (this.mHighlightColor != color2) {
            this.mHighlightColor = color2;
            this.invalidate();
        }
    }

    public int getHighlightColor() {
        return this.mHighlightColor;
    }

    @RemotableViewMethod
    public final void setShowSoftInputOnFocus(boolean show) {
        this.createEditorIfNeeded();
        this.mEditor.mShowSoftInputOnFocus = show;
    }

    public final boolean getShowSoftInputOnFocus() {
        return this.mEditor == null || this.mEditor.mShowSoftInputOnFocus;
    }

    public void setShadowLayer(float radius, float dx, float dy, int color2) {
        this.mTextPaint.setShadowLayer(radius, dx, dy, color2);
        this.mShadowRadius = radius;
        this.mShadowDx = dx;
        this.mShadowDy = dy;
        if (this.mEditor != null) {
            this.mEditor.invalidateTextDisplayList();
        }
        this.invalidate();
    }

    public float getShadowRadius() {
        return this.mShadowRadius;
    }

    public float getShadowDx() {
        return this.mShadowDx;
    }

    public float getShadowDy() {
        return this.mShadowDy;
    }

    public int getShadowColor() {
        return this.mTextPaint.shadowColor;
    }

    public TextPaint getPaint() {
        return this.mTextPaint;
    }

    @RemotableViewMethod
    public final void setAutoLinkMask(int mask) {
        this.mAutoLinkMask = mask;
    }

    @RemotableViewMethod
    public final void setLinksClickable(boolean whether) {
        this.mLinksClickable = whether;
    }

    public final boolean getLinksClickable() {
        return this.mLinksClickable;
    }

    public URLSpan[] getUrls() {
        if (this.mText instanceof Spanned) {
            return ((Spanned)this.mText).getSpans(0, this.mText.length(), URLSpan.class);
        }
        return new URLSpan[0];
    }

    @RemotableViewMethod
    public final void setHintTextColor(int color2) {
        this.mHintTextColor = ColorStateList.valueOf(color2);
        this.updateTextColors();
    }

    public final void setHintTextColor(ColorStateList colors) {
        this.mHintTextColor = colors;
        this.updateTextColors();
    }

    public final ColorStateList getHintTextColors() {
        return this.mHintTextColor;
    }

    public final int getCurrentHintTextColor() {
        return this.mHintTextColor != null ? this.mCurHintTextColor : this.mCurTextColor;
    }

    @RemotableViewMethod
    public final void setLinkTextColor(int color2) {
        this.mLinkTextColor = ColorStateList.valueOf(color2);
        this.updateTextColors();
    }

    public final void setLinkTextColor(ColorStateList colors) {
        this.mLinkTextColor = colors;
        this.updateTextColors();
    }

    public final ColorStateList getLinkTextColors() {
        return this.mLinkTextColor;
    }

    public void setGravity(int gravity) {
        if ((gravity & 0x800007) == 0) {
            gravity |= 0x800003;
        }
        if ((gravity & 0x70) == 0) {
            gravity |= 0x30;
        }
        boolean newLayout = false;
        if ((gravity & 0x800007) != (this.mGravity & 0x800007)) {
            newLayout = true;
        }
        if (gravity != this.mGravity) {
            this.invalidate();
        }
        this.mGravity = gravity;
        if (this.mLayout != null && newLayout) {
            int want = this.mLayout.getWidth();
            int hintWant = this.mHintLayout == null ? 0 : this.mHintLayout.getWidth();
            this.makeNewLayout(want, hintWant, UNKNOWN_BORING, UNKNOWN_BORING, this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), true);
        }
    }

    public int getGravity() {
        return this.mGravity;
    }

    public int getPaintFlags() {
        return this.mTextPaint.getFlags();
    }

    @RemotableViewMethod
    public void setPaintFlags(int flags) {
        if (this.mTextPaint.getFlags() != flags) {
            this.mTextPaint.setFlags(flags);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public void setHorizontallyScrolling(boolean whether) {
        if (this.mHorizontallyScrolling != whether) {
            this.mHorizontallyScrolling = whether;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public boolean getHorizontallyScrolling() {
        return this.mHorizontallyScrolling;
    }

    @RemotableViewMethod
    public void setMinLines(int minlines) {
        this.mMinimum = minlines;
        this.mMinMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    public int getMinLines() {
        return this.mMinMode == 1 ? this.mMinimum : -1;
    }

    @RemotableViewMethod
    public void setMinHeight(int minHeight) {
        this.mMinimum = minHeight;
        this.mMinMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    public int getMinHeight() {
        return this.mMinMode == 2 ? this.mMinimum : -1;
    }

    @RemotableViewMethod
    public void setMaxLines(int maxlines) {
        this.mMaximum = maxlines;
        this.mMaxMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    public int getMaxLines() {
        return this.mMaxMode == 1 ? this.mMaximum : -1;
    }

    @RemotableViewMethod
    public void setMaxHeight(int maxHeight) {
        this.mMaximum = maxHeight;
        this.mMaxMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    public int getMaxHeight() {
        return this.mMaxMode == 2 ? this.mMaximum : -1;
    }

    @RemotableViewMethod
    public void setLines(int lines) {
        this.mMaximum = this.mMinimum = lines;
        this.mMinMode = 1;
        this.mMaxMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setHeight(int pixels) {
        this.mMaximum = this.mMinimum = pixels;
        this.mMinMode = 2;
        this.mMaxMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMinEms(int minems) {
        this.mMinWidth = minems;
        this.mMinWidthMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    public int getMinEms() {
        return this.mMinWidthMode == 1 ? this.mMinWidth : -1;
    }

    @RemotableViewMethod
    public void setMinWidth(int minpixels) {
        this.mMinWidth = minpixels;
        this.mMinWidthMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    public int getMinWidth() {
        return this.mMinWidthMode == 2 ? this.mMinWidth : -1;
    }

    @RemotableViewMethod
    public void setMaxEms(int maxems) {
        this.mMaxWidth = maxems;
        this.mMaxWidthMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    public int getMaxEms() {
        return this.mMaxWidthMode == 1 ? this.mMaxWidth : -1;
    }

    @RemotableViewMethod
    public void setMaxWidth(int maxpixels) {
        this.mMaxWidth = maxpixels;
        this.mMaxWidthMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    public int getMaxWidth() {
        return this.mMaxWidthMode == 2 ? this.mMaxWidth : -1;
    }

    @RemotableViewMethod
    public void setEms(int ems) {
        this.mMaxWidth = this.mMinWidth = ems;
        this.mMinWidthMode = 1;
        this.mMaxWidthMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setWidth(int pixels) {
        this.mMaxWidth = this.mMinWidth = pixels;
        this.mMinWidthMode = 2;
        this.mMaxWidthMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    public void setLineSpacing(float add, float mult) {
        if (this.mSpacingAdd != add || this.mSpacingMult != mult) {
            this.mSpacingAdd = add;
            this.mSpacingMult = mult;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public float getLineSpacingMultiplier() {
        return this.mSpacingMult;
    }

    public float getLineSpacingExtra() {
        return this.mSpacingAdd;
    }

    public final void append(CharSequence text) {
        this.append(text, 0, text.length());
    }

    public void append(CharSequence text, int start, int end) {
        if (!(this.mText instanceof Editable)) {
            this.setText(this.mText, BufferType.EDITABLE);
        }
        ((Editable)this.mText).append(text, start, end);
    }

    private void updateTextColors() {
        boolean inval = false;
        int color2 = this.mTextColor.getColorForState(this.getDrawableState(), 0);
        if (color2 != this.mCurTextColor) {
            this.mCurTextColor = color2;
            inval = true;
        }
        if (this.mLinkTextColor != null && (color2 = this.mLinkTextColor.getColorForState(this.getDrawableState(), 0)) != this.mTextPaint.linkColor) {
            this.mTextPaint.linkColor = color2;
            inval = true;
        }
        if (this.mHintTextColor != null && (color2 = this.mHintTextColor.getColorForState(this.getDrawableState(), 0)) != this.mCurHintTextColor && this.mText.length() == 0) {
            this.mCurHintTextColor = color2;
            inval = true;
        }
        if (inval) {
            if (this.mEditor != null) {
                this.mEditor.invalidateTextDisplayList();
            }
            this.invalidate();
        }
    }

    @Override
    protected void drawableStateChanged() {
        Drawables dr;
        super.drawableStateChanged();
        if (this.mTextColor != null && this.mTextColor.isStateful() || this.mHintTextColor != null && this.mHintTextColor.isStateful() || this.mLinkTextColor != null && this.mLinkTextColor.isStateful()) {
            this.updateTextColors();
        }
        if ((dr = this.mDrawables) != null) {
            int[] state = this.getDrawableState();
            if (dr.mDrawableTop != null && dr.mDrawableTop.isStateful()) {
                dr.mDrawableTop.setState(state);
            }
            if (dr.mDrawableBottom != null && dr.mDrawableBottom.isStateful()) {
                dr.mDrawableBottom.setState(state);
            }
            if (dr.mDrawableLeft != null && dr.mDrawableLeft.isStateful()) {
                dr.mDrawableLeft.setState(state);
            }
            if (dr.mDrawableRight != null && dr.mDrawableRight.isStateful()) {
                dr.mDrawableRight.setState(state);
            }
            if (dr.mDrawableStart != null && dr.mDrawableStart.isStateful()) {
                dr.mDrawableStart.setState(state);
            }
            if (dr.mDrawableEnd != null && dr.mDrawableEnd.isStateful()) {
                dr.mDrawableEnd.setState(state);
            }
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        boolean save = this.mFreezesText;
        int start = 0;
        int end = 0;
        if (this.mText != null) {
            start = this.getSelectionStart();
            end = this.getSelectionEnd();
            if (start >= 0 || end >= 0) {
                save = true;
            }
        }
        if (save) {
            SavedState ss = new SavedState(superState);
            ss.selStart = start;
            ss.selEnd = end;
            if (this.mText instanceof Spanned) {
                SpannableString sp = new SpannableString(this.mText);
                for (ChangeWatcher cw : sp.getSpans(0, sp.length(), ChangeWatcher.class)) {
                    sp.removeSpan(cw);
                }
                if (this.mEditor != null) {
                    this.removeMisspelledSpans(sp);
                    sp.removeSpan(this.mEditor.mSuggestionRangeSpan);
                }
                ss.text = sp;
            } else {
                ss.text = ((Object)this.mText).toString();
            }
            if (this.isFocused() && start >= 0 && end >= 0) {
                ss.frozenWithFocus = true;
            }
            ss.error = this.getError();
            return ss;
        }
        return superState;
    }

    void removeMisspelledSpans(Spannable spannable) {
        SuggestionSpan[] suggestionSpans = spannable.getSpans(0, spannable.length(), SuggestionSpan.class);
        for (int i = 0; i < suggestionSpans.length; ++i) {
            int flags = suggestionSpans[i].getFlags();
            if ((flags & 1) == 0 || (flags & 2) == 0) continue;
            spannable.removeSpan(suggestionSpans[i]);
        }
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.text != null) {
            this.setText(ss.text);
        }
        if (ss.selStart >= 0 && ss.selEnd >= 0 && this.mText instanceof Spannable) {
            int len = this.mText.length();
            if (ss.selStart > len || ss.selEnd > len) {
                String restored = "";
                if (ss.text != null) {
                    restored = "(restored) ";
                }
                Log.e(LOG_TAG, "Saved cursor position " + ss.selStart + "/" + ss.selEnd + " out of range for " + restored + "text " + this.mText);
            } else {
                Selection.setSelection((Spannable)this.mText, ss.selStart, ss.selEnd);
                if (ss.frozenWithFocus) {
                    this.createEditorIfNeeded();
                    this.mEditor.mFrozenWithFocus = true;
                }
            }
        }
        if (ss.error != null) {
            final CharSequence error = ss.error;
            this.post(new Runnable(){

                public void run() {
                    TextView.this.setError(error);
                }
            });
        }
    }

    @RemotableViewMethod
    public void setFreezesText(boolean freezesText) {
        this.mFreezesText = freezesText;
    }

    public boolean getFreezesText() {
        return this.mFreezesText;
    }

    public final void setEditableFactory(Editable.Factory factory) {
        this.mEditableFactory = factory;
        this.setText(this.mText);
    }

    public final void setSpannableFactory(Spannable.Factory factory) {
        this.mSpannableFactory = factory;
        this.setText(this.mText);
    }

    @RemotableViewMethod
    public final void setText(CharSequence text) {
        this.setText(text, this.mBufferType);
    }

    @RemotableViewMethod
    public final void setTextKeepState(CharSequence text) {
        this.setTextKeepState(text, this.mBufferType);
    }

    public void setText(CharSequence text, BufferType type) {
        this.setText(text, type, true, 0);
        if (this.mCharWrapper != null) {
            CharWrapper.access$002(this.mCharWrapper, null);
        }
    }

    private void setText(CharSequence text, BufferType type, boolean notifyBefore, int oldlen) {
        Spannable s2;
        if (text == null) {
            text = "";
        }
        if (!this.isSuggestionsEnabled()) {
            text = this.removeSuggestionSpans(text);
        }
        if (!this.mUserSetTextScaleX) {
            this.mTextPaint.setTextScaleX(1.0f);
        }
        if (text instanceof Spanned && ((Spanned)text).getSpanStart((Object)TextUtils.TruncateAt.MARQUEE) >= 0) {
            if (ViewConfiguration.get(this.mContext).isFadingMarqueeEnabled()) {
                this.setHorizontalFadingEdgeEnabled(true);
                this.mMarqueeFadeMode = 0;
            } else {
                this.setHorizontalFadingEdgeEnabled(false);
                this.mMarqueeFadeMode = 1;
            }
            this.setEllipsize(TextUtils.TruncateAt.MARQUEE);
        }
        int n = this.mFilters.length;
        for (int i = 0; i < n; ++i) {
            CharSequence out = this.mFilters[i].filter(text, 0, text.length(), EMPTY_SPANNED, 0, 0);
            if (out == null) continue;
            text = out;
        }
        if (notifyBefore) {
            if (this.mText != null) {
                oldlen = this.mText.length();
                this.sendBeforeTextChanged(this.mText, 0, oldlen, text.length());
            } else {
                this.sendBeforeTextChanged("", 0, 0, text.length());
            }
        }
        boolean needEditableForNotification = false;
        if (this.mListeners != null && this.mListeners.size() != 0) {
            needEditableForNotification = true;
        }
        if (type == BufferType.EDITABLE || this.getKeyListener() != null || needEditableForNotification) {
            this.createEditorIfNeeded();
            Editable t = this.mEditableFactory.newEditable(text);
            text = t;
            this.setFilters(t, this.mFilters);
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (imm != null) {
                imm.restartInput(this);
            }
        } else if (type == BufferType.SPANNABLE || this.mMovement != null) {
            text = this.mSpannableFactory.newSpannable(text);
        } else if (!(text instanceof CharWrapper)) {
            text = TextUtils.stringOrSpannedString(text);
        }
        if (this.mAutoLinkMask != 0 && Linkify.addLinks(s2 = type == BufferType.EDITABLE || text instanceof Spannable ? (Spannable)text : this.mSpannableFactory.newSpannable(text), this.mAutoLinkMask)) {
            text = s2;
            type = type == BufferType.EDITABLE ? BufferType.EDITABLE : BufferType.SPANNABLE;
            this.mText = text;
            if (this.mLinksClickable && !this.textCanBeSelected()) {
                this.setMovementMethod(LinkMovementMethod.getInstance());
            }
        }
        this.mBufferType = type;
        this.mText = text;
        this.mTransformed = this.mTransformation == null ? text : this.mTransformation.getTransformation(text, this);
        int textLength = text.length();
        if (text instanceof Spannable && !this.mAllowTransformationLengthChange) {
            Spannable sp = (Spannable)text;
            ChangeWatcher[] watchers = sp.getSpans(0, sp.length(), ChangeWatcher.class);
            int count = watchers.length;
            for (int i = 0; i < count; ++i) {
                sp.removeSpan(watchers[i]);
            }
            if (this.mChangeWatcher == null) {
                this.mChangeWatcher = new ChangeWatcher();
            }
            sp.setSpan(this.mChangeWatcher, 0, textLength, 6553618);
            if (this.mEditor != null) {
                this.mEditor.addSpanWatchers(sp);
            }
            if (this.mTransformation != null) {
                sp.setSpan(this.mTransformation, 0, textLength, 18);
            }
            if (this.mMovement != null) {
                this.mMovement.initialize(this, (Spannable)text);
                if (this.mEditor != null) {
                    this.mEditor.mSelectionMoved = false;
                }
            }
        }
        if (this.mLayout != null) {
            this.checkForRelayout();
        }
        this.sendOnTextChanged(text, 0, oldlen, textLength);
        this.onTextChanged(text, 0, oldlen, textLength);
        this.notifyViewAccessibilityStateChangedIfNeeded(2);
        if (needEditableForNotification) {
            this.sendAfterTextChanged((Editable)text);
        }
        if (this.mEditor != null) {
            this.mEditor.prepareCursorControllers();
        }
    }

    public final void setText(char[] text, int start, int len) {
        int oldlen = 0;
        if (start < 0 || len < 0 || start + len > text.length) {
            throw new IndexOutOfBoundsException(start + ", " + len);
        }
        if (this.mText != null) {
            oldlen = this.mText.length();
            this.sendBeforeTextChanged(this.mText, 0, oldlen, len);
        } else {
            this.sendBeforeTextChanged("", 0, 0, len);
        }
        if (this.mCharWrapper == null) {
            this.mCharWrapper = new CharWrapper(text, start, len);
        } else {
            this.mCharWrapper.set(text, start, len);
        }
        this.setText(this.mCharWrapper, this.mBufferType, false, oldlen);
    }

    public final void setTextKeepState(CharSequence text, BufferType type) {
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        int len = text.length();
        this.setText(text, type);
        if ((start >= 0 || end >= 0) && this.mText instanceof Spannable) {
            Selection.setSelection((Spannable)this.mText, Math.max(0, Math.min(start, len)), Math.max(0, Math.min(end, len)));
        }
    }

    @RemotableViewMethod
    public final void setText(int resid) {
        this.setText(this.getContext().getResources().getText(resid));
    }

    public final void setText(int resid, BufferType type) {
        this.setText(this.getContext().getResources().getText(resid), type);
    }

    @RemotableViewMethod
    public final void setHint(CharSequence hint) {
        this.mHint = TextUtils.stringOrSpannedString(hint);
        if (this.mLayout != null) {
            this.checkForRelayout();
        }
        if (this.mText.length() == 0) {
            this.invalidate();
        }
        if (this.mEditor != null && this.mText.length() == 0 && this.mHint != null) {
            this.mEditor.invalidateTextDisplayList();
        }
    }

    @RemotableViewMethod
    public final void setHint(int resid) {
        this.setHint(this.getContext().getResources().getText(resid));
    }

    @ViewDebug.CapturedViewProperty
    public CharSequence getHint() {
        return this.mHint;
    }

    boolean isSingleLine() {
        return this.mSingleLine;
    }

    private static boolean isMultilineInputType(int type) {
        return (type & 0x2000F) == 131073;
    }

    CharSequence removeSuggestionSpans(CharSequence text) {
        if (text instanceof Spanned) {
            Spannable spannable;
            if (text instanceof Spannable) {
                spannable = (Spannable)text;
            } else {
                spannable = new SpannableString(text);
                text = spannable;
            }
            SuggestionSpan[] spans = spannable.getSpans(0, text.length(), SuggestionSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                spannable.removeSpan(spans[i]);
            }
        }
        return text;
    }

    public void setInputType(int type) {
        InputMethodManager imm;
        boolean singleLine;
        boolean wasPassword = TextView.isPasswordInputType(this.getInputType());
        boolean wasVisiblePassword = TextView.isVisiblePasswordInputType(this.getInputType());
        this.setInputType(type, false);
        boolean isPassword = TextView.isPasswordInputType(type);
        boolean isVisiblePassword = TextView.isVisiblePasswordInputType(type);
        boolean forceUpdate = false;
        if (isPassword) {
            this.setTransformationMethod(PasswordTransformationMethod.getInstance());
            this.setTypefaceFromAttrs(null, 3, 0);
        } else if (isVisiblePassword) {
            if (this.mTransformation == PasswordTransformationMethod.getInstance()) {
                forceUpdate = true;
            }
            this.setTypefaceFromAttrs(null, 3, 0);
        } else if (wasPassword || wasVisiblePassword) {
            this.setTypefaceFromAttrs(null, -1, -1);
            if (this.mTransformation == PasswordTransformationMethod.getInstance()) {
                forceUpdate = true;
            }
        }
        boolean bl = singleLine = !TextView.isMultilineInputType(type);
        if (this.mSingleLine != singleLine || forceUpdate) {
            this.applySingleLine(singleLine, !isPassword, true);
        }
        if (!this.isSuggestionsEnabled()) {
            this.mText = this.removeSuggestionSpans(this.mText);
        }
        if ((imm = InputMethodManager.peekInstance()) != null) {
            imm.restartInput(this);
        }
    }

    private boolean hasPasswordTransformationMethod() {
        return this.mTransformation instanceof PasswordTransformationMethod;
    }

    private static boolean isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129 || variation == 225 || variation == 18;
    }

    private static boolean isVisiblePasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 145;
    }

    public void setRawInputType(int type) {
        if (type == 0 && this.mEditor == null) {
            return;
        }
        this.createEditorIfNeeded();
        this.mEditor.mInputType = type;
    }

    private void setInputType(int type, boolean direct) {
        BaseKeyListener input;
        int cls = type & 0xF;
        if (cls == 1) {
            boolean autotext;
            boolean bl = autotext = (type & 0x8000) != 0;
            TextKeyListener.Capitalize cap = (type & 0x1000) != 0 ? TextKeyListener.Capitalize.CHARACTERS : ((type & 0x2000) != 0 ? TextKeyListener.Capitalize.WORDS : ((type & 0x4000) != 0 ? TextKeyListener.Capitalize.SENTENCES : TextKeyListener.Capitalize.NONE));
            input = TextKeyListener.getInstance(autotext, cap);
        } else if (cls == 2) {
            input = DigitsKeyListener.getInstance((type & 0x1000) != 0, (type & 0x2000) != 0);
        } else if (cls == 4) {
            switch (type & 0xFF0) {
                case 16: {
                    input = DateKeyListener.getInstance();
                    break;
                }
                case 32: {
                    input = TimeKeyListener.getInstance();
                    break;
                }
                default: {
                    input = DateTimeKeyListener.getInstance();
                    break;
                }
            }
        } else {
            input = cls == 3 ? DialerKeyListener.getInstance() : TextKeyListener.getInstance();
        }
        this.setRawInputType(type);
        if (direct) {
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = input;
        } else {
            this.setKeyListenerOnly(input);
        }
    }

    public int getInputType() {
        return this.mEditor == null ? 0 : this.mEditor.mInputType;
    }

    public void setImeOptions(int imeOptions) {
        this.createEditorIfNeeded();
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.imeOptions = imeOptions;
    }

    public int getImeOptions() {
        return this.mEditor != null && this.mEditor.mInputContentType != null ? this.mEditor.mInputContentType.imeOptions : 0;
    }

    public void setImeActionLabel(CharSequence label, int actionId) {
        this.createEditorIfNeeded();
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.imeActionLabel = label;
        this.mEditor.mInputContentType.imeActionId = actionId;
    }

    public CharSequence getImeActionLabel() {
        return this.mEditor != null && this.mEditor.mInputContentType != null ? this.mEditor.mInputContentType.imeActionLabel : null;
    }

    public int getImeActionId() {
        return this.mEditor != null && this.mEditor.mInputContentType != null ? this.mEditor.mInputContentType.imeActionId : 0;
    }

    public void setOnEditorActionListener(OnEditorActionListener l) {
        this.createEditorIfNeeded();
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.onEditorActionListener = l;
    }

    public void onEditorAction(int actionCode) {
        ViewRootImpl viewRootImpl;
        Editor.InputContentType ict;
        Editor.InputContentType inputContentType = ict = this.mEditor == null ? null : this.mEditor.mInputContentType;
        if (ict != null) {
            if (ict.onEditorActionListener != null && ict.onEditorActionListener.onEditorAction(this, actionCode, null)) {
                return;
            }
            if (actionCode == 5) {
                View v = this.focusSearch(2);
                if (v != null && !v.requestFocus(2)) {
                    throw new IllegalStateException("focus search returned a view that wasn't able to take focus!");
                }
                return;
            }
            if (actionCode == 7) {
                View v = this.focusSearch(1);
                if (v != null && !v.requestFocus(1)) {
                    throw new IllegalStateException("focus search returned a view that wasn't able to take focus!");
                }
                return;
            }
            if (actionCode == 6) {
                InputMethodManager imm = InputMethodManager.peekInstance();
                if (imm != null && imm.isActive(this)) {
                    imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
                }
                return;
            }
        }
        if ((viewRootImpl = this.getViewRootImpl()) != null) {
            long eventTime = SystemClock.uptimeMillis();
            viewRootImpl.dispatchKeyFromIme(new KeyEvent(eventTime, eventTime, 0, 66, 0, 0, -1, 0, 22));
            viewRootImpl.dispatchKeyFromIme(new KeyEvent(SystemClock.uptimeMillis(), eventTime, 1, 66, 0, 0, -1, 0, 22));
        }
    }

    public void setPrivateImeOptions(String type) {
        this.createEditorIfNeeded();
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.privateImeOptions = type;
    }

    public String getPrivateImeOptions() {
        return this.mEditor != null && this.mEditor.mInputContentType != null ? this.mEditor.mInputContentType.privateImeOptions : null;
    }

    public void setInputExtras(int xmlResId) throws XmlPullParserException, IOException {
        this.createEditorIfNeeded();
        XmlResourceParser parser = this.getResources().getXml(xmlResId);
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.extras = new Bundle();
        this.getResources().parseBundleExtras(parser, this.mEditor.mInputContentType.extras);
    }

    public Bundle getInputExtras(boolean create) {
        if (this.mEditor == null && !create) {
            return null;
        }
        this.createEditorIfNeeded();
        if (this.mEditor.mInputContentType == null) {
            if (!create) {
                return null;
            }
            this.mEditor.createInputContentTypeIfNeeded();
        }
        if (this.mEditor.mInputContentType.extras == null) {
            if (!create) {
                return null;
            }
            this.mEditor.mInputContentType.extras = new Bundle();
        }
        return this.mEditor.mInputContentType.extras;
    }

    public CharSequence getError() {
        return this.mEditor == null ? null : this.mEditor.mError;
    }

    @RemotableViewMethod
    public void setError(CharSequence error) {
        if (error == null) {
            this.setError(null, null);
        } else {
            Drawable dr = this.getContext().getResources().getDrawable(17302446);
            dr.setBounds(0, 0, dr.getIntrinsicWidth(), dr.getIntrinsicHeight());
            this.setError(error, dr);
        }
    }

    public void setError(CharSequence error, Drawable icon) {
        this.createEditorIfNeeded();
        this.mEditor.setError(error, icon);
        this.notifyViewAccessibilityStateChangedIfNeeded(0);
    }

    @Override
    protected boolean setFrame(int l, int t, int r, int b) {
        boolean result = super.setFrame(l, t, r, b);
        if (this.mEditor != null) {
            this.mEditor.setFrame();
        }
        this.restartMarqueeIfNeeded();
        return result;
    }

    private void restartMarqueeIfNeeded() {
        if (this.mRestartMarquee && this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            this.mRestartMarquee = false;
            this.startMarquee();
        }
    }

    public void setFilters(InputFilter[] filters) {
        if (filters == null) {
            throw new IllegalArgumentException();
        }
        this.mFilters = filters;
        if (this.mText instanceof Editable) {
            this.setFilters((Editable)this.mText, filters);
        }
    }

    private void setFilters(Editable e, InputFilter[] filters) {
        if (this.mEditor != null) {
            boolean undoFilter = this.mEditor.mUndoInputFilter != null;
            boolean keyFilter = this.mEditor.mKeyListener instanceof InputFilter;
            int num = 0;
            if (undoFilter) {
                ++num;
            }
            if (keyFilter) {
                ++num;
            }
            if (num > 0) {
                InputFilter[] nf = new InputFilter[filters.length + num];
                System.arraycopy(filters, 0, nf, 0, filters.length);
                num = 0;
                if (undoFilter) {
                    nf[filters.length] = this.mEditor.mUndoInputFilter;
                    ++num;
                }
                if (keyFilter) {
                    nf[filters.length + num] = (InputFilter)((Object)this.mEditor.mKeyListener);
                }
                e.setFilters(nf);
                return;
            }
        }
        e.setFilters(filters);
    }

    public InputFilter[] getFilters() {
        return this.mFilters;
    }

    private int getBoxHeight(Layout l) {
        Insets opticalInsets = TextView.isLayoutModeOptical(this.mParent) ? this.getOpticalInsets() : Insets.NONE;
        int padding = l == this.mHintLayout ? this.getCompoundPaddingTop() + this.getCompoundPaddingBottom() : this.getExtendedPaddingTop() + this.getExtendedPaddingBottom();
        return this.getMeasuredHeight() - padding + opticalInsets.top + opticalInsets.bottom;
    }

    int getVerticalOffset(boolean forceNormal) {
        int voffset = 0;
        int gravity = this.mGravity & 0x70;
        Layout l = this.mLayout;
        if (!forceNormal && this.mText.length() == 0 && this.mHintLayout != null) {
            l = this.mHintLayout;
        }
        if (gravity != 48) {
            int boxht = this.getBoxHeight(l);
            int textht = l.getHeight();
            if (textht < boxht) {
                voffset = gravity == 80 ? boxht - textht : boxht - textht >> 1;
            }
        }
        return voffset;
    }

    private int getBottomVerticalOffset(boolean forceNormal) {
        int voffset = 0;
        int gravity = this.mGravity & 0x70;
        Layout l = this.mLayout;
        if (!forceNormal && this.mText.length() == 0 && this.mHintLayout != null) {
            l = this.mHintLayout;
        }
        if (gravity != 80) {
            int boxht = this.getBoxHeight(l);
            int textht = l.getHeight();
            if (textht < boxht) {
                voffset = gravity == 48 ? boxht - textht : boxht - textht >> 1;
            }
        }
        return voffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateCursorPath() {
        if (this.mHighlightPathBogus) {
            this.invalidateCursor();
        } else {
            int horizontalPadding = this.getCompoundPaddingLeft();
            int verticalPadding = this.getExtendedPaddingTop() + this.getVerticalOffset(true);
            if (this.mEditor.mCursorCount == 0) {
                RectF rectF = TEMP_RECTF;
                synchronized (rectF) {
                    float thick = FloatMath.ceil(this.mTextPaint.getStrokeWidth());
                    if (thick < 1.0f) {
                        thick = 1.0f;
                    }
                    this.mHighlightPath.computeBounds(TEMP_RECTF, false);
                    this.invalidate((int)FloatMath.floor((float)horizontalPadding + TextView.TEMP_RECTF.left - (thick /= 2.0f)), (int)FloatMath.floor((float)verticalPadding + TextView.TEMP_RECTF.top - thick), (int)FloatMath.ceil((float)horizontalPadding + TextView.TEMP_RECTF.right + thick), (int)FloatMath.ceil((float)verticalPadding + TextView.TEMP_RECTF.bottom + thick));
                }
            } else {
                for (int i = 0; i < this.mEditor.mCursorCount; ++i) {
                    Rect bounds = this.mEditor.mCursorDrawable[i].getBounds();
                    this.invalidate(bounds.left + horizontalPadding, bounds.top + verticalPadding, bounds.right + horizontalPadding, bounds.bottom + verticalPadding);
                }
            }
        }
    }

    void invalidateCursor() {
        int where = this.getSelectionEnd();
        this.invalidateCursor(where, where, where);
    }

    private void invalidateCursor(int a, int b, int c) {
        if (a >= 0 || b >= 0 || c >= 0) {
            int start = Math.min(Math.min(a, b), c);
            int end = Math.max(Math.max(a, b), c);
            this.invalidateRegion(start, end, true);
        }
    }

    void invalidateRegion(int start, int end, boolean invalidateCursor) {
        if (this.mLayout == null) {
            this.invalidate();
        } else {
            int right;
            int left;
            int lineStart = this.mLayout.getLineForOffset(start);
            int top = this.mLayout.getLineTop(lineStart);
            if (lineStart > 0) {
                top -= this.mLayout.getLineDescent(lineStart - 1);
            }
            int lineEnd = start == end ? lineStart : this.mLayout.getLineForOffset(end);
            int bottom = this.mLayout.getLineBottom(lineEnd);
            if (invalidateCursor && this.mEditor != null) {
                for (int i = 0; i < this.mEditor.mCursorCount; ++i) {
                    Rect bounds = this.mEditor.mCursorDrawable[i].getBounds();
                    top = Math.min(top, bounds.top);
                    bottom = Math.max(bottom, bounds.bottom);
                }
            }
            int compoundPaddingLeft = this.getCompoundPaddingLeft();
            int verticalPadding = this.getExtendedPaddingTop() + this.getVerticalOffset(true);
            if (lineStart == lineEnd && !invalidateCursor) {
                left = (int)this.mLayout.getPrimaryHorizontal(start);
                right = (int)((double)this.mLayout.getPrimaryHorizontal(end) + 1.0);
                left += compoundPaddingLeft;
                right += compoundPaddingLeft;
            } else {
                left = compoundPaddingLeft;
                right = this.getWidth() - this.getCompoundPaddingRight();
            }
            this.invalidate(this.mScrollX + left, verticalPadding + top, this.mScrollX + right, verticalPadding + bottom);
        }
    }

    private void registerForPreDraw() {
        if (!this.mPreDrawRegistered) {
            this.getViewTreeObserver().addOnPreDrawListener(this);
            this.mPreDrawRegistered = true;
        }
    }

    @Override
    public boolean onPreDraw() {
        if (this.mLayout == null) {
            this.assumeLayout();
        }
        if (this.mMovement != null) {
            int curs = this.getSelectionEnd();
            if (this.mEditor != null && this.mEditor.mSelectionModifierCursorController != null && this.mEditor.mSelectionModifierCursorController.isSelectionStartDragged()) {
                curs = this.getSelectionStart();
            }
            if (curs < 0 && (this.mGravity & 0x70) == 80) {
                curs = this.mText.length();
            }
            if (curs >= 0) {
                this.bringPointIntoView(curs);
            }
        } else {
            this.bringTextIntoView();
        }
        if (this.mEditor != null && this.mEditor.mCreatedWithASelection) {
            this.mEditor.startSelectionActionMode();
            this.mEditor.mCreatedWithASelection = false;
        }
        if (this instanceof ExtractEditText && this.hasSelection() && this.mEditor != null) {
            this.mEditor.startSelectionActionMode();
        }
        this.getViewTreeObserver().removeOnPreDrawListener(this);
        this.mPreDrawRegistered = false;
        return true;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mTemporaryDetach = false;
        if (this.mEditor != null) {
            this.mEditor.onAttachedToWindow();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPreDrawRegistered) {
            this.getViewTreeObserver().removeOnPreDrawListener(this);
            this.mPreDrawRegistered = false;
        }
        this.resetResolvedDrawables();
        if (this.mEditor != null) {
            this.mEditor.onDetachedFromWindow();
        }
    }

    @Override
    public void onScreenStateChanged(int screenState) {
        super.onScreenStateChanged(screenState);
        if (this.mEditor != null) {
            this.mEditor.onScreenStateChanged(screenState);
        }
    }

    @Override
    protected boolean isPaddingOffsetRequired() {
        return this.mShadowRadius != 0.0f || this.mDrawables != null;
    }

    @Override
    protected int getLeftPaddingOffset() {
        return this.getCompoundPaddingLeft() - this.mPaddingLeft + (int)Math.min(0.0f, this.mShadowDx - this.mShadowRadius);
    }

    @Override
    protected int getTopPaddingOffset() {
        return (int)Math.min(0.0f, this.mShadowDy - this.mShadowRadius);
    }

    @Override
    protected int getBottomPaddingOffset() {
        return (int)Math.max(0.0f, this.mShadowDy + this.mShadowRadius);
    }

    @Override
    protected int getRightPaddingOffset() {
        return -(this.getCompoundPaddingRight() - this.mPaddingRight) + (int)Math.max(0.0f, this.mShadowDx + this.mShadowRadius);
    }

    @Override
    protected boolean verifyDrawable(Drawable who) {
        boolean verified = super.verifyDrawable(who);
        if (!verified && this.mDrawables != null) {
            return who == this.mDrawables.mDrawableLeft || who == this.mDrawables.mDrawableTop || who == this.mDrawables.mDrawableRight || who == this.mDrawables.mDrawableBottom || who == this.mDrawables.mDrawableStart || who == this.mDrawables.mDrawableEnd;
        }
        return verified;
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mDrawables != null) {
            if (this.mDrawables.mDrawableLeft != null) {
                this.mDrawables.mDrawableLeft.jumpToCurrentState();
            }
            if (this.mDrawables.mDrawableTop != null) {
                this.mDrawables.mDrawableTop.jumpToCurrentState();
            }
            if (this.mDrawables.mDrawableRight != null) {
                this.mDrawables.mDrawableRight.jumpToCurrentState();
            }
            if (this.mDrawables.mDrawableBottom != null) {
                this.mDrawables.mDrawableBottom.jumpToCurrentState();
            }
            if (this.mDrawables.mDrawableStart != null) {
                this.mDrawables.mDrawableStart.jumpToCurrentState();
            }
            if (this.mDrawables.mDrawableEnd != null) {
                this.mDrawables.mDrawableEnd.jumpToCurrentState();
            }
        }
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        if (this.verifyDrawable(drawable2)) {
            Rect dirty = drawable2.getBounds();
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            Drawables drawables = this.mDrawables;
            if (drawables != null) {
                if (drawable2 == drawables.mDrawableLeft) {
                    int compoundPaddingTop = this.getCompoundPaddingTop();
                    int compoundPaddingBottom = this.getCompoundPaddingBottom();
                    int vspace = this.mBottom - this.mTop - compoundPaddingBottom - compoundPaddingTop;
                    scrollX += this.mPaddingLeft;
                    scrollY += compoundPaddingTop + (vspace - drawables.mDrawableHeightLeft) / 2;
                } else if (drawable2 == drawables.mDrawableRight) {
                    int compoundPaddingTop = this.getCompoundPaddingTop();
                    int compoundPaddingBottom = this.getCompoundPaddingBottom();
                    int vspace = this.mBottom - this.mTop - compoundPaddingBottom - compoundPaddingTop;
                    scrollX += this.mRight - this.mLeft - this.mPaddingRight - drawables.mDrawableSizeRight;
                    scrollY += compoundPaddingTop + (vspace - drawables.mDrawableHeightRight) / 2;
                } else if (drawable2 == drawables.mDrawableTop) {
                    int compoundPaddingLeft = this.getCompoundPaddingLeft();
                    int compoundPaddingRight = this.getCompoundPaddingRight();
                    int hspace = this.mRight - this.mLeft - compoundPaddingRight - compoundPaddingLeft;
                    scrollX += compoundPaddingLeft + (hspace - drawables.mDrawableWidthTop) / 2;
                    scrollY += this.mPaddingTop;
                } else if (drawable2 == drawables.mDrawableBottom) {
                    int compoundPaddingLeft = this.getCompoundPaddingLeft();
                    int compoundPaddingRight = this.getCompoundPaddingRight();
                    int hspace = this.mRight - this.mLeft - compoundPaddingRight - compoundPaddingLeft;
                    scrollX += compoundPaddingLeft + (hspace - drawables.mDrawableWidthBottom) / 2;
                    scrollY += this.mBottom - this.mTop - this.mPaddingBottom - drawables.mDrawableSizeBottom;
                }
            }
            this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
        }
    }

    @Override
    public boolean hasOverlappingRendering() {
        return this.getBackground() != null && this.getBackground().getCurrent() != null || this.mText instanceof Spannable || this.hasSelection() || this.isHorizontalFadingEdgeEnabled();
    }

    public boolean isTextSelectable() {
        return this.mEditor == null ? false : this.mEditor.mTextIsSelectable;
    }

    public void setTextIsSelectable(boolean selectable) {
        if (!selectable && this.mEditor == null) {
            return;
        }
        this.createEditorIfNeeded();
        if (this.mEditor.mTextIsSelectable == selectable) {
            return;
        }
        this.mEditor.mTextIsSelectable = selectable;
        this.setFocusableInTouchMode(selectable);
        this.setFocusable(selectable);
        this.setClickable(selectable);
        this.setLongClickable(selectable);
        this.setMovementMethod(selectable ? ArrowKeyMovementMethod.getInstance() : null);
        this.setText(this.mText, selectable ? BufferType.SPANNABLE : BufferType.NORMAL);
        this.mEditor.prepareCursorControllers();
    }

    @Override
    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState;
        if (this.mSingleLine) {
            drawableState = super.onCreateDrawableState(extraSpace);
        } else {
            drawableState = super.onCreateDrawableState(extraSpace + 1);
            TextView.mergeDrawableStates(drawableState, MULTILINE_STATE_SET);
        }
        if (this.isTextSelectable()) {
            int length = drawableState.length;
            for (int i = 0; i < length; ++i) {
                if (drawableState[i] != 16842919) continue;
                int[] nonPressedState = new int[length - 1];
                System.arraycopy(drawableState, 0, nonPressedState, 0, i);
                System.arraycopy(drawableState, i + 1, nonPressedState, i, length - i - 1);
                return nonPressedState;
            }
        }
        return drawableState;
    }

    private Path getUpdatedHighlightPath() {
        Path highlight = null;
        Paint highlightPaint = this.mHighlightPaint;
        int selStart = this.getSelectionStart();
        int selEnd = this.getSelectionEnd();
        if (this.mMovement != null && (this.isFocused() || this.isPressed()) && selStart >= 0) {
            if (selStart == selEnd) {
                if (this.mEditor != null && this.mEditor.isCursorVisible() && (SystemClock.uptimeMillis() - this.mEditor.mShowCursor) % 1000L < 500L) {
                    if (this.mHighlightPathBogus) {
                        if (this.mHighlightPath == null) {
                            this.mHighlightPath = new Path();
                        }
                        this.mHighlightPath.reset();
                        this.mLayout.getCursorPath(selStart, this.mHighlightPath, this.mText);
                        this.mEditor.updateCursorsPositions();
                        this.mHighlightPathBogus = false;
                    }
                    highlightPaint.setColor(this.mCurTextColor);
                    highlightPaint.setStyle(Paint.Style.STROKE);
                    highlight = this.mHighlightPath;
                }
            } else {
                if (this.mHighlightPathBogus) {
                    if (this.mHighlightPath == null) {
                        this.mHighlightPath = new Path();
                    }
                    this.mHighlightPath.reset();
                    this.mLayout.getSelectionPath(selStart, selEnd, this.mHighlightPath);
                    this.mHighlightPathBogus = false;
                }
                highlightPaint.setColor(this.mHighlightColor);
                highlightPaint.setStyle(Paint.Style.FILL);
                highlight = this.mHighlightPath;
            }
        }
        return highlight;
    }

    public int getHorizontalOffsetForDrawables() {
        return 0;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        this.restartMarqueeIfNeeded();
        super.onDraw(canvas);
        int compoundPaddingLeft = this.getCompoundPaddingLeft();
        int compoundPaddingTop = this.getCompoundPaddingTop();
        int compoundPaddingRight = this.getCompoundPaddingRight();
        int compoundPaddingBottom = this.getCompoundPaddingBottom();
        int scrollX = this.mScrollX;
        int scrollY = this.mScrollY;
        int right = this.mRight;
        int left = this.mLeft;
        int bottom = this.mBottom;
        int top = this.mTop;
        boolean isLayoutRtl = this.isLayoutRtl();
        int offset = this.getHorizontalOffsetForDrawables();
        int leftOffset = isLayoutRtl ? 0 : offset;
        int rightOffset = isLayoutRtl ? offset : 0;
        Drawables dr = this.mDrawables;
        if (dr != null) {
            int vspace = bottom - top - compoundPaddingBottom - compoundPaddingTop;
            int hspace = right - left - compoundPaddingRight - compoundPaddingLeft;
            if (dr.mDrawableLeft != null) {
                canvas.save();
                canvas.translate(scrollX + this.mPaddingLeft + leftOffset, scrollY + compoundPaddingTop + (vspace - dr.mDrawableHeightLeft) / 2);
                dr.mDrawableLeft.draw(canvas);
                canvas.restore();
            }
            if (dr.mDrawableRight != null) {
                canvas.save();
                canvas.translate(scrollX + right - left - this.mPaddingRight - dr.mDrawableSizeRight - rightOffset, scrollY + compoundPaddingTop + (vspace - dr.mDrawableHeightRight) / 2);
                dr.mDrawableRight.draw(canvas);
                canvas.restore();
            }
            if (dr.mDrawableTop != null) {
                canvas.save();
                canvas.translate(scrollX + compoundPaddingLeft + (hspace - dr.mDrawableWidthTop) / 2, scrollY + this.mPaddingTop);
                dr.mDrawableTop.draw(canvas);
                canvas.restore();
            }
            if (dr.mDrawableBottom != null) {
                canvas.save();
                canvas.translate(scrollX + compoundPaddingLeft + (hspace - dr.mDrawableWidthBottom) / 2, scrollY + bottom - top - this.mPaddingBottom - dr.mDrawableSizeBottom);
                dr.mDrawableBottom.draw(canvas);
                canvas.restore();
            }
        }
        int color2 = this.mCurTextColor;
        if (this.mLayout == null) {
            this.assumeLayout();
        }
        Layout layout2 = this.mLayout;
        if (this.mHint != null && this.mText.length() == 0) {
            if (this.mHintTextColor != null) {
                color2 = this.mCurHintTextColor;
            }
            layout2 = this.mHintLayout;
        }
        this.mTextPaint.setColor(color2);
        this.mTextPaint.drawableState = this.getDrawableState();
        canvas.save();
        int extendedPaddingTop = this.getExtendedPaddingTop();
        int extendedPaddingBottom = this.getExtendedPaddingBottom();
        int vspace = this.mBottom - this.mTop - compoundPaddingBottom - compoundPaddingTop;
        int maxScrollY = this.mLayout.getHeight() - vspace;
        float clipLeft = compoundPaddingLeft + scrollX;
        float clipTop = scrollY == 0 ? 0.0f : (float)(extendedPaddingTop + scrollY);
        float clipRight = right - left - compoundPaddingRight + scrollX;
        float clipBottom = bottom - top + scrollY - (scrollY == maxScrollY ? 0 : extendedPaddingBottom);
        if (this.mShadowRadius != 0.0f) {
            clipLeft += Math.min(0.0f, this.mShadowDx - this.mShadowRadius);
            clipRight += Math.max(0.0f, this.mShadowDx + this.mShadowRadius);
            clipTop += Math.min(0.0f, this.mShadowDy - this.mShadowRadius);
            clipBottom += Math.max(0.0f, this.mShadowDy + this.mShadowRadius);
        }
        canvas.clipRect(clipLeft, clipTop, clipRight, clipBottom);
        int voffsetText = 0;
        int voffsetCursor = 0;
        if ((this.mGravity & 0x70) != 48) {
            voffsetText = this.getVerticalOffset(false);
            voffsetCursor = this.getVerticalOffset(true);
        }
        canvas.translate(compoundPaddingLeft, extendedPaddingTop + voffsetText);
        int layoutDirection = this.getLayoutDirection();
        int absoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, layoutDirection);
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode != 1) {
            if (!this.mSingleLine && this.getLineCount() == 1 && this.canMarquee() && (absoluteGravity & 7) != 3) {
                int width = this.mRight - this.mLeft;
                int padding = this.getCompoundPaddingLeft() + this.getCompoundPaddingRight();
                float dx = this.mLayout.getLineRight(0) - (float)(width - padding);
                canvas.translate(isLayoutRtl ? -dx : dx, 0.0f);
            }
            if (this.mMarquee != null && this.mMarquee.isRunning()) {
                float dx = -this.mMarquee.getScroll();
                canvas.translate(isLayoutRtl ? -dx : dx, 0.0f);
            }
        }
        int cursorOffsetVertical = voffsetCursor - voffsetText;
        Path highlight = this.getUpdatedHighlightPath();
        if (this.mEditor != null) {
            this.mEditor.onDraw(canvas, layout2, highlight, this.mHighlightPaint, cursorOffsetVertical);
        } else {
            layout2.draw(canvas, highlight, this.mHighlightPaint, cursorOffsetVertical);
        }
        if (this.mMarquee != null && this.mMarquee.shouldDrawGhost()) {
            int dx = (int)this.mMarquee.getGhostOffset();
            canvas.translate(isLayoutRtl ? (float)(-dx) : (float)dx, 0.0f);
            layout2.draw(canvas, highlight, this.mHighlightPaint, cursorOffsetVertical);
        }
        canvas.restore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getFocusedRect(Rect r) {
        if (this.mLayout == null) {
            super.getFocusedRect(r);
            return;
        }
        int selEnd = this.getSelectionEnd();
        if (selEnd < 0) {
            super.getFocusedRect(r);
            return;
        }
        int selStart = this.getSelectionStart();
        if (selStart < 0 || selStart >= selEnd) {
            int line = this.mLayout.getLineForOffset(selEnd);
            r.top = this.mLayout.getLineTop(line);
            r.bottom = this.mLayout.getLineBottom(line);
            r.left = (int)this.mLayout.getPrimaryHorizontal(selEnd) - 2;
            r.right = r.left + 4;
        } else {
            int lineStart = this.mLayout.getLineForOffset(selStart);
            int lineEnd = this.mLayout.getLineForOffset(selEnd);
            r.top = this.mLayout.getLineTop(lineStart);
            r.bottom = this.mLayout.getLineBottom(lineEnd);
            if (lineStart == lineEnd) {
                r.left = (int)this.mLayout.getPrimaryHorizontal(selStart);
                r.right = (int)this.mLayout.getPrimaryHorizontal(selEnd);
            } else {
                if (this.mHighlightPathBogus) {
                    if (this.mHighlightPath == null) {
                        this.mHighlightPath = new Path();
                    }
                    this.mHighlightPath.reset();
                    this.mLayout.getSelectionPath(selStart, selEnd, this.mHighlightPath);
                    this.mHighlightPathBogus = false;
                }
                RectF rectF = TEMP_RECTF;
                synchronized (rectF) {
                    this.mHighlightPath.computeBounds(TEMP_RECTF, true);
                    r.left = (int)TextView.TEMP_RECTF.left - 1;
                    r.right = (int)TextView.TEMP_RECTF.right + 1;
                }
            }
        }
        int paddingLeft = this.getCompoundPaddingLeft();
        int paddingTop = this.getExtendedPaddingTop();
        if ((this.mGravity & 0x70) != 48) {
            paddingTop += this.getVerticalOffset(false);
        }
        r.offset(paddingLeft, paddingTop);
        int paddingBottom = this.getExtendedPaddingBottom();
        r.bottom += paddingBottom;
    }

    public int getLineCount() {
        return this.mLayout != null ? this.mLayout.getLineCount() : 0;
    }

    public int getLineBounds(int line, Rect bounds) {
        if (this.mLayout == null) {
            if (bounds != null) {
                bounds.set(0, 0, 0, 0);
            }
            return 0;
        }
        int baseline = this.mLayout.getLineBounds(line, bounds);
        int voffset = this.getExtendedPaddingTop();
        if ((this.mGravity & 0x70) != 48) {
            voffset += this.getVerticalOffset(true);
        }
        if (bounds != null) {
            bounds.offset(this.getCompoundPaddingLeft(), voffset);
        }
        return baseline + voffset;
    }

    @Override
    public int getBaseline() {
        if (this.mLayout == null) {
            return super.getBaseline();
        }
        int voffset = 0;
        if ((this.mGravity & 0x70) != 48) {
            voffset = this.getVerticalOffset(true);
        }
        if (TextView.isLayoutModeOptical(this.mParent)) {
            voffset -= this.getOpticalInsets().top;
        }
        return this.getExtendedPaddingTop() + voffset + this.mLayout.getLineBaseline(0);
    }

    @Override
    protected int getFadeTop(boolean offsetRequired) {
        if (this.mLayout == null) {
            return 0;
        }
        int voffset = 0;
        if ((this.mGravity & 0x70) != 48) {
            voffset = this.getVerticalOffset(true);
        }
        if (offsetRequired) {
            voffset += this.getTopPaddingOffset();
        }
        return this.getExtendedPaddingTop() + voffset;
    }

    @Override
    protected int getFadeHeight(boolean offsetRequired) {
        return this.mLayout != null ? this.mLayout.getHeight() : 0;
    }

    @Override
    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            boolean isInSelectionMode;
            boolean bl = isInSelectionMode = this.mEditor != null && this.mEditor.mSelectionActionMode != null;
            if (isInSelectionMode) {
                if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                    KeyEvent.DispatcherState state = this.getKeyDispatcherState();
                    if (state != null) {
                        state.startTracking(event, this);
                    }
                    return true;
                }
                if (event.getAction() == 1) {
                    KeyEvent.DispatcherState state = this.getKeyDispatcherState();
                    if (state != null) {
                        state.handleUpEvent(event);
                    }
                    if (event.isTracking() && !event.isCanceled()) {
                        this.stopSelectionActionMode();
                        return true;
                    }
                }
            }
        }
        return super.onKeyPreIme(keyCode, event);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        int which = this.doKeyDown(keyCode, event, null);
        if (which == 0) {
            return super.onKeyDown(keyCode, event);
        }
        return true;
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        KeyEvent down = KeyEvent.changeAction(event, 0);
        int which = this.doKeyDown(keyCode, down, event);
        if (which == 0) {
            return super.onKeyMultiple(keyCode, repeatCount, event);
        }
        if (which == -1) {
            return true;
        }
        --repeatCount;
        KeyEvent up = KeyEvent.changeAction(event, 1);
        if (which == 1) {
            this.mEditor.mKeyListener.onKeyUp(this, (Editable)this.mText, keyCode, up);
            while (--repeatCount > 0) {
                this.mEditor.mKeyListener.onKeyDown(this, (Editable)this.mText, keyCode, down);
                this.mEditor.mKeyListener.onKeyUp(this, (Editable)this.mText, keyCode, up);
            }
            this.hideErrorIfUnchanged();
        } else if (which == 2) {
            this.mMovement.onKeyUp(this, (Spannable)this.mText, keyCode, up);
            while (--repeatCount > 0) {
                this.mMovement.onKeyDown(this, (Spannable)this.mText, keyCode, down);
                this.mMovement.onKeyUp(this, (Spannable)this.mText, keyCode, up);
            }
        }
        return true;
    }

    private boolean shouldAdvanceFocusOnEnter() {
        int variation;
        if (this.getKeyListener() == null) {
            return false;
        }
        if (this.mSingleLine) {
            return true;
        }
        return this.mEditor != null && (this.mEditor.mInputType & 0xF) == 1 && ((variation = this.mEditor.mInputType & 0xFF0) == 32 || variation == 48);
    }

    private boolean shouldAdvanceFocusOnTab() {
        int variation;
        return this.getKeyListener() == null || this.mSingleLine || this.mEditor == null || (this.mEditor.mInputType & 0xF) != 1 || (variation = this.mEditor.mInputType & 0xFF0) != 262144 && variation != 131072;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doKeyDown(int keyCode, KeyEvent event, KeyEvent otherEvent) {
        boolean handled;
        boolean doDown;
        if (!this.isEnabled()) {
            return 0;
        }
        if (event.getRepeatCount() == 0 && !KeyEvent.isModifierKey(keyCode)) {
            this.mPreventDefaultMovement = false;
        }
        switch (keyCode) {
            case 66: {
                if (!event.hasNoModifiers()) break;
                if (this.mEditor != null && this.mEditor.mInputContentType != null && this.mEditor.mInputContentType.onEditorActionListener != null && this.mEditor.mInputContentType.onEditorActionListener.onEditorAction(this, 0, event)) {
                    this.mEditor.mInputContentType.enterDown = true;
                    return -1;
                }
                if ((event.getFlags() & 0x10) == 0 && !this.shouldAdvanceFocusOnEnter()) break;
                if (this.hasOnClickListeners()) {
                    return 0;
                }
                return -1;
            }
            case 23: {
                if (!event.hasNoModifiers() || !this.shouldAdvanceFocusOnEnter()) break;
                return 0;
            }
            case 61: {
                if (!event.hasNoModifiers() && !event.hasModifiers(1) || !this.shouldAdvanceFocusOnTab()) break;
                return 0;
            }
            case 4: {
                if (this.mEditor == null || this.mEditor.mSelectionActionMode == null) break;
                this.stopSelectionActionMode();
                return -1;
            }
        }
        if (this.mEditor != null && this.mEditor.mKeyListener != null) {
            this.resetErrorChangedFlag();
            doDown = true;
            if (otherEvent != null) {
                try {
                    this.beginBatchEdit();
                    handled = this.mEditor.mKeyListener.onKeyOther(this, (Editable)this.mText, otherEvent);
                    this.hideErrorIfUnchanged();
                    doDown = false;
                    if (handled) {
                        int n = -1;
                        return n;
                    }
                }
                catch (AbstractMethodError e) {
                }
                finally {
                    this.endBatchEdit();
                }
            }
            if (doDown) {
                this.beginBatchEdit();
                handled = this.mEditor.mKeyListener.onKeyDown(this, (Editable)this.mText, keyCode, event);
                this.endBatchEdit();
                this.hideErrorIfUnchanged();
                if (handled) {
                    return 1;
                }
            }
        }
        if (this.mMovement != null && this.mLayout != null) {
            doDown = true;
            if (otherEvent != null) {
                try {
                    handled = this.mMovement.onKeyOther(this, (Spannable)this.mText, otherEvent);
                    doDown = false;
                    if (handled) {
                        return -1;
                    }
                }
                catch (AbstractMethodError e) {
                    // empty catch block
                }
            }
            if (doDown && this.mMovement.onKeyDown(this, (Spannable)this.mText, keyCode, event)) {
                if (event.getRepeatCount() == 0 && !KeyEvent.isModifierKey(keyCode)) {
                    this.mPreventDefaultMovement = true;
                }
                return 2;
            }
        }
        return this.mPreventDefaultMovement && !KeyEvent.isModifierKey(keyCode) ? -1 : 0;
    }

    public void resetErrorChangedFlag() {
        if (this.mEditor != null) {
            this.mEditor.mErrorWasChanged = false;
        }
    }

    public void hideErrorIfUnchanged() {
        if (this.mEditor != null && this.mEditor.mError != null && !this.mEditor.mErrorWasChanged) {
            this.setError(null, null);
        }
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (!this.isEnabled()) {
            return super.onKeyUp(keyCode, event);
        }
        if (!KeyEvent.isModifierKey(keyCode)) {
            this.mPreventDefaultMovement = false;
        }
        switch (keyCode) {
            case 23: {
                if (event.hasNoModifiers() && !this.hasOnClickListeners() && this.mMovement != null && this.mText instanceof Editable && this.mLayout != null && this.onCheckIsTextEditor()) {
                    InputMethodManager imm = InputMethodManager.peekInstance();
                    this.viewClicked(imm);
                    if (imm != null && this.getShowSoftInputOnFocus()) {
                        imm.showSoftInput(this, 0);
                    }
                }
                return super.onKeyUp(keyCode, event);
            }
            case 66: {
                if (!event.hasNoModifiers()) break;
                if (this.mEditor != null && this.mEditor.mInputContentType != null && this.mEditor.mInputContentType.onEditorActionListener != null && this.mEditor.mInputContentType.enterDown) {
                    this.mEditor.mInputContentType.enterDown = false;
                    if (this.mEditor.mInputContentType.onEditorActionListener.onEditorAction(this, 0, event)) {
                        return true;
                    }
                }
                if (((event.getFlags() & 0x10) != 0 || this.shouldAdvanceFocusOnEnter()) && !this.hasOnClickListeners()) {
                    InputMethodManager imm;
                    View v = this.focusSearch(130);
                    if (v != null) {
                        if (!v.requestFocus(130)) {
                            throw new IllegalStateException("focus search returned a view that wasn't able to take focus!");
                        }
                        super.onKeyUp(keyCode, event);
                        return true;
                    }
                    if ((event.getFlags() & 0x10) != 0 && (imm = InputMethodManager.peekInstance()) != null && imm.isActive(this)) {
                        imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
                    }
                }
                return super.onKeyUp(keyCode, event);
            }
        }
        if (this.mEditor != null && this.mEditor.mKeyListener != null && this.mEditor.mKeyListener.onKeyUp(this, (Editable)this.mText, keyCode, event)) {
            return true;
        }
        if (this.mMovement != null && this.mLayout != null && this.mMovement.onKeyUp(this, (Spannable)this.mText, keyCode, event)) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    @Override
    public boolean onCheckIsTextEditor() {
        return this.mEditor != null && this.mEditor.mInputType != 0;
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        if (this.onCheckIsTextEditor() && this.isEnabled()) {
            this.mEditor.createInputMethodStateIfNeeded();
            outAttrs.inputType = this.getInputType();
            if (this.mEditor.mInputContentType != null) {
                outAttrs.imeOptions = this.mEditor.mInputContentType.imeOptions;
                outAttrs.privateImeOptions = this.mEditor.mInputContentType.privateImeOptions;
                outAttrs.actionLabel = this.mEditor.mInputContentType.imeActionLabel;
                outAttrs.actionId = this.mEditor.mInputContentType.imeActionId;
                outAttrs.extras = this.mEditor.mInputContentType.extras;
            } else {
                outAttrs.imeOptions = 0;
            }
            if (this.focusSearch(130) != null) {
                outAttrs.imeOptions |= 0x8000000;
            }
            if (this.focusSearch(33) != null) {
                outAttrs.imeOptions |= 0x4000000;
            }
            if ((outAttrs.imeOptions & 0xFF) == 0) {
                outAttrs.imeOptions = (outAttrs.imeOptions & 0x8000000) != 0 ? (outAttrs.imeOptions |= 5) : (outAttrs.imeOptions |= 6);
                if (!this.shouldAdvanceFocusOnEnter()) {
                    outAttrs.imeOptions |= 0x40000000;
                }
            }
            if (TextView.isMultilineInputType(outAttrs.inputType)) {
                outAttrs.imeOptions |= 0x40000000;
            }
            outAttrs.hintText = this.mHint;
            if (this.mText instanceof Editable) {
                EditableInputConnection ic = new EditableInputConnection(this);
                outAttrs.initialSelStart = this.getSelectionStart();
                outAttrs.initialSelEnd = this.getSelectionEnd();
                outAttrs.initialCapsMode = ic.getCursorCapsMode(this.getInputType());
                return ic;
            }
        }
        return null;
    }

    public boolean extractText(ExtractedTextRequest request, ExtractedText outText) {
        this.createEditorIfNeeded();
        return this.mEditor.extractText(request, outText);
    }

    static void removeParcelableSpans(Spannable spannable, int start, int end) {
        ParcelableSpan[] spans = spannable.getSpans(start, end, ParcelableSpan.class);
        int i = spans.length;
        while (i > 0) {
            spannable.removeSpan(spans[--i]);
        }
    }

    public void setExtractedText(ExtractedText text) {
        Editable content = this.getEditableText();
        if (text.text != null) {
            if (content == null) {
                this.setText(text.text, BufferType.EDITABLE);
            } else if (text.partialStartOffset < 0) {
                TextView.removeParcelableSpans(content, 0, content.length());
                content.replace(0, content.length(), text.text);
            } else {
                int end;
                int start = text.partialStartOffset;
                int N = content.length();
                if (start > N) {
                    start = N;
                }
                if ((end = text.partialEndOffset) > N) {
                    end = N;
                }
                TextView.removeParcelableSpans(content, start, end);
                content.replace(start, end, text.text);
            }
        }
        Spannable sp = (Spannable)this.getText();
        int N = sp.length();
        int start = text.selectionStart;
        if (start < 0) {
            start = 0;
        } else if (start > N) {
            start = N;
        }
        int end = text.selectionEnd;
        if (end < 0) {
            end = 0;
        } else if (end > N) {
            end = N;
        }
        Selection.setSelection(sp, start, end);
        if ((text.flags & 2) != 0) {
            MetaKeyKeyListener.startSelecting(this, sp);
        } else {
            MetaKeyKeyListener.stopSelecting(this, sp);
        }
    }

    public void setExtracting(ExtractedTextRequest req) {
        if (this.mEditor.mInputMethodState != null) {
            this.mEditor.mInputMethodState.mExtractedTextRequest = req;
        }
        this.mEditor.hideControllers();
    }

    public void onCommitCompletion(CompletionInfo text) {
    }

    public void onCommitCorrection(CorrectionInfo info) {
        if (this.mEditor != null) {
            this.mEditor.onCommitCorrection(info);
        }
    }

    public void beginBatchEdit() {
        if (this.mEditor != null) {
            this.mEditor.beginBatchEdit();
        }
    }

    public void endBatchEdit() {
        if (this.mEditor != null) {
            this.mEditor.endBatchEdit();
        }
    }

    public void onBeginBatchEdit() {
    }

    public void onEndBatchEdit() {
    }

    public boolean onPrivateIMECommand(String action, Bundle data) {
        return false;
    }

    private void nullLayouts() {
        if (this.mLayout instanceof BoringLayout && this.mSavedLayout == null) {
            this.mSavedLayout = (BoringLayout)this.mLayout;
        }
        if (this.mHintLayout instanceof BoringLayout && this.mSavedHintLayout == null) {
            this.mSavedHintLayout = (BoringLayout)this.mHintLayout;
        }
        this.mHintLayout = null;
        this.mLayout = null;
        this.mSavedMarqueeModeLayout = null;
        this.mHintBoring = null;
        this.mBoring = null;
        if (this.mEditor != null) {
            this.mEditor.prepareCursorControllers();
        }
    }

    private void assumeLayout() {
        int width = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        if (width < 1) {
            width = 0;
        }
        int physicalWidth = width;
        if (this.mHorizontallyScrolling) {
            width = 0x100000;
        }
        this.makeNewLayout(width, physicalWidth, UNKNOWN_BORING, UNKNOWN_BORING, physicalWidth, false);
    }

    private Layout.Alignment getLayoutAlignment() {
        Layout.Alignment alignment;
        block0 : switch (this.getTextAlignment()) {
            case 1: {
                switch (this.mGravity & 0x800007) {
                    case 0x800003: {
                        alignment = Layout.Alignment.ALIGN_NORMAL;
                        break block0;
                    }
                    case 0x800005: {
                        alignment = Layout.Alignment.ALIGN_OPPOSITE;
                        break block0;
                    }
                    case 3: {
                        alignment = Layout.Alignment.ALIGN_LEFT;
                        break block0;
                    }
                    case 5: {
                        alignment = Layout.Alignment.ALIGN_RIGHT;
                        break block0;
                    }
                    case 1: {
                        alignment = Layout.Alignment.ALIGN_CENTER;
                        break block0;
                    }
                }
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 2: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 3: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 4: {
                alignment = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            case 5: {
                alignment = this.getLayoutDirection() == 1 ? Layout.Alignment.ALIGN_RIGHT : Layout.Alignment.ALIGN_LEFT;
                break;
            }
            case 6: {
                alignment = this.getLayoutDirection() == 1 ? Layout.Alignment.ALIGN_LEFT : Layout.Alignment.ALIGN_RIGHT;
                break;
            }
            default: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
            }
        }
        return alignment;
    }

    protected void makeNewLayout(int wantWidth, int hintWidth, BoringLayout.Metrics boring, BoringLayout.Metrics hintBoring, int ellipsisWidth, boolean bringIntoView) {
        this.stopMarquee();
        this.mOldMaximum = this.mMaximum;
        this.mOldMaxMode = this.mMaxMode;
        this.mHighlightPathBogus = true;
        if (wantWidth < 0) {
            wantWidth = 0;
        }
        if (hintWidth < 0) {
            hintWidth = 0;
        }
        Layout.Alignment alignment = this.getLayoutAlignment();
        boolean testDirChange = this.mSingleLine && this.mLayout != null && (alignment == Layout.Alignment.ALIGN_NORMAL || alignment == Layout.Alignment.ALIGN_OPPOSITE);
        int oldDir = 0;
        if (testDirChange) {
            oldDir = this.mLayout.getParagraphDirection(0);
        }
        boolean shouldEllipsize = this.mEllipsize != null && this.getKeyListener() == null;
        boolean switchEllipsize = this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode != 0;
        TextUtils.TruncateAt effectiveEllipsize = this.mEllipsize;
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode == 1) {
            effectiveEllipsize = TextUtils.TruncateAt.END_SMALL;
        }
        if (this.mTextDir == null) {
            this.mTextDir = this.getTextDirectionHeuristic();
        }
        this.mLayout = this.makeSingleLayout(wantWidth, boring, ellipsisWidth, alignment, shouldEllipsize, effectiveEllipsize, effectiveEllipsize == this.mEllipsize);
        if (switchEllipsize) {
            TextUtils.TruncateAt oppositeEllipsize = effectiveEllipsize == TextUtils.TruncateAt.MARQUEE ? TextUtils.TruncateAt.END : TextUtils.TruncateAt.MARQUEE;
            this.mSavedMarqueeModeLayout = this.makeSingleLayout(wantWidth, boring, ellipsisWidth, alignment, shouldEllipsize, oppositeEllipsize, effectiveEllipsize != this.mEllipsize);
        }
        shouldEllipsize = this.mEllipsize != null;
        this.mHintLayout = null;
        if (this.mHint != null) {
            if (shouldEllipsize) {
                hintWidth = wantWidth;
            }
            if (hintBoring == UNKNOWN_BORING && (hintBoring = BoringLayout.isBoring(this.mHint, this.mTextPaint, this.mTextDir, this.mHintBoring)) != null) {
                this.mHintBoring = hintBoring;
            }
            if (hintBoring != null) {
                if (!(hintBoring.width > hintWidth || shouldEllipsize && hintBoring.width > ellipsisWidth)) {
                    this.mHintLayout = this.mSavedHintLayout != null ? this.mSavedHintLayout.replaceOrMake(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad) : BoringLayout.make(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad);
                    this.mSavedHintLayout = (BoringLayout)this.mHintLayout;
                } else {
                    this.mHintLayout = shouldEllipsize && hintBoring.width <= hintWidth ? (this.mSavedHintLayout != null ? this.mSavedHintLayout.replaceOrMake(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad, this.mEllipsize, ellipsisWidth) : BoringLayout.make(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad, this.mEllipsize, ellipsisWidth)) : (shouldEllipsize ? new StaticLayout(this.mHint, 0, this.mHint.length(), this.mTextPaint, hintWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, this.mEllipsize, ellipsisWidth, this.mMaxMode == 1 ? this.mMaximum : Integer.MAX_VALUE) : new StaticLayout(this.mHint, this.mTextPaint, hintWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad));
                }
            } else {
                this.mHintLayout = shouldEllipsize ? new StaticLayout(this.mHint, 0, this.mHint.length(), this.mTextPaint, hintWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, this.mEllipsize, ellipsisWidth, this.mMaxMode == 1 ? this.mMaximum : Integer.MAX_VALUE) : new StaticLayout(this.mHint, this.mTextPaint, hintWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad);
            }
        }
        if (bringIntoView || testDirChange && oldDir != this.mLayout.getParagraphDirection(0)) {
            this.registerForPreDraw();
        }
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && !this.compressText(ellipsisWidth)) {
            int height = this.mLayoutParams.height;
            if (height != -2 && height != -1) {
                this.startMarquee();
            } else {
                this.mRestartMarquee = true;
            }
        }
        if (this.mEditor != null) {
            this.mEditor.prepareCursorControllers();
        }
    }

    private Layout makeSingleLayout(int wantWidth, BoringLayout.Metrics boring, int ellipsisWidth, Layout.Alignment alignment, boolean shouldEllipsize, TextUtils.TruncateAt effectiveEllipsize, boolean useSaved) {
        Layout result = null;
        if (this.mText instanceof Spannable) {
            result = new DynamicLayout(this.mText, this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, this.getKeyListener() == null ? effectiveEllipsize : null, ellipsisWidth);
        } else {
            if (boring == UNKNOWN_BORING && (boring = BoringLayout.isBoring(this.mTransformed, this.mTextPaint, this.mTextDir, this.mBoring)) != null) {
                this.mBoring = boring;
            }
            if (boring != null) {
                if (boring.width <= wantWidth && (effectiveEllipsize == null || boring.width <= ellipsisWidth)) {
                    result = useSaved && this.mSavedLayout != null ? this.mSavedLayout.replaceOrMake(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad) : BoringLayout.make(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad);
                    if (useSaved) {
                        this.mSavedLayout = (BoringLayout)result;
                    }
                } else {
                    result = shouldEllipsize && boring.width <= wantWidth ? (useSaved && this.mSavedLayout != null ? this.mSavedLayout.replaceOrMake(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad, effectiveEllipsize, ellipsisWidth) : BoringLayout.make(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad, effectiveEllipsize, ellipsisWidth)) : (shouldEllipsize ? new StaticLayout(this.mTransformed, 0, this.mTransformed.length(), this.mTextPaint, wantWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, effectiveEllipsize, ellipsisWidth, this.mMaxMode == 1 ? this.mMaximum : Integer.MAX_VALUE) : new StaticLayout(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad));
                }
            } else {
                result = shouldEllipsize ? new StaticLayout(this.mTransformed, 0, this.mTransformed.length(), this.mTextPaint, wantWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, effectiveEllipsize, ellipsisWidth, this.mMaxMode == 1 ? this.mMaximum : Integer.MAX_VALUE) : new StaticLayout(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad);
            }
        }
        return result;
    }

    private boolean compressText(float width) {
        float textWidth;
        float overflow;
        if (this.isHardwareAccelerated()) {
            return false;
        }
        if (width > 0.0f && this.mLayout != null && this.getLineCount() == 1 && !this.mUserSetTextScaleX && this.mTextPaint.getTextScaleX() == 1.0f && (overflow = ((textWidth = this.mLayout.getLineWidth(0)) + 1.0f - width) / width) > 0.0f && overflow <= 0.07f) {
            this.mTextPaint.setTextScaleX(1.0f - overflow - 0.005f);
            this.post(new Runnable(){

                public void run() {
                    TextView.this.requestLayout();
                }
            });
            return true;
        }
        return false;
    }

    private static int desired(Layout layout2) {
        int i;
        int n = layout2.getLineCount();
        CharSequence text = layout2.getText();
        float max = 0.0f;
        for (i = 0; i < n - 1; ++i) {
            if (text.charAt(layout2.getLineEnd(i) - 1) == '\n') continue;
            return -1;
        }
        for (i = 0; i < n; ++i) {
            max = Math.max(max, layout2.getLineWidth(i));
        }
        return (int)FloatMath.ceil(max);
    }

    public void setIncludeFontPadding(boolean includepad) {
        if (this.mIncludePad != includepad) {
            this.mIncludePad = includepad;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public boolean getIncludeFontPadding() {
        return this.mIncludePad;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int hintWidth;
        int want;
        int width;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        BoringLayout.Metrics boring = UNKNOWN_BORING;
        BoringLayout.Metrics hintBoring = UNKNOWN_BORING;
        if (this.mTextDir == null) {
            this.mTextDir = this.getTextDirectionHeuristic();
        }
        int des = -1;
        boolean fromexisting = false;
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            if (this.mLayout != null && this.mEllipsize == null) {
                des = TextView.desired(this.mLayout);
            }
            if (des < 0) {
                boring = BoringLayout.isBoring(this.mTransformed, this.mTextPaint, this.mTextDir, this.mBoring);
                if (boring != null) {
                    this.mBoring = boring;
                }
            } else {
                fromexisting = true;
            }
            if (boring == null || boring == UNKNOWN_BORING) {
                if (des < 0) {
                    des = (int)FloatMath.ceil(Layout.getDesiredWidth(this.mTransformed, this.mTextPaint));
                }
                width = des;
            } else {
                width = boring.width;
            }
            Drawables dr = this.mDrawables;
            if (dr != null) {
                width = Math.max(width, dr.mDrawableWidthTop);
                width = Math.max(width, dr.mDrawableWidthBottom);
            }
            if (this.mHint != null) {
                int hintWidth2;
                int hintDes = -1;
                if (this.mHintLayout != null && this.mEllipsize == null) {
                    hintDes = TextView.desired(this.mHintLayout);
                }
                if (hintDes < 0 && (hintBoring = BoringLayout.isBoring(this.mHint, this.mTextPaint, this.mTextDir, this.mHintBoring)) != null) {
                    this.mHintBoring = hintBoring;
                }
                if (hintBoring == null || hintBoring == UNKNOWN_BORING) {
                    if (hintDes < 0) {
                        hintDes = (int)FloatMath.ceil(Layout.getDesiredWidth(this.mHint, this.mTextPaint));
                    }
                    hintWidth2 = hintDes;
                } else {
                    hintWidth2 = hintBoring.width;
                }
                if (hintWidth2 > width) {
                    width = hintWidth2;
                }
            }
            width += this.getCompoundPaddingLeft() + this.getCompoundPaddingRight();
            width = this.mMaxWidthMode == 1 ? Math.min(width, this.mMaxWidth * this.getLineHeight()) : Math.min(width, this.mMaxWidth);
            width = this.mMinWidthMode == 1 ? Math.max(width, this.mMinWidth * this.getLineHeight()) : Math.max(width, this.mMinWidth);
            width = Math.max(width, this.getSuggestedMinimumWidth());
            if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(widthSize, width);
            }
        }
        int unpaddedWidth = want = width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        if (this.mHorizontallyScrolling) {
            want = 0x100000;
        }
        int hintWant = want;
        int n = hintWidth = this.mHintLayout == null ? hintWant : this.mHintLayout.getWidth();
        if (this.mLayout == null) {
            this.makeNewLayout(want, hintWant, boring, hintBoring, width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
        } else {
            boolean maximumChanged;
            boolean layoutChanged = this.mLayout.getWidth() != want || hintWidth != hintWant || this.mLayout.getEllipsizedWidth() != width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
            boolean widthChanged = this.mHint == null && this.mEllipsize == null && want > this.mLayout.getWidth() && (this.mLayout instanceof BoringLayout || fromexisting && des >= 0 && des <= want);
            boolean bl = maximumChanged = this.mMaxMode != this.mOldMaxMode || this.mMaximum != this.mOldMaximum;
            if (layoutChanged || maximumChanged) {
                if (!maximumChanged && widthChanged) {
                    this.mLayout.increaseWidthTo(want);
                } else {
                    this.makeNewLayout(want, hintWant, boring, hintBoring, width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
                }
            }
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
            this.mDesiredHeightAtMeasure = -1;
        } else {
            int desired;
            height = desired = this.getDesiredHeight();
            this.mDesiredHeightAtMeasure = desired;
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(desired, heightSize);
            }
        }
        int unpaddedHeight = height - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom();
        if (this.mMaxMode == 1 && this.mLayout.getLineCount() > this.mMaximum) {
            unpaddedHeight = Math.min(unpaddedHeight, this.mLayout.getLineTop(this.mMaximum));
        }
        if (this.mMovement != null || this.mLayout.getWidth() > unpaddedWidth || this.mLayout.getHeight() > unpaddedHeight) {
            this.registerForPreDraw();
        } else {
            this.scrollTo(0, 0);
        }
        this.setMeasuredDimension(width, height);
    }

    private int getDesiredHeight() {
        return Math.max(this.getDesiredHeight(this.mLayout, true), this.getDesiredHeight(this.mHintLayout, this.mEllipsize != null));
    }

    private int getDesiredHeight(Layout layout2, boolean cap) {
        if (layout2 == null) {
            return 0;
        }
        int linecount = layout2.getLineCount();
        int pad = this.getCompoundPaddingTop() + this.getCompoundPaddingBottom();
        int desired = layout2.getLineTop(linecount);
        Drawables dr = this.mDrawables;
        if (dr != null) {
            desired = Math.max(desired, dr.mDrawableHeightLeft);
            desired = Math.max(desired, dr.mDrawableHeightRight);
        }
        desired += pad;
        if (this.mMaxMode == 1) {
            if (cap && linecount > this.mMaximum) {
                desired = layout2.getLineTop(this.mMaximum);
                if (dr != null) {
                    desired = Math.max(desired, dr.mDrawableHeightLeft);
                    desired = Math.max(desired, dr.mDrawableHeightRight);
                }
                desired += pad;
                linecount = this.mMaximum;
            }
        } else {
            desired = Math.min(desired, this.mMaximum);
        }
        if (this.mMinMode == 1) {
            if (linecount < this.mMinimum) {
                desired += this.getLineHeight() * (this.mMinimum - linecount);
            }
        } else {
            desired = Math.max(desired, this.mMinimum);
        }
        desired = Math.max(desired, this.getSuggestedMinimumHeight());
        return desired;
    }

    private void checkForResize() {
        boolean sizeChanged = false;
        if (this.mLayout != null) {
            int desiredHeight;
            if (this.mLayoutParams.width == -2) {
                sizeChanged = true;
                this.invalidate();
            }
            if (this.mLayoutParams.height == -2) {
                int desiredHeight2 = this.getDesiredHeight();
                if (desiredHeight2 != this.getHeight()) {
                    sizeChanged = true;
                }
            } else if (this.mLayoutParams.height == -1 && this.mDesiredHeightAtMeasure >= 0 && (desiredHeight = this.getDesiredHeight()) != this.mDesiredHeightAtMeasure) {
                sizeChanged = true;
            }
        }
        if (sizeChanged) {
            this.requestLayout();
        }
    }

    private void checkForRelayout() {
        if ((this.mLayoutParams.width != -2 || this.mMaxWidthMode == this.mMinWidthMode && this.mMaxWidth == this.mMinWidth) && (this.mHint == null || this.mHintLayout != null) && this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight() > 0) {
            int oldht = this.mLayout.getHeight();
            int want = this.mLayout.getWidth();
            int hintWant = this.mHintLayout == null ? 0 : this.mHintLayout.getWidth();
            this.makeNewLayout(want, hintWant, UNKNOWN_BORING, UNKNOWN_BORING, this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
            if (this.mEllipsize != TextUtils.TruncateAt.MARQUEE) {
                if (this.mLayoutParams.height != -2 && this.mLayoutParams.height != -1) {
                    this.invalidate();
                    return;
                }
                if (this.mLayout.getHeight() == oldht && (this.mHintLayout == null || this.mHintLayout.getHeight() == oldht)) {
                    this.invalidate();
                    return;
                }
            }
            this.requestLayout();
            this.invalidate();
        } else {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mDeferScroll >= 0) {
            int curs = this.mDeferScroll;
            this.mDeferScroll = -1;
            this.bringPointIntoView(Math.min(curs, this.mText.length()));
        }
    }

    private boolean isShowingHint() {
        return TextUtils.isEmpty(this.mText) && !TextUtils.isEmpty(this.mHint);
    }

    private boolean bringTextIntoView() {
        int scrollx;
        Layout layout2 = this.isShowingHint() ? this.mHintLayout : this.mLayout;
        int line = 0;
        if ((this.mGravity & 0x70) == 80) {
            line = layout2.getLineCount() - 1;
        }
        Layout.Alignment a = layout2.getParagraphAlignment(line);
        int dir = layout2.getParagraphDirection(line);
        int hspace = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int vspace = this.mBottom - this.mTop - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom();
        int ht = layout2.getHeight();
        if (a == Layout.Alignment.ALIGN_NORMAL) {
            a = dir == 1 ? Layout.Alignment.ALIGN_LEFT : Layout.Alignment.ALIGN_RIGHT;
        } else if (a == Layout.Alignment.ALIGN_OPPOSITE) {
            Layout.Alignment alignment = a = dir == 1 ? Layout.Alignment.ALIGN_RIGHT : Layout.Alignment.ALIGN_LEFT;
        }
        if (a == Layout.Alignment.ALIGN_CENTER) {
            int left = (int)FloatMath.floor(layout2.getLineLeft(line));
            int right = (int)FloatMath.ceil(layout2.getLineRight(line));
            scrollx = right - left < hspace ? (right + left) / 2 - hspace / 2 : (dir < 0 ? right - hspace : left);
        } else if (a == Layout.Alignment.ALIGN_RIGHT) {
            int right = (int)FloatMath.ceil(layout2.getLineRight(line));
            scrollx = right - hspace;
        } else {
            scrollx = (int)FloatMath.floor(layout2.getLineLeft(line));
        }
        int scrolly = ht < vspace ? 0 : ((this.mGravity & 0x70) == 80 ? ht - vspace : 0);
        if (scrollx != this.mScrollX || scrolly != this.mScrollY) {
            this.scrollTo(scrollx, scrolly);
            return true;
        }
        return false;
    }

    public boolean bringPointIntoView(int offset) {
        int hslack;
        int vslack;
        int grav;
        Layout layout2;
        if (this.isLayoutRequested()) {
            this.mDeferScroll = offset;
            return false;
        }
        boolean changed = false;
        Layout layout3 = layout2 = this.isShowingHint() ? this.mHintLayout : this.mLayout;
        if (layout2 == null) {
            return changed;
        }
        int line = layout2.getLineForOffset(offset);
        switch (layout2.getParagraphAlignment(line)) {
            case ALIGN_LEFT: {
                grav = 1;
                break;
            }
            case ALIGN_RIGHT: {
                grav = -1;
                break;
            }
            case ALIGN_NORMAL: {
                grav = layout2.getParagraphDirection(line);
                break;
            }
            case ALIGN_OPPOSITE: {
                grav = -layout2.getParagraphDirection(line);
                break;
            }
            default: {
                grav = 0;
            }
        }
        boolean clamped = grav > 0;
        int x = (int)layout2.getPrimaryHorizontal(offset, clamped);
        int top = layout2.getLineTop(line);
        int bottom = layout2.getLineTop(line + 1);
        int left = (int)FloatMath.floor(layout2.getLineLeft(line));
        int right = (int)FloatMath.ceil(layout2.getLineRight(line));
        int ht = layout2.getHeight();
        int hspace = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int vspace = this.mBottom - this.mTop - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom();
        if (!this.mHorizontallyScrolling && right - left > hspace && right > x) {
            right = Math.max(x, left + hspace);
        }
        if ((vslack = (hslack = (bottom - top) / 2)) > vspace / 4) {
            vslack = vspace / 4;
        }
        if (hslack > hspace / 4) {
            hslack = hspace / 4;
        }
        int hs = this.mScrollX;
        int vs = this.mScrollY;
        if (top - vs < vslack) {
            vs = top - vslack;
        }
        if (bottom - vs > vspace - vslack) {
            vs = bottom - (vspace - vslack);
        }
        if (ht - vs < vspace) {
            vs = ht - vspace;
        }
        if (0 - vs > 0) {
            vs = 0;
        }
        if (grav != 0) {
            if (x - hs < hslack) {
                hs = x - hslack;
            }
            if (x - hs > hspace - hslack) {
                hs = x - (hspace - hslack);
            }
        }
        if (grav < 0) {
            if (left - hs > 0) {
                hs = left;
            }
            if (right - hs < hspace) {
                hs = right - hspace;
            }
        } else if (grav > 0) {
            if (right - hs < hspace) {
                hs = right - hspace;
            }
            if (left - hs > 0) {
                hs = left;
            }
        } else if (right - left <= hspace) {
            hs = left - (hspace - (right - left)) / 2;
        } else if (x > right - hslack) {
            hs = right - hspace;
        } else if (x < left + hslack) {
            hs = left;
        } else if (left > hs) {
            hs = left;
        } else if (right < hs + hspace) {
            hs = right - hspace;
        } else {
            if (x - hs < hslack) {
                hs = x - hslack;
            }
            if (x - hs > hspace - hslack) {
                hs = x - (hspace - hslack);
            }
        }
        if (hs != this.mScrollX || vs != this.mScrollY) {
            if (this.mScroller == null) {
                this.scrollTo(hs, vs);
            } else {
                long duration = AnimationUtils.currentAnimationTimeMillis() - this.mLastScroll;
                int dx = hs - this.mScrollX;
                int dy = vs - this.mScrollY;
                if (duration > 250L) {
                    this.mScroller.startScroll(this.mScrollX, this.mScrollY, dx, dy);
                    this.awakenScrollBars(this.mScroller.getDuration());
                    this.invalidate();
                } else {
                    if (!this.mScroller.isFinished()) {
                        this.mScroller.abortAnimation();
                    }
                    this.scrollBy(dx, dy);
                }
                this.mLastScroll = AnimationUtils.currentAnimationTimeMillis();
            }
            changed = true;
        }
        if (this.isFocused()) {
            if (this.mTempRect == null) {
                this.mTempRect = new Rect();
            }
            this.mTempRect.set(x - 2, top, x + 2, bottom);
            this.getInterestingRect(this.mTempRect, line);
            this.mTempRect.offset(this.mScrollX, this.mScrollY);
            if (this.requestRectangleOnScreen(this.mTempRect)) {
                changed = true;
            }
        }
        return changed;
    }

    public boolean moveCursorToVisibleOffset() {
        int vs;
        int vspace;
        int end;
        if (!(this.mText instanceof Spannable)) {
            return false;
        }
        int start = this.getSelectionStart();
        if (start != (end = this.getSelectionEnd())) {
            return false;
        }
        int line = this.mLayout.getLineForOffset(start);
        int top = this.mLayout.getLineTop(line);
        int bottom = this.mLayout.getLineTop(line + 1);
        int vslack = (bottom - top) / 2;
        if (vslack > (vspace = this.mBottom - this.mTop - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom()) / 4) {
            vslack = vspace / 4;
        }
        if (top < (vs = this.mScrollY) + vslack) {
            line = this.mLayout.getLineForVertical(vs + vslack + (bottom - top));
        } else if (bottom > vspace + vs - vslack) {
            line = this.mLayout.getLineForVertical(vspace + vs - vslack - (bottom - top));
        }
        int hspace = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int hs = this.mScrollX;
        int leftChar = this.mLayout.getOffsetForHorizontal(line, hs);
        int rightChar = this.mLayout.getOffsetForHorizontal(line, hspace + hs);
        int lowChar = leftChar < rightChar ? leftChar : rightChar;
        int highChar = leftChar > rightChar ? leftChar : rightChar;
        int newStart = start;
        if (newStart < lowChar) {
            newStart = lowChar;
        } else if (newStart > highChar) {
            newStart = highChar;
        }
        if (newStart != start) {
            Selection.setSelection((Spannable)this.mText, newStart);
            return true;
        }
        return false;
    }

    @Override
    public void computeScroll() {
        if (this.mScroller != null && this.mScroller.computeScrollOffset()) {
            this.mScrollX = this.mScroller.getCurrX();
            this.mScrollY = this.mScroller.getCurrY();
            this.invalidateParentCaches();
            this.postInvalidate();
        }
    }

    private void getInterestingRect(Rect r, int line) {
        this.convertFromViewportToContentCoordinates(r);
        if (line == 0) {
            r.top -= this.getExtendedPaddingTop();
        }
        if (line == this.mLayout.getLineCount() - 1) {
            r.bottom += this.getExtendedPaddingBottom();
        }
    }

    private void convertFromViewportToContentCoordinates(Rect r) {
        int horizontalOffset = this.viewportToContentHorizontalOffset();
        r.left += horizontalOffset;
        r.right += horizontalOffset;
        int verticalOffset = this.viewportToContentVerticalOffset();
        r.top += verticalOffset;
        r.bottom += verticalOffset;
    }

    int viewportToContentHorizontalOffset() {
        return this.getCompoundPaddingLeft() - this.mScrollX;
    }

    int viewportToContentVerticalOffset() {
        int offset = this.getExtendedPaddingTop() - this.mScrollY;
        if ((this.mGravity & 0x70) != 48) {
            offset += this.getVerticalOffset(false);
        }
        return offset;
    }

    @Override
    public void debug(int depth) {
        super.debug(depth);
        String output = TextView.debugIndent(depth);
        output = output + "frame={" + this.mLeft + ", " + this.mTop + ", " + this.mRight + ", " + this.mBottom + "} scroll={" + this.mScrollX + ", " + this.mScrollY + "} ";
        if (this.mText != null) {
            output = output + "mText=\"" + this.mText + "\" ";
            if (this.mLayout != null) {
                output = output + "mLayout width=" + this.mLayout.getWidth() + " height=" + this.mLayout.getHeight();
            }
        } else {
            output = output + "mText=NULL";
        }
        Log.d("View", output);
    }

    @ViewDebug.ExportedProperty(category="text")
    public int getSelectionStart() {
        return Selection.getSelectionStart(this.getText());
    }

    @ViewDebug.ExportedProperty(category="text")
    public int getSelectionEnd() {
        return Selection.getSelectionEnd(this.getText());
    }

    public boolean hasSelection() {
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        return selectionStart >= 0 && selectionStart != selectionEnd;
    }

    public void setSingleLine() {
        this.setSingleLine(true);
    }

    public void setAllCaps(boolean allCaps) {
        if (allCaps) {
            this.setTransformationMethod(new AllCapsTransformationMethod(this.getContext()));
        } else {
            this.setTransformationMethod(null);
        }
    }

    @RemotableViewMethod
    public void setSingleLine(boolean singleLine) {
        this.setInputTypeSingleLine(singleLine);
        this.applySingleLine(singleLine, true, true);
    }

    private void setInputTypeSingleLine(boolean singleLine) {
        if (this.mEditor != null && (this.mEditor.mInputType & 0xF) == 1) {
            this.mEditor.mInputType = singleLine ? (this.mEditor.mInputType &= 0xFFFDFFFF) : (this.mEditor.mInputType |= 0x20000);
        }
    }

    private void applySingleLine(boolean singleLine, boolean applyTransformation, boolean changeMaxLines) {
        this.mSingleLine = singleLine;
        if (singleLine) {
            this.setLines(1);
            this.setHorizontallyScrolling(true);
            if (applyTransformation) {
                this.setTransformationMethod(SingleLineTransformationMethod.getInstance());
            }
        } else {
            if (changeMaxLines) {
                this.setMaxLines(Integer.MAX_VALUE);
            }
            this.setHorizontallyScrolling(false);
            if (applyTransformation) {
                this.setTransformationMethod(null);
            }
        }
    }

    public void setEllipsize(TextUtils.TruncateAt where) {
        if (this.mEllipsize != where) {
            this.mEllipsize = where;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public void setMarqueeRepeatLimit(int marqueeLimit) {
        this.mMarqueeRepeatLimit = marqueeLimit;
    }

    public int getMarqueeRepeatLimit() {
        return this.mMarqueeRepeatLimit;
    }

    @ViewDebug.ExportedProperty
    public TextUtils.TruncateAt getEllipsize() {
        return this.mEllipsize;
    }

    @RemotableViewMethod
    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.createEditorIfNeeded();
        this.mEditor.mSelectAllOnFocus = selectAllOnFocus;
        if (selectAllOnFocus && !(this.mText instanceof Spannable)) {
            this.setText(this.mText, BufferType.SPANNABLE);
        }
    }

    @RemotableViewMethod
    public void setCursorVisible(boolean visible) {
        if (visible && this.mEditor == null) {
            return;
        }
        this.createEditorIfNeeded();
        if (this.mEditor.mCursorVisible != visible) {
            this.mEditor.mCursorVisible = visible;
            this.invalidate();
            this.mEditor.makeBlink();
            this.mEditor.prepareCursorControllers();
        }
    }

    public boolean isCursorVisible() {
        return this.mEditor == null ? true : this.mEditor.mCursorVisible;
    }

    private boolean canMarquee() {
        int width = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        return width > 0 && (this.mLayout.getLineWidth(0) > (float)width || this.mMarqueeFadeMode != 0 && this.mSavedMarqueeModeLayout != null && this.mSavedMarqueeModeLayout.getLineWidth(0) > (float)width);
    }

    private void startMarquee() {
        if (this.getKeyListener() != null) {
            return;
        }
        if (this.compressText(this.getWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight())) {
            return;
        }
        if ((this.mMarquee == null || this.mMarquee.isStopped()) && (this.isFocused() || this.isSelected()) && this.getLineCount() == 1 && this.canMarquee()) {
            if (this.mMarqueeFadeMode == 1) {
                this.mMarqueeFadeMode = 2;
                Layout tmp = this.mLayout;
                this.mLayout = this.mSavedMarqueeModeLayout;
                this.mSavedMarqueeModeLayout = tmp;
                this.setHorizontalFadingEdgeEnabled(true);
                this.requestLayout();
                this.invalidate();
            }
            if (this.mMarquee == null) {
                this.mMarquee = new Marquee(this);
            }
            this.mMarquee.start(this.mMarqueeRepeatLimit);
        }
    }

    private void stopMarquee() {
        if (this.mMarquee != null && !this.mMarquee.isStopped()) {
            this.mMarquee.stop();
        }
        if (this.mMarqueeFadeMode == 2) {
            this.mMarqueeFadeMode = 1;
            Layout tmp = this.mSavedMarqueeModeLayout;
            this.mSavedMarqueeModeLayout = this.mLayout;
            this.mLayout = tmp;
            this.setHorizontalFadingEdgeEnabled(false);
            this.requestLayout();
            this.invalidate();
        }
    }

    private void startStopMarquee(boolean start) {
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            if (start) {
                this.startMarquee();
            } else {
                this.stopMarquee();
            }
        }
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        this.sendAccessibilityEvent(8192);
    }

    public void addTextChangedListener(TextWatcher watcher) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(watcher);
    }

    public void removeTextChangedListener(TextWatcher watcher) {
        int i;
        if (this.mListeners != null && (i = this.mListeners.indexOf(watcher)) >= 0) {
            this.mListeners.remove(i);
        }
    }

    private void sendBeforeTextChanged(CharSequence text, int start, int before, int after) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).beforeTextChanged(text, start, before, after);
            }
        }
        this.removeIntersectingNonAdjacentSpans(start, start + before, SpellCheckSpan.class);
        this.removeIntersectingNonAdjacentSpans(start, start + before, SuggestionSpan.class);
    }

    private <T> void removeIntersectingNonAdjacentSpans(int start, int end, Class<T> type) {
        if (!(this.mText instanceof Editable)) {
            return;
        }
        Editable text = (Editable)this.mText;
        T[] spans = text.getSpans(start, end, type);
        int length = spans.length;
        for (int i = 0; i < length; ++i) {
            int spanStart = text.getSpanStart(spans[i]);
            int spanEnd = text.getSpanEnd(spans[i]);
            if (spanEnd == start || spanStart == end) break;
            text.removeSpan(spans[i]);
        }
    }

    void removeAdjacentSuggestionSpans(int pos) {
        if (!(this.mText instanceof Editable)) {
            return;
        }
        Editable text = (Editable)this.mText;
        SuggestionSpan[] spans = text.getSpans(pos, pos, SuggestionSpan.class);
        int length = spans.length;
        for (int i = 0; i < length; ++i) {
            int spanStart = text.getSpanStart(spans[i]);
            int spanEnd = text.getSpanEnd(spans[i]);
            if (spanEnd != pos && spanStart != pos || !SpellChecker.haveWordBoundariesChanged(text, pos, pos, spanStart, spanEnd)) continue;
            text.removeSpan(spans[i]);
        }
    }

    void sendOnTextChanged(CharSequence text, int start, int before, int after) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).onTextChanged(text, start, before, after);
            }
        }
        if (this.mEditor != null) {
            this.mEditor.sendOnTextChanged(start, after);
        }
    }

    void sendAfterTextChanged(Editable text) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).afterTextChanged(text);
            }
        }
    }

    void updateAfterEdit() {
        this.invalidate();
        int curs = this.getSelectionStart();
        if (curs >= 0 || (this.mGravity & 0x70) == 80) {
            this.registerForPreDraw();
        }
        this.checkForResize();
        if (curs >= 0) {
            this.mHighlightPathBogus = true;
            if (this.mEditor != null) {
                this.mEditor.makeBlink();
            }
            this.bringPointIntoView(curs);
        }
    }

    void handleTextChanged(CharSequence buffer, int start, int before, int after) {
        Editor.InputMethodState ims;
        Editor.InputMethodState inputMethodState = ims = this.mEditor == null ? null : this.mEditor.mInputMethodState;
        if (ims == null || ims.mBatchEditNesting == 0) {
            this.updateAfterEdit();
        }
        if (ims != null) {
            ims.mContentChanged = true;
            if (ims.mChangedStart < 0) {
                ims.mChangedStart = start;
                ims.mChangedEnd = start + before;
            } else {
                ims.mChangedStart = Math.min(ims.mChangedStart, start);
                ims.mChangedEnd = Math.max(ims.mChangedEnd, start + before - ims.mChangedDelta);
            }
            ims.mChangedDelta += after - before;
        }
        this.sendOnTextChanged(buffer, start, before, after);
        this.onTextChanged(buffer, start, before, after);
    }

    void spanChange(Spanned buf, Object what, int oldStart, int newStart, int oldEnd, int newEnd) {
        Editor.InputMethodState ims;
        boolean selChanged = false;
        int newSelStart = -1;
        int newSelEnd = -1;
        Editor.InputMethodState inputMethodState = ims = this.mEditor == null ? null : this.mEditor.mInputMethodState;
        if (what == Selection.SELECTION_END) {
            selChanged = true;
            newSelEnd = newStart;
            if (oldStart >= 0 || newStart >= 0) {
                this.invalidateCursor(Selection.getSelectionStart(buf), oldStart, newStart);
                this.checkForResize();
                this.registerForPreDraw();
                if (this.mEditor != null) {
                    this.mEditor.makeBlink();
                }
            }
        }
        if (what == Selection.SELECTION_START) {
            selChanged = true;
            newSelStart = newStart;
            if (oldStart >= 0 || newStart >= 0) {
                int end = Selection.getSelectionEnd(buf);
                this.invalidateCursor(end, oldStart, newStart);
            }
        }
        if (selChanged) {
            this.mHighlightPathBogus = true;
            if (this.mEditor != null && !this.isFocused()) {
                this.mEditor.mSelectionMoved = true;
            }
            if ((buf.getSpanFlags(what) & 0x200) == 0) {
                if (newSelStart < 0) {
                    newSelStart = Selection.getSelectionStart(buf);
                }
                if (newSelEnd < 0) {
                    newSelEnd = Selection.getSelectionEnd(buf);
                }
                this.onSelectionChanged(newSelStart, newSelEnd);
            }
        }
        if (what instanceof UpdateAppearance || what instanceof ParagraphStyle || what instanceof CharacterStyle) {
            if (ims == null || ims.mBatchEditNesting == 0) {
                this.invalidate();
                this.mHighlightPathBogus = true;
                this.checkForResize();
            } else {
                ims.mContentChanged = true;
            }
            if (this.mEditor != null) {
                if (oldStart >= 0) {
                    this.mEditor.invalidateTextDisplayList(this.mLayout, oldStart, oldEnd);
                }
                if (newStart >= 0) {
                    this.mEditor.invalidateTextDisplayList(this.mLayout, newStart, newEnd);
                }
            }
        }
        if (MetaKeyKeyListener.isMetaTracker(buf, what)) {
            this.mHighlightPathBogus = true;
            if (ims != null && MetaKeyKeyListener.isSelectingMetaTracker(buf, what)) {
                ims.mSelectionModeChanged = true;
            }
            if (Selection.getSelectionStart(buf) >= 0) {
                if (ims == null || ims.mBatchEditNesting == 0) {
                    this.invalidateCursor();
                } else {
                    ims.mCursorChanged = true;
                }
            }
        }
        if (what instanceof ParcelableSpan && ims != null && ims.mExtractedTextRequest != null) {
            if (ims.mBatchEditNesting != 0) {
                if (oldStart >= 0) {
                    if (ims.mChangedStart > oldStart) {
                        ims.mChangedStart = oldStart;
                    }
                    if (ims.mChangedStart > oldEnd) {
                        ims.mChangedStart = oldEnd;
                    }
                }
                if (newStart >= 0) {
                    if (ims.mChangedStart > newStart) {
                        ims.mChangedStart = newStart;
                    }
                    if (ims.mChangedStart > newEnd) {
                        ims.mChangedStart = newEnd;
                    }
                }
            } else {
                ims.mContentChanged = true;
            }
        }
        if (this.mEditor != null && this.mEditor.mSpellChecker != null && newStart < 0 && what instanceof SpellCheckSpan) {
            this.mEditor.mSpellChecker.onSpellCheckSpanRemoved((SpellCheckSpan)what);
        }
    }

    @Override
    public void dispatchFinishTemporaryDetach() {
        this.mDispatchTemporaryDetach = true;
        super.dispatchFinishTemporaryDetach();
        this.mDispatchTemporaryDetach = false;
    }

    @Override
    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        if (!this.mDispatchTemporaryDetach) {
            this.mTemporaryDetach = true;
        }
        if (this.mEditor != null) {
            this.mEditor.mTemporaryDetach = true;
        }
    }

    @Override
    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        if (!this.mDispatchTemporaryDetach) {
            this.mTemporaryDetach = false;
        }
        if (this.mEditor != null) {
            this.mEditor.mTemporaryDetach = false;
        }
    }

    @Override
    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        if (this.mTemporaryDetach) {
            super.onFocusChanged(focused, direction, previouslyFocusedRect);
            return;
        }
        if (this.mEditor != null) {
            this.mEditor.onFocusChanged(focused, direction);
        }
        if (focused && this.mText instanceof Spannable) {
            Spannable sp = (Spannable)this.mText;
            MetaKeyKeyListener.resetMetaState(sp);
        }
        this.startStopMarquee(focused);
        if (this.mTransformation != null) {
            this.mTransformation.onFocusChanged(this, this.mText, focused, direction, previouslyFocusedRect);
        }
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (this.mEditor != null) {
            this.mEditor.onWindowFocusChanged(hasWindowFocus);
        }
        this.startStopMarquee(hasWindowFocus);
    }

    @Override
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.mEditor != null && visibility != 0) {
            this.mEditor.hideControllers();
        }
    }

    public void clearComposingText() {
        if (this.mText instanceof Spannable) {
            BaseInputConnection.removeComposingSpans((Spannable)this.mText);
        }
    }

    @Override
    public void setSelected(boolean selected) {
        boolean wasSelected = this.isSelected();
        super.setSelected(selected);
        if (selected != wasSelected && this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            if (selected) {
                this.startMarquee();
            } else {
                this.stopMarquee();
            }
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        boolean touchIsFinished;
        int action = event.getActionMasked();
        if (this.mEditor != null) {
            this.mEditor.onTouchEvent(event);
        }
        boolean superResult = super.onTouchEvent(event);
        if (this.mEditor != null && this.mEditor.mDiscardNextActionUp && action == 1) {
            this.mEditor.mDiscardNextActionUp = false;
            return superResult;
        }
        boolean bl = touchIsFinished = action == 1 && (this.mEditor == null || !this.mEditor.mIgnoreActionUpEvent) && this.isFocused();
        if ((this.mMovement != null || this.onCheckIsTextEditor()) && this.isEnabled() && this.mText instanceof Spannable && this.mLayout != null) {
            ClickableSpan[] links;
            boolean handled = false;
            if (this.mMovement != null) {
                handled |= this.mMovement.onTouchEvent(this, (Spannable)this.mText, event);
            }
            boolean textIsSelectable = this.isTextSelectable();
            if (touchIsFinished && this.mLinksClickable && this.mAutoLinkMask != 0 && textIsSelectable && (links = ((Spannable)this.mText).getSpans(this.getSelectionStart(), this.getSelectionEnd(), ClickableSpan.class)).length > 0) {
                links[0].onClick(this);
                handled = true;
            }
            if (touchIsFinished && (this.isTextEditable() || textIsSelectable)) {
                InputMethodManager imm = InputMethodManager.peekInstance();
                this.viewClicked(imm);
                if (!textIsSelectable && this.mEditor.mShowSoftInputOnFocus) {
                    handled |= imm != null && imm.showSoftInput(this, 0);
                }
                this.mEditor.onTouchUpEvent(event);
                handled = true;
            }
            if (handled) {
                return true;
            }
        }
        return superResult;
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent event) {
        if (this.mMovement != null && this.mText instanceof Spannable && this.mLayout != null) {
            try {
                if (this.mMovement.onGenericMotionEvent(this, (Spannable)this.mText, event)) {
                    return true;
                }
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        return super.onGenericMotionEvent(event);
    }

    boolean isTextEditable() {
        return this.mText instanceof Editable && this.onCheckIsTextEditor() && this.isEnabled();
    }

    public boolean didTouchFocusSelect() {
        return this.mEditor != null && this.mEditor.mTouchFocusSelected;
    }

    @Override
    public void cancelLongPress() {
        super.cancelLongPress();
        if (this.mEditor != null) {
            this.mEditor.mIgnoreActionUpEvent = true;
        }
    }

    @Override
    public boolean onTrackballEvent(MotionEvent event) {
        if (this.mMovement != null && this.mText instanceof Spannable && this.mLayout != null && this.mMovement.onTrackballEvent(this, (Spannable)this.mText, event)) {
            return true;
        }
        return super.onTrackballEvent(event);
    }

    public void setScroller(Scroller s) {
        this.mScroller = s;
    }

    @Override
    protected float getLeftFadingEdgeStrength() {
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode != 1) {
            if (this.mMarquee != null && !this.mMarquee.isStopped()) {
                Marquee marquee = this.mMarquee;
                if (marquee.shouldDrawLeftFade()) {
                    float scroll = marquee.getScroll();
                    return scroll / (float)this.getHorizontalFadingEdgeLength();
                }
                return 0.0f;
            }
            if (this.getLineCount() == 1) {
                int layoutDirection = this.getLayoutDirection();
                int absoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, layoutDirection);
                switch (absoluteGravity & 7) {
                    case 3: {
                        return 0.0f;
                    }
                    case 5: {
                        return (this.mLayout.getLineRight(0) - (float)(this.mRight - this.mLeft) - (float)this.getCompoundPaddingLeft() - (float)this.getCompoundPaddingRight() - this.mLayout.getLineLeft(0)) / (float)this.getHorizontalFadingEdgeLength();
                    }
                    case 1: 
                    case 7: {
                        int textDirection = this.mLayout.getParagraphDirection(0);
                        if (textDirection == 1) {
                            return 0.0f;
                        }
                        return (this.mLayout.getLineRight(0) - (float)(this.mRight - this.mLeft) - (float)this.getCompoundPaddingLeft() - (float)this.getCompoundPaddingRight() - this.mLayout.getLineLeft(0)) / (float)this.getHorizontalFadingEdgeLength();
                    }
                }
            }
        }
        return super.getLeftFadingEdgeStrength();
    }

    @Override
    protected float getRightFadingEdgeStrength() {
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode != 1) {
            if (this.mMarquee != null && !this.mMarquee.isStopped()) {
                Marquee marquee = this.mMarquee;
                float maxFadeScroll = marquee.getMaxFadeScroll();
                float scroll = marquee.getScroll();
                return (maxFadeScroll - scroll) / (float)this.getHorizontalFadingEdgeLength();
            }
            if (this.getLineCount() == 1) {
                int layoutDirection = this.getLayoutDirection();
                int absoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, layoutDirection);
                switch (absoluteGravity & 7) {
                    case 3: {
                        int textWidth = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
                        float lineWidth = this.mLayout.getLineWidth(0);
                        return (lineWidth - (float)textWidth) / (float)this.getHorizontalFadingEdgeLength();
                    }
                    case 5: {
                        return 0.0f;
                    }
                    case 1: 
                    case 7: {
                        int textDirection = this.mLayout.getParagraphDirection(0);
                        if (textDirection == -1) {
                            return 0.0f;
                        }
                        return (this.mLayout.getLineWidth(0) - (float)(this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight())) / (float)this.getHorizontalFadingEdgeLength();
                    }
                }
            }
        }
        return super.getRightFadingEdgeStrength();
    }

    @Override
    protected int computeHorizontalScrollRange() {
        if (this.mLayout != null) {
            return this.mSingleLine && (this.mGravity & 7) == 3 ? (int)this.mLayout.getLineWidth(0) : this.mLayout.getWidth();
        }
        return super.computeHorizontalScrollRange();
    }

    @Override
    protected int computeVerticalScrollRange() {
        if (this.mLayout != null) {
            return this.mLayout.getHeight();
        }
        return super.computeVerticalScrollRange();
    }

    @Override
    protected int computeVerticalScrollExtent() {
        return this.getHeight() - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom();
    }

    @Override
    public void findViewsWithText(ArrayList<View> outViews, CharSequence searched, int flags) {
        super.findViewsWithText(outViews, searched, flags);
        if (!(outViews.contains(this) || (flags & 1) == 0 || TextUtils.isEmpty(searched) || TextUtils.isEmpty(this.mText))) {
            String searchedLowerCase = ((Object)searched).toString().toLowerCase();
            String textLowerCase = ((Object)this.mText).toString().toLowerCase();
            if (textLowerCase.contains(searchedLowerCase)) {
                outViews.add(this);
            }
        }
    }

    public static ColorStateList getTextColors(Context context, TypedArray attrs) {
        int ap;
        ColorStateList colors = attrs.getColorStateList(5);
        if (colors == null && (ap = attrs.getResourceId(1, -1)) != -1) {
            TypedArray appearance = context.obtainStyledAttributes(ap, R.styleable.TextAppearance);
            colors = appearance.getColorStateList(3);
            appearance.recycle();
        }
        return colors;
    }

    public static int getTextColor(Context context, TypedArray attrs, int def) {
        ColorStateList colors = TextView.getTextColors(context, attrs);
        if (colors == null) {
            return def;
        }
        return colors.getDefaultColor();
    }

    @Override
    public boolean onKeyShortcut(int keyCode, KeyEvent event) {
        int filteredMetaState = event.getMetaState() & 0xFFFF8FFF;
        if (KeyEvent.metaStateHasNoModifiers(filteredMetaState)) {
            switch (keyCode) {
                case 29: {
                    if (!this.canSelectText()) break;
                    return this.onTextContextMenuItem(16908319);
                }
                case 52: {
                    if (!this.canCut()) break;
                    return this.onTextContextMenuItem(0x1020020);
                }
                case 31: {
                    if (!this.canCopy()) break;
                    return this.onTextContextMenuItem(0x1020021);
                }
                case 50: {
                    if (!this.canPaste()) break;
                    return this.onTextContextMenuItem(0x1020022);
                }
            }
        }
        return super.onKeyShortcut(keyCode, event);
    }

    private boolean canSelectText() {
        return this.mText.length() != 0 && this.mEditor != null && this.mEditor.hasSelectionController();
    }

    boolean textCanBeSelected() {
        if (this.mMovement == null || !this.mMovement.canSelectArbitrarily()) {
            return false;
        }
        return this.isTextEditable() || this.isTextSelectable() && this.mText instanceof Spannable && this.isEnabled();
    }

    private Locale getTextServicesLocale(boolean allowNullLocale) {
        this.updateTextServicesLocaleAsync();
        return this.mCurrentSpellCheckerLocaleCache == null && !allowNullLocale ? Locale.getDefault() : this.mCurrentSpellCheckerLocaleCache;
    }

    public Locale getTextServicesLocale() {
        return this.getTextServicesLocale(false);
    }

    public Locale getSpellCheckerLocale() {
        return this.getTextServicesLocale(true);
    }

    private void updateTextServicesLocaleAsync() {
        AsyncTask.execute(new Runnable(){

            public void run() {
                TextView.this.updateTextServicesLocaleLocked();
            }
        });
    }

    private void updateTextServicesLocaleLocked() {
        TextServicesManager textServicesManager = (TextServicesManager)this.mContext.getSystemService("textservices");
        SpellCheckerSubtype subtype = textServicesManager.getCurrentSpellCheckerSubtype(true);
        Locale locale = subtype != null ? SpellCheckerSubtype.constructLocaleFromString(subtype.getLocale()) : null;
        this.mCurrentSpellCheckerLocaleCache = locale;
    }

    void onLocaleChanged() {
        this.mEditor.mWordIterator = null;
    }

    public WordIterator getWordIterator() {
        if (this.mEditor != null) {
            return this.mEditor.getWordIterator();
        }
        return null;
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        CharSequence text;
        super.onPopulateAccessibilityEvent(event);
        boolean isPassword = this.hasPasswordTransformationMethod();
        if (!(isPassword && !this.shouldSpeakPasswordsForAccessibility() || TextUtils.isEmpty(text = this.getTextForAccessibility()))) {
            event.getText().add(text);
        }
    }

    private boolean shouldSpeakPasswordsForAccessibility() {
        return Settings.Secure.getInt(this.mContext.getContentResolver(), "speak_password", 0) == 1;
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(TextView.class.getName());
        boolean isPassword = this.hasPasswordTransformationMethod();
        event.setPassword(isPassword);
        if (event.getEventType() == 8192) {
            event.setFromIndex(Selection.getSelectionStart(this.mText));
            event.setToIndex(Selection.getSelectionEnd(this.mText));
            event.setItemCount(this.mText.length());
        }
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(TextView.class.getName());
        boolean isPassword = this.hasPasswordTransformationMethod();
        info.setPassword(isPassword);
        if (!isPassword) {
            info.setText(this.getTextForAccessibility());
        }
        if (this.mBufferType == BufferType.EDITABLE) {
            info.setEditable(true);
        }
        if (this.mEditor != null) {
            info.setInputType(this.mEditor.mInputType);
            if (this.mEditor.mError != null) {
                info.setContentInvalid(true);
            }
        }
        if (!TextUtils.isEmpty(this.mText)) {
            info.addAction(256);
            info.addAction(512);
            info.setMovementGranularities(31);
        }
        if (this.isFocused()) {
            if (this.canSelectText()) {
                info.addAction(131072);
            }
            if (this.canCopy()) {
                info.addAction(16384);
            }
            if (this.canPaste()) {
                info.addAction(32768);
            }
            if (this.canCut()) {
                info.addAction(65536);
            }
        }
        if (!this.isSingleLine()) {
            info.setMultiLine(true);
        }
    }

    @Override
    public boolean performAccessibilityAction(int action, Bundle arguments) {
        switch (action) {
            case 16384: {
                return this.isFocused() && this.canCopy() && this.onTextContextMenuItem(0x1020021);
            }
            case 32768: {
                return this.isFocused() && this.canPaste() && this.onTextContextMenuItem(0x1020022);
            }
            case 65536: {
                return this.isFocused() && this.canCut() && this.onTextContextMenuItem(0x1020020);
            }
            case 131072: {
                if (this.isFocused() && this.canSelectText()) {
                    int end;
                    CharSequence text = this.getIterableTextForAccessibility();
                    if (text == null) {
                        return false;
                    }
                    int start = arguments != null ? arguments.getInt("ACTION_ARGUMENT_SELECTION_START_INT", -1) : -1;
                    int n = end = arguments != null ? arguments.getInt("ACTION_ARGUMENT_SELECTION_END_INT", -1) : -1;
                    if (this.getSelectionStart() != start || this.getSelectionEnd() != end) {
                        if (start == end && end == -1) {
                            Selection.removeSelection((Spannable)text);
                            return true;
                        }
                        if (start >= 0 && start <= end && end <= text.length()) {
                            Selection.setSelection((Spannable)text, start, end);
                            if (this.mEditor != null) {
                                this.mEditor.startSelectionActionMode();
                            }
                            return true;
                        }
                    }
                }
                return false;
            }
        }
        return super.performAccessibilityAction(action, arguments);
    }

    @Override
    public void sendAccessibilityEvent(int eventType) {
        if (eventType == 4096) {
            return;
        }
        super.sendAccessibilityEvent(eventType);
    }

    public CharSequence getTextForAccessibility() {
        CharSequence text = this.getText();
        if (TextUtils.isEmpty(text)) {
            text = this.getHint();
        }
        return text;
    }

    void sendAccessibilityEventTypeViewTextChanged(CharSequence beforeText, int fromIndex, int removedCount, int addedCount) {
        AccessibilityEvent event = AccessibilityEvent.obtain(16);
        event.setFromIndex(fromIndex);
        event.setRemovedCount(removedCount);
        event.setAddedCount(addedCount);
        event.setBeforeText(beforeText);
        this.sendAccessibilityEventUnchecked(event);
    }

    public boolean isInputMethodTarget() {
        InputMethodManager imm = InputMethodManager.peekInstance();
        return imm != null && imm.isActive(this);
    }

    public boolean onTextContextMenuItem(int id2) {
        int min = 0;
        int max = this.mText.length();
        if (this.isFocused()) {
            int selStart = this.getSelectionStart();
            int selEnd = this.getSelectionEnd();
            min = Math.max(0, Math.min(selStart, selEnd));
            max = Math.max(0, Math.max(selStart, selEnd));
        }
        switch (id2) {
            case 16908319: {
                this.selectAllText();
                return true;
            }
            case 0x1020022: {
                this.paste(min, max);
                return true;
            }
            case 0x1020020: {
                this.setPrimaryClip(ClipData.newPlainText(null, this.getTransformedText(min, max)));
                this.deleteText_internal(min, max);
                this.stopSelectionActionMode();
                return true;
            }
            case 0x1020021: {
                this.setPrimaryClip(ClipData.newPlainText(null, this.getTransformedText(min, max)));
                this.stopSelectionActionMode();
                return true;
            }
        }
        return false;
    }

    CharSequence getTransformedText(int start, int end) {
        return this.removeSuggestionSpans(this.mTransformed.subSequence(start, end));
    }

    @Override
    public boolean performLongClick() {
        boolean handled = false;
        if (super.performLongClick()) {
            handled = true;
        }
        if (this.mEditor != null) {
            handled |= this.mEditor.performLongClick(handled);
        }
        if (handled) {
            this.performHapticFeedback(0);
            if (this.mEditor != null) {
                this.mEditor.mDiscardNextActionUp = true;
            }
        }
        return handled;
    }

    @Override
    protected void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
        super.onScrollChanged(horiz, vert, oldHoriz, oldVert);
        if (this.mEditor != null) {
            this.mEditor.onScrollChanged();
        }
    }

    public boolean isSuggestionsEnabled() {
        if (this.mEditor == null) {
            return false;
        }
        if ((this.mEditor.mInputType & 0xF) != 1) {
            return false;
        }
        if ((this.mEditor.mInputType & 0x80000) > 0) {
            return false;
        }
        int variation = this.mEditor.mInputType & 0xFF0;
        return variation == 0 || variation == 48 || variation == 80 || variation == 64 || variation == 160;
    }

    public void setCustomSelectionActionModeCallback(ActionMode.Callback actionModeCallback) {
        this.createEditorIfNeeded();
        this.mEditor.mCustomSelectionActionModeCallback = actionModeCallback;
    }

    public ActionMode.Callback getCustomSelectionActionModeCallback() {
        return this.mEditor == null ? null : this.mEditor.mCustomSelectionActionModeCallback;
    }

    protected void stopSelectionActionMode() {
        this.mEditor.stopSelectionActionMode();
    }

    boolean canCut() {
        if (this.hasPasswordTransformationMethod()) {
            return false;
        }
        return this.mText.length() > 0 && this.hasSelection() && this.mText instanceof Editable && this.mEditor != null && this.mEditor.mKeyListener != null;
    }

    boolean canCopy() {
        if (this.hasPasswordTransformationMethod()) {
            return false;
        }
        return this.mText.length() > 0 && this.hasSelection();
    }

    boolean canPaste() {
        return this.mText instanceof Editable && this.mEditor != null && this.mEditor.mKeyListener != null && this.getSelectionStart() >= 0 && this.getSelectionEnd() >= 0 && ((ClipboardManager)this.getContext().getSystemService("clipboard")).hasPrimaryClip();
    }

    boolean selectAllText() {
        int length = this.mText.length();
        Selection.setSelection((Spannable)this.mText, 0, length);
        return length > 0;
    }

    long prepareSpacesAroundPaste(int min, int max, CharSequence paste) {
        if (paste.length() > 0) {
            char charAfter;
            char charBefore;
            if (min > 0) {
                charBefore = this.mTransformed.charAt(min - 1);
                charAfter = paste.charAt(0);
                if (Character.isSpaceChar(charBefore) && Character.isSpaceChar(charAfter)) {
                    int originalLength = this.mText.length();
                    this.deleteText_internal(min - 1, min);
                    int delta = this.mText.length() - originalLength;
                    min += delta;
                    max += delta;
                } else if (!Character.isSpaceChar(charBefore) && charBefore != '\n' && !Character.isSpaceChar(charAfter) && charAfter != '\n') {
                    int originalLength = this.mText.length();
                    this.replaceText_internal(min, min, " ");
                    int delta = this.mText.length() - originalLength;
                    min += delta;
                    max += delta;
                }
            }
            if (max < this.mText.length()) {
                charBefore = paste.charAt(paste.length() - 1);
                charAfter = this.mTransformed.charAt(max);
                if (Character.isSpaceChar(charBefore) && Character.isSpaceChar(charAfter)) {
                    this.deleteText_internal(max, max + 1);
                } else if (!Character.isSpaceChar(charBefore) && charBefore != '\n' && !Character.isSpaceChar(charAfter) && charAfter != '\n') {
                    this.replaceText_internal(max, max, " ");
                }
            }
        }
        return TextUtils.packRangeInLong(min, max);
    }

    private void paste(int min, int max) {
        ClipboardManager clipboard = (ClipboardManager)this.getContext().getSystemService("clipboard");
        ClipData clip = clipboard.getPrimaryClip();
        if (clip != null) {
            boolean didFirst = false;
            for (int i = 0; i < clip.getItemCount(); ++i) {
                CharSequence paste = clip.getItemAt(i).coerceToStyledText(this.getContext());
                if (paste == null) continue;
                if (!didFirst) {
                    long minMax = this.prepareSpacesAroundPaste(min, max, paste);
                    min = TextUtils.unpackRangeStartFromLong(minMax);
                    max = TextUtils.unpackRangeEndFromLong(minMax);
                    Selection.setSelection((Spannable)this.mText, max);
                    ((Editable)this.mText).replace(min, max, paste);
                    didFirst = true;
                    continue;
                }
                ((Editable)this.mText).insert(this.getSelectionEnd(), "\n");
                ((Editable)this.mText).insert(this.getSelectionEnd(), paste);
            }
            this.stopSelectionActionMode();
            LAST_CUT_OR_COPY_TIME = 0L;
        }
    }

    private void setPrimaryClip(ClipData clip) {
        ClipboardManager clipboard = (ClipboardManager)this.getContext().getSystemService("clipboard");
        clipboard.setPrimaryClip(clip);
        LAST_CUT_OR_COPY_TIME = SystemClock.uptimeMillis();
    }

    public int getOffsetForPosition(float x, float y) {
        if (this.getLayout() == null) {
            return -1;
        }
        int line = this.getLineAtCoordinate(y);
        int offset = this.getOffsetAtCoordinate(line, x);
        return offset;
    }

    float convertToLocalHorizontalCoordinate(float x) {
        x -= (float)this.getTotalPaddingLeft();
        x = Math.max(0.0f, x);
        x = Math.min((float)(this.getWidth() - this.getTotalPaddingRight() - 1), x);
        return x += (float)this.getScrollX();
    }

    int getLineAtCoordinate(float y) {
        y -= (float)this.getTotalPaddingTop();
        y = Math.max(0.0f, y);
        y = Math.min((float)(this.getHeight() - this.getTotalPaddingBottom() - 1), y);
        return this.getLayout().getLineForVertical((int)(y += (float)this.getScrollY()));
    }

    private int getOffsetAtCoordinate(int line, float x) {
        x = this.convertToLocalHorizontalCoordinate(x);
        return this.getLayout().getOffsetForHorizontal(line, x);
    }

    @Override
    public boolean onDragEvent(DragEvent event) {
        switch (event.getAction()) {
            case 1: {
                return this.mEditor != null && this.mEditor.hasInsertionController();
            }
            case 5: {
                this.requestFocus();
                return true;
            }
            case 2: {
                int offset = this.getOffsetForPosition(event.getX(), event.getY());
                Selection.setSelection((Spannable)this.mText, offset);
                return true;
            }
            case 3: {
                if (this.mEditor != null) {
                    this.mEditor.onDrop(event);
                }
                return true;
            }
        }
        return true;
    }

    boolean isInBatchEditMode() {
        if (this.mEditor == null) {
            return false;
        }
        Editor.InputMethodState ims = this.mEditor.mInputMethodState;
        if (ims != null) {
            return ims.mBatchEditNesting > 0;
        }
        return this.mEditor.mInBatchEditControllers;
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.mTextDir = this.getTextDirectionHeuristic();
    }

    TextDirectionHeuristic getTextDirectionHeuristic() {
        if (this.hasPasswordTransformationMethod()) {
            return TextDirectionHeuristics.LTR;
        }
        boolean defaultIsRtl = this.getLayoutDirection() == 1;
        switch (this.getTextDirection()) {
            default: {
                return defaultIsRtl ? TextDirectionHeuristics.FIRSTSTRONG_RTL : TextDirectionHeuristics.FIRSTSTRONG_LTR;
            }
            case 2: {
                return TextDirectionHeuristics.ANYRTL_LTR;
            }
            case 3: {
                return TextDirectionHeuristics.LTR;
            }
            case 4: {
                return TextDirectionHeuristics.RTL;
            }
            case 5: 
        }
        return TextDirectionHeuristics.LOCALE;
    }

    @Override
    public void onResolveDrawables(int layoutDirection) {
        if (this.mLastLayoutDirection == layoutDirection) {
            return;
        }
        this.mLastLayoutDirection = layoutDirection;
        if (this.mDrawables != null) {
            this.mDrawables.resolveWithLayoutDirection(layoutDirection);
        }
    }

    @Override
    protected void resetResolvedDrawables() {
        super.resetResolvedDrawables();
        this.mLastLayoutDirection = -1;
    }

    protected void viewClicked(InputMethodManager imm) {
        if (imm != null) {
            imm.viewClicked(this);
        }
    }

    protected void deleteText_internal(int start, int end) {
        ((Editable)this.mText).delete(start, end);
    }

    protected void replaceText_internal(int start, int end, CharSequence text) {
        ((Editable)this.mText).replace(start, end, text);
    }

    protected void setSpan_internal(Object span, int start, int end, int flags) {
        ((Editable)this.mText).setSpan(span, start, end, flags);
    }

    protected void setCursorPosition_internal(int start, int end) {
        Selection.setSelection((Editable)this.mText, start, end);
    }

    private void createEditorIfNeeded() {
        if (this.mEditor == null) {
            this.mEditor = new Editor(this);
        }
    }

    @Override
    public CharSequence getIterableTextForAccessibility() {
        if (!(this.mText instanceof Spannable)) {
            this.setText(this.mText, BufferType.SPANNABLE);
        }
        return this.mText;
    }

    @Override
    public AccessibilityIterators.TextSegmentIterator getIteratorForGranularity(int granularity) {
        switch (granularity) {
            case 4: {
                Spannable text = (Spannable)this.getIterableTextForAccessibility();
                if (TextUtils.isEmpty(text) || this.getLayout() == null) break;
                AccessibilityIterators.LineTextSegmentIterator iterator = AccessibilityIterators.LineTextSegmentIterator.getInstance();
                iterator.initialize(text, this.getLayout());
                return iterator;
            }
            case 16: {
                Spannable text = (Spannable)this.getIterableTextForAccessibility();
                if (TextUtils.isEmpty(text) || this.getLayout() == null) break;
                AccessibilityIterators.PageTextSegmentIterator iterator = AccessibilityIterators.PageTextSegmentIterator.getInstance();
                iterator.initialize(this);
                return iterator;
            }
        }
        return super.getIteratorForGranularity(granularity);
    }

    @Override
    public int getAccessibilitySelectionStart() {
        return this.getSelectionStart();
    }

    @Override
    public boolean isAccessibilitySelectionExtendable() {
        return true;
    }

    @Override
    public int getAccessibilitySelectionEnd() {
        return this.getSelectionEnd();
    }

    @Override
    public void setAccessibilitySelection(int start, int end) {
        if (this.getAccessibilitySelectionStart() == start && this.getAccessibilitySelectionEnd() == end) {
            return;
        }
        if (this.mEditor != null) {
            this.mEditor.hideControllers();
        }
        CharSequence text = this.getIterableTextForAccessibility();
        if (Math.min(start, end) >= 0 && Math.max(start, end) <= text.length()) {
            Selection.setSelection((Spannable)text, start, end);
        } else {
            Selection.removeSelection((Spannable)text);
        }
    }

    static {
        Paint p = new Paint();
        p.setAntiAlias(true);
        p.measureText("H");
        UNKNOWN_BORING = new BoringLayout.Metrics();
    }

    private class ChangeWatcher
    implements TextWatcher,
    SpanWatcher {
        private CharSequence mBeforeText;

        private ChangeWatcher() {
        }

        public void beforeTextChanged(CharSequence buffer, int start, int before, int after) {
            if (AccessibilityManager.getInstance(TextView.this.mContext).isEnabled() && (!TextView.isPasswordInputType(TextView.this.getInputType()) && !TextView.this.hasPasswordTransformationMethod() || TextView.this.shouldSpeakPasswordsForAccessibility())) {
                this.mBeforeText = ((Object)buffer).toString();
            }
            TextView.this.sendBeforeTextChanged(buffer, start, before, after);
        }

        public void onTextChanged(CharSequence buffer, int start, int before, int after) {
            TextView.this.handleTextChanged(buffer, start, before, after);
            if (AccessibilityManager.getInstance(TextView.this.mContext).isEnabled() && (TextView.this.isFocused() || TextView.this.isSelected() && TextView.this.isShown())) {
                TextView.this.sendAccessibilityEventTypeViewTextChanged(this.mBeforeText, start, before, after);
                this.mBeforeText = null;
            }
        }

        public void afterTextChanged(Editable buffer) {
            TextView.this.sendAfterTextChanged(buffer);
            if (MetaKeyKeyListener.getMetaState((CharSequence)buffer, 2048) != 0) {
                MetaKeyKeyListener.stopSelecting(TextView.this, buffer);
            }
        }

        public void onSpanChanged(Spannable buf, Object what, int s, int e, int st, int en) {
            TextView.this.spanChange(buf, what, s, st, e, en);
        }

        public void onSpanAdded(Spannable buf, Object what, int s, int e) {
            TextView.this.spanChange(buf, what, -1, s, -1, e);
        }

        public void onSpanRemoved(Spannable buf, Object what, int s, int e) {
            TextView.this.spanChange(buf, what, s, -1, e, -1);
        }
    }

    private static final class Marquee
    extends Handler {
        private static final float MARQUEE_DELTA_MAX = 0.07f;
        private static final int MARQUEE_DELAY = 1200;
        private static final int MARQUEE_RESTART_DELAY = 1200;
        private static final int MARQUEE_RESOLUTION = 33;
        private static final int MARQUEE_PIXELS_PER_SECOND = 30;
        private static final byte MARQUEE_STOPPED = 0;
        private static final byte MARQUEE_STARTING = 1;
        private static final byte MARQUEE_RUNNING = 2;
        private static final int MESSAGE_START = 1;
        private static final int MESSAGE_TICK = 2;
        private static final int MESSAGE_RESTART = 3;
        private final WeakReference<TextView> mView;
        private byte mStatus = 0;
        private final float mScrollUnit;
        private float mMaxScroll;
        private float mMaxFadeScroll;
        private float mGhostStart;
        private float mGhostOffset;
        private float mFadeStop;
        private int mRepeatLimit;
        private float mScroll;

        Marquee(TextView v) {
            float density = v.getContext().getResources().getDisplayMetrics().density;
            this.mScrollUnit = 30.0f * density / 33.0f;
            this.mView = new WeakReference<TextView>(v);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.mStatus = (byte)2;
                    this.tick();
                    break;
                }
                case 2: {
                    this.tick();
                    break;
                }
                case 3: {
                    if (this.mStatus != 2) break;
                    if (this.mRepeatLimit >= 0) {
                        --this.mRepeatLimit;
                    }
                    this.start(this.mRepeatLimit);
                }
            }
        }

        void tick() {
            if (this.mStatus != 2) {
                return;
            }
            this.removeMessages(2);
            TextView textView = (TextView)this.mView.get();
            if (textView != null && (textView.isFocused() || textView.isSelected())) {
                this.mScroll += this.mScrollUnit;
                if (this.mScroll > this.mMaxScroll) {
                    this.mScroll = this.mMaxScroll;
                    this.sendEmptyMessageDelayed(3, 1200L);
                } else {
                    this.sendEmptyMessageDelayed(2, 33L);
                }
                textView.invalidate();
            }
        }

        void stop() {
            this.mStatus = 0;
            this.removeMessages(1);
            this.removeMessages(3);
            this.removeMessages(2);
            this.resetScroll();
        }

        private void resetScroll() {
            this.mScroll = 0.0f;
            TextView textView = (TextView)this.mView.get();
            if (textView != null) {
                textView.invalidate();
            }
        }

        void start(int repeatLimit) {
            if (repeatLimit == 0) {
                this.stop();
                return;
            }
            this.mRepeatLimit = repeatLimit;
            TextView textView = (TextView)this.mView.get();
            if (textView != null && textView.mLayout != null) {
                this.mStatus = 1;
                this.mScroll = 0.0f;
                int textWidth = textView.getWidth() - textView.getCompoundPaddingLeft() - textView.getCompoundPaddingRight();
                float lineWidth = textView.mLayout.getLineWidth(0);
                float gap = (float)textWidth / 3.0f;
                this.mGhostStart = lineWidth - (float)textWidth + gap;
                this.mMaxScroll = this.mGhostStart + (float)textWidth;
                this.mGhostOffset = lineWidth + gap;
                this.mFadeStop = lineWidth + (float)textWidth / 6.0f;
                this.mMaxFadeScroll = this.mGhostStart + lineWidth + lineWidth;
                textView.invalidate();
                this.sendEmptyMessageDelayed(1, 1200L);
            }
        }

        float getGhostOffset() {
            return this.mGhostOffset;
        }

        float getScroll() {
            return this.mScroll;
        }

        float getMaxFadeScroll() {
            return this.mMaxFadeScroll;
        }

        boolean shouldDrawLeftFade() {
            return this.mScroll <= this.mFadeStop;
        }

        boolean shouldDrawGhost() {
            return this.mStatus == 2 && this.mScroll > this.mGhostStart;
        }

        boolean isRunning() {
            return this.mStatus == 2;
        }

        boolean isStopped() {
            return this.mStatus == 0;
        }
    }

    private static class CharWrapper
    implements CharSequence,
    GetChars,
    GraphicsOperations {
        private char[] mChars;
        private int mStart;
        private int mLength;

        public CharWrapper(char[] chars, int start, int len) {
            this.mChars = chars;
            this.mStart = start;
            this.mLength = len;
        }

        void set(char[] chars, int start, int len) {
            this.mChars = chars;
            this.mStart = start;
            this.mLength = len;
        }

        public int length() {
            return this.mLength;
        }

        public char charAt(int off) {
            return this.mChars[off + this.mStart];
        }

        public String toString() {
            return new String(this.mChars, this.mStart, this.mLength);
        }

        public CharSequence subSequence(int start, int end) {
            if (start < 0 || end < 0 || start > this.mLength || end > this.mLength) {
                throw new IndexOutOfBoundsException(start + ", " + end);
            }
            return new String(this.mChars, start + this.mStart, end - start);
        }

        public void getChars(int start, int end, char[] buf, int off) {
            if (start < 0 || end < 0 || start > this.mLength || end > this.mLength) {
                throw new IndexOutOfBoundsException(start + ", " + end);
            }
            System.arraycopy(this.mChars, start + this.mStart, buf, off, end - start);
        }

        public void drawText(Canvas c, int start, int end, float x, float y, Paint p) {
            c.drawText(this.mChars, start + this.mStart, end - start, x, y, p);
        }

        public void drawTextRun(Canvas c, int start, int end, int contextStart, int contextEnd, float x, float y, int flags, Paint p) {
            int count = end - start;
            int contextCount = contextEnd - contextStart;
            c.drawTextRun(this.mChars, start + this.mStart, count, contextStart + this.mStart, contextCount, x, y, flags, p);
        }

        public float measureText(int start, int end, Paint p) {
            return p.measureText(this.mChars, start + this.mStart, end - start);
        }

        public int getTextWidths(int start, int end, float[] widths, Paint p) {
            return p.getTextWidths(this.mChars, start + this.mStart, end - start, widths);
        }

        public float getTextRunAdvances(int start, int end, int contextStart, int contextEnd, int flags, float[] advances, int advancesIndex, Paint p) {
            int count = end - start;
            int contextCount = contextEnd - contextStart;
            return p.getTextRunAdvances(this.mChars, start + this.mStart, count, contextStart + this.mStart, contextCount, flags, advances, advancesIndex);
        }

        public int getTextRunCursor(int contextStart, int contextEnd, int flags, int offset, int cursorOpt, Paint p) {
            int contextCount = contextEnd - contextStart;
            return p.getTextRunCursor(this.mChars, contextStart + this.mStart, contextCount, flags, offset + this.mStart, cursorOpt);
        }

        static /* synthetic */ char[] access$002(CharWrapper x0, char[] x1) {
            x0.mChars = x1;
            return x1;
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        int selStart;
        int selEnd;
        CharSequence text;
        boolean frozenWithFocus;
        CharSequence error;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.selStart);
            out.writeInt(this.selEnd);
            out.writeInt(this.frozenWithFocus ? 1 : 0);
            TextUtils.writeToParcel(this.text, out, flags);
            if (this.error == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                TextUtils.writeToParcel(this.error, out, flags);
            }
        }

        public String toString() {
            String str = "TextView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " start=" + this.selStart + " end=" + this.selEnd;
            if (this.text != null) {
                str = str + " text=" + this.text;
            }
            return str + "}";
        }

        private SavedState(Parcel in) {
            super(in);
            this.selStart = in.readInt();
            this.selEnd = in.readInt();
            this.frozenWithFocus = in.readInt() != 0;
            this.text = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            if (in.readInt() != 0) {
                this.error = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BufferType {
        NORMAL,
        SPANNABLE,
        EDITABLE;

    }

    public static interface OnEditorActionListener {
        public boolean onEditorAction(TextView var1, int var2, KeyEvent var3);
    }

    static class Drawables {
        static final int DRAWABLE_NONE = -1;
        static final int DRAWABLE_RIGHT = 0;
        static final int DRAWABLE_LEFT = 1;
        final Rect mCompoundRect = new Rect();
        Drawable mDrawableTop;
        Drawable mDrawableBottom;
        Drawable mDrawableLeft;
        Drawable mDrawableRight;
        Drawable mDrawableStart;
        Drawable mDrawableEnd;
        Drawable mDrawableError;
        Drawable mDrawableTemp;
        Drawable mDrawableLeftInitial;
        Drawable mDrawableRightInitial;
        boolean mIsRtlCompatibilityMode;
        boolean mOverride;
        int mDrawableSizeTop;
        int mDrawableSizeBottom;
        int mDrawableSizeLeft;
        int mDrawableSizeRight;
        int mDrawableSizeStart;
        int mDrawableSizeEnd;
        int mDrawableSizeError;
        int mDrawableSizeTemp;
        int mDrawableWidthTop;
        int mDrawableWidthBottom;
        int mDrawableHeightLeft;
        int mDrawableHeightRight;
        int mDrawableHeightStart;
        int mDrawableHeightEnd;
        int mDrawableHeightError;
        int mDrawableHeightTemp;
        int mDrawablePadding;
        int mDrawableSaved = -1;

        public Drawables(Context context) {
            int targetSdkVersion = context.getApplicationInfo().targetSdkVersion;
            this.mIsRtlCompatibilityMode = targetSdkVersion < 17 || !context.getApplicationInfo().hasRtlSupport();
            this.mOverride = false;
        }

        public void resolveWithLayoutDirection(int layoutDirection) {
            this.mDrawableLeft = this.mDrawableLeftInitial;
            this.mDrawableRight = this.mDrawableRightInitial;
            if (this.mIsRtlCompatibilityMode) {
                if (this.mDrawableStart != null && this.mDrawableLeft == null) {
                    this.mDrawableLeft = this.mDrawableStart;
                    this.mDrawableSizeLeft = this.mDrawableSizeStart;
                    this.mDrawableHeightLeft = this.mDrawableHeightStart;
                }
                if (this.mDrawableEnd != null && this.mDrawableRight == null) {
                    this.mDrawableRight = this.mDrawableEnd;
                    this.mDrawableSizeRight = this.mDrawableSizeEnd;
                    this.mDrawableHeightRight = this.mDrawableHeightEnd;
                }
            } else {
                switch (layoutDirection) {
                    case 1: {
                        if (!this.mOverride) break;
                        this.mDrawableRight = this.mDrawableStart;
                        this.mDrawableSizeRight = this.mDrawableSizeStart;
                        this.mDrawableHeightRight = this.mDrawableHeightStart;
                        this.mDrawableLeft = this.mDrawableEnd;
                        this.mDrawableSizeLeft = this.mDrawableSizeEnd;
                        this.mDrawableHeightLeft = this.mDrawableHeightEnd;
                        break;
                    }
                    default: {
                        if (!this.mOverride) break;
                        this.mDrawableLeft = this.mDrawableStart;
                        this.mDrawableSizeLeft = this.mDrawableSizeStart;
                        this.mDrawableHeightLeft = this.mDrawableHeightStart;
                        this.mDrawableRight = this.mDrawableEnd;
                        this.mDrawableSizeRight = this.mDrawableSizeEnd;
                        this.mDrawableHeightRight = this.mDrawableHeightEnd;
                    }
                }
            }
            this.applyErrorDrawableIfNeeded(layoutDirection);
            this.updateDrawablesLayoutDirection(layoutDirection);
        }

        private void updateDrawablesLayoutDirection(int layoutDirection) {
            if (this.mDrawableLeft != null) {
                this.mDrawableLeft.setLayoutDirection(layoutDirection);
            }
            if (this.mDrawableRight != null) {
                this.mDrawableRight.setLayoutDirection(layoutDirection);
            }
            if (this.mDrawableTop != null) {
                this.mDrawableTop.setLayoutDirection(layoutDirection);
            }
            if (this.mDrawableBottom != null) {
                this.mDrawableBottom.setLayoutDirection(layoutDirection);
            }
        }

        public void setErrorDrawable(Drawable dr, TextView tv) {
            if (this.mDrawableError != dr && this.mDrawableError != null) {
                this.mDrawableError.setCallback(null);
            }
            this.mDrawableError = dr;
            Rect compoundRect = this.mCompoundRect;
            int[] state = tv.getDrawableState();
            if (this.mDrawableError != null) {
                this.mDrawableError.setState(state);
                this.mDrawableError.copyBounds(compoundRect);
                this.mDrawableError.setCallback(tv);
                this.mDrawableSizeError = compoundRect.width();
                this.mDrawableHeightError = compoundRect.height();
            } else {
                this.mDrawableHeightError = 0;
                this.mDrawableSizeError = 0;
            }
        }

        private void applyErrorDrawableIfNeeded(int layoutDirection) {
            switch (this.mDrawableSaved) {
                case 1: {
                    this.mDrawableLeft = this.mDrawableTemp;
                    this.mDrawableSizeLeft = this.mDrawableSizeTemp;
                    this.mDrawableHeightLeft = this.mDrawableHeightTemp;
                    break;
                }
                case 0: {
                    this.mDrawableRight = this.mDrawableTemp;
                    this.mDrawableSizeRight = this.mDrawableSizeTemp;
                    this.mDrawableHeightRight = this.mDrawableHeightTemp;
                    break;
                }
            }
            if (this.mDrawableError != null) {
                switch (layoutDirection) {
                    case 1: {
                        this.mDrawableSaved = 1;
                        this.mDrawableTemp = this.mDrawableLeft;
                        this.mDrawableSizeTemp = this.mDrawableSizeLeft;
                        this.mDrawableHeightTemp = this.mDrawableHeightLeft;
                        this.mDrawableLeft = this.mDrawableError;
                        this.mDrawableSizeLeft = this.mDrawableSizeError;
                        this.mDrawableHeightLeft = this.mDrawableHeightError;
                        break;
                    }
                    default: {
                        this.mDrawableSaved = 0;
                        this.mDrawableTemp = this.mDrawableRight;
                        this.mDrawableSizeTemp = this.mDrawableSizeRight;
                        this.mDrawableHeightTemp = this.mDrawableHeightRight;
                        this.mDrawableRight = this.mDrawableError;
                        this.mDrawableSizeRight = this.mDrawableSizeError;
                        this.mDrawableHeightRight = this.mDrawableHeightError;
                    }
                }
            }
        }
    }
}

