/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.internal.util.ArrayUtils;
import libcore.util.EmptyArray;

public class LongArray
implements Cloneable {
    private static final int MIN_CAPACITY_INCREMENT = 12;
    private long[] mValues;
    private int mSize;

    public LongArray() {
        this(10);
    }

    public LongArray(int initialCapacity) {
        this.mValues = initialCapacity == 0 ? EmptyArray.LONG : ArrayUtils.newUnpaddedLongArray((int)initialCapacity);
        this.mSize = 0;
    }

    public void add(long value) {
        this.add(this.mSize, value);
    }

    public void add(int index, long value) {
        if (index < 0 || index > this.mSize) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(1);
        if (this.mSize - index != 0) {
            System.arraycopy((long[])this.mValues, (int)index, (long[])this.mValues, (int)(index + 1), (int)(this.mSize - index));
        }
        this.mValues[index] = value;
        ++this.mSize;
    }

    public void addAll(LongArray values) {
        int count = values.mSize;
        this.ensureCapacity(count);
        System.arraycopy((long[])values.mValues, (int)0, (long[])this.mValues, (int)this.mSize, (int)count);
        this.mSize += count;
    }

    private void ensureCapacity(int count) {
        int currentSize = this.mSize;
        int minCapacity = currentSize + count;
        if (minCapacity >= this.mValues.length) {
            int targetCap = currentSize + (currentSize < 6 ? 12 : currentSize >> 1);
            int newCapacity = targetCap > minCapacity ? targetCap : minCapacity;
            long[] newValues = ArrayUtils.newUnpaddedLongArray((int)newCapacity);
            System.arraycopy((long[])this.mValues, (int)0, (long[])newValues, (int)0, (int)currentSize);
            this.mValues = newValues;
        }
    }

    public void clear() {
        this.mSize = 0;
    }

    public LongArray clone() {
        LongArray clone = null;
        try {
            clone = (LongArray)super.clone();
            clone.mValues = (long[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public long get(int index) {
        if (index >= this.mSize) {
            throw new ArrayIndexOutOfBoundsException(this.mSize, index);
        }
        return this.mValues[index];
    }

    public int indexOf(long value) {
        int n = this.mSize;
        for (int i = 0; i < n; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void remove(int index) {
        if (index >= this.mSize) {
            throw new ArrayIndexOutOfBoundsException(this.mSize, index);
        }
        System.arraycopy((long[])this.mValues, (int)(index + 1), (long[])this.mValues, (int)index, (int)(this.mSize - index - 1));
        --this.mSize;
    }

    public int size() {
        return this.mSize;
    }
}

