/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.Intent;
import android.net.Uri;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.BaseColumns;
import android.telephony.Rlog;
import android.telephony.SubInfoRecord;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.ISub;
import java.util.ArrayList;
import java.util.List;

public class SubscriptionManager
implements BaseColumns {
    private static final String LOG_TAG = "SUB";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    public static final int INVALID_PHONE_ID = -1000;
    public static final int DEFAULT_PHONE_ID = Integer.MAX_VALUE;
    public static final int INVALID_SLOT_ID = -1000;
    public static final int DEFAULT_SLOT_ID = Integer.MAX_VALUE;
    public static final long ASK_USER_SUB_ID = -1001L;
    public static final long INVALID_SUB_ID = -1000L;
    public static final long DEFAULT_SUB_ID = Long.MAX_VALUE;
    public static final Uri CONTENT_URI = Uri.parse("content://telephony/siminfo");
    public static final int DEFAULT_INT_VALUE = -100;
    public static final String DEFAULT_STRING_VALUE = "N/A";
    public static final int EXTRA_VALUE_NEW_SIM = 1;
    public static final int EXTRA_VALUE_REMOVE_SIM = 2;
    public static final int EXTRA_VALUE_REPOSITION_SIM = 3;
    public static final int EXTRA_VALUE_NOCHANGE = 4;
    public static final String INTENT_KEY_DETECT_STATUS = "simDetectStatus";
    public static final String INTENT_KEY_SIM_COUNT = "simCount";
    public static final String INTENT_KEY_NEW_SIM_SLOT = "newSIMSlot";
    public static final String INTENT_KEY_NEW_SIM_STATUS = "newSIMStatus";
    public static final String ICC_ID = "icc_id";
    public static final String SIM_ID = "sim_id";
    public static final int SIM_NOT_INSERTED = -1;
    public static final String DISPLAY_NAME = "display_name";
    public static final int DEFAULT_NAME_RES = 17039374;
    public static final String NAME_SOURCE = "name_source";
    public static final int NAME_SOURCE_UNDEFINDED = -1;
    public static final int NAME_SOURCE_DEFAULT_SOURCE = 0;
    public static final int NAME_SOURCE_SIM_SOURCE = 1;
    public static final int NAME_SOURCE_USER_INPUT = 2;
    public static final String COLOR = "color";
    public static final int COLOR_1 = 0;
    public static final int COLOR_2 = 1;
    public static final int COLOR_3 = 2;
    public static final int COLOR_4 = 3;
    public static final int COLOR_DEFAULT = 0;
    public static final String NUMBER = "number";
    public static final String DISPLAY_NUMBER_FORMAT = "display_number_format";
    public static final int DISPLAY_NUMBER_NONE = 0;
    public static final int DISPLAY_NUMBER_FIRST = 1;
    public static final int DISPLAY_NUMBER_LAST = 2;
    public static final int DISLPAY_NUMBER_DEFAULT = 1;
    public static final String DATA_ROAMING = "data_roaming";
    public static final int DATA_ROAMING_ENABLE = 1;
    public static final int DATA_ROAMING_DISABLE = 0;
    public static final int DATA_ROAMING_DEFAULT = 0;
    public static final String MCC = "mcc";
    public static final String MNC = "mnc";
    private static final int RES_TYPE_BACKGROUND_DARK = 0;
    private static final int RES_TYPE_BACKGROUND_LIGHT = 1;
    private static final int[] sSimBackgroundDarkRes = SubscriptionManager.setSimResource(0);
    public static final String SUB_DEFAULT_CHANGED_ACTION = "android.intent.action.SUB_DEFAULT_CHANGED";

    public SubscriptionManager() {
        SubscriptionManager.logd("SubscriptionManager created");
    }

    public static SubInfoRecord getSubInfoForSubscriber(long subId) {
        if (!SubscriptionManager.isValidSubId(subId)) {
            SubscriptionManager.logd("[getSubInfoForSubscriberx]- invalid subId");
            return null;
        }
        SubInfoRecord subInfo = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subInfo = iSub.getSubInfoForSubscriber(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subInfo;
    }

    public static List<SubInfoRecord> getSubInfoUsingIccId(String iccId) {
        if (iccId == null) {
            SubscriptionManager.logd("[getSubInfoUsingIccId]- null iccid");
            return null;
        }
        List<Object> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getSubInfoUsingIccId(iccId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    public static List<SubInfoRecord> getSubInfoUsingSlotId(int slotId) {
        if (!SubscriptionManager.isValidSlotId(slotId)) {
            SubscriptionManager.logd("[getSubInfoUsingSlotId]- invalid slotId");
            return null;
        }
        List<Object> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getSubInfoUsingSlotId(slotId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    public static List<SubInfoRecord> getAllSubInfoList() {
        List<Object> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAllSubInfoList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    public static List<SubInfoRecord> getActiveSubInfoList() {
        List<Object> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubInfoList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    public static int getAllSubInfoCount() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAllSubInfoCount();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public static int getActiveSubInfoCount() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubInfoCount();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public static Uri addSubInfoRecord(String iccId, int slotId) {
        if (iccId == null) {
            SubscriptionManager.logd("[addSubInfoRecord]- null iccId");
        }
        if (!SubscriptionManager.isValidSlotId(slotId)) {
            SubscriptionManager.logd("[addSubInfoRecord]- invalid slotId");
        }
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.addSubInfoRecord(iccId, slotId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public static int setColor(int color2, long subId) {
        int size = sSimBackgroundDarkRes.length;
        if (!SubscriptionManager.isValidSubId(subId) || color2 < 0 || color2 >= size) {
            SubscriptionManager.logd("[setColor]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setColor(color2, subId);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return result;
    }

    public static int setDisplayName(String displayName, long subId) {
        return SubscriptionManager.setDisplayName(displayName, subId, -1L);
    }

    public static int setDisplayName(String displayName, long subId, long nameSource) {
        if (!SubscriptionManager.isValidSubId(subId)) {
            SubscriptionManager.logd("[setDisplayName]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDisplayNameUsingSrc(displayName, subId, nameSource);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return result;
    }

    public static int setDisplayNumber(String number, long subId) {
        if (number == null || !SubscriptionManager.isValidSubId(subId)) {
            SubscriptionManager.logd("[setDisplayNumber]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDisplayNumber(number, subId);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return result;
    }

    public static int setDisplayNumberFormat(int format, long subId) {
        if (format < 0 || !SubscriptionManager.isValidSubId(subId)) {
            SubscriptionManager.logd("[setDisplayNumberFormat]- fail, return -1");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDisplayNumberFormat(format, subId);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return result;
    }

    public static int setDataRoaming(int roaming, long subId) {
        if (roaming < 0 || !SubscriptionManager.isValidSubId(subId)) {
            SubscriptionManager.logd("[setDataRoaming]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDataRoaming(roaming, subId);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return result;
    }

    public static int getSlotId(long subId) {
        if (!SubscriptionManager.isValidSubId(subId)) {
            SubscriptionManager.logd("[getSlotId]- fail");
        }
        int result = -1000;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getSlotId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public static long[] getSubId(int slotId) {
        if (!SubscriptionManager.isValidSlotId(slotId)) {
            SubscriptionManager.logd("[getSubId]- fail");
            return null;
        }
        long[] subId = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getSubId(slotId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public static int getPhoneId(long subId) {
        if (!SubscriptionManager.isValidSubId(subId)) {
            SubscriptionManager.logd("[getPhoneId]- fail");
            return -1000;
        }
        int result = -1000;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getPhoneId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static int[] setSimResource(int type) {
        int[] simResource = null;
        switch (type) {
            case 0: {
                simResource = new int[]{17303045, 17303047, 17303046, 17303048};
                break;
            }
            case 1: {
                simResource = new int[]{17303049, 17303051, 17303050, 17303052};
            }
        }
        return simResource;
    }

    private static void logd(String msg) {
        Rlog.d(LOG_TAG, "[SubManager] " + msg);
    }

    public static long getDefaultSubId() {
        long subId = -1000L;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public static long getDefaultVoiceSubId() {
        long subId = -1000L;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultVoiceSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public static void setDefaultVoiceSubId(long subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultVoiceSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static SubInfoRecord getDefaultVoiceSubInfo() {
        return SubscriptionManager.getSubInfoForSubscriber(SubscriptionManager.getDefaultVoiceSubId());
    }

    public static int getDefaultVoicePhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultVoiceSubId());
    }

    public static long getDefaultSmsSubId() {
        long subId = -1000L;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultSmsSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public static void setDefaultSmsSubId(long subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultSmsSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static SubInfoRecord getDefaultSmsSubInfo() {
        return SubscriptionManager.getSubInfoForSubscriber(SubscriptionManager.getDefaultSmsSubId());
    }

    public static int getDefaultSmsPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultSmsSubId());
    }

    public static long getDefaultDataSubId() {
        long subId = -1000L;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultDataSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    public static void setDefaultDataSubId(long subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultDataSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static SubInfoRecord getDefaultDataSubInfo() {
        return SubscriptionManager.getSubInfoForSubscriber(SubscriptionManager.getDefaultDataSubId());
    }

    public static int getDefaultDataPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultDataSubId());
    }

    public static void clearSubInfo() {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.clearSubInfo();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static boolean allDefaultsSelected() {
        if (SubscriptionManager.getDefaultDataSubId() == -1000L) {
            return false;
        }
        if (SubscriptionManager.getDefaultSmsSubId() == -1000L) {
            return false;
        }
        return SubscriptionManager.getDefaultVoiceSubId() != -1000L;
    }

    public static void clearDefaultsForInactiveSubIds() {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.clearDefaultsForInactiveSubIds();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static boolean isValidSubId(long subId) {
        return subId > -1000L;
    }

    public static boolean isValidSlotId(int slotId) {
        return slotId != -1000 && slotId >= 0 && slotId < TelephonyManager.getDefault().getSimCount();
    }

    public static boolean isValidPhoneId(int phoneId) {
        return phoneId != -1000 && phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount();
    }

    public static void putPhoneIdAndSubIdExtra(Intent intent, int phoneId) {
        long[] subIds = SubscriptionManager.getSubId(phoneId);
        if (subIds != null && subIds.length > 0) {
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId, subIds[0]);
        } else {
            SubscriptionManager.logd("putPhoneIdAndSubIdExtra: no valid subs");
        }
    }

    public static void putPhoneIdAndSubIdExtra(Intent intent, int phoneId, long subId) {
        intent.putExtra("subscription", subId);
        intent.putExtra("phone", phoneId);
        intent.putExtra("slot", phoneId);
    }

    public static long[] getActiveSubIdList() {
        long[] subId = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getActiveSubIdList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (subId == null) {
            subId = new long[]{};
        }
        return subId;
    }
}

