/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.security.Credentials;
import android.security.KeyStore;
import android.security.KeyStoreParameter;
import android.util.Log;
import com.android.org.conscrypt.OpenSSLEngine;
import com.android.org.conscrypt.OpenSSLKeyHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidKeyStore
extends KeyStoreSpi {
    public static final String NAME = "AndroidKeyStore";
    private KeyStore mKeyStore;

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (!this.isKeyEntry(alias)) {
            return null;
        }
        OpenSSLEngine engine = OpenSSLEngine.getInstance("keystore");
        try {
            return engine.getPrivateKeyById("USRPKEY_" + alias);
        }
        catch (InvalidKeyException e) {
            UnrecoverableKeyException t = new UnrecoverableKeyException("Can't get key");
            t.initCause(e);
            throw t;
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] caList;
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        X509Certificate leaf = (X509Certificate)this.engineGetCertificate(alias);
        if (leaf == null) {
            return null;
        }
        byte[] caBytes = this.mKeyStore.get("CACERT_" + alias);
        if (caBytes != null) {
            Collection<X509Certificate> caChain = AndroidKeyStore.toCertificates(caBytes);
            caList = new Certificate[caChain.size() + 1];
            Iterator<X509Certificate> it = caChain.iterator();
            int i = 1;
            while (it.hasNext()) {
                caList[i++] = it.next();
            }
        } else {
            caList = new Certificate[]{leaf};
        }
        return caList;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        byte[] certificate = this.mKeyStore.get("USRCERT_" + alias);
        if (certificate != null) {
            return AndroidKeyStore.toCertificate(certificate);
        }
        certificate = this.mKeyStore.get("CACERT_" + alias);
        if (certificate != null) {
            return AndroidKeyStore.toCertificate(certificate);
        }
        return null;
    }

    private static X509Certificate toCertificate(byte[] bytes) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            Log.w(NAME, "Couldn't parse certificate in keystore", e);
            return null;
        }
    }

    private static Collection<X509Certificate> toCertificates(byte[] bytes) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            return certFactory.generateCertificates(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            Log.w(NAME, "Couldn't parse certificates in keystore", e);
            return new ArrayList<X509Certificate>();
        }
    }

    private Date getModificationDate(String alias) {
        long epochMillis = this.mKeyStore.getmtime(alias);
        if (epochMillis == -1L) {
            return null;
        }
        return new Date(epochMillis);
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        Date d = this.getModificationDate("USRPKEY_" + alias);
        if (d != null) {
            return d;
        }
        d = this.getModificationDate("USRCERT_" + alias);
        if (d != null) {
            return d;
        }
        return this.getModificationDate("CACERT_" + alias);
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (password != null && password.length > 0) {
            throw new KeyStoreException("entries cannot be protected with passwords");
        }
        if (!(key instanceof PrivateKey)) {
            throw new KeyStoreException("Only PrivateKeys are supported");
        }
        this.setPrivateKeyEntry(alias, (PrivateKey)key, chain, null);
    }

    private void setPrivateKeyEntry(String alias, PrivateKey key, Certificate[] chain, KeyStoreParameter params) throws KeyStoreException {
        int flags;
        byte[] chainBytes;
        byte[] userCertBytes;
        boolean shouldReplacePrivateKey;
        byte[] keyBytes = null;
        String pkeyAlias = key instanceof OpenSSLKeyHolder ? ((OpenSSLKeyHolder)((Object)key)).getOpenSSLKey().getAlias() : null;
        if (pkeyAlias != null && pkeyAlias.startsWith("USRPKEY_")) {
            String keySubalias = pkeyAlias.substring("USRPKEY_".length());
            if (!alias.equals(keySubalias)) {
                throw new KeyStoreException("Can only replace keys with same alias: " + alias + " != " + keySubalias);
            }
            shouldReplacePrivateKey = false;
        } else {
            String keyFormat = key.getFormat();
            if (keyFormat == null || !"PKCS#8".equals(keyFormat)) {
                throw new KeyStoreException("Only PrivateKeys that can be encoded into PKCS#8 are supported");
            }
            keyBytes = key.getEncoded();
            if (keyBytes == null) {
                throw new KeyStoreException("PrivateKey has no encoding");
            }
            shouldReplacePrivateKey = true;
        }
        if (chain == null || chain.length == 0) {
            throw new KeyStoreException("Must supply at least one Certificate with PrivateKey");
        }
        X509Certificate[] x509chain = new X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            if (!"X.509".equals(chain[i].getType())) {
                throw new KeyStoreException("Certificates must be in X.509 format: invalid cert #" + i);
            }
            if (!(chain[i] instanceof X509Certificate)) {
                throw new KeyStoreException("Certificates must be in X.509 format: invalid cert #" + i);
            }
            x509chain[i] = (X509Certificate)chain[i];
        }
        try {
            userCertBytes = x509chain[0].getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new KeyStoreException("Couldn't encode certificate #1", e);
        }
        if (chain.length > 1) {
            byte[][] certsBytes = new byte[x509chain.length - 1][];
            int totalCertLength = 0;
            for (int i = 0; i < certsBytes.length; ++i) {
                try {
                    certsBytes[i] = x509chain[i + 1].getEncoded();
                    totalCertLength += certsBytes[i].length;
                    continue;
                }
                catch (CertificateEncodingException e) {
                    throw new KeyStoreException("Can't encode Certificate #" + i, e);
                }
            }
            chainBytes = new byte[totalCertLength];
            int outputOffset = 0;
            for (int i = 0; i < certsBytes.length; ++i) {
                int certLength = certsBytes[i].length;
                System.arraycopy(certsBytes[i], 0, chainBytes, outputOffset, certLength);
                outputOffset += certLength;
                certsBytes[i] = null;
            }
        } else {
            chainBytes = null;
        }
        if (shouldReplacePrivateKey) {
            Credentials.deleteAllTypesForAlias(this.mKeyStore, alias);
        } else {
            Credentials.deleteCertificateTypesForAlias(this.mKeyStore, alias);
        }
        int n = flags = params == null ? 0 : params.getFlags();
        if (shouldReplacePrivateKey && !this.mKeyStore.importKey("USRPKEY_" + alias, keyBytes, -1, flags)) {
            Credentials.deleteAllTypesForAlias(this.mKeyStore, alias);
            throw new KeyStoreException("Couldn't put private key in keystore");
        }
        if (!this.mKeyStore.put("USRCERT_" + alias, userCertBytes, -1, flags)) {
            Credentials.deleteAllTypesForAlias(this.mKeyStore, alias);
            throw new KeyStoreException("Couldn't put certificate #1 in keystore");
        }
        if (chainBytes != null && !this.mKeyStore.put("CACERT_" + alias, chainBytes, -1, flags)) {
            Credentials.deleteAllTypesForAlias(this.mKeyStore, alias);
            throw new KeyStoreException("Couldn't put certificate chain in keystore");
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] userKey, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Operation not supported because key encoding is unknown");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        byte[] encoded;
        if (this.isKeyEntry(alias)) {
            throw new KeyStoreException("Entry exists and is not a trusted certificate");
        }
        if (cert == null) {
            throw new NullPointerException("cert == null");
        }
        try {
            encoded = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new KeyStoreException(e);
        }
        if (!this.mKeyStore.put("CACERT_" + alias, encoded, -1, 0)) {
            throw new KeyStoreException("Couldn't insert certificate; is KeyStore initialized?");
        }
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (!this.isKeyEntry(alias) && !this.isCertificateEntry(alias)) {
            return;
        }
        if (!Credentials.deleteAllTypesForAlias(this.mKeyStore, alias)) {
            throw new KeyStoreException("No such entry " + alias);
        }
    }

    private Set<String> getUniqueAliases() {
        String[] rawAliases = this.mKeyStore.saw("");
        if (rawAliases == null) {
            return new HashSet<String>();
        }
        HashSet<String> aliases = new HashSet<String>(rawAliases.length);
        for (String alias : rawAliases) {
            int idx = alias.indexOf(95);
            if (idx == -1 || alias.length() <= idx) {
                Log.e(NAME, "invalid alias: " + alias);
                continue;
            }
            aliases.add(new String(alias.substring(idx + 1)));
        }
        return aliases;
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.getUniqueAliases());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        return this.mKeyStore.contains("USRPKEY_" + alias) || this.mKeyStore.contains("USRCERT_" + alias) || this.mKeyStore.contains("CACERT_" + alias);
    }

    @Override
    public int engineSize() {
        return this.getUniqueAliases().size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return this.isKeyEntry(alias);
    }

    private boolean isKeyEntry(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        return this.mKeyStore.contains("USRPKEY_" + alias);
    }

    private boolean isCertificateEntry(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        return this.mKeyStore.contains("CACERT_" + alias);
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return !this.isKeyEntry(alias) && this.isCertificateEntry(alias);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (cert == null) {
            return null;
        }
        HashSet<String> nonCaEntries = new HashSet<String>();
        String[] certAliases = this.mKeyStore.saw("USRCERT_");
        if (certAliases != null) {
            for (String alias : certAliases) {
                byte[] certBytes = this.mKeyStore.get("USRCERT_" + alias);
                if (certBytes == null) continue;
                X509Certificate c = AndroidKeyStore.toCertificate(certBytes);
                nonCaEntries.add(alias);
                if (!cert.equals(c)) continue;
                return alias;
            }
        }
        String[] caAliases = this.mKeyStore.saw("CACERT_");
        if (certAliases != null) {
            for (String alias : caAliases) {
                X509Certificate c;
                byte[] certBytes;
                if (nonCaEntries.contains(alias) || (certBytes = this.mKeyStore.get("CACERT_" + alias)) == null || !cert.equals(c = AndroidKeyStore.toCertificate(this.mKeyStore.get("CACERT_" + alias)))) continue;
                return alias;
            }
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new UnsupportedOperationException("Can not serialize AndroidKeyStore to OutputStream");
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream != null) {
            throw new IllegalArgumentException("InputStream not supported");
        }
        if (password != null) {
            throw new IllegalArgumentException("password not supported");
        }
        this.mKeyStore = KeyStore.getInstance();
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter param) throws KeyStoreException {
        if (entry == null) {
            throw new KeyStoreException("entry == null");
        }
        if (this.engineContainsAlias(alias)) {
            this.engineDeleteEntry(alias);
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry trE = (KeyStore.TrustedCertificateEntry)entry;
            this.engineSetCertificateEntry(alias, trE.getTrustedCertificate());
            return;
        }
        if (param != null && !(param instanceof KeyStoreParameter)) {
            throw new KeyStoreException("protParam should be android.security.KeyStoreParameter; was: " + param.getClass().getName());
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry prE = (KeyStore.PrivateKeyEntry)entry;
            this.setPrivateKeyEntry(alias, prE.getPrivateKey(), prE.getCertificateChain(), (KeyStoreParameter)param);
            return;
        }
        throw new KeyStoreException("Entry must be a PrivateKeyEntry or TrustedCertificateEntry; was " + entry);
    }
}

