/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.os.SystemProperties;
import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.ProgramRaster;
import android.renderscript.ProgramStore;
import android.renderscript.RSDriverException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.Sampler;
import android.util.Log;
import android.view.Surface;
import java.io.File;
import java.lang.reflect.Method;

public class RenderScript {
    static final long TRACE_TAG = 32768L;
    static final String LOG_TAG = "RenderScript_jni";
    static final boolean DEBUG = false;
    static final boolean LOG_ENABLED = false;
    private Context mApplicationContext;
    static boolean sInitialized = false;
    static Object sRuntime;
    static Method registerNativeAllocation;
    static Method registerNativeFree;
    static File mCacheDir;
    ContextType mContextType = ContextType.NORMAL;
    int mDev;
    int mContext;
    MessageThread mMessageThread;
    Element mElement_U8;
    Element mElement_I8;
    Element mElement_U16;
    Element mElement_I16;
    Element mElement_U32;
    Element mElement_I32;
    Element mElement_U64;
    Element mElement_I64;
    Element mElement_F32;
    Element mElement_F64;
    Element mElement_BOOLEAN;
    Element mElement_ELEMENT;
    Element mElement_TYPE;
    Element mElement_ALLOCATION;
    Element mElement_SAMPLER;
    Element mElement_SCRIPT;
    Element mElement_MESH;
    Element mElement_PROGRAM_FRAGMENT;
    Element mElement_PROGRAM_VERTEX;
    Element mElement_PROGRAM_RASTER;
    Element mElement_PROGRAM_STORE;
    Element mElement_FONT;
    Element mElement_A_8;
    Element mElement_RGB_565;
    Element mElement_RGB_888;
    Element mElement_RGBA_5551;
    Element mElement_RGBA_4444;
    Element mElement_RGBA_8888;
    Element mElement_FLOAT_2;
    Element mElement_FLOAT_3;
    Element mElement_FLOAT_4;
    Element mElement_DOUBLE_2;
    Element mElement_DOUBLE_3;
    Element mElement_DOUBLE_4;
    Element mElement_UCHAR_2;
    Element mElement_UCHAR_3;
    Element mElement_UCHAR_4;
    Element mElement_CHAR_2;
    Element mElement_CHAR_3;
    Element mElement_CHAR_4;
    Element mElement_USHORT_2;
    Element mElement_USHORT_3;
    Element mElement_USHORT_4;
    Element mElement_SHORT_2;
    Element mElement_SHORT_3;
    Element mElement_SHORT_4;
    Element mElement_UINT_2;
    Element mElement_UINT_3;
    Element mElement_UINT_4;
    Element mElement_INT_2;
    Element mElement_INT_3;
    Element mElement_INT_4;
    Element mElement_ULONG_2;
    Element mElement_ULONG_3;
    Element mElement_ULONG_4;
    Element mElement_LONG_2;
    Element mElement_LONG_3;
    Element mElement_LONG_4;
    Element mElement_YUV;
    Element mElement_MATRIX_4X4;
    Element mElement_MATRIX_3X3;
    Element mElement_MATRIX_2X2;
    Sampler mSampler_CLAMP_NEAREST;
    Sampler mSampler_CLAMP_LINEAR;
    Sampler mSampler_CLAMP_LINEAR_MIP_LINEAR;
    Sampler mSampler_WRAP_NEAREST;
    Sampler mSampler_WRAP_LINEAR;
    Sampler mSampler_WRAP_LINEAR_MIP_LINEAR;
    Sampler mSampler_MIRRORED_REPEAT_NEAREST;
    Sampler mSampler_MIRRORED_REPEAT_LINEAR;
    Sampler mSampler_MIRRORED_REPEAT_LINEAR_MIP_LINEAR;
    ProgramStore mProgramStore_BLEND_NONE_DEPTH_TEST;
    ProgramStore mProgramStore_BLEND_NONE_DEPTH_NO_DEPTH;
    ProgramStore mProgramStore_BLEND_ALPHA_DEPTH_TEST;
    ProgramStore mProgramStore_BLEND_ALPHA_DEPTH_NO_DEPTH;
    ProgramRaster mProgramRaster_CULL_BACK;
    ProgramRaster mProgramRaster_CULL_FRONT;
    ProgramRaster mProgramRaster_CULL_NONE;
    RSMessageHandler mMessageCallback = null;
    RSErrorHandler mErrorCallback = null;

    static native void _nInit();

    native int nDeviceCreate();

    native void nDeviceDestroy(int var1);

    native void nDeviceSetConfig(int var1, int var2, int var3);

    native int nContextGetUserMessage(int var1, int[] var2);

    native String nContextGetErrorMessage(int var1);

    native int nContextPeekMessage(int var1, int[] var2);

    native void nContextInitToClient(int var1);

    native void nContextDeinitToClient(int var1);

    public static void setupDiskCache(File cacheDir) {
        if (!sInitialized) {
            Log.e(LOG_TAG, "RenderScript.setupDiskCache() called when disabled");
            return;
        }
        mCacheDir = cacheDir;
    }

    native int rsnContextCreateGL(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, float var14, int var15);

    synchronized int nContextCreateGL(int dev, int ver, int sdkVer, int colorMin, int colorPref, int alphaMin, int alphaPref, int depthMin, int depthPref, int stencilMin, int stencilPref, int samplesMin, int samplesPref, float samplesQ, int dpi) {
        return this.rsnContextCreateGL(dev, ver, sdkVer, colorMin, colorPref, alphaMin, alphaPref, depthMin, depthPref, stencilMin, stencilPref, samplesMin, samplesPref, samplesQ, dpi);
    }

    native int rsnContextCreate(int var1, int var2, int var3, int var4);

    synchronized int nContextCreate(int dev, int ver, int sdkVer, int contextType) {
        return this.rsnContextCreate(dev, ver, sdkVer, contextType);
    }

    native void rsnContextDestroy(int var1);

    synchronized void nContextDestroy() {
        this.validate();
        this.rsnContextDestroy(this.mContext);
    }

    native void rsnContextSetSurface(int var1, int var2, int var3, Surface var4);

    synchronized void nContextSetSurface(int w, int h, Surface sur) {
        this.validate();
        this.rsnContextSetSurface(this.mContext, w, h, sur);
    }

    native void rsnContextSetSurfaceTexture(int var1, int var2, int var3, SurfaceTexture var4);

    synchronized void nContextSetSurfaceTexture(int w, int h, SurfaceTexture sur) {
        this.validate();
        this.rsnContextSetSurfaceTexture(this.mContext, w, h, sur);
    }

    native void rsnContextSetPriority(int var1, int var2);

    synchronized void nContextSetPriority(int p) {
        this.validate();
        this.rsnContextSetPriority(this.mContext, p);
    }

    native void rsnContextDump(int var1, int var2);

    synchronized void nContextDump(int bits) {
        this.validate();
        this.rsnContextDump(this.mContext, bits);
    }

    native void rsnContextFinish(int var1);

    synchronized void nContextFinish() {
        this.validate();
        this.rsnContextFinish(this.mContext);
    }

    native void rsnContextSendMessage(int var1, int var2, int[] var3);

    synchronized void nContextSendMessage(int id2, int[] data) {
        this.validate();
        this.rsnContextSendMessage(this.mContext, id2, data);
    }

    native void rsnContextBindRootScript(int var1, int var2);

    synchronized void nContextBindRootScript(int script) {
        this.validate();
        this.rsnContextBindRootScript(this.mContext, script);
    }

    native void rsnContextBindSampler(int var1, int var2, int var3);

    synchronized void nContextBindSampler(int sampler, int slot) {
        this.validate();
        this.rsnContextBindSampler(this.mContext, sampler, slot);
    }

    native void rsnContextBindProgramStore(int var1, int var2);

    synchronized void nContextBindProgramStore(int pfs) {
        this.validate();
        this.rsnContextBindProgramStore(this.mContext, pfs);
    }

    native void rsnContextBindProgramFragment(int var1, int var2);

    synchronized void nContextBindProgramFragment(int pf) {
        this.validate();
        this.rsnContextBindProgramFragment(this.mContext, pf);
    }

    native void rsnContextBindProgramVertex(int var1, int var2);

    synchronized void nContextBindProgramVertex(int pv) {
        this.validate();
        this.rsnContextBindProgramVertex(this.mContext, pv);
    }

    native void rsnContextBindProgramRaster(int var1, int var2);

    synchronized void nContextBindProgramRaster(int pr) {
        this.validate();
        this.rsnContextBindProgramRaster(this.mContext, pr);
    }

    native void rsnContextPause(int var1);

    synchronized void nContextPause() {
        this.validate();
        this.rsnContextPause(this.mContext);
    }

    native void rsnContextResume(int var1);

    synchronized void nContextResume() {
        this.validate();
        this.rsnContextResume(this.mContext);
    }

    native void rsnAssignName(int var1, int var2, byte[] var3);

    synchronized void nAssignName(int obj, byte[] name) {
        this.validate();
        this.rsnAssignName(this.mContext, obj, name);
    }

    native String rsnGetName(int var1, int var2);

    synchronized String nGetName(int obj) {
        this.validate();
        return this.rsnGetName(this.mContext, obj);
    }

    native void rsnObjDestroy(int var1, int var2);

    synchronized void nObjDestroy(int id2) {
        if (this.mContext != 0) {
            this.rsnObjDestroy(this.mContext, id2);
        }
    }

    native int rsnElementCreate(int var1, int var2, int var3, boolean var4, int var5);

    synchronized int nElementCreate(int type, int kind, boolean norm, int vecSize) {
        this.validate();
        return this.rsnElementCreate(this.mContext, type, kind, norm, vecSize);
    }

    native int rsnElementCreate2(int var1, int[] var2, String[] var3, int[] var4);

    synchronized int nElementCreate2(int[] elements, String[] names, int[] arraySizes) {
        this.validate();
        return this.rsnElementCreate2(this.mContext, elements, names, arraySizes);
    }

    native void rsnElementGetNativeData(int var1, int var2, int[] var3);

    synchronized void nElementGetNativeData(int id2, int[] elementData) {
        this.validate();
        this.rsnElementGetNativeData(this.mContext, id2, elementData);
    }

    native void rsnElementGetSubElements(int var1, int var2, int[] var3, String[] var4, int[] var5);

    synchronized void nElementGetSubElements(int id2, int[] IDs, String[] names, int[] arraySizes) {
        this.validate();
        this.rsnElementGetSubElements(this.mContext, id2, IDs, names, arraySizes);
    }

    native int rsnTypeCreate(int var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7, int var8);

    synchronized int nTypeCreate(int eid, int x, int y, int z, boolean mips, boolean faces, int yuv) {
        this.validate();
        return this.rsnTypeCreate(this.mContext, eid, x, y, z, mips, faces, yuv);
    }

    native void rsnTypeGetNativeData(int var1, int var2, int[] var3);

    synchronized void nTypeGetNativeData(int id2, int[] typeData) {
        this.validate();
        this.rsnTypeGetNativeData(this.mContext, id2, typeData);
    }

    native int rsnAllocationCreateTyped(int var1, int var2, int var3, int var4, int var5);

    synchronized int nAllocationCreateTyped(int type, int mip, int usage, int pointer) {
        this.validate();
        return this.rsnAllocationCreateTyped(this.mContext, type, mip, usage, pointer);
    }

    native int rsnAllocationCreateFromBitmap(int var1, int var2, int var3, Bitmap var4, int var5);

    synchronized int nAllocationCreateFromBitmap(int type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromBitmap(this.mContext, type, mip, bmp, usage);
    }

    native int rsnAllocationCreateBitmapBackedAllocation(int var1, int var2, int var3, Bitmap var4, int var5);

    synchronized int nAllocationCreateBitmapBackedAllocation(int type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCreateBitmapBackedAllocation(this.mContext, type, mip, bmp, usage);
    }

    native int rsnAllocationCubeCreateFromBitmap(int var1, int var2, int var3, Bitmap var4, int var5);

    synchronized int nAllocationCubeCreateFromBitmap(int type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCubeCreateFromBitmap(this.mContext, type, mip, bmp, usage);
    }

    native int rsnAllocationCreateBitmapRef(int var1, int var2, Bitmap var3);

    synchronized int nAllocationCreateBitmapRef(int type, Bitmap bmp) {
        this.validate();
        return this.rsnAllocationCreateBitmapRef(this.mContext, type, bmp);
    }

    native int rsnAllocationCreateFromAssetStream(int var1, int var2, int var3, int var4);

    synchronized int nAllocationCreateFromAssetStream(int mips, int assetStream, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromAssetStream(this.mContext, mips, assetStream, usage);
    }

    native void rsnAllocationCopyToBitmap(int var1, int var2, Bitmap var3);

    synchronized void nAllocationCopyToBitmap(int alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyToBitmap(this.mContext, alloc, bmp);
    }

    native void rsnAllocationSyncAll(int var1, int var2, int var3);

    synchronized void nAllocationSyncAll(int alloc, int src) {
        this.validate();
        this.rsnAllocationSyncAll(this.mContext, alloc, src);
    }

    native Surface rsnAllocationGetSurface(int var1, int var2);

    synchronized Surface nAllocationGetSurface(int alloc) {
        this.validate();
        return this.rsnAllocationGetSurface(this.mContext, alloc);
    }

    native void rsnAllocationSetSurface(int var1, int var2, Surface var3);

    synchronized void nAllocationSetSurface(int alloc, Surface sur) {
        this.validate();
        this.rsnAllocationSetSurface(this.mContext, alloc, sur);
    }

    native void rsnAllocationIoSend(int var1, int var2);

    synchronized void nAllocationIoSend(int alloc) {
        this.validate();
        this.rsnAllocationIoSend(this.mContext, alloc);
    }

    native void rsnAllocationIoReceive(int var1, int var2);

    synchronized void nAllocationIoReceive(int alloc) {
        this.validate();
        this.rsnAllocationIoReceive(this.mContext, alloc);
    }

    native void rsnAllocationGenerateMipmaps(int var1, int var2);

    synchronized void nAllocationGenerateMipmaps(int alloc) {
        this.validate();
        this.rsnAllocationGenerateMipmaps(this.mContext, alloc);
    }

    native void rsnAllocationCopyFromBitmap(int var1, int var2, Bitmap var3);

    synchronized void nAllocationCopyFromBitmap(int alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyFromBitmap(this.mContext, alloc, bmp);
    }

    native void rsnAllocationData1D(int var1, int var2, int var3, int var4, int var5, int[] var6, int var7);

    synchronized void nAllocationData1D(int id2, int off, int mip, int count, int[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    native void rsnAllocationData1D(int var1, int var2, int var3, int var4, int var5, short[] var6, int var7);

    synchronized void nAllocationData1D(int id2, int off, int mip, int count, short[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    native void rsnAllocationData1D(int var1, int var2, int var3, int var4, int var5, byte[] var6, int var7);

    synchronized void nAllocationData1D(int id2, int off, int mip, int count, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    native void rsnAllocationData1D(int var1, int var2, int var3, int var4, int var5, float[] var6, int var7);

    synchronized void nAllocationData1D(int id2, int off, int mip, int count, float[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    native void rsnAllocationElementData1D(int var1, int var2, int var3, int var4, int var5, byte[] var6, int var7);

    synchronized void nAllocationElementData1D(int id2, int xoff, int mip, int compIdx, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationElementData1D(this.mContext, id2, xoff, mip, compIdx, d, sizeBytes);
    }

    native void rsnAllocationData2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13);

    synchronized void nAllocationData2D(int dstAlloc, int dstXoff, int dstYoff, int dstMip, int dstFace, int width, int height, int srcAlloc, int srcXoff, int srcYoff, int srcMip, int srcFace) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, dstAlloc, dstXoff, dstYoff, dstMip, dstFace, width, height, srcAlloc, srcXoff, srcYoff, srcMip, srcFace);
    }

    native void rsnAllocationData2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, byte[] var9, int var10);

    synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    native void rsnAllocationData2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, short[] var9, int var10);

    synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, short[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    native void rsnAllocationData2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int[] var9, int var10);

    synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, int[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    native void rsnAllocationData2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, float[] var9, int var10);

    synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, float[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    native void rsnAllocationData2D(int var1, int var2, int var3, int var4, int var5, int var6, Bitmap var7);

    synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, Bitmap b) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, b);
    }

    native void rsnAllocationData3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    synchronized void nAllocationData3D(int dstAlloc, int dstXoff, int dstYoff, int dstZoff, int dstMip, int width, int height, int depth, int srcAlloc, int srcXoff, int srcYoff, int srcZoff, int srcMip) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, dstAlloc, dstXoff, dstYoff, dstZoff, dstMip, width, height, depth, srcAlloc, srcXoff, srcYoff, srcZoff, srcMip);
    }

    native void rsnAllocationData3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, byte[] var10, int var11);

    synchronized void nAllocationData3D(int id2, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, id2, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes);
    }

    native void rsnAllocationData3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, short[] var10, int var11);

    synchronized void nAllocationData3D(int id2, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, short[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, id2, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes);
    }

    native void rsnAllocationData3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int[] var10, int var11);

    synchronized void nAllocationData3D(int id2, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, int[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, id2, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes);
    }

    native void rsnAllocationData3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, float[] var10, int var11);

    synchronized void nAllocationData3D(int id2, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, float[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, id2, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes);
    }

    native void rsnAllocationRead(int var1, int var2, byte[] var3);

    synchronized void nAllocationRead(int id2, byte[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    native void rsnAllocationRead(int var1, int var2, short[] var3);

    synchronized void nAllocationRead(int id2, short[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    native void rsnAllocationRead(int var1, int var2, int[] var3);

    synchronized void nAllocationRead(int id2, int[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    native void rsnAllocationRead(int var1, int var2, float[] var3);

    synchronized void nAllocationRead(int id2, float[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    native int rsnAllocationGetType(int var1, int var2);

    synchronized int nAllocationGetType(int id2) {
        this.validate();
        return this.rsnAllocationGetType(this.mContext, id2);
    }

    native void rsnAllocationResize1D(int var1, int var2, int var3);

    synchronized void nAllocationResize1D(int id2, int dimX) {
        this.validate();
        this.rsnAllocationResize1D(this.mContext, id2, dimX);
    }

    native int rsnFileA3DCreateFromAssetStream(int var1, int var2);

    synchronized int nFileA3DCreateFromAssetStream(int assetStream) {
        this.validate();
        return this.rsnFileA3DCreateFromAssetStream(this.mContext, assetStream);
    }

    native int rsnFileA3DCreateFromFile(int var1, String var2);

    synchronized int nFileA3DCreateFromFile(String path) {
        this.validate();
        return this.rsnFileA3DCreateFromFile(this.mContext, path);
    }

    native int rsnFileA3DCreateFromAsset(int var1, AssetManager var2, String var3);

    synchronized int nFileA3DCreateFromAsset(AssetManager mgr, String path) {
        this.validate();
        return this.rsnFileA3DCreateFromAsset(this.mContext, mgr, path);
    }

    native int rsnFileA3DGetNumIndexEntries(int var1, int var2);

    synchronized int nFileA3DGetNumIndexEntries(int fileA3D) {
        this.validate();
        return this.rsnFileA3DGetNumIndexEntries(this.mContext, fileA3D);
    }

    native void rsnFileA3DGetIndexEntries(int var1, int var2, int var3, int[] var4, String[] var5);

    synchronized void nFileA3DGetIndexEntries(int fileA3D, int numEntries, int[] IDs, String[] names) {
        this.validate();
        this.rsnFileA3DGetIndexEntries(this.mContext, fileA3D, numEntries, IDs, names);
    }

    native int rsnFileA3DGetEntryByIndex(int var1, int var2, int var3);

    synchronized int nFileA3DGetEntryByIndex(int fileA3D, int index) {
        this.validate();
        return this.rsnFileA3DGetEntryByIndex(this.mContext, fileA3D, index);
    }

    native int rsnFontCreateFromFile(int var1, String var2, float var3, int var4);

    synchronized int nFontCreateFromFile(String fileName, float size, int dpi) {
        this.validate();
        return this.rsnFontCreateFromFile(this.mContext, fileName, size, dpi);
    }

    native int rsnFontCreateFromAssetStream(int var1, String var2, float var3, int var4, int var5);

    synchronized int nFontCreateFromAssetStream(String name, float size, int dpi, int assetStream) {
        this.validate();
        return this.rsnFontCreateFromAssetStream(this.mContext, name, size, dpi, assetStream);
    }

    native int rsnFontCreateFromAsset(int var1, AssetManager var2, String var3, float var4, int var5);

    synchronized int nFontCreateFromAsset(AssetManager mgr, String path, float size, int dpi) {
        this.validate();
        return this.rsnFontCreateFromAsset(this.mContext, mgr, path, size, dpi);
    }

    native void rsnScriptBindAllocation(int var1, int var2, int var3, int var4);

    synchronized void nScriptBindAllocation(int script, int alloc, int slot) {
        this.validate();
        this.rsnScriptBindAllocation(this.mContext, script, alloc, slot);
    }

    native void rsnScriptSetTimeZone(int var1, int var2, byte[] var3);

    synchronized void nScriptSetTimeZone(int script, byte[] timeZone) {
        this.validate();
        this.rsnScriptSetTimeZone(this.mContext, script, timeZone);
    }

    native void rsnScriptInvoke(int var1, int var2, int var3);

    synchronized void nScriptInvoke(int id2, int slot) {
        this.validate();
        this.rsnScriptInvoke(this.mContext, id2, slot);
    }

    native void rsnScriptForEach(int var1, int var2, int var3, int var4, int var5, byte[] var6);

    native void rsnScriptForEach(int var1, int var2, int var3, int var4, int var5);

    native void rsnScriptForEachClipped(int var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, int var9, int var10, int var11, int var12);

    native void rsnScriptForEachClipped(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    synchronized void nScriptForEach(int id2, int slot, int ain, int aout, byte[] params) {
        this.validate();
        if (params == null) {
            this.rsnScriptForEach(this.mContext, id2, slot, ain, aout);
        } else {
            this.rsnScriptForEach(this.mContext, id2, slot, ain, aout, params);
        }
    }

    synchronized void nScriptForEachClipped(int id2, int slot, int ain, int aout, byte[] params, int xstart, int xend, int ystart, int yend, int zstart, int zend) {
        this.validate();
        if (params == null) {
            this.rsnScriptForEachClipped(this.mContext, id2, slot, ain, aout, xstart, xend, ystart, yend, zstart, zend);
        } else {
            this.rsnScriptForEachClipped(this.mContext, id2, slot, ain, aout, params, xstart, xend, ystart, yend, zstart, zend);
        }
    }

    native void rsnScriptInvokeV(int var1, int var2, int var3, byte[] var4);

    synchronized void nScriptInvokeV(int id2, int slot, byte[] params) {
        this.validate();
        this.rsnScriptInvokeV(this.mContext, id2, slot, params);
    }

    native void rsnScriptSetVarI(int var1, int var2, int var3, int var4);

    synchronized void nScriptSetVarI(int id2, int slot, int val) {
        this.validate();
        this.rsnScriptSetVarI(this.mContext, id2, slot, val);
    }

    native int rsnScriptGetVarI(int var1, int var2, int var3);

    synchronized int nScriptGetVarI(int id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarI(this.mContext, id2, slot);
    }

    native void rsnScriptSetVarJ(int var1, int var2, int var3, long var4);

    synchronized void nScriptSetVarJ(int id2, int slot, long val) {
        this.validate();
        this.rsnScriptSetVarJ(this.mContext, id2, slot, val);
    }

    native long rsnScriptGetVarJ(int var1, int var2, int var3);

    synchronized long nScriptGetVarJ(int id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarJ(this.mContext, id2, slot);
    }

    native void rsnScriptSetVarF(int var1, int var2, int var3, float var4);

    synchronized void nScriptSetVarF(int id2, int slot, float val) {
        this.validate();
        this.rsnScriptSetVarF(this.mContext, id2, slot, val);
    }

    native float rsnScriptGetVarF(int var1, int var2, int var3);

    synchronized float nScriptGetVarF(int id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarF(this.mContext, id2, slot);
    }

    native void rsnScriptSetVarD(int var1, int var2, int var3, double var4);

    synchronized void nScriptSetVarD(int id2, int slot, double val) {
        this.validate();
        this.rsnScriptSetVarD(this.mContext, id2, slot, val);
    }

    native double rsnScriptGetVarD(int var1, int var2, int var3);

    synchronized double nScriptGetVarD(int id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarD(this.mContext, id2, slot);
    }

    native void rsnScriptSetVarV(int var1, int var2, int var3, byte[] var4);

    synchronized void nScriptSetVarV(int id2, int slot, byte[] val) {
        this.validate();
        this.rsnScriptSetVarV(this.mContext, id2, slot, val);
    }

    native void rsnScriptGetVarV(int var1, int var2, int var3, byte[] var4);

    synchronized void nScriptGetVarV(int id2, int slot, byte[] val) {
        this.validate();
        this.rsnScriptGetVarV(this.mContext, id2, slot, val);
    }

    native void rsnScriptSetVarVE(int var1, int var2, int var3, byte[] var4, int var5, int[] var6);

    synchronized void nScriptSetVarVE(int id2, int slot, byte[] val, int e, int[] dims) {
        this.validate();
        this.rsnScriptSetVarVE(this.mContext, id2, slot, val, e, dims);
    }

    native void rsnScriptSetVarObj(int var1, int var2, int var3, int var4);

    synchronized void nScriptSetVarObj(int id2, int slot, int val) {
        this.validate();
        this.rsnScriptSetVarObj(this.mContext, id2, slot, val);
    }

    native int rsnScriptCCreate(int var1, String var2, String var3, byte[] var4, int var5);

    synchronized int nScriptCCreate(String resName, String cacheDir, byte[] script, int length) {
        this.validate();
        return this.rsnScriptCCreate(this.mContext, resName, cacheDir, script, length);
    }

    native int rsnScriptIntrinsicCreate(int var1, int var2, int var3);

    synchronized int nScriptIntrinsicCreate(int id2, int eid) {
        this.validate();
        return this.rsnScriptIntrinsicCreate(this.mContext, id2, eid);
    }

    native int rsnScriptKernelIDCreate(int var1, int var2, int var3, int var4);

    synchronized int nScriptKernelIDCreate(int sid, int slot, int sig) {
        this.validate();
        return this.rsnScriptKernelIDCreate(this.mContext, sid, slot, sig);
    }

    native int rsnScriptFieldIDCreate(int var1, int var2, int var3);

    synchronized int nScriptFieldIDCreate(int sid, int slot) {
        this.validate();
        return this.rsnScriptFieldIDCreate(this.mContext, sid, slot);
    }

    native int rsnScriptGroupCreate(int var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6);

    synchronized int nScriptGroupCreate(int[] kernels, int[] src, int[] dstk, int[] dstf, int[] types) {
        this.validate();
        return this.rsnScriptGroupCreate(this.mContext, kernels, src, dstk, dstf, types);
    }

    native void rsnScriptGroupSetInput(int var1, int var2, int var3, int var4);

    synchronized void nScriptGroupSetInput(int group, int kernel, int alloc) {
        this.validate();
        this.rsnScriptGroupSetInput(this.mContext, group, kernel, alloc);
    }

    native void rsnScriptGroupSetOutput(int var1, int var2, int var3, int var4);

    synchronized void nScriptGroupSetOutput(int group, int kernel, int alloc) {
        this.validate();
        this.rsnScriptGroupSetOutput(this.mContext, group, kernel, alloc);
    }

    native void rsnScriptGroupExecute(int var1, int var2);

    synchronized void nScriptGroupExecute(int group) {
        this.validate();
        this.rsnScriptGroupExecute(this.mContext, group);
    }

    native int rsnSamplerCreate(int var1, int var2, int var3, int var4, int var5, int var6, float var7);

    synchronized int nSamplerCreate(int magFilter, int minFilter, int wrapS, int wrapT, int wrapR, float aniso) {
        this.validate();
        return this.rsnSamplerCreate(this.mContext, magFilter, minFilter, wrapS, wrapT, wrapR, aniso);
    }

    native int rsnProgramStoreCreate(int var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, int var8, int var9, int var10);

    synchronized int nProgramStoreCreate(boolean r, boolean g, boolean b, boolean a, boolean depthMask, boolean dither, int srcMode, int dstMode, int depthFunc) {
        this.validate();
        return this.rsnProgramStoreCreate(this.mContext, r, g, b, a, depthMask, dither, srcMode, dstMode, depthFunc);
    }

    native int rsnProgramRasterCreate(int var1, boolean var2, int var3);

    synchronized int nProgramRasterCreate(boolean pointSprite, int cullMode) {
        this.validate();
        return this.rsnProgramRasterCreate(this.mContext, pointSprite, cullMode);
    }

    native void rsnProgramBindConstants(int var1, int var2, int var3, int var4);

    synchronized void nProgramBindConstants(int pv, int slot, int mID) {
        this.validate();
        this.rsnProgramBindConstants(this.mContext, pv, slot, mID);
    }

    native void rsnProgramBindTexture(int var1, int var2, int var3, int var4);

    synchronized void nProgramBindTexture(int vpf, int slot, int a) {
        this.validate();
        this.rsnProgramBindTexture(this.mContext, vpf, slot, a);
    }

    native void rsnProgramBindSampler(int var1, int var2, int var3, int var4);

    synchronized void nProgramBindSampler(int vpf, int slot, int s) {
        this.validate();
        this.rsnProgramBindSampler(this.mContext, vpf, slot, s);
    }

    native int rsnProgramFragmentCreate(int var1, String var2, String[] var3, int[] var4);

    synchronized int nProgramFragmentCreate(String shader, String[] texNames, int[] params) {
        this.validate();
        return this.rsnProgramFragmentCreate(this.mContext, shader, texNames, params);
    }

    native int rsnProgramVertexCreate(int var1, String var2, String[] var3, int[] var4);

    synchronized int nProgramVertexCreate(String shader, String[] texNames, int[] params) {
        this.validate();
        return this.rsnProgramVertexCreate(this.mContext, shader, texNames, params);
    }

    native int rsnMeshCreate(int var1, int[] var2, int[] var3, int[] var4);

    synchronized int nMeshCreate(int[] vtx, int[] idx, int[] prim) {
        this.validate();
        return this.rsnMeshCreate(this.mContext, vtx, idx, prim);
    }

    native int rsnMeshGetVertexBufferCount(int var1, int var2);

    synchronized int nMeshGetVertexBufferCount(int id2) {
        this.validate();
        return this.rsnMeshGetVertexBufferCount(this.mContext, id2);
    }

    native int rsnMeshGetIndexCount(int var1, int var2);

    synchronized int nMeshGetIndexCount(int id2) {
        this.validate();
        return this.rsnMeshGetIndexCount(this.mContext, id2);
    }

    native void rsnMeshGetVertices(int var1, int var2, int[] var3, int var4);

    synchronized void nMeshGetVertices(int id2, int[] vtxIds, int vtxIdCount) {
        this.validate();
        this.rsnMeshGetVertices(this.mContext, id2, vtxIds, vtxIdCount);
    }

    native void rsnMeshGetIndices(int var1, int var2, int[] var3, int[] var4, int var5);

    synchronized void nMeshGetIndices(int id2, int[] idxIds, int[] primitives, int vtxIdCount) {
        this.validate();
        this.rsnMeshGetIndices(this.mContext, id2, idxIds, primitives, vtxIdCount);
    }

    native int rsnPathCreate(int var1, int var2, boolean var3, int var4, int var5, float var6);

    synchronized int nPathCreate(int prim, boolean isStatic, int vtx, int loop, float q) {
        this.validate();
        return this.rsnPathCreate(this.mContext, prim, isStatic, vtx, loop, q);
    }

    public void setMessageHandler(RSMessageHandler msg) {
        this.mMessageCallback = msg;
    }

    public RSMessageHandler getMessageHandler() {
        return this.mMessageCallback;
    }

    public void sendMessage(int id2, int[] data) {
        this.nContextSendMessage(id2, data);
    }

    public void setErrorHandler(RSErrorHandler msg) {
        this.mErrorCallback = msg;
    }

    public RSErrorHandler getErrorHandler() {
        return this.mErrorCallback;
    }

    void validate() {
        if (this.mContext == 0) {
            throw new RSInvalidStateException("Calling RS with no Context active.");
        }
    }

    public void setPriority(Priority p) {
        this.validate();
        this.nContextSetPriority(p.mID);
    }

    RenderScript(Context ctx) {
        if (ctx != null) {
            this.mApplicationContext = ctx.getApplicationContext();
        }
    }

    public final Context getApplicationContext() {
        return this.mApplicationContext;
    }

    public static RenderScript create(Context ctx, int sdkVersion) {
        return RenderScript.create(ctx, sdkVersion, ContextType.NORMAL);
    }

    public static RenderScript create(Context ctx, int sdkVersion, ContextType ct) {
        if (!sInitialized) {
            Log.e(LOG_TAG, "RenderScript.create() called when disabled; someone is likely to crash");
            return null;
        }
        RenderScript rs = new RenderScript(ctx);
        rs.mDev = rs.nDeviceCreate();
        rs.mContext = rs.nContextCreate(rs.mDev, 0, sdkVersion, ct.mID);
        rs.mContextType = ct;
        if (rs.mContext == 0) {
            throw new RSDriverException("Failed to create RS context.");
        }
        rs.mMessageThread = new MessageThread(rs);
        rs.mMessageThread.start();
        return rs;
    }

    public static RenderScript create(Context ctx) {
        return RenderScript.create(ctx, ContextType.NORMAL);
    }

    public static RenderScript create(Context ctx, ContextType ct) {
        int v = ctx.getApplicationInfo().targetSdkVersion;
        return RenderScript.create(ctx, v, ct);
    }

    public void contextDump() {
        this.validate();
        this.nContextDump(0);
    }

    public void finish() {
        this.nContextFinish();
    }

    public void destroy() {
        this.validate();
        this.nContextDeinitToClient(this.mContext);
        this.mMessageThread.mRun = false;
        try {
            this.mMessageThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.nContextDestroy();
        this.mContext = 0;
        this.nDeviceDestroy(this.mDev);
        this.mDev = 0;
    }

    boolean isAlive() {
        return this.mContext != 0;
    }

    int safeID(BaseObj o) {
        if (o != null) {
            return o.getID(this);
        }
        return 0;
    }

    static {
        if (!SystemProperties.getBoolean("config.disable_renderscript", false)) {
            try {
                Class<?> vm_runtime = Class.forName("dalvik.system.VMRuntime");
                Method get_runtime = vm_runtime.getDeclaredMethod("getRuntime", new Class[0]);
                sRuntime = get_runtime.invoke(null, new Object[0]);
                registerNativeAllocation = vm_runtime.getDeclaredMethod("registerNativeAllocation", Integer.TYPE);
                registerNativeFree = vm_runtime.getDeclaredMethod("registerNativeFree", Integer.TYPE);
            }
            catch (Exception e) {
                Log.e(LOG_TAG, "Error loading GC methods: " + e);
                throw new RSRuntimeException("Error loading GC methods: " + e);
            }
            try {
                System.loadLibrary("rs_jni");
                RenderScript._nInit();
                sInitialized = true;
            }
            catch (UnsatisfiedLinkError e) {
                Log.e(LOG_TAG, "Error loading RS jni library: " + e);
                throw new RSRuntimeException("Error loading RS jni library: " + e);
            }
        }
    }

    static class MessageThread
    extends Thread {
        RenderScript mRS;
        boolean mRun = true;
        int[] mAuxData = new int[2];
        static final int RS_MESSAGE_TO_CLIENT_NONE = 0;
        static final int RS_MESSAGE_TO_CLIENT_EXCEPTION = 1;
        static final int RS_MESSAGE_TO_CLIENT_RESIZE = 2;
        static final int RS_MESSAGE_TO_CLIENT_ERROR = 3;
        static final int RS_MESSAGE_TO_CLIENT_USER = 4;
        static final int RS_MESSAGE_TO_CLIENT_NEW_BUFFER = 5;
        static final int RS_ERROR_FATAL_DEBUG = 2048;
        static final int RS_ERROR_FATAL_UNKNOWN = 4096;

        MessageThread(RenderScript rs) {
            super("RSMessageThread");
            this.mRS = rs;
        }

        public void run() {
            int[] rbuf = new int[16];
            this.mRS.nContextInitToClient(this.mRS.mContext);
            while (this.mRun) {
                rbuf[0] = 0;
                int msg = this.mRS.nContextPeekMessage(this.mRS.mContext, this.mAuxData);
                int size = this.mAuxData[1];
                int subID = this.mAuxData[0];
                if (msg == 4) {
                    if (size >> 2 >= rbuf.length) {
                        rbuf = new int[size + 3 >> 2];
                    }
                    if (this.mRS.nContextGetUserMessage(this.mRS.mContext, rbuf) != 4) {
                        throw new RSDriverException("Error processing message from RenderScript.");
                    }
                    if (this.mRS.mMessageCallback != null) {
                        this.mRS.mMessageCallback.mData = rbuf;
                        this.mRS.mMessageCallback.mID = subID;
                        this.mRS.mMessageCallback.mLength = size;
                        this.mRS.mMessageCallback.run();
                        continue;
                    }
                    throw new RSInvalidStateException("Received a message from the script with no message handler installed.");
                }
                if (msg == 3) {
                    String e = this.mRS.nContextGetErrorMessage(this.mRS.mContext);
                    if (subID >= 4096 || subID >= 2048 && (this.mRS.mContextType != ContextType.DEBUG || this.mRS.mErrorCallback == null)) {
                        throw new RSRuntimeException("Fatal error " + subID + ", details: " + e);
                    }
                    if (this.mRS.mErrorCallback != null) {
                        this.mRS.mErrorCallback.mErrorMessage = e;
                        this.mRS.mErrorCallback.mErrorNum = subID;
                        this.mRS.mErrorCallback.run();
                        continue;
                    }
                    Log.e(RenderScript.LOG_TAG, "non fatal RS error, " + e);
                    continue;
                }
                if (msg == 5) {
                    Allocation.sendBufferNotification(subID);
                    continue;
                }
                try {
                    MessageThread.sleep(1L, 0);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        LOW(15),
        NORMAL(-4);

        int mID;

        private Priority(int id2) {
            this.mID = id2;
        }
    }

    public static class RSErrorHandler
    implements Runnable {
        protected String mErrorMessage;
        protected int mErrorNum;

        public void run() {
        }
    }

    public static class RSMessageHandler
    implements Runnable {
        protected int[] mData;
        protected int mID;
        protected int mLength;

        public void run() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContextType {
        NORMAL(0),
        DEBUG(1),
        PROFILE(2);

        int mID;

        private ContextType(int id2) {
            this.mID = id2;
        }
    }
}

