/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.FieldPacker;
import android.renderscript.Float4;
import android.renderscript.Program;
import android.renderscript.ProgramFragment;
import android.renderscript.RenderScript;
import android.renderscript.Type;

public class ProgramFragmentFixedFunction
extends ProgramFragment {
    ProgramFragmentFixedFunction(int id2, RenderScript rs) {
        super(id2, rs);
    }

    public static class Builder {
        public static final int MAX_TEXTURE = 2;
        int mNumTextures;
        boolean mPointSpriteEnable;
        boolean mVaryingColorEnable;
        String mShader;
        RenderScript mRS;
        Slot[] mSlots;

        private void buildShaderString() {
            this.mShader = "//rs_shader_internal\n";
            this.mShader = this.mShader + "varying lowp vec4 varColor;\n";
            this.mShader = this.mShader + "varying vec2 varTex0;\n";
            this.mShader = this.mShader + "void main() {\n";
            this.mShader = this.mVaryingColorEnable ? this.mShader + "  lowp vec4 col = varColor;\n" : this.mShader + "  lowp vec4 col = UNI_Color;\n";
            if (this.mNumTextures != 0) {
                this.mShader = this.mPointSpriteEnable ? this.mShader + "  vec2 t0 = gl_PointCoord;\n" : this.mShader + "  vec2 t0 = varTex0.xy;\n";
            }
            block17: for (int i = 0; i < this.mNumTextures; ++i) {
                switch (this.mSlots[i].env) {
                    case REPLACE: {
                        switch (this.mSlots[i].format) {
                            case ALPHA: {
                                this.mShader = this.mShader + "  col.a = texture2D(UNI_Tex0, t0).a;\n";
                                break;
                            }
                            case LUMINANCE_ALPHA: {
                                this.mShader = this.mShader + "  col.rgba = texture2D(UNI_Tex0, t0).rgba;\n";
                                break;
                            }
                            case RGB: {
                                this.mShader = this.mShader + "  col.rgb = texture2D(UNI_Tex0, t0).rgb;\n";
                                break;
                            }
                            case RGBA: {
                                this.mShader = this.mShader + "  col.rgba = texture2D(UNI_Tex0, t0).rgba;\n";
                            }
                        }
                        continue block17;
                    }
                    case MODULATE: {
                        switch (this.mSlots[i].format) {
                            case ALPHA: {
                                this.mShader = this.mShader + "  col.a *= texture2D(UNI_Tex0, t0).a;\n";
                                break;
                            }
                            case LUMINANCE_ALPHA: {
                                this.mShader = this.mShader + "  col.rgba *= texture2D(UNI_Tex0, t0).rgba;\n";
                                break;
                            }
                            case RGB: {
                                this.mShader = this.mShader + "  col.rgb *= texture2D(UNI_Tex0, t0).rgb;\n";
                                break;
                            }
                            case RGBA: {
                                this.mShader = this.mShader + "  col.rgba *= texture2D(UNI_Tex0, t0).rgba;\n";
                            }
                        }
                        continue block17;
                    }
                    case DECAL: {
                        this.mShader = this.mShader + "  col = texture2D(UNI_Tex0, t0);\n";
                    }
                }
            }
            this.mShader = this.mShader + "  gl_FragColor = col;\n";
            this.mShader = this.mShader + "}\n";
        }

        public Builder(RenderScript rs) {
            this.mRS = rs;
            this.mSlots = new Slot[2];
            this.mPointSpriteEnable = false;
        }

        public Builder setTexture(EnvMode env, Format fmt, int slot) throws IllegalArgumentException {
            if (slot < 0 || slot >= 2) {
                throw new IllegalArgumentException("MAX_TEXTURE exceeded.");
            }
            this.mSlots[slot] = new Slot(env, fmt);
            return this;
        }

        public Builder setPointSpriteTexCoordinateReplacement(boolean enable) {
            this.mPointSpriteEnable = enable;
            return this;
        }

        public Builder setVaryingColor(boolean enable) {
            this.mVaryingColorEnable = enable;
            return this;
        }

        public ProgramFragmentFixedFunction create() {
            InternalBuilder sb = new InternalBuilder(this.mRS);
            this.mNumTextures = 0;
            for (int i = 0; i < 2; ++i) {
                if (this.mSlots[i] == null) continue;
                ++this.mNumTextures;
            }
            this.buildShaderString();
            sb.setShader(this.mShader);
            Type constType = null;
            if (!this.mVaryingColorEnable) {
                Element.Builder b = new Element.Builder(this.mRS);
                b.add(Element.F32_4(this.mRS), "Color");
                Type.Builder typeBuilder = new Type.Builder(this.mRS, b.create());
                typeBuilder.setX(1);
                constType = typeBuilder.create();
                sb.addConstant(constType);
            }
            for (int i = 0; i < this.mNumTextures; ++i) {
                sb.addTexture(Program.TextureType.TEXTURE_2D);
            }
            ProgramFragmentFixedFunction pf = sb.create();
            pf.mTextureCount = 2;
            if (!this.mVaryingColorEnable) {
                Allocation constantData = Allocation.createTyped(this.mRS, constType);
                FieldPacker fp = new FieldPacker(16);
                Float4 f4 = new Float4(1.0f, 1.0f, 1.0f, 1.0f);
                fp.addF32(f4);
                constantData.setFromFieldPacker(0, fp);
                pf.bindConstants(constantData, 0);
            }
            return pf;
        }

        private class Slot {
            EnvMode env;
            Format format;

            Slot(EnvMode _env, Format _fmt) {
                this.env = _env;
                this.format = _fmt;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Format {
            ALPHA(1),
            LUMINANCE_ALPHA(2),
            RGB(3),
            RGBA(4);

            int mID;

            private Format(int id2) {
                this.mID = id2;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EnvMode {
            REPLACE(1),
            MODULATE(2),
            DECAL(3);

            int mID;

            private EnvMode(int id2) {
                this.mID = id2;
            }
        }
    }

    static class InternalBuilder
    extends Program.BaseProgramBuilder {
        public InternalBuilder(RenderScript rs) {
            super(rs);
        }

        public ProgramFragmentFixedFunction create() {
            int i;
            this.mRS.validate();
            int[] tmp = new int[(this.mInputCount + this.mOutputCount + this.mConstantCount + this.mTextureCount) * 2];
            String[] texNames = new String[this.mTextureCount];
            int idx = 0;
            for (i = 0; i < this.mInputCount; ++i) {
                tmp[idx++] = Program.ProgramParam.INPUT.mID;
                tmp[idx++] = this.mInputs[i].getID(this.mRS);
            }
            for (i = 0; i < this.mOutputCount; ++i) {
                tmp[idx++] = Program.ProgramParam.OUTPUT.mID;
                tmp[idx++] = this.mOutputs[i].getID(this.mRS);
            }
            for (i = 0; i < this.mConstantCount; ++i) {
                tmp[idx++] = Program.ProgramParam.CONSTANT.mID;
                tmp[idx++] = this.mConstants[i].getID(this.mRS);
            }
            for (i = 0; i < this.mTextureCount; ++i) {
                tmp[idx++] = Program.ProgramParam.TEXTURE_TYPE.mID;
                tmp[idx++] = this.mTextureTypes[i].mID;
                texNames[i] = this.mTextureNames[i];
            }
            int id2 = this.mRS.nProgramFragmentCreate(this.mShader, texNames, tmp);
            ProgramFragmentFixedFunction pf = new ProgramFragmentFixedFunction(id2, this.mRS);
            this.initProgram(pf);
            return pf;
        }
    }
}

