/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MemoryFile {
    private static String TAG = "MemoryFile";
    private static final int PROT_READ = 1;
    private static final int PROT_WRITE = 2;
    private FileDescriptor mFD;
    private int mAddress;
    private int mLength;
    private boolean mAllowPurging = false;

    private static native FileDescriptor native_open(String var0, int var1) throws IOException;

    private static native int native_mmap(FileDescriptor var0, int var1, int var2) throws IOException;

    private static native void native_munmap(int var0, int var1) throws IOException;

    private static native void native_close(FileDescriptor var0);

    private static native int native_read(FileDescriptor var0, int var1, byte[] var2, int var3, int var4, int var5, boolean var6) throws IOException;

    private static native void native_write(FileDescriptor var0, int var1, byte[] var2, int var3, int var4, int var5, boolean var6) throws IOException;

    private static native void native_pin(FileDescriptor var0, boolean var1) throws IOException;

    private static native int native_get_size(FileDescriptor var0) throws IOException;

    public MemoryFile(String name, int length) throws IOException {
        this.mLength = length;
        this.mFD = MemoryFile.native_open(name, length);
        this.mAddress = length > 0 ? MemoryFile.native_mmap(this.mFD, length, 3) : 0;
    }

    public void close() {
        this.deactivate();
        if (!this.isClosed()) {
            MemoryFile.native_close(this.mFD);
        }
    }

    void deactivate() {
        if (!this.isDeactivated()) {
            try {
                MemoryFile.native_munmap(this.mAddress, this.mLength);
                this.mAddress = 0;
            }
            catch (IOException ex) {
                Log.e(TAG, ex.toString());
            }
        }
    }

    private boolean isDeactivated() {
        return this.mAddress == 0;
    }

    private boolean isClosed() {
        return !this.mFD.valid();
    }

    protected void finalize() {
        if (!this.isClosed()) {
            Log.e(TAG, "MemoryFile.finalize() called while ashmem still open");
            this.close();
        }
    }

    public int length() {
        return this.mLength;
    }

    public boolean isPurgingAllowed() {
        return this.mAllowPurging;
    }

    public synchronized boolean allowPurging(boolean allowPurging) throws IOException {
        boolean oldValue = this.mAllowPurging;
        if (oldValue != allowPurging) {
            MemoryFile.native_pin(this.mFD, !allowPurging);
            this.mAllowPurging = allowPurging;
        }
        return oldValue;
    }

    public InputStream getInputStream() {
        return new MemoryInputStream();
    }

    public OutputStream getOutputStream() {
        return new MemoryOutputStream();
    }

    public int readBytes(byte[] buffer, int srcOffset, int destOffset, int count) throws IOException {
        if (this.isDeactivated()) {
            throw new IOException("Can't read from deactivated memory file.");
        }
        if (destOffset < 0 || destOffset > buffer.length || count < 0 || count > buffer.length - destOffset || srcOffset < 0 || srcOffset > this.mLength || count > this.mLength - srcOffset) {
            throw new IndexOutOfBoundsException();
        }
        return MemoryFile.native_read(this.mFD, this.mAddress, buffer, srcOffset, destOffset, count, this.mAllowPurging);
    }

    public void writeBytes(byte[] buffer, int srcOffset, int destOffset, int count) throws IOException {
        if (this.isDeactivated()) {
            throw new IOException("Can't write to deactivated memory file.");
        }
        if (srcOffset < 0 || srcOffset > buffer.length || count < 0 || count > buffer.length - srcOffset || destOffset < 0 || destOffset > this.mLength || count > this.mLength - destOffset) {
            throw new IndexOutOfBoundsException();
        }
        MemoryFile.native_write(this.mFD, this.mAddress, buffer, srcOffset, destOffset, count, this.mAllowPurging);
    }

    public FileDescriptor getFileDescriptor() throws IOException {
        return this.mFD;
    }

    public static int getSize(FileDescriptor fd) throws IOException {
        return MemoryFile.native_get_size(fd);
    }

    private class MemoryOutputStream
    extends OutputStream {
        private int mOffset = 0;
        private byte[] mSingleByte;

        private MemoryOutputStream() {
        }

        public void write(byte[] buffer, int offset, int count) throws IOException {
            MemoryFile.this.writeBytes(buffer, offset, this.mOffset, count);
            this.mOffset += count;
        }

        public void write(int oneByte) throws IOException {
            if (this.mSingleByte == null) {
                this.mSingleByte = new byte[1];
            }
            this.mSingleByte[0] = (byte)oneByte;
            this.write(this.mSingleByte, 0, 1);
        }
    }

    private class MemoryInputStream
    extends InputStream {
        private int mMark = 0;
        private int mOffset = 0;
        private byte[] mSingleByte;

        private MemoryInputStream() {
        }

        public int available() throws IOException {
            if (this.mOffset >= MemoryFile.this.mLength) {
                return 0;
            }
            return MemoryFile.this.mLength - this.mOffset;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int readlimit) {
            this.mMark = this.mOffset;
        }

        public void reset() throws IOException {
            this.mOffset = this.mMark;
        }

        public int read() throws IOException {
            int result;
            if (this.mSingleByte == null) {
                this.mSingleByte = new byte[1];
            }
            if ((result = this.read(this.mSingleByte, 0, 1)) != 1) {
                return -1;
            }
            return this.mSingleByte[0];
        }

        public int read(byte[] buffer, int offset, int count) throws IOException {
            if (offset < 0 || count < 0 || offset + count > buffer.length) {
                throw new IndexOutOfBoundsException();
            }
            if ((count = Math.min(count, this.available())) < 1) {
                return -1;
            }
            int result = MemoryFile.this.readBytes(buffer, this.mOffset, offset, count);
            if (result > 0) {
                this.mOffset += result;
            }
            return result;
        }

        public long skip(long n) throws IOException {
            if ((long)this.mOffset + n > (long)MemoryFile.this.mLength) {
                n = MemoryFile.this.mLength - this.mOffset;
            }
            this.mOffset = (int)((long)this.mOffset + n);
            return n;
        }
    }
}

