/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import android.net.dhcp.DhcpStateMachine;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;

class DhcpNakPacket
extends DhcpPacket {
    DhcpNakPacket(int transId, InetAddress clientIp, InetAddress yourIp, InetAddress nextIp, InetAddress relayIp, byte[] clientMac) {
        super(transId, Inet4Address.ANY, Inet4Address.ANY, nextIp, relayIp, clientMac, false);
    }

    public String toString() {
        String s = super.toString();
        return s + " NAK, reason " + (this.mMessage == null ? "(none)" : this.mMessage);
    }

    public ByteBuffer buildPacket(int encap, short destUdp, short srcUdp) {
        ByteBuffer result = ByteBuffer.allocate(1500);
        InetAddress destIp = this.mClientIp;
        InetAddress srcIp = this.mYourIp;
        this.fillInPacket(encap, destIp, srcIp, destUdp, srcUdp, result, (byte)2, this.mBroadcast);
        result.flip();
        return result;
    }

    void finishPacket(ByteBuffer buffer) {
        this.addTlv(buffer, (byte)53, (byte)6);
        this.addTlv(buffer, (byte)54, this.mServerIdentifier);
        this.addTlv(buffer, (byte)56, this.mMessage);
        this.addTlvEnd(buffer);
    }

    public void doNextOp(DhcpStateMachine machine) {
        machine.onNakReceived();
    }
}

