/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.os.Parcel;
import android.os.Parcelable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteInfo
implements Parcelable {
    private final LinkAddress mDestination;
    private final InetAddress mGateway;
    private final String mInterface;
    private final boolean mIsDefault;
    private final boolean mIsHost;
    private final boolean mHasGateway;
    public static final Parcelable.Creator<RouteInfo> CREATOR = new Parcelable.Creator<RouteInfo>(){

        @Override
        public RouteInfo createFromParcel(Parcel in) {
            byte[] addr;
            InetAddress destAddr = null;
            int prefix = 0;
            InetAddress gateway = null;
            if (in.readByte() == 1) {
                addr = in.createByteArray();
                prefix = in.readInt();
                try {
                    destAddr = InetAddress.getByAddress(addr);
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            if (in.readByte() == 1) {
                addr = in.createByteArray();
                try {
                    gateway = InetAddress.getByAddress(addr);
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            String iface = in.readString();
            LinkAddress dest = null;
            if (destAddr != null) {
                dest = new LinkAddress(destAddr, prefix);
            }
            return new RouteInfo(dest, gateway, iface);
        }

        public RouteInfo[] newArray(int size) {
            return new RouteInfo[size];
        }
    };

    public RouteInfo(LinkAddress destination, InetAddress gateway, String iface) {
        if (destination == null) {
            if (gateway != null) {
                destination = gateway instanceof Inet4Address ? new LinkAddress(Inet4Address.ANY, 0) : new LinkAddress(Inet6Address.ANY, 0);
            } else {
                throw new IllegalArgumentException("Invalid arguments passed in: " + gateway + "," + destination);
            }
        }
        if (gateway == null) {
            gateway = destination.getAddress() instanceof Inet4Address ? Inet4Address.ANY : Inet6Address.ANY;
        }
        this.mHasGateway = !gateway.isAnyLocalAddress();
        this.mDestination = new LinkAddress(NetworkUtils.getNetworkPart(destination.getAddress(), destination.getNetworkPrefixLength()), destination.getNetworkPrefixLength());
        this.mGateway = gateway;
        this.mInterface = iface;
        this.mIsDefault = this.isDefault();
        this.mIsHost = this.isHost();
    }

    public RouteInfo(LinkAddress destination, InetAddress gateway) {
        this(destination, gateway, null);
    }

    public RouteInfo(InetAddress gateway) {
        this(null, gateway, null);
    }

    public RouteInfo(LinkAddress host) {
        this(host, null, null);
    }

    public static RouteInfo makeHostRoute(InetAddress host, String iface) {
        return RouteInfo.makeHostRoute(host, null, iface);
    }

    public static RouteInfo makeHostRoute(InetAddress host, InetAddress gateway, String iface) {
        if (host == null) {
            return null;
        }
        if (host instanceof Inet4Address) {
            return new RouteInfo(new LinkAddress(host, 32), gateway, iface);
        }
        return new RouteInfo(new LinkAddress(host, 128), gateway, iface);
    }

    private boolean isHost() {
        return this.mDestination.getAddress() instanceof Inet4Address && this.mDestination.getNetworkPrefixLength() == 32 || this.mDestination.getAddress() instanceof Inet6Address && this.mDestination.getNetworkPrefixLength() == 128;
    }

    private boolean isDefault() {
        boolean val = false;
        if (this.mGateway != null) {
            val = this.mGateway instanceof Inet4Address ? this.mDestination == null || this.mDestination.getNetworkPrefixLength() == 0 : this.mDestination == null || this.mDestination.getNetworkPrefixLength() == 0;
        }
        return val;
    }

    public LinkAddress getDestination() {
        return this.mDestination;
    }

    public InetAddress getGateway() {
        return this.mGateway;
    }

    public String getInterface() {
        return this.mInterface;
    }

    public boolean isDefaultRoute() {
        return this.mIsDefault;
    }

    public boolean isHostRoute() {
        return this.mIsHost;
    }

    public boolean hasGateway() {
        return this.mHasGateway;
    }

    public String toString() {
        String val = "";
        if (this.mDestination != null) {
            val = this.mDestination.toString();
        }
        if (this.mGateway != null) {
            val = val + " -> " + this.mGateway.getHostAddress();
        }
        return val;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.mDestination == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeByteArray(this.mDestination.getAddress().getAddress());
            dest.writeInt(this.mDestination.getNetworkPrefixLength());
        }
        if (this.mGateway == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeByteArray(this.mGateway.getAddress());
        }
        dest.writeString(this.mInterface);
    }

    public boolean equals(Object obj) {
        boolean sameAddress;
        boolean sameDestination;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RouteInfo)) {
            return false;
        }
        RouteInfo target = (RouteInfo)obj;
        boolean bl = this.mDestination == null ? target.getDestination() == null : (sameDestination = this.mDestination.equals(target.getDestination()));
        boolean bl2 = this.mGateway == null ? target.getGateway() == null : (sameAddress = this.mGateway.equals(target.getGateway()));
        boolean sameInterface = this.mInterface == null ? target.getInterface() == null : this.mInterface.equals(target.getInterface());
        return sameDestination && sameAddress && sameInterface && this.mIsDefault == target.mIsDefault;
    }

    public int hashCode() {
        return (this.mDestination == null ? 0 : this.mDestination.hashCode() * 41) + (this.mGateway == null ? 0 : this.mGateway.hashCode() * 47) + (this.mInterface == null ? 0 : this.mInterface.hashCode() * 67) + (this.mIsDefault ? 3 : 7);
    }

    protected boolean matches(InetAddress destination) {
        if (destination == null) {
            return false;
        }
        InetAddress dstNet = NetworkUtils.getNetworkPart(destination, this.mDestination.getNetworkPrefixLength());
        return this.mDestination.getAddress().equals(dstNet);
    }

    public static RouteInfo selectBestRoute(Collection<RouteInfo> routes, InetAddress dest) {
        if (routes == null || dest == null) {
            return null;
        }
        RouteInfo bestRoute = null;
        for (RouteInfo route : routes) {
            if (!NetworkUtils.addressTypeMatches(route.mDestination.getAddress(), dest) || bestRoute != null && bestRoute.mDestination.getNetworkPrefixLength() >= route.mDestination.getNetworkPrefixLength() || !route.matches(dest)) continue;
            bestRoute = route;
        }
        return bestRoute;
    }
}

