/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ParseException;
import android.net.Uri;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailTo {
    public static final String MAILTO_SCHEME = "mailto:";
    private HashMap<String, String> mHeaders = new HashMap();
    private static final String TO = "to";
    private static final String BODY = "body";
    private static final String CC = "cc";
    private static final String SUBJECT = "subject";

    public static boolean isMailTo(String url) {
        return url != null && url.startsWith(MAILTO_SCHEME);
    }

    public static MailTo parse(String url) throws ParseException {
        String address;
        if (url == null) {
            throw new NullPointerException();
        }
        if (!MailTo.isMailTo(url)) {
            throw new ParseException("Not a mailto scheme");
        }
        String noScheme = url.substring(MAILTO_SCHEME.length());
        Uri email = Uri.parse(noScheme);
        MailTo m = new MailTo();
        String query = email.getQuery();
        if (query != null) {
            String[] queries;
            for (String q : queries = query.split("&")) {
                String[] nameval = q.split("=");
                if (nameval.length == 0) continue;
                m.mHeaders.put(Uri.decode(nameval[0]).toLowerCase(Locale.ROOT), nameval.length > 1 ? Uri.decode(nameval[1]) : null);
            }
        }
        if ((address = email.getPath()) != null) {
            String addr = m.getTo();
            if (addr != null) {
                address = address + ", " + addr;
            }
            m.mHeaders.put(TO, address);
        }
        return m;
    }

    public String getTo() {
        return this.mHeaders.get(TO);
    }

    public String getCc() {
        return this.mHeaders.get(CC);
    }

    public String getSubject() {
        return this.mHeaders.get(SUBJECT);
    }

    public String getBody() {
        return this.mHeaders.get(BODY);
    }

    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(MAILTO_SCHEME);
        sb.append('?');
        for (Map.Entry<String, String> header : this.mHeaders.entrySet()) {
            sb.append(Uri.encode(header.getKey()));
            sb.append('=');
            sb.append(Uri.encode(header.getValue()));
            sb.append('&');
        }
        return sb.toString();
    }

    private MailTo() {
    }
}

