/*
 * Decompiled with CFR 0.152.
 */
package android.media.videoeditor;

import android.media.videoeditor.VideoEditor;
import android.media.videoeditor.VideoEditorImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class VideoEditorFactory {
    public static VideoEditor create(String projectPath) throws IOException {
        File dir = new File(projectPath);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new FileNotFoundException("Cannot create project path: " + projectPath);
            }
            if (!new File(dir, ".nomedia").createNewFile()) {
                throw new FileNotFoundException("Cannot create file .nomedia");
            }
        }
        return new VideoEditorImpl(projectPath);
    }

    public static VideoEditor load(String projectPath, boolean generatePreview) throws IOException {
        VideoEditorImpl videoEditor = new VideoEditorImpl(projectPath);
        if (generatePreview) {
            videoEditor.generatePreview(null);
        }
        return videoEditor;
    }
}

