/*
 * Decompiled with CFR 0.152.
 */
package android.media.effect;

import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameManager;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.format.ImageFormat;
import android.media.effect.Effect;
import android.media.effect.EffectContext;

public abstract class FilterEffect
extends Effect {
    protected EffectContext mEffectContext;
    private String mName;

    protected FilterEffect(EffectContext context, String name) {
        this.mEffectContext = context;
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    protected void beginGLEffect() {
        this.mEffectContext.assertValidGLState();
        this.mEffectContext.saveGLState();
    }

    protected void endGLEffect() {
        this.mEffectContext.restoreGLState();
    }

    protected FilterContext getFilterContext() {
        return this.mEffectContext.mFilterContext;
    }

    protected Frame frameFromTexture(int texId, int width, int height) {
        FrameManager manager = this.getFilterContext().getFrameManager();
        MutableFrameFormat format = ImageFormat.create(width, height, 3, 3);
        Frame frame = manager.newBoundFrame(format, 100, texId);
        frame.setTimestamp(-1L);
        return frame;
    }
}

