/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public class MarshalQueryableParcelable<T extends Parcelable>
implements MarshalQueryable<T> {
    private static final String TAG = "MarshalParcelable";
    private static final boolean VERBOSE = Log.isLoggable("MarshalParcelable", 2);
    private static final String FIELD_CREATOR = "CREATOR";

    @Override
    public Marshaler<T> createMarshaler(TypeReference<T> managedType, int nativeType) {
        return new MarshalerParcelable(managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<T> managedType, int nativeType) {
        return Parcelable.class.isAssignableFrom(managedType.getRawType());
    }

    private class MarshalerParcelable
    extends Marshaler<T> {
        private final Class<T> mClass;
        private final Parcelable.Creator<T> mCreator;

        protected MarshalerParcelable(TypeReference<T> typeReference, int nativeType) {
            Field creatorField;
            super(MarshalQueryableParcelable.this, typeReference, nativeType);
            this.mClass = typeReference.getRawType();
            try {
                creatorField = this.mClass.getDeclaredField(MarshalQueryableParcelable.FIELD_CREATOR);
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
            try {
                this.mCreator = (Parcelable.Creator)creatorField.get(null);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void marshal(T value, ByteBuffer buffer) {
            byte[] parcelContents;
            if (VERBOSE) {
                Log.v(MarshalQueryableParcelable.TAG, "marshal " + value);
            }
            Parcel parcel = Parcel.obtain();
            try {
                value.writeToParcel(parcel, 0);
                if (parcel.hasFileDescriptors()) {
                    throw new UnsupportedOperationException("Parcelable " + value + " must not have file descriptors");
                }
                parcelContents = parcel.marshall();
            }
            finally {
                parcel.recycle();
            }
            if (parcelContents.length == 0) {
                throw new AssertionError((Object)("No data marshaled for " + value));
            }
            buffer.put(parcelContents);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T unmarshal(ByteBuffer buffer) {
            if (VERBOSE) {
                Log.v(MarshalQueryableParcelable.TAG, "unmarshal, buffer remaining " + buffer.remaining());
            }
            buffer.mark();
            Parcel parcel = Parcel.obtain();
            try {
                int maxLength = buffer.remaining();
                byte[] remaining = new byte[maxLength];
                buffer.get(remaining);
                parcel.unmarshall(remaining, 0, maxLength);
                parcel.setDataPosition(0);
                Parcelable value = (Parcelable)this.mCreator.createFromParcel(parcel);
                int actualLength = parcel.dataPosition();
                if (actualLength == 0) {
                    throw new AssertionError((Object)("No data marshaled for " + value));
                }
                buffer.reset();
                buffer.position(buffer.position() + actualLength);
                if (VERBOSE) {
                    Log.v(MarshalQueryableParcelable.TAG, "unmarshal, parcel length was " + actualLength);
                    Log.v(MarshalQueryableParcelable.TAG, "unmarshal, value is " + value);
                }
                Parcelable parcelable = (Parcelable)this.mClass.cast(value);
                return parcelable;
            }
            finally {
                parcel.recycle();
            }
        }

        @Override
        public int getNativeSize() {
            return NATIVE_SIZE_DYNAMIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int calculateMarshalSize(T value) {
            Parcel parcel = Parcel.obtain();
            try {
                value.writeToParcel(parcel, 0);
                int length = parcel.marshall().length;
                if (VERBOSE) {
                    Log.v(MarshalQueryableParcelable.TAG, "calculateMarshalSize, length when parceling " + value + " is " + length);
                }
                int n = length;
                return n;
            }
            finally {
                parcel.recycle();
            }
        }
    }
}

