/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.dispatch;

import android.hardware.camera2.dispatch.Dispatchable;
import com.android.internal.util.Preconditions;
import java.lang.reflect.Method;

public class ArgumentReplacingDispatcher<T, TArg>
implements Dispatchable<T> {
    private final Dispatchable<T> mTarget;
    private final int mArgumentIndex;
    private final TArg mReplaceWith;

    public ArgumentReplacingDispatcher(Dispatchable<T> target, int argumentIndex, TArg replaceWith) {
        this.mTarget = Preconditions.checkNotNull(target, "target must not be null");
        this.mArgumentIndex = Preconditions.checkArgumentNonnegative((int)argumentIndex, (String)"argumentIndex must not be negative");
        this.mReplaceWith = Preconditions.checkNotNull(replaceWith, "replaceWith must not be null");
    }

    @Override
    public Object dispatch(Method method, Object[] args) throws Throwable {
        if (args.length > this.mArgumentIndex) {
            args = ArgumentReplacingDispatcher.arrayCopy(args);
            args[this.mArgumentIndex] = this.mReplaceWith;
        }
        return this.mTarget.dispatch(method, args);
    }

    private static Object[] arrayCopy(Object[] array2) {
        int length = array2.length;
        Object[] newArray = new Object[length];
        for (int i = 0; i < length; ++i) {
            newArray[i] = array2[i];
        }
        return newArray;
    }
}

