/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.os.Handler;
import java.util.List;

public abstract class CameraCaptureSession
implements AutoCloseable {
    public abstract CameraDevice getDevice();

    public abstract int capture(CaptureRequest var1, CaptureCallback var2, Handler var3) throws CameraAccessException;

    public abstract int captureBurst(List<CaptureRequest> var1, CaptureCallback var2, Handler var3) throws CameraAccessException;

    public abstract int setRepeatingRequest(CaptureRequest var1, CaptureCallback var2, Handler var3) throws CameraAccessException;

    public abstract int setRepeatingBurst(List<CaptureRequest> var1, CaptureCallback var2, Handler var3) throws CameraAccessException;

    public abstract void stopRepeating() throws CameraAccessException;

    public abstract void abortCaptures() throws CameraAccessException;

    @Override
    public abstract void close();

    public static abstract class CaptureListener
    extends CaptureCallback {
    }

    public static abstract class CaptureCallback {
        public static final int NO_FRAMES_CAPTURED = -1;

        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
            this.onCaptureStarted(session, request, timestamp);
        }

        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp) {
        }

        public void onCapturePartial(CameraCaptureSession session, CaptureRequest request, CaptureResult result) {
        }

        public void onCaptureProgressed(CameraCaptureSession session, CaptureRequest request, CaptureResult partialResult) {
        }

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
        }

        public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
        }

        public void onCaptureSequenceCompleted(CameraCaptureSession session, int sequenceId, long frameNumber) {
        }

        public void onCaptureSequenceAborted(CameraCaptureSession session, int sequenceId) {
        }
    }

    public static abstract class StateListener
    extends StateCallback {
    }

    public static abstract class StateCallback {
        public abstract void onConfigured(CameraCaptureSession var1);

        public abstract void onConfigureFailed(CameraCaptureSession var1);

        public void onReady(CameraCaptureSession session) {
        }

        public void onActive(CameraCaptureSession session) {
        }

        public void onClosed(CameraCaptureSession session) {
        }
    }
}

