/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.LongSparseLongArray;
import android.util.SparseIntArray;
import android.util.StateSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedStateListDrawable
extends StateListDrawable {
    private static final String LOGTAG = AnimatedStateListDrawable.class.getSimpleName();
    private static final String ELEMENT_TRANSITION = "transition";
    private static final String ELEMENT_ITEM = "item";
    private AnimatedStateListState mState;
    private Transition mTransition;
    private int mTransitionToIndex = -1;
    private int mTransitionFromIndex = -1;
    private boolean mMutated;

    public AnimatedStateListDrawable() {
        this(null, null);
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (this.mTransition != null && (changed || restart)) {
            if (visible) {
                this.mTransition.start();
            } else {
                this.jumpToCurrentState();
            }
        }
        return changed;
    }

    public void addState(int[] stateSet, Drawable drawable2, int id2) {
        if (drawable2 == null) {
            throw new IllegalArgumentException("Drawable must not be null");
        }
        this.mState.addStateSet(stateSet, drawable2, id2);
        this.onStateChange(this.getState());
    }

    public <T extends Drawable> void addTransition(int fromId, int toId, T transition2, boolean reversible) {
        if (transition2 == null) {
            throw new IllegalArgumentException("Transition drawable must not be null");
        }
        this.mState.addTransition(fromId, toId, transition2, reversible);
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        int keyframeIndex = this.mState.indexOfKeyframe(stateSet);
        if (keyframeIndex == this.getCurrentIndex()) {
            Drawable current = this.getCurrent();
            if (current != null) {
                return current.setState(stateSet);
            }
            return false;
        }
        if (this.selectTransition(keyframeIndex)) {
            return true;
        }
        if (this.selectDrawable(keyframeIndex)) {
            return true;
        }
        return super.onStateChange(stateSet);
    }

    private boolean selectTransition(int toIndex) {
        Transition transition2;
        int fromIndex;
        Transition currentTransition = this.mTransition;
        if (currentTransition != null) {
            if (toIndex == this.mTransitionToIndex) {
                return true;
            }
            if (toIndex == this.mTransitionFromIndex && currentTransition.canReverse()) {
                currentTransition.reverse();
                this.mTransitionToIndex = this.mTransitionFromIndex;
                this.mTransitionFromIndex = toIndex;
                return true;
            }
            fromIndex = this.mTransitionToIndex;
            currentTransition.stop();
        } else {
            fromIndex = this.getCurrentIndex();
        }
        this.mTransition = null;
        this.mTransitionFromIndex = -1;
        this.mTransitionToIndex = -1;
        AnimatedStateListState state = this.mState;
        int fromId = state.getKeyframeIdAt(fromIndex);
        int toId = state.getKeyframeIdAt(toIndex);
        if (toId == 0 || fromId == 0) {
            return false;
        }
        int transitionIndex = state.indexOfTransition(fromId, toId);
        if (transitionIndex < 0) {
            return false;
        }
        this.selectDrawable(transitionIndex);
        Drawable d = this.getCurrent();
        if (d instanceof AnimationDrawable) {
            boolean reversed = state.isTransitionReversed(fromId, toId);
            transition2 = new AnimationDrawableTransition((AnimationDrawable)d, reversed);
        } else if (d instanceof AnimatedVectorDrawable) {
            boolean reversed = state.isTransitionReversed(fromId, toId);
            transition2 = new AnimatedVectorDrawableTransition((AnimatedVectorDrawable)d, reversed);
        } else if (d instanceof Animatable) {
            transition2 = new AnimatableTransition((Animatable)((Object)d));
        } else {
            return false;
        }
        transition2.start();
        this.mTransition = transition2;
        this.mTransitionFromIndex = fromIndex;
        this.mTransitionToIndex = toIndex;
        return true;
    }

    @Override
    public void jumpToCurrentState() {
        super.jumpToCurrentState();
        if (this.mTransition != null) {
            this.mTransition.stop();
            this.mTransition = null;
            this.selectDrawable(this.mTransitionToIndex);
            this.mTransitionToIndex = -1;
            this.mTransitionFromIndex = -1;
        }
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        TypedArray a = AnimatedStateListDrawable.obtainAttributes((Resources)r, (Resources.Theme)theme, (AttributeSet)attrs, (int[])R.styleable.AnimatedStateListDrawable);
        super.inflateWithAttributes(r, parser, a, 1);
        StateListDrawable.StateListState stateListState = this.getStateListState();
        stateListState.setVariablePadding(a.getBoolean(2, false));
        stateListState.setConstantSize(a.getBoolean(3, false));
        stateListState.setEnterFadeDuration(a.getInt(4, 0));
        stateListState.setExitFadeDuration(a.getInt(5, 0));
        this.setDither(a.getBoolean(0, true));
        this.setAutoMirrored(a.getBoolean(6, false));
        a.recycle();
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth) continue;
            if (parser.getName().equals(ELEMENT_ITEM)) {
                this.parseItem(r, parser, attrs, theme);
                continue;
            }
            if (!parser.getName().equals(ELEMENT_TRANSITION)) continue;
            this.parseTransition(r, parser, attrs, theme);
        }
        this.onStateChange(this.getState());
    }

    private int parseTransition(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        Drawable dr;
        int drawableRes = 0;
        int fromId = 0;
        int toId = 0;
        boolean reversible = false;
        int numAttrs = attrs.getAttributeCount();
        block7: for (int i = 0; i < numAttrs; ++i) {
            int stateResId = attrs.getAttributeNameResource(i);
            switch (stateResId) {
                case 0: {
                    continue block7;
                }
                case 16843850: {
                    fromId = attrs.getAttributeResourceValue(i, 0);
                    continue block7;
                }
                case 16843849: {
                    toId = attrs.getAttributeResourceValue(i, 0);
                    continue block7;
                }
                case 0x1010199: {
                    drawableRes = attrs.getAttributeResourceValue(i, 0);
                    continue block7;
                }
                case 16843851: {
                    reversible = attrs.getAttributeBooleanValue(i, false);
                }
            }
        }
        if (drawableRes != 0) {
            dr = r.getDrawable(drawableRes, theme);
        } else {
            int type;
            while ((type = parser.next()) == 4) {
            }
            if (type != 2) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
            }
            dr = Drawable.createFromXmlInner((Resources)r, (XmlPullParser)parser, (AttributeSet)attrs, (Resources.Theme)theme);
        }
        return this.mState.addTransition(fromId, toId, dr, reversible);
    }

    private int parseItem(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        Drawable dr;
        int drawableRes = 0;
        int keyframeId = 0;
        int j = 0;
        int numAttrs = attrs.getAttributeCount();
        int[] states = new int[numAttrs];
        block5: for (int i = 0; i < numAttrs; ++i) {
            int stateResId = attrs.getAttributeNameResource(i);
            switch (stateResId) {
                case 0: {
                    continue block5;
                }
                case 0x10100D0: {
                    keyframeId = attrs.getAttributeResourceValue(i, 0);
                    continue block5;
                }
                case 0x1010199: {
                    drawableRes = attrs.getAttributeResourceValue(i, 0);
                    continue block5;
                }
                default: {
                    boolean hasState = attrs.getAttributeBooleanValue(i, false);
                    states[j++] = hasState ? stateResId : -stateResId;
                }
            }
        }
        states = StateSet.trimStateSet(states, j);
        if (drawableRes != 0) {
            dr = r.getDrawable(drawableRes, theme);
        } else {
            int type;
            while ((type = parser.next()) == 4) {
            }
            if (type != 2) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
            }
            dr = Drawable.createFromXmlInner((Resources)r, (XmlPullParser)parser, (AttributeSet)attrs, (Resources.Theme)theme);
        }
        return this.mState.addStateSet(states, dr, keyframeId);
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            AnimatedStateListState newState = new AnimatedStateListState(this.mState, this, null);
            this.setConstantState(newState);
            this.mMutated = true;
        }
        return this;
    }

    void setConstantState(AnimatedStateListState state) {
        super.setConstantState((StateListDrawable.StateListState)state);
        this.mState = state;
    }

    private AnimatedStateListDrawable(AnimatedStateListState state, Resources res) {
        super(null);
        AnimatedStateListState newState = new AnimatedStateListState(state, this, res);
        this.setConstantState(newState);
        this.onStateChange(this.getState());
        this.jumpToCurrentState();
    }

    private static class FrameInterpolator
    implements TimeInterpolator {
        private int[] mFrameTimes;
        private int mFrames;
        private int mTotalDuration;

        public FrameInterpolator(AnimationDrawable d, boolean reversed) {
            this.updateFrames(d, reversed);
        }

        public int updateFrames(AnimationDrawable d, boolean reversed) {
            int N;
            this.mFrames = N = d.getNumberOfFrames();
            if (this.mFrameTimes == null || this.mFrameTimes.length < N) {
                this.mFrameTimes = new int[N];
            }
            int[] frameTimes = this.mFrameTimes;
            int totalDuration = 0;
            for (int i = 0; i < N; ++i) {
                int duration;
                frameTimes[i] = duration = d.getDuration(reversed ? N - i - 1 : i);
                totalDuration += duration;
            }
            this.mTotalDuration = totalDuration;
            return totalDuration;
        }

        public int getTotalDuration() {
            return this.mTotalDuration;
        }

        @Override
        public float getInterpolation(float input) {
            int i;
            int elapsed = (int)(input * (float)this.mTotalDuration + 0.5f);
            int N = this.mFrames;
            int[] frameTimes = this.mFrameTimes;
            int remaining = elapsed;
            for (i = 0; i < N && remaining >= frameTimes[i]; remaining -= frameTimes[i], ++i) {
            }
            float frameElapsed = i < N ? (float)remaining / (float)this.mTotalDuration : 0.0f;
            return (float)i / (float)N + frameElapsed;
        }
    }

    static class AnimatedStateListState
    extends StateListDrawable.StateListState {
        private static final int REVERSE_SHIFT = 32;
        private static final int REVERSE_MASK = 1;
        final LongSparseLongArray mTransitions;
        final SparseIntArray mStateIds;

        AnimatedStateListState(AnimatedStateListState orig, AnimatedStateListDrawable owner, Resources res) {
            super(orig, owner, res);
            if (orig != null) {
                this.mTransitions = orig.mTransitions.clone();
                this.mStateIds = orig.mStateIds.clone();
            } else {
                this.mTransitions = new LongSparseLongArray();
                this.mStateIds = new SparseIntArray();
            }
        }

        int addTransition(int fromId, int toId, Drawable anim2, boolean reversible) {
            int pos = super.addChild(anim2);
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            this.mTransitions.append(keyFromTo, pos);
            if (reversible) {
                long keyToFrom = AnimatedStateListState.generateTransitionKey(toId, fromId);
                this.mTransitions.append(keyToFrom, (long)pos | 0x100000000L);
            }
            return this.addChild(anim2);
        }

        int addStateSet(int[] stateSet, Drawable drawable2, int id2) {
            int index = super.addStateSet(stateSet, drawable2);
            this.mStateIds.put(index, id2);
            return index;
        }

        int indexOfKeyframe(int[] stateSet) {
            int index = super.indexOfStateSet(stateSet);
            if (index >= 0) {
                return index;
            }
            return super.indexOfStateSet(StateSet.WILD_CARD);
        }

        int getKeyframeIdAt(int index) {
            return index < 0 ? 0 : this.mStateIds.get(index, 0);
        }

        int indexOfTransition(int fromId, int toId) {
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            return (int)this.mTransitions.get(keyFromTo, -1L);
        }

        boolean isTransitionReversed(int fromId, int toId) {
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            return (this.mTransitions.get(keyFromTo, -1L) >> 32 & 1L) == 1L;
        }

        @Override
        public Drawable newDrawable() {
            return new AnimatedStateListDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new AnimatedStateListDrawable(this, res);
        }

        private static long generateTransitionKey(int fromId, int toId) {
            return (long)fromId << 32 | (long)toId;
        }
    }

    private static class AnimatedVectorDrawableTransition
    extends Transition {
        private final AnimatedVectorDrawable mAvd;
        private final boolean mReversed;

        public AnimatedVectorDrawableTransition(AnimatedVectorDrawable avd, boolean reversed) {
            this.mAvd = avd;
            this.mReversed = reversed;
        }

        @Override
        public boolean canReverse() {
            return this.mAvd.canReverse();
        }

        @Override
        public void start() {
            if (this.mReversed) {
                this.reverse();
            } else {
                this.mAvd.start();
            }
        }

        @Override
        public void reverse() {
            if (this.canReverse()) {
                this.mAvd.reverse();
            } else {
                Log.w(LOGTAG, "Reverse() is called on a drawable can't reverse");
            }
        }

        @Override
        public void stop() {
            this.mAvd.stop();
        }
    }

    private static class AnimationDrawableTransition
    extends Transition {
        private final ObjectAnimator mAnim;

        public AnimationDrawableTransition(AnimationDrawable ad, boolean reversed) {
            int frameCount = ad.getNumberOfFrames();
            int fromFrame = reversed ? frameCount - 1 : 0;
            int toFrame = reversed ? 0 : frameCount - 1;
            FrameInterpolator interp = new FrameInterpolator(ad, reversed);
            ObjectAnimator anim2 = ObjectAnimator.ofInt(ad, "currentIndex", fromFrame, toFrame);
            anim2.setAutoCancel(true);
            anim2.setDuration(interp.getTotalDuration());
            anim2.setInterpolator(interp);
            this.mAnim = anim2;
        }

        @Override
        public boolean canReverse() {
            return true;
        }

        @Override
        public void start() {
            this.mAnim.start();
        }

        @Override
        public void reverse() {
            this.mAnim.reverse();
        }

        @Override
        public void stop() {
            this.mAnim.cancel();
        }
    }

    private static class AnimatableTransition
    extends Transition {
        private final Animatable mA;

        public AnimatableTransition(Animatable a) {
            this.mA = a;
        }

        @Override
        public void start() {
            this.mA.start();
        }

        @Override
        public void stop() {
            this.mA.stop();
        }
    }

    private static abstract class Transition {
        private Transition() {
        }

        public abstract void start();

        public abstract void stop();

        public void reverse() {
        }

        public boolean canReverse() {
            return false;
        }
    }
}

