/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.Path;

public class PathMeasure {
    private Path mPath;
    public static final int POSITION_MATRIX_FLAG = 1;
    public static final int TANGENT_MATRIX_FLAG = 2;
    private final int native_instance;

    public PathMeasure() {
        this.mPath = null;
        this.native_instance = PathMeasure.native_create(0, false);
    }

    public PathMeasure(Path path, boolean forceClosed) {
        this.mPath = path;
        this.native_instance = PathMeasure.native_create(path != null ? path.ni() : 0, forceClosed);
    }

    public void setPath(Path path, boolean forceClosed) {
        this.mPath = path;
        PathMeasure.native_setPath(this.native_instance, path != null ? path.ni() : 0, forceClosed);
    }

    public float getLength() {
        return PathMeasure.native_getLength(this.native_instance);
    }

    public boolean getPosTan(float distance, float[] pos, float[] tan) {
        if (pos != null && pos.length < 2 || tan != null && tan.length < 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return PathMeasure.native_getPosTan(this.native_instance, distance, pos, tan);
    }

    public boolean getMatrix(float distance, Matrix matrix, int flags) {
        return PathMeasure.native_getMatrix(this.native_instance, distance, matrix.native_instance, flags);
    }

    public boolean getSegment(float startD, float stopD, Path dst, boolean startWithMoveTo) {
        return PathMeasure.native_getSegment(this.native_instance, startD, stopD, dst.ni(), startWithMoveTo);
    }

    public boolean isClosed() {
        return PathMeasure.native_isClosed(this.native_instance);
    }

    public boolean nextContour() {
        return PathMeasure.native_nextContour(this.native_instance);
    }

    protected void finalize() throws Throwable {
        PathMeasure.native_destroy(this.native_instance);
    }

    private static native int native_create(int var0, boolean var1);

    private static native void native_setPath(int var0, int var1, boolean var2);

    private static native float native_getLength(int var0);

    private static native boolean native_getPosTan(int var0, float var1, float[] var2, float[] var3);

    private static native boolean native_getMatrix(int var0, float var1, int var2, int var3);

    private static native boolean native_getSegment(int var0, float var1, float var2, int var3, boolean var4);

    private static native boolean native_isClosed(int var0);

    private static native boolean native_nextContour(int var0);

    private static native void native_destroy(int var0);
}

