/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;

public class FontFamily {
    public long mNativePtr;

    public FontFamily() {
        this.mNativePtr = FontFamily.nCreateFamily(null, 0);
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("error creating native FontFamily");
        }
    }

    public FontFamily(String lang, String variant) {
        int varEnum = 0;
        if ("compact".equals(variant)) {
            varEnum = 1;
        } else if ("elegant".equals(variant)) {
            varEnum = 2;
        }
        this.mNativePtr = FontFamily.nCreateFamily(lang, varEnum);
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("error creating native FontFamily");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            FontFamily.nUnrefFamily(this.mNativePtr);
        }
        finally {
            super.finalize();
        }
    }

    public boolean addFont(String path) {
        return FontFamily.nAddFont(this.mNativePtr, path);
    }

    public boolean addFontWeightStyle(String path, int weight, boolean style2) {
        return FontFamily.nAddFontWeightStyle(this.mNativePtr, path, weight, style2);
    }

    public boolean addFontFromAsset(AssetManager mgr, String path) {
        return FontFamily.nAddFontFromAsset(this.mNativePtr, mgr, path);
    }

    private static native long nCreateFamily(String var0, int var1);

    private static native void nUnrefFamily(long var0);

    private static native boolean nAddFont(long var0, String var2);

    private static native boolean nAddFontWeightStyle(long var0, String var2, int var3, boolean var4);

    private static native boolean nAddFontFromAsset(long var0, AssetManager var2, String var3);
}

