/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.Program;
import android.filterfw.format.ImageFormat;
import java.lang.reflect.Field;

public abstract class ImageCombineFilter
extends Filter {
    protected Program mProgram;
    protected String[] mInputNames;
    protected String mOutputName;
    protected String mParameterName;
    protected int mCurrentTarget = 0;

    public ImageCombineFilter(String name, String[] inputNames, String outputName, String parameterName) {
        super(name);
        this.mInputNames = inputNames;
        this.mOutputName = outputName;
        this.mParameterName = parameterName;
    }

    public void setupPorts() {
        if (this.mParameterName != null) {
            try {
                Field programField = ImageCombineFilter.class.getDeclaredField("mProgram");
                this.addProgramPort(this.mParameterName, this.mParameterName, programField, Float.TYPE, false);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Internal Error: mProgram field not found!");
            }
        }
        for (String inputName : this.mInputNames) {
            this.addMaskedInputPort(inputName, ImageFormat.create(3));
        }
        this.addOutputBasedOnInput(this.mOutputName, this.mInputNames[0]);
    }

    public FrameFormat getOutputFormat(String portName, FrameFormat inputFormat) {
        return inputFormat;
    }

    private void assertAllInputTargetsMatch() {
        int target = this.getInputFormat(this.mInputNames[0]).getTarget();
        for (String inputName : this.mInputNames) {
            if (target == this.getInputFormat(inputName).getTarget()) continue;
            throw new RuntimeException("Type mismatch of input formats in filter " + this + ". All input frames must have the same target!");
        }
    }

    public void process(FilterContext context) {
        int i = 0;
        Frame[] inputs = new Frame[this.mInputNames.length];
        for (String inputName : this.mInputNames) {
            inputs[i++] = this.pullInput(inputName);
        }
        Frame output = context.getFrameManager().newFrame(inputs[0].getFormat());
        this.updateProgramWithTarget(inputs[0].getFormat().getTarget(), context);
        this.mProgram.process(inputs, output);
        this.pushOutput(this.mOutputName, output);
        output.release();
    }

    protected void updateProgramWithTarget(int target, FilterContext context) {
        if (target != this.mCurrentTarget) {
            switch (target) {
                case 2: {
                    this.mProgram = this.getNativeProgram(context);
                    break;
                }
                case 3: {
                    this.mProgram = this.getShaderProgram(context);
                    break;
                }
                default: {
                    this.mProgram = null;
                }
            }
            if (this.mProgram == null) {
                throw new RuntimeException("Could not create a program for image filter " + this + "!");
            }
            this.initProgramInputs(this.mProgram, context);
            this.mCurrentTarget = target;
        }
    }

    protected abstract Program getNativeProgram(FilterContext var1);

    protected abstract Program getShaderProgram(FilterContext var1);
}

