/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.base;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.format.PrimitiveFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class InputStreamSource
extends Filter {
    @GenerateFinalPort(name="target")
    private String mTarget;
    @GenerateFieldPort(name="stream")
    private InputStream mInputStream;
    @GenerateFinalPort(name="format", hasDefault=true)
    private MutableFrameFormat mOutputFormat = null;

    public InputStreamSource(String name) {
        super(name);
    }

    public void setupPorts() {
        int target = FrameFormat.readTargetString(this.mTarget);
        if (this.mOutputFormat == null) {
            this.mOutputFormat = PrimitiveFormat.createByteFormat(target);
        }
        this.addOutputPort("data", this.mOutputFormat);
    }

    public void process(FilterContext context) {
        int fileSize = 0;
        ByteBuffer byteBuffer = null;
        try {
            int bytesRead;
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = this.mInputStream.read(buffer)) > 0) {
                byteStream.write(buffer, 0, bytesRead);
                fileSize += bytesRead;
            }
            byteBuffer = ByteBuffer.wrap(byteStream.toByteArray());
        }
        catch (IOException exception) {
            throw new RuntimeException("InputStreamSource: Could not read stream: " + exception.getMessage() + "!");
        }
        this.mOutputFormat.setDimensions(fileSize);
        Frame output = context.getFrameManager().newFrame(this.mOutputFormat);
        output.setData(byteBuffer);
        this.pushOutput("data", output);
        output.release();
        this.closeOutputPort("data");
    }
}

