/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.FieldPort;
import android.filterfw.core.FilterContext;
import android.filterfw.core.FilterPort;
import android.filterfw.core.FinalPort;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.GenerateProgramPort;
import android.filterfw.core.GenerateProgramPorts;
import android.filterfw.core.InputPort;
import android.filterfw.core.KeyValueMap;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.OutputPort;
import android.filterfw.core.Program;
import android.filterfw.core.ProgramPort;
import android.filterfw.core.ProtocolException;
import android.filterfw.core.SerializedFrame;
import android.filterfw.core.SimpleFrame;
import android.filterfw.core.StreamPort;
import android.filterfw.format.ObjectFormat;
import android.filterfw.io.GraphIOException;
import android.filterfw.io.TextGraphReader;
import android.util.Log;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Filter {
    static final int STATUS_PREINIT = 0;
    static final int STATUS_UNPREPARED = 1;
    static final int STATUS_PREPARED = 2;
    static final int STATUS_PROCESSING = 3;
    static final int STATUS_SLEEPING = 4;
    static final int STATUS_FINISHED = 5;
    static final int STATUS_ERROR = 6;
    static final int STATUS_RELEASED = 7;
    private String mName;
    private int mInputCount = -1;
    private int mOutputCount = -1;
    private HashMap<String, InputPort> mInputPorts;
    private HashMap<String, OutputPort> mOutputPorts;
    private HashSet<Frame> mFramesToRelease;
    private HashMap<String, Frame> mFramesToSet;
    private int mStatus = 0;
    private boolean mIsOpen = false;
    private int mSleepDelay;
    private long mCurrentTimestamp;
    private boolean mLogVerbose;
    private static final String TAG = "Filter";

    public Filter(String name) {
        this.mName = name;
        this.mFramesToRelease = new HashSet();
        this.mFramesToSet = new HashMap();
        this.mStatus = 0;
        this.mLogVerbose = Log.isLoggable(TAG, 2);
    }

    public static final boolean isAvailable(String filterName) {
        Class<?> filterClass;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            filterClass = contextClassLoader.loadClass(filterName);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        try {
            filterClass.asSubclass(Filter.class);
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    public final void initWithValueMap(KeyValueMap valueMap) {
        this.initFinalPorts(valueMap);
        this.initRemainingPorts(valueMap);
        this.mStatus = 1;
    }

    public final void initWithAssignmentString(String assignments) {
        try {
            KeyValueMap valueMap = new TextGraphReader().readKeyValueAssignments(assignments);
            this.initWithValueMap(valueMap);
        }
        catch (GraphIOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public final void initWithAssignmentList(Object ... keyValues) {
        KeyValueMap valueMap = new KeyValueMap();
        valueMap.setKeyValues(keyValues);
        this.initWithValueMap(valueMap);
    }

    public final void init() throws ProtocolException {
        KeyValueMap valueMap = new KeyValueMap();
        this.initWithValueMap(valueMap);
    }

    public String getFilterClassName() {
        return this.getClass().getSimpleName();
    }

    public final String getName() {
        return this.mName;
    }

    public boolean isOpen() {
        return this.mIsOpen;
    }

    public void setInputFrame(String inputName, Frame frame) {
        InputPort port = this.getInputPort(inputName);
        if (!port.isOpen()) {
            ((FilterPort)port).open();
        }
        port.setFrame(frame);
    }

    public final void setInputValue(String inputName, Object value) {
        this.setInputFrame(inputName, this.wrapInputValue(inputName, value));
    }

    protected void prepare(FilterContext context) {
    }

    protected void parametersUpdated(Set<String> updated) {
    }

    protected void delayNextProcess(int millisecs) {
        this.mSleepDelay = millisecs;
        this.mStatus = 4;
    }

    public abstract void setupPorts();

    public FrameFormat getOutputFormat(String portName, FrameFormat inputFormat) {
        return null;
    }

    public final FrameFormat getInputFormat(String portName) {
        InputPort inputPort = this.getInputPort(portName);
        return inputPort.getSourceFormat();
    }

    public void open(FilterContext context) {
    }

    public abstract void process(FilterContext var1);

    public final int getSleepDelay() {
        return 250;
    }

    public void close(FilterContext context) {
    }

    public void tearDown(FilterContext context) {
    }

    public final int getNumberOfConnectedInputs() {
        int c = 0;
        for (InputPort inputPort : this.mInputPorts.values()) {
            if (!inputPort.isConnected()) continue;
            ++c;
        }
        return c;
    }

    public final int getNumberOfConnectedOutputs() {
        int c = 0;
        for (OutputPort outputPort : this.mOutputPorts.values()) {
            if (!outputPort.isConnected()) continue;
            ++c;
        }
        return c;
    }

    public final int getNumberOfInputs() {
        return this.mOutputPorts == null ? 0 : this.mInputPorts.size();
    }

    public final int getNumberOfOutputs() {
        return this.mInputPorts == null ? 0 : this.mOutputPorts.size();
    }

    public final InputPort getInputPort(String portName) {
        if (this.mInputPorts == null) {
            throw new NullPointerException("Attempting to access input port '" + portName + "' of " + this + " before Filter has been initialized!");
        }
        InputPort result = this.mInputPorts.get(portName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown input port '" + portName + "' on filter " + this + "!");
        }
        return result;
    }

    public final OutputPort getOutputPort(String portName) {
        if (this.mInputPorts == null) {
            throw new NullPointerException("Attempting to access output port '" + portName + "' of " + this + " before Filter has been initialized!");
        }
        OutputPort result = this.mOutputPorts.get(portName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown output port '" + portName + "' on filter " + this + "!");
        }
        return result;
    }

    protected final void pushOutput(String name, Frame frame) {
        if (frame.getTimestamp() == -2L) {
            if (this.mLogVerbose) {
                Log.v(TAG, "Default-setting output Frame timestamp on port " + name + " to " + this.mCurrentTimestamp);
            }
            frame.setTimestamp(this.mCurrentTimestamp);
        }
        this.getOutputPort(name).pushFrame(frame);
    }

    protected final Frame pullInput(String name) {
        Frame result = this.getInputPort(name).pullFrame();
        if (this.mCurrentTimestamp == -1L) {
            this.mCurrentTimestamp = result.getTimestamp();
            if (this.mLogVerbose) {
                Log.v(TAG, "Default-setting current timestamp from input port " + name + " to " + this.mCurrentTimestamp);
            }
        }
        this.mFramesToRelease.add(result);
        return result;
    }

    public void fieldPortValueUpdated(String name, FilterContext context) {
    }

    protected void transferInputPortFrame(String name, FilterContext context) {
        this.getInputPort(name).transfer(context);
    }

    protected void initProgramInputs(Program program, FilterContext context) {
        if (program != null) {
            for (InputPort inputPort : this.mInputPorts.values()) {
                if (inputPort.getTarget() != program) continue;
                inputPort.transfer(context);
            }
        }
    }

    protected void addInputPort(String name) {
        this.addMaskedInputPort(name, null);
    }

    protected void addMaskedInputPort(String name, FrameFormat formatMask) {
        StreamPort port = new StreamPort(this, name);
        if (this.mLogVerbose) {
            Log.v(TAG, "Filter " + this + " adding " + port);
        }
        this.mInputPorts.put(name, port);
        port.setPortFormat(formatMask);
    }

    protected void addOutputPort(String name, FrameFormat format) {
        OutputPort port = new OutputPort(this, name);
        if (this.mLogVerbose) {
            Log.v(TAG, "Filter " + this + " adding " + port);
        }
        port.setPortFormat(format);
        this.mOutputPorts.put(name, port);
    }

    protected void addOutputBasedOnInput(String outputName, String inputName) {
        OutputPort port = new OutputPort(this, outputName);
        if (this.mLogVerbose) {
            Log.v(TAG, "Filter " + this + " adding " + port);
        }
        port.setBasePort(this.getInputPort(inputName));
        this.mOutputPorts.put(outputName, port);
    }

    protected void addFieldPort(String name, Field field, boolean hasDefault, boolean isFinal) {
        FieldPort fieldPort;
        field.setAccessible(true);
        FieldPort fieldPort2 = fieldPort = isFinal ? new FinalPort(this, name, field, hasDefault) : new FieldPort(this, name, field, hasDefault);
        if (this.mLogVerbose) {
            Log.v(TAG, "Filter " + this + " adding " + fieldPort);
        }
        MutableFrameFormat format = ObjectFormat.fromClass(field.getType(), 1);
        fieldPort.setPortFormat(format);
        this.mInputPorts.put(name, fieldPort);
    }

    protected void addProgramPort(String name, String varName, Field field, Class varType, boolean hasDefault) {
        field.setAccessible(true);
        ProgramPort programPort = new ProgramPort(this, name, varName, field, hasDefault);
        if (this.mLogVerbose) {
            Log.v(TAG, "Filter " + this + " adding " + programPort);
        }
        MutableFrameFormat format = ObjectFormat.fromClass(varType, 1);
        programPort.setPortFormat(format);
        this.mInputPorts.put(name, programPort);
    }

    protected void closeOutputPort(String name) {
        this.getOutputPort(name).close();
    }

    protected void setWaitsOnInputPort(String portName, boolean waits) {
        this.getInputPort(portName).setBlocking(waits);
    }

    protected void setWaitsOnOutputPort(String portName, boolean waits) {
        this.getOutputPort(portName).setBlocking(waits);
    }

    public String toString() {
        return "'" + this.getName() + "' (" + this.getFilterClassName() + ")";
    }

    final Collection<InputPort> getInputPorts() {
        return this.mInputPorts.values();
    }

    final Collection<OutputPort> getOutputPorts() {
        return this.mOutputPorts.values();
    }

    final synchronized int getStatus() {
        return this.mStatus;
    }

    final synchronized void unsetStatus(int flag) {
        this.mStatus &= ~flag;
    }

    final synchronized void performOpen(FilterContext context) {
        if (!this.mIsOpen) {
            if (this.mStatus == 1) {
                if (this.mLogVerbose) {
                    Log.v(TAG, "Preparing " + this);
                }
                this.prepare(context);
                this.mStatus = 2;
            }
            if (this.mStatus == 2) {
                if (this.mLogVerbose) {
                    Log.v(TAG, "Opening " + this);
                }
                this.open(context);
                this.mStatus = 3;
            }
            if (this.mStatus != 3) {
                throw new RuntimeException("Filter " + this + " was brought into invalid state during " + "opening (state: " + this.mStatus + ")!");
            }
            this.mIsOpen = true;
        }
    }

    final synchronized void performProcess(FilterContext context) {
        if (this.mStatus == 7) {
            throw new RuntimeException("Filter " + this + " is already torn down!");
        }
        this.transferInputFrames(context);
        if (this.mStatus < 3) {
            this.performOpen(context);
        }
        if (this.mLogVerbose) {
            Log.v(TAG, "Processing " + this);
        }
        this.mCurrentTimestamp = -1L;
        this.process(context);
        this.releasePulledFrames(context);
        if (this.filterMustClose()) {
            this.performClose(context);
        }
    }

    final synchronized void performClose(FilterContext context) {
        if (this.mIsOpen) {
            if (this.mLogVerbose) {
                Log.v(TAG, "Closing " + this);
            }
            this.mIsOpen = false;
            this.mStatus = 2;
            this.close(context);
            this.closePorts();
        }
    }

    final synchronized void performTearDown(FilterContext context) {
        this.performClose(context);
        if (this.mStatus != 7) {
            this.tearDown(context);
            this.mStatus = 7;
        }
    }

    final synchronized boolean canProcess() {
        if (this.mLogVerbose) {
            Log.v(TAG, "Checking if can process: " + this + " (" + this.mStatus + ").");
        }
        if (this.mStatus <= 3) {
            return this.inputConditionsMet() && this.outputConditionsMet();
        }
        return false;
    }

    final void openOutputs() {
        if (this.mLogVerbose) {
            Log.v(TAG, "Opening all output ports on " + this + "!");
        }
        for (OutputPort outputPort : this.mOutputPorts.values()) {
            if (outputPort.isOpen()) continue;
            outputPort.open();
        }
    }

    final void clearInputs() {
        for (InputPort inputPort : this.mInputPorts.values()) {
            inputPort.clear();
        }
    }

    final void clearOutputs() {
        for (OutputPort outputPort : this.mOutputPorts.values()) {
            outputPort.clear();
        }
    }

    final void notifyFieldPortValueUpdated(String name, FilterContext context) {
        if (this.mStatus == 3 || this.mStatus == 2) {
            this.fieldPortValueUpdated(name, context);
        }
    }

    final synchronized void pushInputFrame(String inputName, Frame frame) {
        InputPort port = this.getInputPort(inputName);
        if (!port.isOpen()) {
            ((FilterPort)port).open();
        }
        port.pushFrame(frame);
    }

    final synchronized void pushInputValue(String inputName, Object value) {
        this.pushInputFrame(inputName, this.wrapInputValue(inputName, value));
    }

    private final void initFinalPorts(KeyValueMap values) {
        this.mInputPorts = new HashMap();
        this.mOutputPorts = new HashMap();
        this.addAndSetFinalPorts(values);
    }

    private final void initRemainingPorts(KeyValueMap values) {
        this.addAnnotatedPorts();
        this.setupPorts();
        this.setInitialInputValues(values);
    }

    private final void addAndSetFinalPorts(KeyValueMap values) {
        Class<?> filterClass = this.getClass();
        for (Field field : filterClass.getDeclaredFields()) {
            GenerateFinalPort annotation = field.getAnnotation(GenerateFinalPort.class);
            if (annotation == null) continue;
            GenerateFinalPort generator = annotation;
            String name = generator.name().isEmpty() ? field.getName() : generator.name();
            boolean hasDefault = generator.hasDefault();
            this.addFieldPort(name, field, hasDefault, true);
            if (values.containsKey(name)) {
                this.setImmediateInputValue(name, values.get(name));
                values.remove(name);
                continue;
            }
            if (generator.hasDefault()) continue;
            throw new RuntimeException("No value specified for final input port '" + name + "' of filter " + this + "!");
        }
    }

    private final void addAnnotatedPorts() {
        Class<?> filterClass = this.getClass();
        for (Field field : filterClass.getDeclaredFields()) {
            Annotation generator;
            Annotation annotation = field.getAnnotation(GenerateFieldPort.class);
            if (annotation != null) {
                generator = annotation;
                this.addFieldGenerator((GenerateFieldPort)generator, field);
                continue;
            }
            annotation = field.getAnnotation(GenerateProgramPort.class);
            if (annotation != null) {
                generator = (GenerateProgramPort)annotation;
                this.addProgramGenerator((GenerateProgramPort)generator, field);
                continue;
            }
            annotation = field.getAnnotation(GenerateProgramPorts.class);
            if (annotation == null) continue;
            GenerateProgramPorts generators = (GenerateProgramPorts)annotation;
            for (GenerateProgramPort generator2 : generators.value()) {
                this.addProgramGenerator(generator2, field);
            }
        }
    }

    private final void addFieldGenerator(GenerateFieldPort generator, Field field) {
        String name = generator.name().isEmpty() ? field.getName() : generator.name();
        boolean hasDefault = generator.hasDefault();
        this.addFieldPort(name, field, hasDefault, false);
    }

    private final void addProgramGenerator(GenerateProgramPort generator, Field field) {
        String name = generator.name();
        String varName = generator.variableName().isEmpty() ? name : generator.variableName();
        Class varType = generator.type();
        boolean hasDefault = generator.hasDefault();
        this.addProgramPort(name, varName, field, varType, hasDefault);
    }

    private final void setInitialInputValues(KeyValueMap values) {
        for (Map.Entry entry : values.entrySet()) {
            this.setInputValue((String)entry.getKey(), entry.getValue());
        }
    }

    private final void setImmediateInputValue(String name, Object value) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Setting immediate value " + value + " for port " + name + "!");
        }
        InputPort port = this.getInputPort(name);
        ((FilterPort)port).open();
        port.setFrame(SimpleFrame.wrapObject(value, null));
    }

    private final void transferInputFrames(FilterContext context) {
        for (InputPort inputPort : this.mInputPorts.values()) {
            inputPort.transfer(context);
        }
    }

    private final Frame wrapInputValue(String inputName, Object value) {
        MutableFrameFormat inputFormat = ObjectFormat.fromObject(value, 1);
        if (value == null) {
            FrameFormat portFormat = this.getInputPort(inputName).getPortFormat();
            Class portClass = portFormat == null ? null : portFormat.getObjectClass();
            inputFormat.setObjectClass(portClass);
        }
        boolean shouldSerialize = !(value instanceof Number) && !(value instanceof Boolean) && !(value instanceof String) && value instanceof Serializable;
        Frame frame = shouldSerialize ? new SerializedFrame(inputFormat, null) : new SimpleFrame(inputFormat, null);
        frame.setObjectValue(value);
        return frame;
    }

    private final void releasePulledFrames(FilterContext context) {
        for (Frame frame : this.mFramesToRelease) {
            context.getFrameManager().releaseFrame(frame);
        }
        this.mFramesToRelease.clear();
    }

    private final boolean inputConditionsMet() {
        for (InputPort port : this.mInputPorts.values()) {
            if (((FilterPort)port).isReady()) continue;
            if (this.mLogVerbose) {
                Log.v(TAG, "Input condition not met: " + port + "!");
            }
            return false;
        }
        return true;
    }

    private final boolean outputConditionsMet() {
        for (OutputPort port : this.mOutputPorts.values()) {
            if (((FilterPort)port).isReady()) continue;
            if (this.mLogVerbose) {
                Log.v(TAG, "Output condition not met: " + port + "!");
            }
            return false;
        }
        return true;
    }

    private final void closePorts() {
        if (this.mLogVerbose) {
            Log.v(TAG, "Closing all ports on " + this + "!");
        }
        for (InputPort inputPort : this.mInputPorts.values()) {
            inputPort.close();
        }
        for (OutputPort outputPort : this.mOutputPorts.values()) {
            outputPort.close();
        }
    }

    private final boolean filterMustClose() {
        for (InputPort inputPort : this.mInputPorts.values()) {
            if (!inputPort.filterMustClose()) continue;
            if (this.mLogVerbose) {
                Log.v(TAG, "Filter " + this + " must close due to port " + inputPort);
            }
            return true;
        }
        for (OutputPort outputPort : this.mOutputPorts.values()) {
            if (!outputPort.filterMustClose()) continue;
            if (this.mLogVerbose) {
                Log.v(TAG, "Filter " + this + " must close due to port " + outputPort);
            }
            return true;
        }
        return false;
    }
}

