/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.InputPort;
import java.lang.reflect.Field;

public class FieldPort
extends InputPort {
    protected Field mField;
    protected boolean mHasFrame;
    protected boolean mValueWaiting = false;
    protected Object mValue;

    public FieldPort(Filter filter, String name, Field field, boolean hasDefault) {
        super(filter, name);
        this.mField = field;
        this.mHasFrame = hasDefault;
    }

    public void clear() {
    }

    public void pushFrame(Frame frame) {
        this.setFieldFrame(frame, false);
    }

    public void setFrame(Frame frame) {
        this.setFieldFrame(frame, true);
    }

    public Object getTarget() {
        try {
            return this.mField.get(this.mFilter);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public synchronized void transfer(FilterContext context) {
        if (this.mValueWaiting) {
            try {
                this.mField.set(this.mFilter, this.mValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Access to field '" + this.mField.getName() + "' was denied!");
            }
            this.mValueWaiting = false;
            if (context != null) {
                this.mFilter.notifyFieldPortValueUpdated(this.mName, context);
            }
        }
    }

    public synchronized Frame pullFrame() {
        throw new RuntimeException("Cannot pull frame on " + this + "!");
    }

    public synchronized boolean hasFrame() {
        return this.mHasFrame;
    }

    public synchronized boolean acceptsFrame() {
        return !this.mValueWaiting;
    }

    public String toString() {
        return "field " + super.toString();
    }

    protected synchronized void setFieldFrame(Frame frame, boolean isAssignment) {
        this.assertPortIsOpen();
        this.checkFrameType(frame, isAssignment);
        Object value = frame.getObjectValue();
        if (value == null && this.mValue != null || !value.equals(this.mValue)) {
            this.mValue = value;
            this.mValueWaiting = true;
        }
        this.mHasFrame = true;
    }
}

