/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.IContentObserver;
import android.net.Uri;
import android.os.Handler;

public abstract class ContentObserver {
    private final Object mLock = new Object();
    private Transport mTransport;
    Handler mHandler;

    public ContentObserver(Handler handler) {
        this.mHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContentObserver getContentObserver() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTransport == null) {
                this.mTransport = new Transport(this);
            }
            return this.mTransport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContentObserver releaseContentObserver() {
        Object object = this.mLock;
        synchronized (object) {
            Transport oldTransport = this.mTransport;
            if (oldTransport != null) {
                oldTransport.releaseContentObserver();
                this.mTransport = null;
            }
            return oldTransport;
        }
    }

    public boolean deliverSelfNotifications() {
        return false;
    }

    public void onChange(boolean selfChange) {
    }

    public void onChange(boolean selfChange, Uri uri) {
        this.onChange(selfChange);
    }

    @Deprecated
    public final void dispatchChange(boolean selfChange) {
        this.dispatchChange(selfChange, null);
    }

    public final void dispatchChange(boolean selfChange, Uri uri) {
        if (this.mHandler == null) {
            this.onChange(selfChange, uri);
        } else {
            this.mHandler.post(new NotificationRunnable(selfChange, uri));
        }
    }

    private static final class Transport
    extends IContentObserver.Stub {
        private ContentObserver mContentObserver;

        public Transport(ContentObserver contentObserver) {
            this.mContentObserver = contentObserver;
        }

        public void onChange(boolean selfChange, Uri uri) {
            ContentObserver contentObserver = this.mContentObserver;
            if (contentObserver != null) {
                contentObserver.dispatchChange(selfChange, uri);
            }
        }

        public void releaseContentObserver() {
            this.mContentObserver = null;
        }
    }

    private final class NotificationRunnable
    implements Runnable {
        private final boolean mSelfChange;
        private final Uri mUri;

        public NotificationRunnable(boolean selfChange, Uri uri) {
            this.mSelfChange = selfChange;
            this.mUri = uri;
        }

        public void run() {
            ContentObserver.this.onChange(this.mSelfChange, this.mUri);
        }
    }
}

