/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import libcore.io.ErrnoException;
import libcore.io.Libcore;
import libcore.io.OsConstants;

public final class IoUtils {
    private static final Random TEMPORARY_DIRECTORY_PRNG = new Random();

    private IoUtils() {
    }

    public static void close(FileDescriptor fd) throws IOException {
        try {
            if (fd != null && fd.valid()) {
                Libcore.os.close(fd);
            }
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public static void closeQuietly(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(FileDescriptor fd) {
        try {
            IoUtils.close(fd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setBlocking(FileDescriptor fd, boolean blocking) throws IOException {
        try {
            int flags = Libcore.os.fcntlVoid(fd, OsConstants.F_GETFL);
            flags = !blocking ? (flags |= OsConstants.O_NONBLOCK) : (flags &= ~OsConstants.O_NONBLOCK);
            Libcore.os.fcntlLong(fd, OsConstants.F_SETFL, flags);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public static byte[] readFileAsByteArray(String path) throws IOException {
        return IoUtils.readFileAsBytes(path).toByteArray();
    }

    public static String readFileAsString(String path) throws IOException {
        return IoUtils.readFileAsBytes(path).toString(StandardCharsets.UTF_8);
    }

    private static UnsafeByteSequence readFileAsBytes(String path) throws IOException {
        UnsafeByteSequence unsafeByteSequence;
        int byteCount;
        byte[] buffer;
        UnsafeByteSequence bytes;
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(path, "r");
            bytes = new UnsafeByteSequence((int)f.length());
            buffer = new byte[8192];
            while (true) {
                if ((byteCount = f.read(buffer)) != -1) break block4;
                unsafeByteSequence = bytes;
                Object var7_6 = null;
                break;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            IoUtils.closeQuietly(f);
            throw throwable;
        }
        {
            block4: {
                IoUtils.closeQuietly(f);
                return unsafeByteSequence;
            }
            bytes.write(buffer, 0, byteCount);
            continue;
        }
    }

    public static void deleteContents(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    IoUtils.deleteContents(file);
                }
                file.delete();
            }
        }
    }

    public static File createTemporaryDirectory(String prefix) {
        String candidateName;
        File result;
        do {
            candidateName = prefix + TEMPORARY_DIRECTORY_PRNG.nextInt();
        } while (!(result = new File(System.getProperty("java.io.tmpdir"), candidateName)).mkdir());
        return result;
    }

    public static boolean canOpenReadOnly(String path) {
        try {
            FileDescriptor fd = Libcore.os.open(path, OsConstants.O_RDONLY, 0);
            Libcore.os.close(fd);
            return true;
        }
        catch (ErrnoException errnoException) {
            return false;
        }
    }

    public static void throwInterruptedIoException() throws InterruptedIOException {
        Thread.currentThread().interrupt();
        throw new InterruptedIOException();
    }
}

