/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import libcore.io.ErrnoException;
import libcore.io.GaiException;
import libcore.io.Os;
import libcore.io.StructAddrinfo;
import libcore.io.StructFlock;
import libcore.io.StructGroupReq;
import libcore.io.StructLinger;
import libcore.io.StructPasswd;
import libcore.io.StructPollfd;
import libcore.io.StructStat;
import libcore.io.StructStatVfs;
import libcore.io.StructTimeval;
import libcore.io.StructUcred;
import libcore.io.StructUtsname;
import libcore.util.MutableInt;
import libcore.util.MutableLong;

public class ForwardingOs
implements Os {
    protected final Os os;

    public ForwardingOs(Os os) {
        this.os = os;
    }

    public FileDescriptor accept(FileDescriptor fd, InetSocketAddress peerAddress) throws ErrnoException, SocketException {
        return this.os.accept(fd, peerAddress);
    }

    public boolean access(String path, int mode) throws ErrnoException {
        return this.os.access(path, mode);
    }

    public void bind(FileDescriptor fd, InetAddress address, int port) throws ErrnoException, SocketException {
        this.os.bind(fd, address, port);
    }

    public void chmod(String path, int mode) throws ErrnoException {
        this.os.chmod(path, mode);
    }

    public void chown(String path, int uid, int gid) throws ErrnoException {
        this.os.chown(path, uid, gid);
    }

    public void close(FileDescriptor fd) throws ErrnoException {
        this.os.close(fd);
    }

    public void connect(FileDescriptor fd, InetAddress address, int port) throws ErrnoException, SocketException {
        this.os.connect(fd, address, port);
    }

    public FileDescriptor dup(FileDescriptor oldFd) throws ErrnoException {
        return this.os.dup(oldFd);
    }

    public FileDescriptor dup2(FileDescriptor oldFd, int newFd) throws ErrnoException {
        return this.os.dup2(oldFd, newFd);
    }

    public String[] environ() {
        return this.os.environ();
    }

    public void execv(String filename, String[] argv) throws ErrnoException {
        this.os.execv(filename, argv);
    }

    public void execve(String filename, String[] argv, String[] envp) throws ErrnoException {
        this.os.execve(filename, argv, envp);
    }

    public void fchmod(FileDescriptor fd, int mode) throws ErrnoException {
        this.os.fchmod(fd, mode);
    }

    public void fchown(FileDescriptor fd, int uid, int gid) throws ErrnoException {
        this.os.fchown(fd, uid, gid);
    }

    public int fcntlVoid(FileDescriptor fd, int cmd) throws ErrnoException {
        return this.os.fcntlVoid(fd, cmd);
    }

    public int fcntlLong(FileDescriptor fd, int cmd, long arg) throws ErrnoException {
        return this.os.fcntlLong(fd, cmd, arg);
    }

    public int fcntlFlock(FileDescriptor fd, int cmd, StructFlock arg) throws ErrnoException {
        return this.os.fcntlFlock(fd, cmd, arg);
    }

    public void fdatasync(FileDescriptor fd) throws ErrnoException {
        this.os.fdatasync(fd);
    }

    public StructStat fstat(FileDescriptor fd) throws ErrnoException {
        return this.os.fstat(fd);
    }

    public StructStatVfs fstatvfs(FileDescriptor fd) throws ErrnoException {
        return this.os.fstatvfs(fd);
    }

    public void fsync(FileDescriptor fd) throws ErrnoException {
        this.os.fsync(fd);
    }

    public void ftruncate(FileDescriptor fd, long length) throws ErrnoException {
        this.os.ftruncate(fd, length);
    }

    public String gai_strerror(int error) {
        return this.os.gai_strerror(error);
    }

    public InetAddress[] getaddrinfo(String node, StructAddrinfo hints) throws GaiException {
        return this.os.getaddrinfo(node, hints);
    }

    public int getegid() {
        return this.os.getegid();
    }

    public int geteuid() {
        return this.os.geteuid();
    }

    public int getgid() {
        return this.os.getgid();
    }

    public String getenv(String name) {
        return this.os.getenv(name);
    }

    public String getnameinfo(InetAddress address, int flags) throws GaiException {
        return this.os.getnameinfo(address, flags);
    }

    public SocketAddress getpeername(FileDescriptor fd) throws ErrnoException {
        return this.os.getpeername(fd);
    }

    public int getpid() {
        return this.os.getpid();
    }

    public int getppid() {
        return this.os.getppid();
    }

    public StructPasswd getpwnam(String name) throws ErrnoException {
        return this.os.getpwnam(name);
    }

    public StructPasswd getpwuid(int uid) throws ErrnoException {
        return this.os.getpwuid(uid);
    }

    public SocketAddress getsockname(FileDescriptor fd) throws ErrnoException {
        return this.os.getsockname(fd);
    }

    public int getsockoptByte(FileDescriptor fd, int level, int option) throws ErrnoException {
        return this.os.getsockoptByte(fd, level, option);
    }

    public InetAddress getsockoptInAddr(FileDescriptor fd, int level, int option) throws ErrnoException {
        return this.os.getsockoptInAddr(fd, level, option);
    }

    public int getsockoptInt(FileDescriptor fd, int level, int option) throws ErrnoException {
        return this.os.getsockoptInt(fd, level, option);
    }

    public StructLinger getsockoptLinger(FileDescriptor fd, int level, int option) throws ErrnoException {
        return this.os.getsockoptLinger(fd, level, option);
    }

    public StructTimeval getsockoptTimeval(FileDescriptor fd, int level, int option) throws ErrnoException {
        return this.os.getsockoptTimeval(fd, level, option);
    }

    public StructUcred getsockoptUcred(FileDescriptor fd, int level, int option) throws ErrnoException {
        return this.os.getsockoptUcred(fd, level, option);
    }

    public int gettid() {
        return this.os.gettid();
    }

    public int getuid() {
        return this.os.getuid();
    }

    public String if_indextoname(int index) {
        return this.os.if_indextoname(index);
    }

    public InetAddress inet_pton(int family, String address) {
        return this.os.inet_pton(family, address);
    }

    public InetAddress ioctlInetAddress(FileDescriptor fd, int cmd, String interfaceName) throws ErrnoException {
        return this.os.ioctlInetAddress(fd, cmd, interfaceName);
    }

    public int ioctlInt(FileDescriptor fd, int cmd, MutableInt arg) throws ErrnoException {
        return this.os.ioctlInt(fd, cmd, arg);
    }

    public boolean isatty(FileDescriptor fd) {
        return this.os.isatty(fd);
    }

    public void kill(int pid, int signal) throws ErrnoException {
        this.os.kill(pid, signal);
    }

    public void lchown(String path, int uid, int gid) throws ErrnoException {
        this.os.lchown(path, uid, gid);
    }

    public void listen(FileDescriptor fd, int backlog) throws ErrnoException {
        this.os.listen(fd, backlog);
    }

    public long lseek(FileDescriptor fd, long offset, int whence) throws ErrnoException {
        return this.os.lseek(fd, offset, whence);
    }

    public StructStat lstat(String path) throws ErrnoException {
        return this.os.lstat(path);
    }

    public void mincore(long address, long byteCount, byte[] vector) throws ErrnoException {
        this.os.mincore(address, byteCount, vector);
    }

    public void mkdir(String path, int mode) throws ErrnoException {
        this.os.mkdir(path, mode);
    }

    public void mlock(long address, long byteCount) throws ErrnoException {
        this.os.mlock(address, byteCount);
    }

    public long mmap(long address, long byteCount, int prot, int flags, FileDescriptor fd, long offset) throws ErrnoException {
        return this.os.mmap(address, byteCount, prot, flags, fd, offset);
    }

    public void msync(long address, long byteCount, int flags) throws ErrnoException {
        this.os.msync(address, byteCount, flags);
    }

    public void munlock(long address, long byteCount) throws ErrnoException {
        this.os.munlock(address, byteCount);
    }

    public void munmap(long address, long byteCount) throws ErrnoException {
        this.os.munmap(address, byteCount);
    }

    public FileDescriptor open(String path, int flags, int mode) throws ErrnoException {
        return this.os.open(path, flags, mode);
    }

    public FileDescriptor[] pipe() throws ErrnoException {
        return this.os.pipe();
    }

    public int poll(StructPollfd[] fds, int timeoutMs) throws ErrnoException {
        return this.os.poll(fds, timeoutMs);
    }

    public int pread(FileDescriptor fd, ByteBuffer buffer, long offset) throws ErrnoException {
        return this.os.pread(fd, buffer, offset);
    }

    public int pread(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, long offset) throws ErrnoException {
        return this.os.pread(fd, bytes, byteOffset, byteCount, offset);
    }

    public int pwrite(FileDescriptor fd, ByteBuffer buffer, long offset) throws ErrnoException {
        return this.os.pwrite(fd, buffer, offset);
    }

    public int pwrite(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, long offset) throws ErrnoException {
        return this.os.pwrite(fd, bytes, byteOffset, byteCount, offset);
    }

    public int read(FileDescriptor fd, ByteBuffer buffer) throws ErrnoException {
        return this.os.read(fd, buffer);
    }

    public int read(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws ErrnoException {
        return this.os.read(fd, bytes, byteOffset, byteCount);
    }

    public int readv(FileDescriptor fd, Object[] buffers, int[] offsets, int[] byteCounts) throws ErrnoException {
        return this.os.readv(fd, buffers, offsets, byteCounts);
    }

    public int recvfrom(FileDescriptor fd, ByteBuffer buffer, int flags, InetSocketAddress srcAddress) throws ErrnoException, SocketException {
        return this.os.recvfrom(fd, buffer, flags, srcAddress);
    }

    public int recvfrom(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, InetSocketAddress srcAddress) throws ErrnoException, SocketException {
        return this.os.recvfrom(fd, bytes, byteOffset, byteCount, flags, srcAddress);
    }

    public void remove(String path) throws ErrnoException {
        this.os.remove(path);
    }

    public void rename(String oldPath, String newPath) throws ErrnoException {
        this.os.rename(oldPath, newPath);
    }

    public long sendfile(FileDescriptor outFd, FileDescriptor inFd, MutableLong inOffset, long byteCount) throws ErrnoException {
        return this.os.sendfile(outFd, inFd, inOffset, byteCount);
    }

    public int sendto(FileDescriptor fd, ByteBuffer buffer, int flags, InetAddress inetAddress, int port) throws ErrnoException, SocketException {
        return this.os.sendto(fd, buffer, flags, inetAddress, port);
    }

    public int sendto(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, InetAddress inetAddress, int port) throws ErrnoException, SocketException {
        return this.os.sendto(fd, bytes, byteOffset, byteCount, flags, inetAddress, port);
    }

    public void setegid(int egid) throws ErrnoException {
        this.os.setegid(egid);
    }

    public void setenv(String name, String value, boolean overwrite) throws ErrnoException {
        this.os.setenv(name, value, overwrite);
    }

    public void seteuid(int euid) throws ErrnoException {
        this.os.seteuid(euid);
    }

    public void setgid(int gid) throws ErrnoException {
        this.os.setgid(gid);
    }

    public int setsid() throws ErrnoException {
        return this.os.setsid();
    }

    public void setsockoptByte(FileDescriptor fd, int level, int option, int value) throws ErrnoException {
        this.os.setsockoptByte(fd, level, option, value);
    }

    public void setsockoptIfreq(FileDescriptor fd, int level, int option, String value) throws ErrnoException {
        this.os.setsockoptIfreq(fd, level, option, value);
    }

    public void setsockoptInt(FileDescriptor fd, int level, int option, int value) throws ErrnoException {
        this.os.setsockoptInt(fd, level, option, value);
    }

    public void setsockoptIpMreqn(FileDescriptor fd, int level, int option, int value) throws ErrnoException {
        this.os.setsockoptIpMreqn(fd, level, option, value);
    }

    public void setsockoptGroupReq(FileDescriptor fd, int level, int option, StructGroupReq value) throws ErrnoException {
        this.os.setsockoptGroupReq(fd, level, option, value);
    }

    public void setsockoptLinger(FileDescriptor fd, int level, int option, StructLinger value) throws ErrnoException {
        this.os.setsockoptLinger(fd, level, option, value);
    }

    public void setsockoptTimeval(FileDescriptor fd, int level, int option, StructTimeval value) throws ErrnoException {
        this.os.setsockoptTimeval(fd, level, option, value);
    }

    public void setuid(int uid) throws ErrnoException {
        this.os.setuid(uid);
    }

    public void shutdown(FileDescriptor fd, int how) throws ErrnoException {
        this.os.shutdown(fd, how);
    }

    public FileDescriptor socket(int domain, int type, int protocol) throws ErrnoException {
        return this.os.socket(domain, type, protocol);
    }

    public void socketpair(int domain, int type, int protocol, FileDescriptor fd1, FileDescriptor fd2) throws ErrnoException {
        this.os.socketpair(domain, type, protocol, fd1, fd2);
    }

    public StructStat stat(String path) throws ErrnoException {
        return this.os.stat(path);
    }

    public StructStatVfs statvfs(String path) throws ErrnoException {
        return this.os.statvfs(path);
    }

    public String strerror(int errno) {
        return this.os.strerror(errno);
    }

    public String strsignal(int signal) {
        return this.os.strsignal(signal);
    }

    public void symlink(String oldPath, String newPath) throws ErrnoException {
        this.os.symlink(oldPath, newPath);
    }

    public long sysconf(int name) {
        return this.os.sysconf(name);
    }

    public void tcdrain(FileDescriptor fd) throws ErrnoException {
        this.os.tcdrain(fd);
    }

    public void tcsendbreak(FileDescriptor fd, int duration) throws ErrnoException {
        this.os.tcsendbreak(fd, duration);
    }

    public int umask(int mask) {
        return this.os.umask(mask);
    }

    public StructUtsname uname() {
        return this.os.uname();
    }

    public void unsetenv(String name) throws ErrnoException {
        this.os.unsetenv(name);
    }

    public int waitpid(int pid, MutableInt status, int options) throws ErrnoException {
        return this.os.waitpid(pid, status, options);
    }

    public int write(FileDescriptor fd, ByteBuffer buffer) throws ErrnoException {
        return this.os.write(fd, buffer);
    }

    public int write(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws ErrnoException {
        return this.os.write(fd, bytes, byteOffset, byteCount);
    }

    public int writev(FileDescriptor fd, Object[] buffers, int[] offsets, int[] byteCounts) throws ErrnoException {
        return this.os.writev(fd, buffers, offsets, byteCounts);
    }
}

