/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import java.util.LinkedHashSet;
import java.util.Locale;
import libcore.icu.LocaleData;

public final class ICU {
    private static String[] isoLanguages;
    private static String[] isoCountries;
    private static Locale[] availableLocalesCache;
    public static final int U_ZERO_ERROR = 0;
    public static final int U_INVALID_CHAR_FOUND = 10;
    public static final int U_TRUNCATED_CHAR_FOUND = 11;
    public static final int U_ILLEGAL_CHAR_FOUND = 12;
    public static final int U_BUFFER_OVERFLOW_ERROR = 15;

    public static String[] getISOLanguages() {
        if (isoLanguages == null) {
            isoLanguages = ICU.getISOLanguagesNative();
        }
        return (String[])isoLanguages.clone();
    }

    public static String[] getISOCountries() {
        if (isoCountries == null) {
            isoCountries = ICU.getISOCountriesNative();
        }
        return (String[])isoCountries.clone();
    }

    public static Locale localeFromString(String localeName) {
        int first = localeName.indexOf(95);
        int second = localeName.indexOf(95, first + 1);
        if (first == -1) {
            return new Locale(localeName);
        }
        if (second == -1) {
            return new Locale(localeName.substring(0, first), localeName.substring(first + 1));
        }
        return new Locale(localeName.substring(0, first), localeName.substring(first + 1, second), localeName.substring(second + 1));
    }

    public static Locale[] localesFromStrings(String[] localeNames) {
        LinkedHashSet<Locale> set = new LinkedHashSet<Locale>();
        for (String localeName : localeNames) {
            set.add(ICU.localeFromString(localeName));
        }
        return set.toArray(new Locale[set.size()]);
    }

    public static Locale[] getAvailableLocales() {
        if (availableLocalesCache == null) {
            availableLocalesCache = ICU.localesFromStrings(ICU.getAvailableLocalesNative());
        }
        return (Locale[])availableLocalesCache.clone();
    }

    public static Locale[] getAvailableBreakIteratorLocales() {
        return ICU.localesFromStrings(ICU.getAvailableBreakIteratorLocalesNative());
    }

    public static Locale[] getAvailableCalendarLocales() {
        return ICU.localesFromStrings(ICU.getAvailableCalendarLocalesNative());
    }

    public static Locale[] getAvailableCollatorLocales() {
        return ICU.localesFromStrings(ICU.getAvailableCollatorLocalesNative());
    }

    public static Locale[] getAvailableDateFormatLocales() {
        return ICU.localesFromStrings(ICU.getAvailableDateFormatLocalesNative());
    }

    public static Locale[] getAvailableDateFormatSymbolsLocales() {
        return ICU.getAvailableDateFormatLocales();
    }

    public static Locale[] getAvailableDecimalFormatSymbolsLocales() {
        return ICU.getAvailableNumberFormatLocales();
    }

    public static Locale[] getAvailableNumberFormatLocales() {
        return ICU.localesFromStrings(ICU.getAvailableNumberFormatLocalesNative());
    }

    public static native String getBestDateTimePattern(String var0, String var1);

    public static char[] getDateFormatOrder(String pattern) {
        char[] result = new char[3];
        int resultIndex = 0;
        boolean sawDay = false;
        boolean sawMonth = false;
        boolean sawYear = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == 'd' || ch == 'L' || ch == 'M' || ch == 'y') {
                if (ch == 'd' && !sawDay) {
                    result[resultIndex++] = 100;
                    sawDay = true;
                    continue;
                }
                if (!(ch != 'L' && ch != 'M' || sawMonth)) {
                    result[resultIndex++] = 77;
                    sawMonth = true;
                    continue;
                }
                if (ch != 'y' || sawYear) continue;
                result[resultIndex++] = 121;
                sawYear = true;
                continue;
            }
            if (ch == 'G') continue;
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                throw new IllegalArgumentException("Bad pattern character '" + ch + "' in " + pattern);
            }
            if (ch != '\'') continue;
            if (i < pattern.length() - 1 && pattern.charAt(i + 1) == '\'') {
                ++i;
                continue;
            }
            if ((i = pattern.indexOf(39, i + 1)) == -1) {
                throw new IllegalArgumentException("Bad quoting in " + pattern);
            }
            ++i;
        }
        return result;
    }

    public static native String getCldrVersion();

    public static native String getIcuVersion();

    public static native String getUnicodeVersion();

    public static native String toLowerCase(String var0, String var1);

    public static native String toUpperCase(String var0, String var1);

    public static boolean U_FAILURE(int error) {
        return error > 0;
    }

    private static native String[] getAvailableBreakIteratorLocalesNative();

    private static native String[] getAvailableCalendarLocalesNative();

    private static native String[] getAvailableCollatorLocalesNative();

    private static native String[] getAvailableDateFormatLocalesNative();

    private static native String[] getAvailableLocalesNative();

    private static native String[] getAvailableNumberFormatLocalesNative();

    public static native String[] getAvailableCurrencyCodes();

    public static native String getCurrencyCode(String var0);

    public static native String getCurrencyDisplayName(String var0, String var1);

    public static native int getCurrencyFractionDigits(String var0);

    public static native String getCurrencySymbol(String var0, String var1);

    public static native String getDisplayCountryNative(String var0, String var1);

    public static native String getDisplayLanguageNative(String var0, String var1);

    public static native String getDisplayVariantNative(String var0, String var1);

    public static native String getISO3CountryNative(String var0);

    public static native String getISO3LanguageNative(String var0);

    public static native String addLikelySubtags(String var0);

    public static native String getScript(String var0);

    private static native String[] getISOLanguagesNative();

    private static native String[] getISOCountriesNative();

    static native boolean initLocaleDataImpl(String var0, LocaleData var1);
}

